/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.structureformat.base;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseFieldFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IStructureFormatter;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.types.Scalar;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ScalarFormatter
extends BaseFieldFormatter {
    private final int typeCode;
    private final Method castMethod;
    private final Method atMethod;
    private final Class<? extends AbstractPointer> pointerClass;

    public ScalarFormatter(int n, Class<? extends AbstractPointer> clazz) {
        this.typeCode = n;
        try {
            this.castMethod = clazz.getMethod("cast", Long.TYPE);
            this.atMethod = clazz.getMethod("at", Long.TYPE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        this.pointerClass = clazz;
    }

    protected void formatShortScalar(Scalar scalar, PrintStream printStream) {
        printStream.print(scalar.getHexValue());
        printStream.print(" (");
        printStream.print(scalar.longValue());
        printStream.print(")");
    }

    @Override
    public FormatWalkResult format(String string, String string2, String string3, int n, long l, PrintStream printStream, Context context, IStructureFormatter iStructureFormatter) throws CorruptDataException {
        if (n == this.typeCode) {
            Object object = null;
            try {
                object = this.castMethod.invoke(null, l);
            }
            catch (Exception exception) {
                throw new RuntimeException("Cast failed on " + this.pointerClass.getName(), exception);
            }
            try {
                Scalar scalar = (Scalar)this.atMethod.invoke(object, 0L);
                this.formatShortScalar(scalar, printStream);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof CorruptDataException) {
                    throw (CorruptDataException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException("Problem invoking at() method on " + this.pointerClass.getName(), invocationTargetException);
            }
            catch (Exception exception) {
                throw new RuntimeException("Problem invoking at() method on " + this.pointerClass.getName(), exception);
            }
            return FormatWalkResult.STOP_WALKING;
        }
        return FormatWalkResult.KEEP_WALKING;
    }
}

