/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.reflect;

import com.ibm.oti.reflect.AnnotationParser;
import com.ibm.oti.reflect.Annotations;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;

public class Method {
    private final java.lang.reflect.Method method;
    private SoftReference<Annotations> annotations;
    private SoftReference<Object> srDefaultValue;

    public Method(java.lang.reflect.Method method) {
        this.method = method;
    }

    private synchronized Annotations getAnnotations() {
        Annotations annotations;
        if (this.annotations == null || (annotations = this.annotations.get()) == null) {
            annotations = new Annotations(AnnotationParser.parseAnnotations(this.method));
            this.annotations = new SoftReference<Annotations>(annotations);
        }
        return annotations;
    }

    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return this.getAnnotations().getAnnotation(clazz);
    }

    public Annotation[] getDeclaredAnnotations() {
        return (Annotation[])this.getAnnotations().getAnnotations().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDefaultValue() {
        Object object;
        Method method = this;
        synchronized (method) {
            if (this.srDefaultValue == null || (object = this.srDefaultValue.get()) == null) {
                object = AnnotationParser.parseDefaultValue(this.method);
                this.srDefaultValue = new SoftReference<Object>(object);
            }
        }
        return object;
    }

    public Annotation[][] getParameterAnnotations() {
        return AnnotationParser.parseParameterAnnotations(this.method);
    }
}

