/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;

public abstract class CallSite {
    private final MethodType type;
    private static MethodHandle initialTargetHandleCache;

    CallSite(MethodType methodType) {
        methodType.getClass();
        this.type = methodType;
    }

    public MethodType type() {
        return this.type;
    }

    public abstract MethodHandle getTarget();

    public abstract void setTarget(MethodHandle var1) throws WrongMethodTypeException, NullPointerException;

    public abstract MethodHandle dynamicInvoker();

    static void throwIllegalStateException() throws IllegalStateException {
        throw new IllegalStateException();
    }

    static MethodHandle initialTarget(MethodType methodType) {
        MethodHandle methodHandle = initialTargetHandleCache;
        if (null == methodHandle) {
            methodHandle = CallSite.lookupInitialTarget();
        }
        methodHandle = methodHandle.asType(MethodType.methodType(methodType.returnType));
        return MethodHandles.dropArguments(methodHandle, 0, methodType.arguments);
    }

    private static MethodHandle lookupInitialTarget() {
        try {
            initialTargetHandleCache = MethodHandles.Lookup.internalPrivilegedLookup.findStatic(CallSite.class, "throwIllegalStateException", MethodType.methodType(Void.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
            throw new InternalError("Unable to lookup CallSite initial target");
        }
        return initialTargetHandleCache;
    }
}

