/*
 * Decompiled with CFR 0.152.
 */
package sun.instrument;

import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;

public class TransformerManager {
    private TransformerInfo[] mTransformerList = new TransformerInfo[0];
    private boolean mIsRetransformable;

    TransformerManager(boolean bl) {
        this.mIsRetransformable = bl;
    }

    boolean isRetransformable() {
        return this.mIsRetransformable;
    }

    public synchronized void addTransformer(ClassFileTransformer classFileTransformer) {
        TransformerInfo[] transformerInfoArray = this.mTransformerList;
        TransformerInfo[] transformerInfoArray2 = new TransformerInfo[transformerInfoArray.length + 1];
        System.arraycopy((Object)transformerInfoArray, 0, (Object)transformerInfoArray2, 0, transformerInfoArray.length);
        transformerInfoArray2[transformerInfoArray.length] = new TransformerInfo(classFileTransformer);
        this.mTransformerList = transformerInfoArray2;
    }

    public synchronized boolean removeTransformer(ClassFileTransformer classFileTransformer) {
        boolean bl = false;
        TransformerInfo[] transformerInfoArray = this.mTransformerList;
        int n = transformerInfoArray.length;
        int n2 = n - 1;
        int n3 = 0;
        for (int i = n - 1; i >= 0; --i) {
            if (transformerInfoArray[i].transformer() != classFileTransformer) continue;
            bl = true;
            n3 = i;
            break;
        }
        if (bl) {
            TransformerInfo[] transformerInfoArray2 = new TransformerInfo[n2];
            if (n3 > 0) {
                System.arraycopy((Object)transformerInfoArray, 0, (Object)transformerInfoArray2, 0, n3);
            }
            if (n3 < n2) {
                System.arraycopy((Object)transformerInfoArray, n3 + 1, (Object)transformerInfoArray2, n3, n2 - n3);
            }
            this.mTransformerList = transformerInfoArray2;
        }
        return bl;
    }

    synchronized boolean includesTransformer(ClassFileTransformer classFileTransformer) {
        for (TransformerInfo transformerInfo : this.mTransformerList) {
            if (transformerInfo.transformer() != classFileTransformer) continue;
            return true;
        }
        return false;
    }

    private TransformerInfo[] getSnapshotTransformerList() {
        return this.mTransformerList;
    }

    public byte[] transform(ClassLoader classLoader, String string, Class<?> clazz, ProtectionDomain protectionDomain, byte[] byArray) {
        boolean bl = false;
        TransformerInfo[] transformerInfoArray = this.getSnapshotTransformerList();
        byte[] byArray2 = byArray;
        for (int i = 0; i < transformerInfoArray.length; ++i) {
            TransformerInfo transformerInfo = transformerInfoArray[i];
            ClassFileTransformer classFileTransformer = transformerInfo.transformer();
            byte[] byArray3 = null;
            try {
                byArray3 = classFileTransformer.transform(classLoader, string, clazz, protectionDomain, byArray2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (byArray3 == null) continue;
            bl = true;
            byArray2 = byArray3;
        }
        Object object = bl ? byArray2 : null;
        return object;
    }

    int getTransformerCount() {
        TransformerInfo[] transformerInfoArray = this.getSnapshotTransformerList();
        return transformerInfoArray.length;
    }

    boolean setNativeMethodPrefix(ClassFileTransformer classFileTransformer, String string) {
        TransformerInfo[] transformerInfoArray = this.getSnapshotTransformerList();
        for (int i = 0; i < transformerInfoArray.length; ++i) {
            TransformerInfo transformerInfo = transformerInfoArray[i];
            ClassFileTransformer classFileTransformer2 = transformerInfo.transformer();
            if (classFileTransformer2 != classFileTransformer) continue;
            transformerInfo.setPrefix(string);
            return true;
        }
        return false;
    }

    String[] getNativeMethodPrefixes() {
        TransformerInfo[] transformerInfoArray = this.getSnapshotTransformerList();
        String[] stringArray = new String[transformerInfoArray.length];
        for (int i = 0; i < transformerInfoArray.length; ++i) {
            TransformerInfo transformerInfo = transformerInfoArray[i];
            stringArray[i] = transformerInfo.getPrefix();
        }
        return stringArray;
    }

    private class TransformerInfo {
        final ClassFileTransformer mTransformer;
        String mPrefix;

        TransformerInfo(ClassFileTransformer classFileTransformer) {
            this.mTransformer = classFileTransformer;
            this.mPrefix = null;
        }

        ClassFileTransformer transformer() {
            return this.mTransformer;
        }

        String getPrefix() {
            return this.mPrefix;
        }

        void setPrefix(String string) {
            this.mPrefix = string;
        }
    }
}

