/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AnnotatedElement;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class TypeAnnotation {
    private final TypeAnnotationTargetInfo targetInfo;
    private final LocationInfo loc;
    private final Annotation annotation;
    private final AnnotatedElement baseDeclaration;

    public TypeAnnotation(TypeAnnotationTargetInfo typeAnnotationTargetInfo, LocationInfo locationInfo, Annotation annotation, AnnotatedElement annotatedElement) {
        this.targetInfo = typeAnnotationTargetInfo;
        this.loc = locationInfo;
        this.annotation = annotation;
        this.baseDeclaration = annotatedElement;
    }

    public TypeAnnotationTargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public AnnotatedElement getBaseDeclaration() {
        return this.baseDeclaration;
    }

    public LocationInfo getLocationInfo() {
        return this.loc;
    }

    public static List<TypeAnnotation> filter(TypeAnnotation[] typeAnnotationArray, TypeAnnotationTarget typeAnnotationTarget) {
        ArrayList<TypeAnnotation> arrayList = new ArrayList<TypeAnnotation>(typeAnnotationArray.length);
        for (TypeAnnotation typeAnnotation : typeAnnotationArray) {
            if (typeAnnotation.getTargetInfo().getTarget() != typeAnnotationTarget) continue;
            arrayList.add(typeAnnotation);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public String toString() {
        return this.annotation.toString() + " with Targetnfo: " + this.targetInfo.toString() + " on base declaration: " + this.baseDeclaration.toString();
    }

    public static final class LocationInfo {
        private final int depth;
        private final Location[] locations;
        public static final LocationInfo BASE_LOCATION = new LocationInfo();

        private LocationInfo() {
            this(0, new Location[0]);
        }

        private LocationInfo(int n, Location[] locationArray) {
            this.depth = n;
            this.locations = locationArray;
        }

        public static LocationInfo parseLocationInfo(ByteBuffer byteBuffer) {
            int n = byteBuffer.get() & 0xFF;
            if (n == 0) {
                return BASE_LOCATION;
            }
            Location[] locationArray = new Location[n];
            for (int i = 0; i < n; ++i) {
                byte by = byteBuffer.get();
                short s = (short)(byteBuffer.get() & 0xFF);
                if (by != 0 && !(by == 1 | by == 2) && by != 3) {
                    throw new AnnotationFormatError("Bad Location encoding in Type Annotation");
                }
                if (by != 3 && s != 0) {
                    throw new AnnotationFormatError("Bad Location encoding in Type Annotation");
                }
                locationArray[i] = new Location(by, s);
            }
            return new LocationInfo(n, locationArray);
        }

        public LocationInfo pushArray() {
            return this.pushLocation((byte)0, (short)0);
        }

        public LocationInfo pushInner() {
            return this.pushLocation((byte)1, (short)0);
        }

        public LocationInfo pushWildcard() {
            return this.pushLocation((byte)2, (short)0);
        }

        public LocationInfo pushTypeArg(short s) {
            return this.pushLocation((byte)3, s);
        }

        public LocationInfo pushLocation(byte by, short s) {
            int n = this.depth + 1;
            Location[] locationArray = new Location[n];
            System.arraycopy((Object)this.locations, 0, (Object)locationArray, 0, this.depth);
            locationArray[n - 1] = new Location(by, (short)(s & 0xFF));
            return new LocationInfo(n, locationArray);
        }

        public TypeAnnotation[] filter(TypeAnnotation[] typeAnnotationArray) {
            ArrayList<TypeAnnotation> arrayList = new ArrayList<TypeAnnotation>(typeAnnotationArray.length);
            for (TypeAnnotation typeAnnotation : typeAnnotationArray) {
                if (!this.isSameLocationInfo(typeAnnotation.getLocationInfo())) continue;
                arrayList.add(typeAnnotation);
            }
            return arrayList.toArray(new TypeAnnotation[0]);
        }

        boolean isSameLocationInfo(LocationInfo locationInfo) {
            if (this.depth != locationInfo.depth) {
                return false;
            }
            for (int i = 0; i < this.depth; ++i) {
                if (this.locations[i].isSameLocation(locationInfo.locations[i])) continue;
                return false;
            }
            return true;
        }

        public static final class Location {
            public final byte tag;
            public final short index;

            boolean isSameLocation(Location location) {
                return this.tag == location.tag && this.index == location.index;
            }

            public Location(byte by, short s) {
                this.tag = by;
                this.index = s;
            }
        }
    }

    public static final class TypeAnnotationTargetInfo {
        private final TypeAnnotationTarget target;
        private final int count;
        private final int secondaryIndex;
        private static final int UNUSED_INDEX = -2;

        public TypeAnnotationTargetInfo(TypeAnnotationTarget typeAnnotationTarget) {
            this(typeAnnotationTarget, -2, -2);
        }

        public TypeAnnotationTargetInfo(TypeAnnotationTarget typeAnnotationTarget, int n) {
            this(typeAnnotationTarget, n, -2);
        }

        public TypeAnnotationTargetInfo(TypeAnnotationTarget typeAnnotationTarget, int n, int n2) {
            this.target = typeAnnotationTarget;
            this.count = n;
            this.secondaryIndex = n2;
        }

        public TypeAnnotationTarget getTarget() {
            return this.target;
        }

        public int getCount() {
            return this.count;
        }

        public int getSecondaryIndex() {
            return this.secondaryIndex;
        }

        public String toString() {
            return "" + (Object)((Object)this.target) + ": " + this.count + ", " + this.secondaryIndex;
        }
    }

    public static enum TypeAnnotationTarget {
        CLASS_TYPE_PARAMETER,
        METHOD_TYPE_PARAMETER,
        CLASS_EXTENDS,
        CLASS_IMPLEMENTS,
        CLASS_TYPE_PARAMETER_BOUND,
        METHOD_TYPE_PARAMETER_BOUND,
        FIELD,
        METHOD_RETURN,
        METHOD_RECEIVER,
        METHOD_FORMAL_PARAMETER,
        THROWS;

    }
}

