import { TomlSlashCommandConfigurator } from './toml-base.js';
const FILE_PATHS = {
    proposal: '.gemini/commands/openspec/proposal.toml',
    apply: '.gemini/commands/openspec/apply.toml',
    archive: '.gemini/commands/openspec/archive.toml'
};
const DESCRIPTIONS = {
    proposal: 'Scaffold a new OpenSpec change and validate strictly.',
    apply: 'Implement an approved OpenSpec change and keep tasks in sync.',
    archive: 'Archive a deployed OpenSpec change and update specs.'
};
export class GeminiSlashCommandConfigurator extends TomlSlashCommandConfigurator {
    toolId = 'gemini';
    isAvailable = true;
    getRelativePath(id) {
        return FILE_PATHS[id];
    }
    getDescription(id) {
        return DESCRIPTIONS[id];
    }
}
//# sourceMappingURL=gemini.js.map