// Copyright (c) 2005-2017 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "AguilaXSD.h"

namespace pcrxml
{
  // Aguila
  // 

  const Aguila::multiView_optional& Aguila::
  multiView () const
  {
    return this->multiView_;
  }

  Aguila::multiView_optional& Aguila::
  multiView ()
  {
    return this->multiView_;
  }

  void Aguila::
  multiView (const multiView_type& x)
  {
    this->multiView_.set (x);
  }

  void Aguila::
  multiView (const multiView_optional& x)
  {
    this->multiView_ = x;
  }

  void Aguila::
  multiView (::std::unique_ptr< multiView_type > x)
  {
    this->multiView_.set (std::move (x));
  }

  const Aguila::visualisationGroup_type& Aguila::
  visualisationGroup () const
  {
    return this->visualisationGroup_.get ();
  }

  Aguila::visualisationGroup_type& Aguila::
  visualisationGroup ()
  {
    return this->visualisationGroup_.get ();
  }

  void Aguila::
  visualisationGroup (const visualisationGroup_type& x)
  {
    this->visualisationGroup_.set (x);
  }

  void Aguila::
  visualisationGroup (::std::unique_ptr< visualisationGroup_type > x)
  {
    this->visualisationGroup_.set (std::move (x));
  }


  // VisualisationGroup
  // 

  const VisualisationGroup::cursorValueMonitorFile_optional& VisualisationGroup::
  cursorValueMonitorFile () const
  {
    return this->cursorValueMonitorFile_;
  }

  VisualisationGroup::cursorValueMonitorFile_optional& VisualisationGroup::
  cursorValueMonitorFile ()
  {
    return this->cursorValueMonitorFile_;
  }

  void VisualisationGroup::
  cursorValueMonitorFile (const cursorValueMonitorFile_type& x)
  {
    this->cursorValueMonitorFile_.set (x);
  }

  void VisualisationGroup::
  cursorValueMonitorFile (const cursorValueMonitorFile_optional& x)
  {
    this->cursorValueMonitorFile_ = x;
  }

  void VisualisationGroup::
  cursorValueMonitorFile (::std::unique_ptr< cursorValueMonitorFile_type > x)
  {
    this->cursorValueMonitorFile_.set (std::move (x));
  }

  const VisualisationGroup::fileToGetCursorValue_optional& VisualisationGroup::
  fileToGetCursorValue () const
  {
    return this->fileToGetCursorValue_;
  }

  VisualisationGroup::fileToGetCursorValue_optional& VisualisationGroup::
  fileToGetCursorValue ()
  {
    return this->fileToGetCursorValue_;
  }

  void VisualisationGroup::
  fileToGetCursorValue (const fileToGetCursorValue_type& x)
  {
    this->fileToGetCursorValue_.set (x);
  }

  void VisualisationGroup::
  fileToGetCursorValue (const fileToGetCursorValue_optional& x)
  {
    this->fileToGetCursorValue_ = x;
  }

  void VisualisationGroup::
  fileToGetCursorValue (::std::unique_ptr< fileToGetCursorValue_type > x)
  {
    this->fileToGetCursorValue_.set (std::move (x));
  }

  const VisualisationGroup::searchSpace_optional& VisualisationGroup::
  searchSpace () const
  {
    return this->searchSpace_;
  }

  VisualisationGroup::searchSpace_optional& VisualisationGroup::
  searchSpace ()
  {
    return this->searchSpace_;
  }

  void VisualisationGroup::
  searchSpace (const searchSpace_type& x)
  {
    this->searchSpace_.set (x);
  }

  void VisualisationGroup::
  searchSpace (const searchSpace_optional& x)
  {
    this->searchSpace_ = x;
  }

  void VisualisationGroup::
  searchSpace (::std::unique_ptr< searchSpace_type > x)
  {
    this->searchSpace_.set (std::move (x));
  }

  const VisualisationGroup::data_sequence& VisualisationGroup::
  data () const
  {
    return this->data_;
  }

  VisualisationGroup::data_sequence& VisualisationGroup::
  data ()
  {
    return this->data_;
  }

  void VisualisationGroup::
  data (const data_sequence& s)
  {
    this->data_ = s;
  }

  const VisualisationGroup::view_sequence& VisualisationGroup::
  view () const
  {
    return this->view_;
  }

  VisualisationGroup::view_sequence& VisualisationGroup::
  view ()
  {
    return this->view_;
  }

  void VisualisationGroup::
  view (const view_sequence& s)
  {
    this->view_ = s;
  }


  // DataSpace
  // 

  const DataSpace::scenarios_sequence& DataSpace::
  scenarios () const
  {
    return this->scenarios_;
  }

  DataSpace::scenarios_sequence& DataSpace::
  scenarios ()
  {
    return this->scenarios_;
  }

  void DataSpace::
  scenarios (const scenarios_sequence& s)
  {
    this->scenarios_ = s;
  }

  const DataSpace::quantiles_sequence& DataSpace::
  quantiles () const
  {
    return this->quantiles_;
  }

  DataSpace::quantiles_sequence& DataSpace::
  quantiles ()
  {
    return this->quantiles_;
  }

  void DataSpace::
  quantiles (const quantiles_sequence& s)
  {
    this->quantiles_ = s;
  }

  const DataSpace::timesteps_sequence& DataSpace::
  timesteps () const
  {
    return this->timesteps_;
  }

  DataSpace::timesteps_sequence& DataSpace::
  timesteps ()
  {
    return this->timesteps_;
  }

  void DataSpace::
  timesteps (const timesteps_sequence& s)
  {
    this->timesteps_ = s;
  }


  // Timesteps
  // 

  const Timesteps::dateMapper_optional& Timesteps::
  dateMapper () const
  {
    return this->dateMapper_;
  }

  Timesteps::dateMapper_optional& Timesteps::
  dateMapper ()
  {
    return this->dateMapper_;
  }

  void Timesteps::
  dateMapper (const dateMapper_type& x)
  {
    this->dateMapper_.set (x);
  }

  void Timesteps::
  dateMapper (const dateMapper_optional& x)
  {
    this->dateMapper_ = x;
  }

  void Timesteps::
  dateMapper (::std::unique_ptr< dateMapper_type > x)
  {
    this->dateMapper_.set (std::move (x));
  }


  // DateMapper
  // 

  const DateMapper::index_type& DateMapper::
  index () const
  {
    return this->index_.get ();
  }

  DateMapper::index_type& DateMapper::
  index ()
  {
    return this->index_.get ();
  }

  void DateMapper::
  index (const index_type& x)
  {
    this->index_.set (x);
  }

  const DateMapper::timeOfIndex_type& DateMapper::
  timeOfIndex () const
  {
    return this->timeOfIndex_.get ();
  }

  DateMapper::timeOfIndex_type& DateMapper::
  timeOfIndex ()
  {
    return this->timeOfIndex_.get ();
  }

  void DateMapper::
  timeOfIndex (const timeOfIndex_type& x)
  {
    this->timeOfIndex_.set (x);
  }

  void DateMapper::
  timeOfIndex (::std::unique_ptr< timeOfIndex_type > x)
  {
    this->timeOfIndex_.set (std::move (x));
  }

  const DateMapper::duration_type& DateMapper::
  duration () const
  {
    return this->duration_.get ();
  }

  DateMapper::duration_type& DateMapper::
  duration ()
  {
    return this->duration_.get ();
  }

  void DateMapper::
  duration (const duration_type& x)
  {
    this->duration_.set (x);
  }

  void DateMapper::
  duration (::std::unique_ptr< duration_type > x)
  {
    this->duration_.set (std::move (x));
  }


  // AguilaView
  // 

  const AguilaView::map_optional& AguilaView::
  map () const
  {
    return this->map_;
  }

  AguilaView::map_optional& AguilaView::
  map ()
  {
    return this->map_;
  }

  void AguilaView::
  map (const map_type& x)
  {
    this->map_.set (x);
  }

  void AguilaView::
  map (const map_optional& x)
  {
    this->map_ = x;
  }

  void AguilaView::
  map (::std::unique_ptr< map_type > x)
  {
    this->map_.set (std::move (x));
  }

  const AguilaView::drape_optional& AguilaView::
  drape () const
  {
    return this->drape_;
  }

  AguilaView::drape_optional& AguilaView::
  drape ()
  {
    return this->drape_;
  }

  void AguilaView::
  drape (const drape_type& x)
  {
    this->drape_.set (x);
  }

  void AguilaView::
  drape (const drape_optional& x)
  {
    this->drape_ = x;
  }

  void AguilaView::
  drape (::std::unique_ptr< drape_type > x)
  {
    this->drape_.set (std::move (x));
  }

  const AguilaView::timeGraph_optional& AguilaView::
  timeGraph () const
  {
    return this->timeGraph_;
  }

  AguilaView::timeGraph_optional& AguilaView::
  timeGraph ()
  {
    return this->timeGraph_;
  }

  void AguilaView::
  timeGraph (const timeGraph_type& x)
  {
    this->timeGraph_.set (x);
  }

  void AguilaView::
  timeGraph (const timeGraph_optional& x)
  {
    this->timeGraph_ = x;
  }

  void AguilaView::
  timeGraph (::std::unique_ptr< timeGraph_type > x)
  {
    this->timeGraph_.set (std::move (x));
  }

  const AguilaView::probabilityGraph_optional& AguilaView::
  probabilityGraph () const
  {
    return this->probabilityGraph_;
  }

  AguilaView::probabilityGraph_optional& AguilaView::
  probabilityGraph ()
  {
    return this->probabilityGraph_;
  }

  void AguilaView::
  probabilityGraph (const probabilityGraph_type& x)
  {
    this->probabilityGraph_.set (x);
  }

  void AguilaView::
  probabilityGraph (const probabilityGraph_optional& x)
  {
    this->probabilityGraph_ = x;
  }

  void AguilaView::
  probabilityGraph (::std::unique_ptr< probabilityGraph_type > x)
  {
    this->probabilityGraph_.set (std::move (x));
  }

  const AguilaView::valueOnly_optional& AguilaView::
  valueOnly () const
  {
    return this->valueOnly_;
  }

  AguilaView::valueOnly_optional& AguilaView::
  valueOnly ()
  {
    return this->valueOnly_;
  }

  void AguilaView::
  valueOnly (const valueOnly_type& x)
  {
    this->valueOnly_.set (x);
  }

  void AguilaView::
  valueOnly (const valueOnly_optional& x)
  {
    this->valueOnly_ = x;
  }

  void AguilaView::
  valueOnly (::std::unique_ptr< valueOnly_type > x)
  {
    this->valueOnly_.set (std::move (x));
  }

  const AguilaView::default_optional& AguilaView::
  default_ () const
  {
    return this->default__;
  }

  AguilaView::default_optional& AguilaView::
  default_ ()
  {
    return this->default__;
  }

  void AguilaView::
  default_ (const default_type& x)
  {
    this->default__.set (x);
  }

  void AguilaView::
  default_ (const default_optional& x)
  {
    this->default__ = x;
  }

  void AguilaView::
  default_ (::std::unique_ptr< default_type > x)
  {
    this->default__.set (std::move (x));
  }

  const AguilaView::test_optional& AguilaView::
  test () const
  {
    return this->test_;
  }

  AguilaView::test_optional& AguilaView::
  test ()
  {
    return this->test_;
  }

  void AguilaView::
  test (const test_type& x)
  {
    this->test_.set (x);
  }

  void AguilaView::
  test (const test_optional& x)
  {
    this->test_ = x;
  }

  void AguilaView::
  test (::std::unique_ptr< test_type > x)
  {
    this->test_.set (std::move (x));
  }


  // AguilaData
  // 

  const AguilaData::name_type& AguilaData::
  name () const
  {
    return this->name_.get ();
  }

  AguilaData::name_type& AguilaData::
  name ()
  {
    return this->name_.get ();
  }

  void AguilaData::
  name (const name_type& x)
  {
    this->name_.set (x);
  }

  void AguilaData::
  name (::std::unique_ptr< name_type > x)
  {
    this->name_.set (std::move (x));
  }

  const AguilaData::dataSpace_optional& AguilaData::
  dataSpace () const
  {
    return this->dataSpace_;
  }

  AguilaData::dataSpace_optional& AguilaData::
  dataSpace ()
  {
    return this->dataSpace_;
  }

  void AguilaData::
  dataSpace (const dataSpace_type& x)
  {
    this->dataSpace_.set (x);
  }

  void AguilaData::
  dataSpace (const dataSpace_optional& x)
  {
    this->dataSpace_ = x;
  }

  void AguilaData::
  dataSpace (::std::unique_ptr< dataSpace_type > x)
  {
    this->dataSpace_.set (std::move (x));
  }

  const AguilaData::drawProperties_optional& AguilaData::
  drawProperties () const
  {
    return this->drawProperties_;
  }

  AguilaData::drawProperties_optional& AguilaData::
  drawProperties ()
  {
    return this->drawProperties_;
  }

  void AguilaData::
  drawProperties (const drawProperties_type& x)
  {
    this->drawProperties_.set (x);
  }

  void AguilaData::
  drawProperties (const drawProperties_optional& x)
  {
    this->drawProperties_ = x;
  }

  void AguilaData::
  drawProperties (::std::unique_ptr< drawProperties_type > x)
  {
    this->drawProperties_.set (std::move (x));
  }


  // DrawProperties
  // 

  const DrawProperties::legendBorderValuesType_optional& DrawProperties::
  legendBorderValuesType () const
  {
    return this->legendBorderValuesType_;
  }

  DrawProperties::legendBorderValuesType_optional& DrawProperties::
  legendBorderValuesType ()
  {
    return this->legendBorderValuesType_;
  }

  void DrawProperties::
  legendBorderValuesType (const legendBorderValuesType_type& x)
  {
    this->legendBorderValuesType_.set (x);
  }

  void DrawProperties::
  legendBorderValuesType (const legendBorderValuesType_optional& x)
  {
    this->legendBorderValuesType_ = x;
  }

  void DrawProperties::
  legendBorderValuesType (::std::unique_ptr< legendBorderValuesType_type > x)
  {
    this->legendBorderValuesType_.set (std::move (x));
  }

  const DrawProperties::minimumCutOff_optional& DrawProperties::
  minimumCutOff () const
  {
    return this->minimumCutOff_;
  }

  DrawProperties::minimumCutOff_optional& DrawProperties::
  minimumCutOff ()
  {
    return this->minimumCutOff_;
  }

  void DrawProperties::
  minimumCutOff (const minimumCutOff_type& x)
  {
    this->minimumCutOff_.set (x);
  }

  void DrawProperties::
  minimumCutOff (const minimumCutOff_optional& x)
  {
    this->minimumCutOff_ = x;
  }

  const DrawProperties::maximumCutOff_optional& DrawProperties::
  maximumCutOff () const
  {
    return this->maximumCutOff_;
  }

  DrawProperties::maximumCutOff_optional& DrawProperties::
  maximumCutOff ()
  {
    return this->maximumCutOff_;
  }

  void DrawProperties::
  maximumCutOff (const maximumCutOff_type& x)
  {
    this->maximumCutOff_.set (x);
  }

  void DrawProperties::
  maximumCutOff (const maximumCutOff_optional& x)
  {
    this->maximumCutOff_ = x;
  }

  const DrawProperties::numberOfColours_optional& DrawProperties::
  numberOfColours () const
  {
    return this->numberOfColours_;
  }

  DrawProperties::numberOfColours_optional& DrawProperties::
  numberOfColours ()
  {
    return this->numberOfColours_;
  }

  void DrawProperties::
  numberOfColours (const numberOfColours_type& x)
  {
    this->numberOfColours_.set (x);
  }

  void DrawProperties::
  numberOfColours (const numberOfColours_optional& x)
  {
    this->numberOfColours_ = x;
  }

  void DrawProperties::
  numberOfColours (::std::unique_ptr< numberOfColours_type > x)
  {
    this->numberOfColours_.set (std::move (x));
  }

  const DrawProperties::colourAssignment_optional& DrawProperties::
  colourAssignment () const
  {
    return this->colourAssignment_;
  }

  DrawProperties::colourAssignment_optional& DrawProperties::
  colourAssignment ()
  {
    return this->colourAssignment_;
  }

  void DrawProperties::
  colourAssignment (const colourAssignment_type& x)
  {
    this->colourAssignment_.set (x);
  }

  void DrawProperties::
  colourAssignment (const colourAssignment_optional& x)
  {
    this->colourAssignment_ = x;
  }

  void DrawProperties::
  colourAssignment (::std::unique_ptr< colourAssignment_type > x)
  {
    this->colourAssignment_.set (std::move (x));
  }

  const DrawProperties::drawMode_optional& DrawProperties::
  drawMode () const
  {
    return this->drawMode_;
  }

  DrawProperties::drawMode_optional& DrawProperties::
  drawMode ()
  {
    return this->drawMode_;
  }

  void DrawProperties::
  drawMode (const drawMode_type& x)
  {
    this->drawMode_.set (x);
  }

  void DrawProperties::
  drawMode (const drawMode_optional& x)
  {
    this->drawMode_ = x;
  }

  void DrawProperties::
  drawMode (::std::unique_ptr< drawMode_type > x)
  {
    this->drawMode_.set (std::move (x));
  }

  const DrawProperties::palette_optional& DrawProperties::
  palette () const
  {
    return this->palette_;
  }

  DrawProperties::palette_optional& DrawProperties::
  palette ()
  {
    return this->palette_;
  }

  void DrawProperties::
  palette (const palette_type& x)
  {
    this->palette_.set (x);
  }

  void DrawProperties::
  palette (const palette_optional& x)
  {
    this->palette_ = x;
  }

  void DrawProperties::
  palette (::std::unique_ptr< palette_type > x)
  {
    this->palette_.set (std::move (x));
  }


  // Palette
  // 

  const Palette::rgb_sequence& Palette::
  rgb () const
  {
    return this->rgb_;
  }

  Palette::rgb_sequence& Palette::
  rgb ()
  {
    return this->rgb_;
  }

  void Palette::
  rgb (const rgb_sequence& s)
  {
    this->rgb_ = s;
  }


  // Rgb
  // 

  const Rgb::r_type& Rgb::
  r () const
  {
    return this->r_.get ();
  }

  Rgb::r_type& Rgb::
  r ()
  {
    return this->r_.get ();
  }

  void Rgb::
  r (const r_type& x)
  {
    this->r_.set (x);
  }

  const Rgb::g_type& Rgb::
  g () const
  {
    return this->g_.get ();
  }

  Rgb::g_type& Rgb::
  g ()
  {
    return this->g_.get ();
  }

  void Rgb::
  g (const g_type& x)
  {
    this->g_.set (x);
  }

  const Rgb::b_type& Rgb::
  b () const
  {
    return this->b_.get ();
  }

  Rgb::b_type& Rgb::
  b ()
  {
    return this->b_.get ();
  }

  void Rgb::
  b (const b_type& x)
  {
    this->b_.set (x);
  }


  // LegendBorderValuesType
  // 

  const LegendBorderValuesType::rounded_optional& LegendBorderValuesType::
  rounded () const
  {
    return this->rounded_;
  }

  LegendBorderValuesType::rounded_optional& LegendBorderValuesType::
  rounded ()
  {
    return this->rounded_;
  }

  void LegendBorderValuesType::
  rounded (const rounded_type& x)
  {
    this->rounded_.set (x);
  }

  void LegendBorderValuesType::
  rounded (const rounded_optional& x)
  {
    this->rounded_ = x;
  }

  void LegendBorderValuesType::
  rounded (::std::unique_ptr< rounded_type > x)
  {
    this->rounded_.set (std::move (x));
  }

  const LegendBorderValuesType::exact_optional& LegendBorderValuesType::
  exact () const
  {
    return this->exact_;
  }

  LegendBorderValuesType::exact_optional& LegendBorderValuesType::
  exact ()
  {
    return this->exact_;
  }

  void LegendBorderValuesType::
  exact (const exact_type& x)
  {
    this->exact_.set (x);
  }

  void LegendBorderValuesType::
  exact (const exact_optional& x)
  {
    this->exact_ = x;
  }

  void LegendBorderValuesType::
  exact (::std::unique_ptr< exact_type > x)
  {
    this->exact_.set (std::move (x));
  }


  // ColourAssignment
  // 

  const ColourAssignment::linear_optional& ColourAssignment::
  linear () const
  {
    return this->linear_;
  }

  ColourAssignment::linear_optional& ColourAssignment::
  linear ()
  {
    return this->linear_;
  }

  void ColourAssignment::
  linear (const linear_type& x)
  {
    this->linear_.set (x);
  }

  void ColourAssignment::
  linear (const linear_optional& x)
  {
    this->linear_ = x;
  }

  void ColourAssignment::
  linear (::std::unique_ptr< linear_type > x)
  {
    this->linear_.set (std::move (x));
  }

  const ColourAssignment::trueLogarithmic_optional& ColourAssignment::
  trueLogarithmic () const
  {
    return this->trueLogarithmic_;
  }

  ColourAssignment::trueLogarithmic_optional& ColourAssignment::
  trueLogarithmic ()
  {
    return this->trueLogarithmic_;
  }

  void ColourAssignment::
  trueLogarithmic (const trueLogarithmic_type& x)
  {
    this->trueLogarithmic_.set (x);
  }

  void ColourAssignment::
  trueLogarithmic (const trueLogarithmic_optional& x)
  {
    this->trueLogarithmic_ = x;
  }

  void ColourAssignment::
  trueLogarithmic (::std::unique_ptr< trueLogarithmic_type > x)
  {
    this->trueLogarithmic_.set (std::move (x));
  }

  const ColourAssignment::shiftedLogarithmic_optional& ColourAssignment::
  shiftedLogarithmic () const
  {
    return this->shiftedLogarithmic_;
  }

  ColourAssignment::shiftedLogarithmic_optional& ColourAssignment::
  shiftedLogarithmic ()
  {
    return this->shiftedLogarithmic_;
  }

  void ColourAssignment::
  shiftedLogarithmic (const shiftedLogarithmic_type& x)
  {
    this->shiftedLogarithmic_.set (x);
  }

  void ColourAssignment::
  shiftedLogarithmic (const shiftedLogarithmic_optional& x)
  {
    this->shiftedLogarithmic_ = x;
  }

  void ColourAssignment::
  shiftedLogarithmic (::std::unique_ptr< shiftedLogarithmic_type > x)
  {
    this->shiftedLogarithmic_.set (std::move (x));
  }

  const ColourAssignment::confidenceLevel_optional& ColourAssignment::
  confidenceLevel () const
  {
    return this->confidenceLevel_;
  }

  ColourAssignment::confidenceLevel_optional& ColourAssignment::
  confidenceLevel ()
  {
    return this->confidenceLevel_;
  }

  void ColourAssignment::
  confidenceLevel (const confidenceLevel_type& x)
  {
    this->confidenceLevel_.set (x);
  }

  void ColourAssignment::
  confidenceLevel (const confidenceLevel_optional& x)
  {
    this->confidenceLevel_ = x;
  }

  void ColourAssignment::
  confidenceLevel (::std::unique_ptr< confidenceLevel_type > x)
  {
    this->confidenceLevel_.set (std::move (x));
  }


  // ConfidenceLevel
  // 

  const ConfidenceLevel::value_type& ConfidenceLevel::
  value () const
  {
    return this->value_.get ();
  }

  ConfidenceLevel::value_type& ConfidenceLevel::
  value ()
  {
    return this->value_.get ();
  }

  void ConfidenceLevel::
  value (const value_type& x)
  {
    this->value_.set (x);
  }


  // DrawMode
  // 

  const DrawMode::fill_optional& DrawMode::
  fill () const
  {
    return this->fill_;
  }

  DrawMode::fill_optional& DrawMode::
  fill ()
  {
    return this->fill_;
  }

  void DrawMode::
  fill (const fill_type& x)
  {
    this->fill_.set (x);
  }

  void DrawMode::
  fill (const fill_optional& x)
  {
    this->fill_ = x;
  }

  void DrawMode::
  fill (::std::unique_ptr< fill_type > x)
  {
    this->fill_.set (std::move (x));
  }

  const DrawMode::contour_optional& DrawMode::
  contour () const
  {
    return this->contour_;
  }

  DrawMode::contour_optional& DrawMode::
  contour ()
  {
    return this->contour_;
  }

  void DrawMode::
  contour (const contour_type& x)
  {
    this->contour_.set (x);
  }

  void DrawMode::
  contour (const contour_optional& x)
  {
    this->contour_ = x;
  }

  void DrawMode::
  contour (::std::unique_ptr< contour_type > x)
  {
    this->contour_.set (std::move (x));
  }


  // AguilaCursorValues
  // 

  const AguilaCursorValues::aguilaCursorValue_sequence& AguilaCursorValues::
  aguilaCursorValue () const
  {
    return this->aguilaCursorValue_;
  }

  AguilaCursorValues::aguilaCursorValue_sequence& AguilaCursorValues::
  aguilaCursorValue ()
  {
    return this->aguilaCursorValue_;
  }

  void AguilaCursorValues::
  aguilaCursorValue (const aguilaCursorValue_sequence& s)
  {
    this->aguilaCursorValue_ = s;
  }


  // AguilaCursorValue
  // 

  const AguilaCursorValue::cursor_optional& AguilaCursorValue::
  cursor () const
  {
    return this->cursor_;
  }

  AguilaCursorValue::cursor_optional& AguilaCursorValue::
  cursor ()
  {
    return this->cursor_;
  }

  void AguilaCursorValue::
  cursor (const cursor_type& x)
  {
    this->cursor_.set (x);
  }

  void AguilaCursorValue::
  cursor (const cursor_optional& x)
  {
    this->cursor_ = x;
  }

  void AguilaCursorValue::
  cursor (::std::unique_ptr< cursor_type > x)
  {
    this->cursor_.set (std::move (x));
  }

  const AguilaCursorValue::dataValue_sequence& AguilaCursorValue::
  dataValue () const
  {
    return this->dataValue_;
  }

  AguilaCursorValue::dataValue_sequence& AguilaCursorValue::
  dataValue ()
  {
    return this->dataValue_;
  }

  void AguilaCursorValue::
  dataValue (const dataValue_sequence& s)
  {
    this->dataValue_ = s;
  }


  // Cursor
  // 

  const Cursor::time_optional& Cursor::
  time () const
  {
    return this->time_;
  }

  Cursor::time_optional& Cursor::
  time ()
  {
    return this->time_;
  }

  void Cursor::
  time (const time_type& x)
  {
    this->time_.set (x);
  }

  void Cursor::
  time (const time_optional& x)
  {
    this->time_ = x;
  }

  const Cursor::date_optional& Cursor::
  date () const
  {
    return this->date_;
  }

  Cursor::date_optional& Cursor::
  date ()
  {
    return this->date_;
  }

  void Cursor::
  date (const date_type& x)
  {
    this->date_.set (x);
  }

  void Cursor::
  date (const date_optional& x)
  {
    this->date_ = x;
  }

  void Cursor::
  date (::std::unique_ptr< date_type > x)
  {
    this->date_.set (std::move (x));
  }

  const Cursor::x_optional& Cursor::
  x () const
  {
    return this->x_;
  }

  Cursor::x_optional& Cursor::
  x ()
  {
    return this->x_;
  }

  void Cursor::
  x (const x_type& x)
  {
    this->x_.set (x);
  }

  void Cursor::
  x (const x_optional& x)
  {
    this->x_ = x;
  }

  const Cursor::y_optional& Cursor::
  y () const
  {
    return this->y_;
  }

  Cursor::y_optional& Cursor::
  y ()
  {
    return this->y_;
  }

  void Cursor::
  y (const y_type& x)
  {
    this->y_.set (x);
  }

  void Cursor::
  y (const y_optional& x)
  {
    this->y_ = x;
  }


  // DataValue
  // 

  const DataValue::name_type& DataValue::
  name () const
  {
    return this->name_.get ();
  }

  DataValue::name_type& DataValue::
  name ()
  {
    return this->name_.get ();
  }

  void DataValue::
  name (const name_type& x)
  {
    this->name_.set (x);
  }

  void DataValue::
  name (::std::unique_ptr< name_type > x)
  {
    this->name_.set (std::move (x));
  }

  const DataValue::value_type& DataValue::
  value () const
  {
    return this->value_.get ();
  }

  DataValue::value_type& DataValue::
  value ()
  {
    return this->value_.get ();
  }

  void DataValue::
  value (const value_type& x)
  {
    this->value_.set (x);
  }

  void DataValue::
  value (::std::unique_ptr< value_type > x)
  {
    this->value_.set (std::move (x));
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

namespace pcrxml
{
  // Aguila
  //

  Aguila::
  Aguila (const visualisationGroup_type& visualisationGroup)
  : ::xml_schema::type (),
    multiView_ (this),
    visualisationGroup_ (visualisationGroup, this)
  {
  }

  Aguila::
  Aguila (::std::unique_ptr< visualisationGroup_type > visualisationGroup)
  : ::xml_schema::type (),
    multiView_ (this),
    visualisationGroup_ (std::move (visualisationGroup), this)
  {
  }

  Aguila::
  Aguila (const Aguila& x,
          ::xml_schema::flags f,
          ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    multiView_ (x.multiView_, f, this),
    visualisationGroup_ (x.visualisationGroup_, f, this)
  {
  }

  Aguila::
  Aguila (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    multiView_ (this),
    visualisationGroup_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void Aguila::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // multiView
      //
      if (n.name () == "multiView" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< multiView_type > r (
          multiView_traits::create (i, f, this));

        if (!this->multiView_)
        {
          this->multiView_.set (::std::move (r));
          continue;
        }
      }

      // visualisationGroup
      //
      if (n.name () == "visualisationGroup" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< visualisationGroup_type > r (
          visualisationGroup_traits::create (i, f, this));

        if (!visualisationGroup_.present ())
        {
          this->visualisationGroup_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!visualisationGroup_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "visualisationGroup",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  Aguila* Aguila::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Aguila (*this, f, c);
  }

  Aguila& Aguila::
  operator= (const Aguila& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->multiView_ = x.multiView_;
      this->visualisationGroup_ = x.visualisationGroup_;
    }

    return *this;
  }

  Aguila::
  ~Aguila ()
  {
  }

  // VisualisationGroup
  //

  VisualisationGroup::
  VisualisationGroup ()
  : ::xml_schema::type (),
    cursorValueMonitorFile_ (this),
    fileToGetCursorValue_ (this),
    searchSpace_ (this),
    data_ (this),
    view_ (this)
  {
  }

  VisualisationGroup::
  VisualisationGroup (const VisualisationGroup& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    cursorValueMonitorFile_ (x.cursorValueMonitorFile_, f, this),
    fileToGetCursorValue_ (x.fileToGetCursorValue_, f, this),
    searchSpace_ (x.searchSpace_, f, this),
    data_ (x.data_, f, this),
    view_ (x.view_, f, this)
  {
  }

  VisualisationGroup::
  VisualisationGroup (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    cursorValueMonitorFile_ (this),
    fileToGetCursorValue_ (this),
    searchSpace_ (this),
    data_ (this),
    view_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void VisualisationGroup::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // cursorValueMonitorFile
      //
      if (n.name () == "cursorValueMonitorFile" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< cursorValueMonitorFile_type > r (
          cursorValueMonitorFile_traits::create (i, f, this));

        if (!this->cursorValueMonitorFile_)
        {
          this->cursorValueMonitorFile_.set (::std::move (r));
          continue;
        }
      }

      // fileToGetCursorValue
      //
      if (n.name () == "fileToGetCursorValue" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< fileToGetCursorValue_type > r (
          fileToGetCursorValue_traits::create (i, f, this));

        if (!this->fileToGetCursorValue_)
        {
          this->fileToGetCursorValue_.set (::std::move (r));
          continue;
        }
      }

      // searchSpace
      //
      if (n.name () == "searchSpace" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< searchSpace_type > r (
          searchSpace_traits::create (i, f, this));

        if (!this->searchSpace_)
        {
          this->searchSpace_.set (::std::move (r));
          continue;
        }
      }

      // data
      //
      if (n.name () == "data" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< data_type > r (
          data_traits::create (i, f, this));

        this->data_.push_back (::std::move (r));
        continue;
      }

      // view
      //
      if (n.name () == "view" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< view_type > r (
          view_traits::create (i, f, this));

        this->view_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  VisualisationGroup* VisualisationGroup::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class VisualisationGroup (*this, f, c);
  }

  VisualisationGroup& VisualisationGroup::
  operator= (const VisualisationGroup& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->cursorValueMonitorFile_ = x.cursorValueMonitorFile_;
      this->fileToGetCursorValue_ = x.fileToGetCursorValue_;
      this->searchSpace_ = x.searchSpace_;
      this->data_ = x.data_;
      this->view_ = x.view_;
    }

    return *this;
  }

  VisualisationGroup::
  ~VisualisationGroup ()
  {
  }

  // DataSpace
  //

  DataSpace::
  DataSpace ()
  : ::xml_schema::type (),
    scenarios_ (this),
    quantiles_ (this),
    timesteps_ (this)
  {
  }

  DataSpace::
  DataSpace (const DataSpace& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    scenarios_ (x.scenarios_, f, this),
    quantiles_ (x.quantiles_, f, this),
    timesteps_ (x.timesteps_, f, this)
  {
  }

  DataSpace::
  DataSpace (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    scenarios_ (this),
    quantiles_ (this),
    timesteps_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DataSpace::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // scenarios
      //
      if (n.name () == "scenarios" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< scenarios_type > r (
          scenarios_traits::create (i, f, this));

        this->scenarios_.push_back (::std::move (r));
        continue;
      }

      // quantiles
      //
      if (n.name () == "quantiles" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< quantiles_type > r (
          quantiles_traits::create (i, f, this));

        this->quantiles_.push_back (::std::move (r));
        continue;
      }

      // timesteps
      //
      if (n.name () == "timesteps" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< timesteps_type > r (
          timesteps_traits::create (i, f, this));

        this->timesteps_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  DataSpace* DataSpace::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DataSpace (*this, f, c);
  }

  DataSpace& DataSpace::
  operator= (const DataSpace& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->scenarios_ = x.scenarios_;
      this->quantiles_ = x.quantiles_;
      this->timesteps_ = x.timesteps_;
    }

    return *this;
  }

  DataSpace::
  ~DataSpace ()
  {
  }

  // Timesteps
  //

  Timesteps::
  Timesteps ()
  : ::pcrxml::OneBasedIntegerRangeOrSet (),
    dateMapper_ (this)
  {
  }

  Timesteps::
  Timesteps (const Timesteps& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::pcrxml::OneBasedIntegerRangeOrSet (x, f, c),
    dateMapper_ (x.dateMapper_, f, this)
  {
  }

  Timesteps::
  Timesteps (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::pcrxml::OneBasedIntegerRangeOrSet (e, f | ::xml_schema::flags::base, c),
    dateMapper_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void Timesteps::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::pcrxml::OneBasedIntegerRangeOrSet::parse (p, f);

    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // dateMapper
      //
      if (n.name () == "dateMapper" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< dateMapper_type > r (
          dateMapper_traits::create (i, f, this));

        if (!this->dateMapper_)
        {
          this->dateMapper_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  Timesteps* Timesteps::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Timesteps (*this, f, c);
  }

  Timesteps& Timesteps::
  operator= (const Timesteps& x)
  {
    if (this != &x)
    {
      static_cast< ::pcrxml::OneBasedIntegerRangeOrSet& > (*this) = x;
      this->dateMapper_ = x.dateMapper_;
    }

    return *this;
  }

  Timesteps::
  ~Timesteps ()
  {
  }

  // DateMapper
  //

  DateMapper::
  DateMapper (const index_type& index,
              const timeOfIndex_type& timeOfIndex,
              const duration_type& duration)
  : ::xml_schema::type (),
    index_ (index, this),
    timeOfIndex_ (timeOfIndex, this),
    duration_ (duration, this)
  {
  }

  DateMapper::
  DateMapper (const index_type& index,
              const timeOfIndex_type& timeOfIndex,
              ::std::unique_ptr< duration_type > duration)
  : ::xml_schema::type (),
    index_ (index, this),
    timeOfIndex_ (timeOfIndex, this),
    duration_ (std::move (duration), this)
  {
  }

  DateMapper::
  DateMapper (const DateMapper& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    index_ (x.index_, f, this),
    timeOfIndex_ (x.timeOfIndex_, f, this),
    duration_ (x.duration_, f, this)
  {
  }

  DateMapper::
  DateMapper (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    index_ (this),
    timeOfIndex_ (this),
    duration_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DateMapper::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // index
      //
      if (n.name () == "index" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!index_.present ())
        {
          this->index_.set (index_traits::create (i, f, this));
          continue;
        }
      }

      // timeOfIndex
      //
      if (n.name () == "timeOfIndex" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< timeOfIndex_type > r (
          timeOfIndex_traits::create (i, f, this));

        if (!timeOfIndex_.present ())
        {
          this->timeOfIndex_.set (::std::move (r));
          continue;
        }
      }

      // duration
      //
      if (n.name () == "duration" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< duration_type > r (
          duration_traits::create (i, f, this));

        if (!duration_.present ())
        {
          this->duration_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!index_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "index",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!timeOfIndex_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "timeOfIndex",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!duration_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "duration",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  DateMapper* DateMapper::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DateMapper (*this, f, c);
  }

  DateMapper& DateMapper::
  operator= (const DateMapper& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->index_ = x.index_;
      this->timeOfIndex_ = x.timeOfIndex_;
      this->duration_ = x.duration_;
    }

    return *this;
  }

  DateMapper::
  ~DateMapper ()
  {
  }

  // AguilaView
  //

  AguilaView::
  AguilaView ()
  : ::xml_schema::type (),
    map_ (this),
    drape_ (this),
    timeGraph_ (this),
    probabilityGraph_ (this),
    valueOnly_ (this),
    default__ (this),
    test_ (this)
  {
  }

  AguilaView::
  AguilaView (const AguilaView& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    map_ (x.map_, f, this),
    drape_ (x.drape_, f, this),
    timeGraph_ (x.timeGraph_, f, this),
    probabilityGraph_ (x.probabilityGraph_, f, this),
    valueOnly_ (x.valueOnly_, f, this),
    default__ (x.default__, f, this),
    test_ (x.test_, f, this)
  {
  }

  AguilaView::
  AguilaView (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    map_ (this),
    drape_ (this),
    timeGraph_ (this),
    probabilityGraph_ (this),
    valueOnly_ (this),
    default__ (this),
    test_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void AguilaView::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // map
      //
      if (n.name () == "map" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< map_type > r (
          map_traits::create (i, f, this));

        if (!this->map_)
        {
          this->map_.set (::std::move (r));
          continue;
        }
      }

      // drape
      //
      if (n.name () == "drape" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< drape_type > r (
          drape_traits::create (i, f, this));

        if (!this->drape_)
        {
          this->drape_.set (::std::move (r));
          continue;
        }
      }

      // timeGraph
      //
      if (n.name () == "timeGraph" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< timeGraph_type > r (
          timeGraph_traits::create (i, f, this));

        if (!this->timeGraph_)
        {
          this->timeGraph_.set (::std::move (r));
          continue;
        }
      }

      // probabilityGraph
      //
      if (n.name () == "probabilityGraph" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< probabilityGraph_type > r (
          probabilityGraph_traits::create (i, f, this));

        if (!this->probabilityGraph_)
        {
          this->probabilityGraph_.set (::std::move (r));
          continue;
        }
      }

      // valueOnly
      //
      if (n.name () == "valueOnly" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< valueOnly_type > r (
          valueOnly_traits::create (i, f, this));

        if (!this->valueOnly_)
        {
          this->valueOnly_.set (::std::move (r));
          continue;
        }
      }

      // default
      //
      if (n.name () == "default" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< default_type > r (
          default_traits::create (i, f, this));

        if (!this->default__)
        {
          this->default__.set (::std::move (r));
          continue;
        }
      }

      // test
      //
      if (n.name () == "test" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< test_type > r (
          test_traits::create (i, f, this));

        if (!this->test_)
        {
          this->test_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  AguilaView* AguilaView::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AguilaView (*this, f, c);
  }

  AguilaView& AguilaView::
  operator= (const AguilaView& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->map_ = x.map_;
      this->drape_ = x.drape_;
      this->timeGraph_ = x.timeGraph_;
      this->probabilityGraph_ = x.probabilityGraph_;
      this->valueOnly_ = x.valueOnly_;
      this->default__ = x.default__;
      this->test_ = x.test_;
    }

    return *this;
  }

  AguilaView::
  ~AguilaView ()
  {
  }

  // AguilaData
  //

  AguilaData::
  AguilaData (const name_type& name)
  : ::xml_schema::type (),
    name_ (name, this),
    dataSpace_ (this),
    drawProperties_ (this)
  {
  }

  AguilaData::
  AguilaData (const AguilaData& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    name_ (x.name_, f, this),
    dataSpace_ (x.dataSpace_, f, this),
    drawProperties_ (x.drawProperties_, f, this)
  {
  }

  AguilaData::
  AguilaData (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    name_ (this),
    dataSpace_ (this),
    drawProperties_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void AguilaData::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // name
      //
      if (n.name () == "name" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< name_type > r (
          name_traits::create (i, f, this));

        if (!name_.present ())
        {
          this->name_.set (::std::move (r));
          continue;
        }
      }

      // dataSpace
      //
      if (n.name () == "dataSpace" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< dataSpace_type > r (
          dataSpace_traits::create (i, f, this));

        if (!this->dataSpace_)
        {
          this->dataSpace_.set (::std::move (r));
          continue;
        }
      }

      // drawProperties
      //
      if (n.name () == "drawProperties" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< drawProperties_type > r (
          drawProperties_traits::create (i, f, this));

        if (!this->drawProperties_)
        {
          this->drawProperties_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!name_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "name",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  AguilaData* AguilaData::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AguilaData (*this, f, c);
  }

  AguilaData& AguilaData::
  operator= (const AguilaData& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->name_ = x.name_;
      this->dataSpace_ = x.dataSpace_;
      this->drawProperties_ = x.drawProperties_;
    }

    return *this;
  }

  AguilaData::
  ~AguilaData ()
  {
  }

  // DrawProperties
  //

  DrawProperties::
  DrawProperties ()
  : ::xml_schema::type (),
    legendBorderValuesType_ (this),
    minimumCutOff_ (this),
    maximumCutOff_ (this),
    numberOfColours_ (this),
    colourAssignment_ (this),
    drawMode_ (this),
    palette_ (this)
  {
  }

  DrawProperties::
  DrawProperties (const DrawProperties& x,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    legendBorderValuesType_ (x.legendBorderValuesType_, f, this),
    minimumCutOff_ (x.minimumCutOff_, f, this),
    maximumCutOff_ (x.maximumCutOff_, f, this),
    numberOfColours_ (x.numberOfColours_, f, this),
    colourAssignment_ (x.colourAssignment_, f, this),
    drawMode_ (x.drawMode_, f, this),
    palette_ (x.palette_, f, this)
  {
  }

  DrawProperties::
  DrawProperties (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f,
                  ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    legendBorderValuesType_ (this),
    minimumCutOff_ (this),
    maximumCutOff_ (this),
    numberOfColours_ (this),
    colourAssignment_ (this),
    drawMode_ (this),
    palette_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DrawProperties::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // legendBorderValuesType
      //
      if (n.name () == "legendBorderValuesType" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< legendBorderValuesType_type > r (
          legendBorderValuesType_traits::create (i, f, this));

        if (!this->legendBorderValuesType_)
        {
          this->legendBorderValuesType_.set (::std::move (r));
          continue;
        }
      }

      // minimumCutOff
      //
      if (n.name () == "minimumCutOff" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->minimumCutOff_)
        {
          this->minimumCutOff_.set (minimumCutOff_traits::create (i, f, this));
          continue;
        }
      }

      // maximumCutOff
      //
      if (n.name () == "maximumCutOff" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->maximumCutOff_)
        {
          this->maximumCutOff_.set (maximumCutOff_traits::create (i, f, this));
          continue;
        }
      }

      // numberOfColours
      //
      if (n.name () == "numberOfColours" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< numberOfColours_type > r (
          numberOfColours_traits::create (i, f, this));

        if (!this->numberOfColours_)
        {
          this->numberOfColours_.set (::std::move (r));
          continue;
        }
      }

      // colourAssignment
      //
      if (n.name () == "colourAssignment" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< colourAssignment_type > r (
          colourAssignment_traits::create (i, f, this));

        if (!this->colourAssignment_)
        {
          this->colourAssignment_.set (::std::move (r));
          continue;
        }
      }

      // drawMode
      //
      if (n.name () == "drawMode" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< drawMode_type > r (
          drawMode_traits::create (i, f, this));

        if (!this->drawMode_)
        {
          this->drawMode_.set (::std::move (r));
          continue;
        }
      }

      // palette
      //
      if (n.name () == "palette" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< palette_type > r (
          palette_traits::create (i, f, this));

        if (!this->palette_)
        {
          this->palette_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  DrawProperties* DrawProperties::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DrawProperties (*this, f, c);
  }

  DrawProperties& DrawProperties::
  operator= (const DrawProperties& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->legendBorderValuesType_ = x.legendBorderValuesType_;
      this->minimumCutOff_ = x.minimumCutOff_;
      this->maximumCutOff_ = x.maximumCutOff_;
      this->numberOfColours_ = x.numberOfColours_;
      this->colourAssignment_ = x.colourAssignment_;
      this->drawMode_ = x.drawMode_;
      this->palette_ = x.palette_;
    }

    return *this;
  }

  DrawProperties::
  ~DrawProperties ()
  {
  }

  // Palette
  //

  Palette::
  Palette ()
  : ::xml_schema::type (),
    rgb_ (this)
  {
  }

  Palette::
  Palette (const Palette& x,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    rgb_ (x.rgb_, f, this)
  {
  }

  Palette::
  Palette (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    rgb_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void Palette::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // rgb
      //
      if (n.name () == "rgb" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< rgb_type > r (
          rgb_traits::create (i, f, this));

        this->rgb_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  Palette* Palette::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Palette (*this, f, c);
  }

  Palette& Palette::
  operator= (const Palette& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->rgb_ = x.rgb_;
    }

    return *this;
  }

  Palette::
  ~Palette ()
  {
  }

  // Rgb
  //

  Rgb::
  Rgb (const r_type& r,
       const g_type& g,
       const b_type& b)
  : ::xml_schema::type (),
    r_ (r, this),
    g_ (g, this),
    b_ (b, this)
  {
  }

  Rgb::
  Rgb (const Rgb& x,
       ::xml_schema::flags f,
       ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    r_ (x.r_, f, this),
    g_ (x.g_, f, this),
    b_ (x.b_, f, this)
  {
  }

  Rgb::
  Rgb (const ::xercesc::DOMElement& e,
       ::xml_schema::flags f,
       ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    r_ (this),
    g_ (this),
    b_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void Rgb::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // r
      //
      if (n.name () == "r" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!r_.present ())
        {
          this->r_.set (r_traits::create (i, f, this));
          continue;
        }
      }

      // g
      //
      if (n.name () == "g" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!g_.present ())
        {
          this->g_.set (g_traits::create (i, f, this));
          continue;
        }
      }

      // b
      //
      if (n.name () == "b" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!b_.present ())
        {
          this->b_.set (b_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!r_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "r",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!g_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "g",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!b_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "b",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  Rgb* Rgb::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Rgb (*this, f, c);
  }

  Rgb& Rgb::
  operator= (const Rgb& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->r_ = x.r_;
      this->g_ = x.g_;
      this->b_ = x.b_;
    }

    return *this;
  }

  Rgb::
  ~Rgb ()
  {
  }

  // LegendBorderValuesType
  //

  LegendBorderValuesType::
  LegendBorderValuesType ()
  : ::xml_schema::type (),
    rounded_ (this),
    exact_ (this)
  {
  }

  LegendBorderValuesType::
  LegendBorderValuesType (const LegendBorderValuesType& x,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    rounded_ (x.rounded_, f, this),
    exact_ (x.exact_, f, this)
  {
  }

  LegendBorderValuesType::
  LegendBorderValuesType (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f,
                          ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    rounded_ (this),
    exact_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void LegendBorderValuesType::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // rounded
      //
      if (n.name () == "rounded" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< rounded_type > r (
          rounded_traits::create (i, f, this));

        if (!this->rounded_)
        {
          this->rounded_.set (::std::move (r));
          continue;
        }
      }

      // exact
      //
      if (n.name () == "exact" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< exact_type > r (
          exact_traits::create (i, f, this));

        if (!this->exact_)
        {
          this->exact_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  LegendBorderValuesType* LegendBorderValuesType::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class LegendBorderValuesType (*this, f, c);
  }

  LegendBorderValuesType& LegendBorderValuesType::
  operator= (const LegendBorderValuesType& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->rounded_ = x.rounded_;
      this->exact_ = x.exact_;
    }

    return *this;
  }

  LegendBorderValuesType::
  ~LegendBorderValuesType ()
  {
  }

  // ColourAssignment
  //

  ColourAssignment::
  ColourAssignment ()
  : ::xml_schema::type (),
    linear_ (this),
    trueLogarithmic_ (this),
    shiftedLogarithmic_ (this),
    confidenceLevel_ (this)
  {
  }

  ColourAssignment::
  ColourAssignment (const ColourAssignment& x,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    linear_ (x.linear_, f, this),
    trueLogarithmic_ (x.trueLogarithmic_, f, this),
    shiftedLogarithmic_ (x.shiftedLogarithmic_, f, this),
    confidenceLevel_ (x.confidenceLevel_, f, this)
  {
  }

  ColourAssignment::
  ColourAssignment (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f,
                    ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    linear_ (this),
    trueLogarithmic_ (this),
    shiftedLogarithmic_ (this),
    confidenceLevel_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void ColourAssignment::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // linear
      //
      if (n.name () == "linear" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< linear_type > r (
          linear_traits::create (i, f, this));

        if (!this->linear_)
        {
          this->linear_.set (::std::move (r));
          continue;
        }
      }

      // trueLogarithmic
      //
      if (n.name () == "trueLogarithmic" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< trueLogarithmic_type > r (
          trueLogarithmic_traits::create (i, f, this));

        if (!this->trueLogarithmic_)
        {
          this->trueLogarithmic_.set (::std::move (r));
          continue;
        }
      }

      // shiftedLogarithmic
      //
      if (n.name () == "shiftedLogarithmic" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< shiftedLogarithmic_type > r (
          shiftedLogarithmic_traits::create (i, f, this));

        if (!this->shiftedLogarithmic_)
        {
          this->shiftedLogarithmic_.set (::std::move (r));
          continue;
        }
      }

      // confidenceLevel
      //
      if (n.name () == "confidenceLevel" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< confidenceLevel_type > r (
          confidenceLevel_traits::create (i, f, this));

        if (!this->confidenceLevel_)
        {
          this->confidenceLevel_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  ColourAssignment* ColourAssignment::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ColourAssignment (*this, f, c);
  }

  ColourAssignment& ColourAssignment::
  operator= (const ColourAssignment& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->linear_ = x.linear_;
      this->trueLogarithmic_ = x.trueLogarithmic_;
      this->shiftedLogarithmic_ = x.shiftedLogarithmic_;
      this->confidenceLevel_ = x.confidenceLevel_;
    }

    return *this;
  }

  ColourAssignment::
  ~ColourAssignment ()
  {
  }

  // ConfidenceLevel
  //

  ConfidenceLevel::
  ConfidenceLevel (const value_type& value)
  : ::xml_schema::type (),
    value_ (value, this)
  {
  }

  ConfidenceLevel::
  ConfidenceLevel (const ConfidenceLevel& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    value_ (x.value_, f, this)
  {
  }

  ConfidenceLevel::
  ConfidenceLevel (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    value_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void ConfidenceLevel::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // value
      //
      if (n.name () == "value" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!value_.present ())
        {
          this->value_.set (value_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!value_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "value",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  ConfidenceLevel* ConfidenceLevel::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class ConfidenceLevel (*this, f, c);
  }

  ConfidenceLevel& ConfidenceLevel::
  operator= (const ConfidenceLevel& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->value_ = x.value_;
    }

    return *this;
  }

  ConfidenceLevel::
  ~ConfidenceLevel ()
  {
  }

  // DrawMode
  //

  DrawMode::
  DrawMode ()
  : ::xml_schema::type (),
    fill_ (this),
    contour_ (this)
  {
  }

  DrawMode::
  DrawMode (const DrawMode& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    fill_ (x.fill_, f, this),
    contour_ (x.contour_, f, this)
  {
  }

  DrawMode::
  DrawMode (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    fill_ (this),
    contour_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DrawMode::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // fill
      //
      if (n.name () == "fill" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< fill_type > r (
          fill_traits::create (i, f, this));

        if (!this->fill_)
        {
          this->fill_.set (::std::move (r));
          continue;
        }
      }

      // contour
      //
      if (n.name () == "contour" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< contour_type > r (
          contour_traits::create (i, f, this));

        if (!this->contour_)
        {
          this->contour_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  DrawMode* DrawMode::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DrawMode (*this, f, c);
  }

  DrawMode& DrawMode::
  operator= (const DrawMode& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->fill_ = x.fill_;
      this->contour_ = x.contour_;
    }

    return *this;
  }

  DrawMode::
  ~DrawMode ()
  {
  }

  // AguilaCursorValues
  //

  AguilaCursorValues::
  AguilaCursorValues ()
  : ::xml_schema::type (),
    aguilaCursorValue_ (this)
  {
  }

  AguilaCursorValues::
  AguilaCursorValues (const AguilaCursorValues& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    aguilaCursorValue_ (x.aguilaCursorValue_, f, this)
  {
  }

  AguilaCursorValues::
  AguilaCursorValues (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    aguilaCursorValue_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void AguilaCursorValues::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // aguilaCursorValue
      //
      if (n.name () == "aguilaCursorValue" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< aguilaCursorValue_type > r (
          aguilaCursorValue_traits::create (i, f, this));

        this->aguilaCursorValue_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  AguilaCursorValues* AguilaCursorValues::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AguilaCursorValues (*this, f, c);
  }

  AguilaCursorValues& AguilaCursorValues::
  operator= (const AguilaCursorValues& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->aguilaCursorValue_ = x.aguilaCursorValue_;
    }

    return *this;
  }

  AguilaCursorValues::
  ~AguilaCursorValues ()
  {
  }

  // AguilaCursorValue
  //

  AguilaCursorValue::
  AguilaCursorValue ()
  : ::xml_schema::type (),
    cursor_ (this),
    dataValue_ (this)
  {
  }

  AguilaCursorValue::
  AguilaCursorValue (const AguilaCursorValue& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    cursor_ (x.cursor_, f, this),
    dataValue_ (x.dataValue_, f, this)
  {
  }

  AguilaCursorValue::
  AguilaCursorValue (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    cursor_ (this),
    dataValue_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void AguilaCursorValue::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // cursor
      //
      if (n.name () == "cursor" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< cursor_type > r (
          cursor_traits::create (i, f, this));

        if (!this->cursor_)
        {
          this->cursor_.set (::std::move (r));
          continue;
        }
      }

      // dataValue
      //
      if (n.name () == "dataValue" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< dataValue_type > r (
          dataValue_traits::create (i, f, this));

        this->dataValue_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  AguilaCursorValue* AguilaCursorValue::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class AguilaCursorValue (*this, f, c);
  }

  AguilaCursorValue& AguilaCursorValue::
  operator= (const AguilaCursorValue& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->cursor_ = x.cursor_;
      this->dataValue_ = x.dataValue_;
    }

    return *this;
  }

  AguilaCursorValue::
  ~AguilaCursorValue ()
  {
  }

  // Cursor
  //

  Cursor::
  Cursor ()
  : ::xml_schema::type (),
    time_ (this),
    date_ (this),
    x_ (this),
    y_ (this)
  {
  }

  Cursor::
  Cursor (const Cursor& x,
          ::xml_schema::flags f,
          ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    time_ (x.time_, f, this),
    date_ (x.date_, f, this),
    x_ (x.x_, f, this),
    y_ (x.y_, f, this)
  {
  }

  Cursor::
  Cursor (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    time_ (this),
    date_ (this),
    x_ (this),
    y_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void Cursor::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // time
      //
      if (n.name () == "time" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->time_)
        {
          this->time_.set (time_traits::create (i, f, this));
          continue;
        }
      }

      // date
      //
      if (n.name () == "date" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< date_type > r (
          date_traits::create (i, f, this));

        if (!this->date_)
        {
          this->date_.set (::std::move (r));
          continue;
        }
      }

      // x
      //
      if (n.name () == "x" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->x_)
        {
          this->x_.set (x_traits::create (i, f, this));
          continue;
        }
      }

      // y
      //
      if (n.name () == "y" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->y_)
        {
          this->y_.set (y_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }
  }

  Cursor* Cursor::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Cursor (*this, f, c);
  }

  Cursor& Cursor::
  operator= (const Cursor& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->time_ = x.time_;
      this->date_ = x.date_;
      this->x_ = x.x_;
      this->y_ = x.y_;
    }

    return *this;
  }

  Cursor::
  ~Cursor ()
  {
  }

  // DataValue
  //

  DataValue::
  DataValue (const name_type& name,
             const value_type& value)
  : ::xml_schema::type (),
    name_ (name, this),
    value_ (value, this)
  {
  }

  DataValue::
  DataValue (const DataValue& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    name_ (x.name_, f, this),
    value_ (x.value_, f, this)
  {
  }

  DataValue::
  DataValue (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    name_ (this),
    value_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void DataValue::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // name
      //
      if (n.name () == "name" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< name_type > r (
          name_traits::create (i, f, this));

        if (!name_.present ())
        {
          this->name_.set (::std::move (r));
          continue;
        }
      }

      // value
      //
      if (n.name () == "value" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< value_type > r (
          value_traits::create (i, f, this));

        if (!value_.present ())
        {
          this->value_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!name_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "name",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!value_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "value",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  DataValue* DataValue::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class DataValue (*this, f, c);
  }

  DataValue& DataValue::
  operator= (const DataValue& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->name_ = x.name_;
      this->value_ = x.value_;
    }

    return *this;
  }

  DataValue::
  ~DataValue ()
  {
  }
}

#include <ostream>

namespace pcrxml
{
  ::std::ostream&
  operator<< (::std::ostream& o, const Aguila& i)
  {
    if (i.multiView ())
    {
      o << ::std::endl << "multiView: " << *i.multiView ();
    }

    o << ::std::endl << "visualisationGroup: " << i.visualisationGroup ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const VisualisationGroup& i)
  {
    if (i.cursorValueMonitorFile ())
    {
      o << ::std::endl << "cursorValueMonitorFile: " << *i.cursorValueMonitorFile ();
    }

    if (i.fileToGetCursorValue ())
    {
      o << ::std::endl << "fileToGetCursorValue: " << *i.fileToGetCursorValue ();
    }

    if (i.searchSpace ())
    {
      o << ::std::endl << "searchSpace: " << *i.searchSpace ();
    }

    for (VisualisationGroup::data_const_iterator
         b (i.data ().begin ()), e (i.data ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "data: " << *b;
    }

    for (VisualisationGroup::view_const_iterator
         b (i.view ().begin ()), e (i.view ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "view: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const DataSpace& i)
  {
    for (DataSpace::scenarios_const_iterator
         b (i.scenarios ().begin ()), e (i.scenarios ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "scenarios: " << *b;
    }

    for (DataSpace::quantiles_const_iterator
         b (i.quantiles ().begin ()), e (i.quantiles ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "quantiles: " << *b;
    }

    for (DataSpace::timesteps_const_iterator
         b (i.timesteps ().begin ()), e (i.timesteps ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "timesteps: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const Timesteps& i)
  {
    o << static_cast< const ::pcrxml::OneBasedIntegerRangeOrSet& > (i);

    if (i.dateMapper ())
    {
      o << ::std::endl << "dateMapper: " << *i.dateMapper ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const DateMapper& i)
  {
    o << ::std::endl << "index: " << i.index ();
    o << ::std::endl << "timeOfIndex: " << i.timeOfIndex ();
    o << ::std::endl << "duration: " << i.duration ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const AguilaView& i)
  {
    if (i.map ())
    {
      o << ::std::endl << "map: " << *i.map ();
    }

    if (i.drape ())
    {
      o << ::std::endl << "drape: " << *i.drape ();
    }

    if (i.timeGraph ())
    {
      o << ::std::endl << "timeGraph: " << *i.timeGraph ();
    }

    if (i.probabilityGraph ())
    {
      o << ::std::endl << "probabilityGraph: " << *i.probabilityGraph ();
    }

    if (i.valueOnly ())
    {
      o << ::std::endl << "valueOnly: " << *i.valueOnly ();
    }

    if (i.default_ ())
    {
      o << ::std::endl << "default: " << *i.default_ ();
    }

    if (i.test ())
    {
      o << ::std::endl << "test: " << *i.test ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const AguilaData& i)
  {
    o << ::std::endl << "name: " << i.name ();
    if (i.dataSpace ())
    {
      o << ::std::endl << "dataSpace: " << *i.dataSpace ();
    }

    if (i.drawProperties ())
    {
      o << ::std::endl << "drawProperties: " << *i.drawProperties ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const DrawProperties& i)
  {
    if (i.legendBorderValuesType ())
    {
      o << ::std::endl << "legendBorderValuesType: " << *i.legendBorderValuesType ();
    }

    if (i.minimumCutOff ())
    {
      o << ::std::endl << "minimumCutOff: " << *i.minimumCutOff ();
    }

    if (i.maximumCutOff ())
    {
      o << ::std::endl << "maximumCutOff: " << *i.maximumCutOff ();
    }

    if (i.numberOfColours ())
    {
      o << ::std::endl << "numberOfColours: " << *i.numberOfColours ();
    }

    if (i.colourAssignment ())
    {
      o << ::std::endl << "colourAssignment: " << *i.colourAssignment ();
    }

    if (i.drawMode ())
    {
      o << ::std::endl << "drawMode: " << *i.drawMode ();
    }

    if (i.palette ())
    {
      o << ::std::endl << "palette: " << *i.palette ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const Palette& i)
  {
    for (Palette::rgb_const_iterator
         b (i.rgb ().begin ()), e (i.rgb ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "rgb: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const Rgb& i)
  {
    o << ::std::endl << "r: " << i.r ();
    o << ::std::endl << "g: " << i.g ();
    o << ::std::endl << "b: " << i.b ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const LegendBorderValuesType& i)
  {
    if (i.rounded ())
    {
      o << ::std::endl << "rounded: " << *i.rounded ();
    }

    if (i.exact ())
    {
      o << ::std::endl << "exact: " << *i.exact ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const ColourAssignment& i)
  {
    if (i.linear ())
    {
      o << ::std::endl << "linear: " << *i.linear ();
    }

    if (i.trueLogarithmic ())
    {
      o << ::std::endl << "trueLogarithmic: " << *i.trueLogarithmic ();
    }

    if (i.shiftedLogarithmic ())
    {
      o << ::std::endl << "shiftedLogarithmic: " << *i.shiftedLogarithmic ();
    }

    if (i.confidenceLevel ())
    {
      o << ::std::endl << "confidenceLevel: " << *i.confidenceLevel ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const ConfidenceLevel& i)
  {
    o << ::std::endl << "value: " << i.value ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const DrawMode& i)
  {
    if (i.fill ())
    {
      o << ::std::endl << "fill: " << *i.fill ();
    }

    if (i.contour ())
    {
      o << ::std::endl << "contour: " << *i.contour ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const AguilaCursorValues& i)
  {
    for (AguilaCursorValues::aguilaCursorValue_const_iterator
         b (i.aguilaCursorValue ().begin ()), e (i.aguilaCursorValue ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "aguilaCursorValue: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const AguilaCursorValue& i)
  {
    if (i.cursor ())
    {
      o << ::std::endl << "cursor: " << *i.cursor ();
    }

    for (AguilaCursorValue::dataValue_const_iterator
         b (i.dataValue ().begin ()), e (i.dataValue ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "dataValue: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const Cursor& i)
  {
    if (i.time ())
    {
      o << ::std::endl << "time: " << *i.time ();
    }

    if (i.date ())
    {
      o << ::std::endl << "date: " << *i.date ();
    }

    if (i.x ())
    {
      o << ::std::endl << "x: " << *i.x ();
    }

    if (i.y ())
    {
      o << ::std::endl << "y: " << *i.y ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const DataValue& i)
  {
    o << ::std::endl << "name: " << i.name ();
    o << ::std::endl << "value: " << i.value ();
    return o;
  }
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace pcrxml
{
  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::std::string& u,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::Aguila > (
      ::pcrxml::aguila (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::std::string& u,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Aguila > (
      ::pcrxml::aguila (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::std::string& u,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Aguila > (
      ::pcrxml::aguila (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguila (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguila (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguila (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          const ::std::string& sid,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguila (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          const ::std::string& sid,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguila (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::std::istream& is,
          const ::std::string& sid,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguila (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xercesc::InputSource& i,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::Aguila > (
      ::pcrxml::aguila (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xercesc::InputSource& i,
          ::xml_schema::error_handler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Aguila > (
      ::pcrxml::aguila (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xercesc::InputSource& i,
          ::xercesc::DOMErrorHandler& h,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Aguila > (
      ::pcrxml::aguila (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (const ::xercesc::DOMDocument& doc,
          ::xml_schema::flags f,
          const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::pcrxml::Aguila > (
        ::pcrxml::aguila (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "aguila" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::Aguila > r (
        ::xsd::cxx::tree::traits< ::pcrxml::Aguila, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "aguila",
      "http://www.pcraster.nl/pcrxml");
  }

  ::std::unique_ptr< ::pcrxml::Aguila >
  aguila (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
          ::xml_schema::flags f,
          const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "aguila" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::Aguila > r (
        ::xsd::cxx::tree::traits< ::pcrxml::Aguila, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "aguila",
      "http://www.pcraster.nl/pcrxml");
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::std::string& u,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
      ::pcrxml::aguilaCursorValues (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::std::string& u,
                      ::xml_schema::error_handler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
      ::pcrxml::aguilaCursorValues (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::std::string& u,
                      ::xercesc::DOMErrorHandler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
      ::pcrxml::aguilaCursorValues (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguilaCursorValues (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      ::xml_schema::error_handler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguilaCursorValues (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      ::xercesc::DOMErrorHandler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguilaCursorValues (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      const ::std::string& sid,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguilaCursorValues (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      const ::std::string& sid,
                      ::xml_schema::error_handler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguilaCursorValues (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::std::istream& is,
                      const ::std::string& sid,
                      ::xercesc::DOMErrorHandler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguilaCursorValues (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xercesc::InputSource& i,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
      ::pcrxml::aguilaCursorValues (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xercesc::InputSource& i,
                      ::xml_schema::error_handler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
      ::pcrxml::aguilaCursorValues (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xercesc::InputSource& i,
                      ::xercesc::DOMErrorHandler& h,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
      ::pcrxml::aguilaCursorValues (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (const ::xercesc::DOMDocument& doc,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::pcrxml::AguilaCursorValues > (
        ::pcrxml::aguilaCursorValues (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "aguilaCursorValues" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::AguilaCursorValues > r (
        ::xsd::cxx::tree::traits< ::pcrxml::AguilaCursorValues, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "aguilaCursorValues",
      "http://www.pcraster.nl/pcrxml");
  }

  ::std::unique_ptr< ::pcrxml::AguilaCursorValues >
  aguilaCursorValues (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                      ::xml_schema::flags f,
                      const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "aguilaCursorValues" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::AguilaCursorValues > r (
        ::xsd::cxx::tree::traits< ::pcrxml::AguilaCursorValues, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "aguilaCursorValues",
      "http://www.pcraster.nl/pcrxml");
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::std::string& u,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::Cursor > (
      ::pcrxml::aguilaCursor (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::std::string& u,
                ::xml_schema::error_handler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Cursor > (
      ::pcrxml::aguilaCursor (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::std::string& u,
                ::xercesc::DOMErrorHandler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Cursor > (
      ::pcrxml::aguilaCursor (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguilaCursor (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                ::xml_schema::error_handler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguilaCursor (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                ::xercesc::DOMErrorHandler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::aguilaCursor (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                const ::std::string& sid,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguilaCursor (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                const ::std::string& sid,
                ::xml_schema::error_handler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguilaCursor (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::std::istream& is,
                const ::std::string& sid,
                ::xercesc::DOMErrorHandler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::aguilaCursor (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xercesc::InputSource& i,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::Cursor > (
      ::pcrxml::aguilaCursor (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xercesc::InputSource& i,
                ::xml_schema::error_handler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Cursor > (
      ::pcrxml::aguilaCursor (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xercesc::InputSource& i,
                ::xercesc::DOMErrorHandler& h,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::Cursor > (
      ::pcrxml::aguilaCursor (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (const ::xercesc::DOMDocument& doc,
                ::xml_schema::flags f,
                const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::pcrxml::Cursor > (
        ::pcrxml::aguilaCursor (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "aguilaCursor" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::Cursor > r (
        ::xsd::cxx::tree::traits< ::pcrxml::Cursor, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "aguilaCursor",
      "http://www.pcraster.nl/pcrxml");
  }

  ::std::unique_ptr< ::pcrxml::Cursor >
  aguilaCursor (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                ::xml_schema::flags f,
                const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "aguilaCursor" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::Cursor > r (
        ::xsd::cxx::tree::traits< ::pcrxml::Cursor, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "aguilaCursor",
      "http://www.pcraster.nl/pcrxml");
  }
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

namespace pcrxml
{
  void
  aguila (::std::ostream& o,
          const ::pcrxml::Aguila& s,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguila (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  aguila (::std::ostream& o,
          const ::pcrxml::Aguila& s,
          ::xml_schema::error_handler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguila (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguila (::std::ostream& o,
          const ::pcrxml::Aguila& s,
          ::xercesc::DOMErrorHandler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguila (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguila (::xercesc::XMLFormatTarget& t,
          const ::pcrxml::Aguila& s,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguila (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  aguila (::xercesc::XMLFormatTarget& t,
          const ::pcrxml::Aguila& s,
          ::xml_schema::error_handler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguila (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguila (::xercesc::XMLFormatTarget& t,
          const ::pcrxml::Aguila& s,
          ::xercesc::DOMErrorHandler& h,
          const ::xml_schema::namespace_infomap& m,
          const ::std::string& e,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguila (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguila (::xercesc::DOMDocument& d,
          const ::pcrxml::Aguila& s,
          ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "aguila" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "aguila",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  aguila (const ::pcrxml::Aguila& s,
          const ::xml_schema::namespace_infomap& m,
          ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "aguila",
        "http://www.pcraster.nl/pcrxml",
        m, f));

    ::pcrxml::aguila (*d, s, f);
    return d;
  }

  void
  aguilaCursorValues (::std::ostream& o,
                      const ::pcrxml::AguilaCursorValues& s,
                      const ::xml_schema::namespace_infomap& m,
                      const ::std::string& e,
                      ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursorValues (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  aguilaCursorValues (::std::ostream& o,
                      const ::pcrxml::AguilaCursorValues& s,
                      ::xml_schema::error_handler& h,
                      const ::xml_schema::namespace_infomap& m,
                      const ::std::string& e,
                      ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursorValues (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursorValues (::std::ostream& o,
                      const ::pcrxml::AguilaCursorValues& s,
                      ::xercesc::DOMErrorHandler& h,
                      const ::xml_schema::namespace_infomap& m,
                      const ::std::string& e,
                      ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursorValues (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursorValues (::xercesc::XMLFormatTarget& t,
                      const ::pcrxml::AguilaCursorValues& s,
                      const ::xml_schema::namespace_infomap& m,
                      const ::std::string& e,
                      ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursorValues (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  aguilaCursorValues (::xercesc::XMLFormatTarget& t,
                      const ::pcrxml::AguilaCursorValues& s,
                      ::xml_schema::error_handler& h,
                      const ::xml_schema::namespace_infomap& m,
                      const ::std::string& e,
                      ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursorValues (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursorValues (::xercesc::XMLFormatTarget& t,
                      const ::pcrxml::AguilaCursorValues& s,
                      ::xercesc::DOMErrorHandler& h,
                      const ::xml_schema::namespace_infomap& m,
                      const ::std::string& e,
                      ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursorValues (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursorValues (::xercesc::DOMDocument& d,
                      const ::pcrxml::AguilaCursorValues& s,
                      ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "aguilaCursorValues" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "aguilaCursorValues",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  aguilaCursorValues (const ::pcrxml::AguilaCursorValues& s,
                      const ::xml_schema::namespace_infomap& m,
                      ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "aguilaCursorValues",
        "http://www.pcraster.nl/pcrxml",
        m, f));

    ::pcrxml::aguilaCursorValues (*d, s, f);
    return d;
  }

  void
  aguilaCursor (::std::ostream& o,
                const ::pcrxml::Cursor& s,
                const ::xml_schema::namespace_infomap& m,
                const ::std::string& e,
                ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursor (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  aguilaCursor (::std::ostream& o,
                const ::pcrxml::Cursor& s,
                ::xml_schema::error_handler& h,
                const ::xml_schema::namespace_infomap& m,
                const ::std::string& e,
                ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursor (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursor (::std::ostream& o,
                const ::pcrxml::Cursor& s,
                ::xercesc::DOMErrorHandler& h,
                const ::xml_schema::namespace_infomap& m,
                const ::std::string& e,
                ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursor (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursor (::xercesc::XMLFormatTarget& t,
                const ::pcrxml::Cursor& s,
                const ::xml_schema::namespace_infomap& m,
                const ::std::string& e,
                ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursor (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  aguilaCursor (::xercesc::XMLFormatTarget& t,
                const ::pcrxml::Cursor& s,
                ::xml_schema::error_handler& h,
                const ::xml_schema::namespace_infomap& m,
                const ::std::string& e,
                ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursor (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursor (::xercesc::XMLFormatTarget& t,
                const ::pcrxml::Cursor& s,
                ::xercesc::DOMErrorHandler& h,
                const ::xml_schema::namespace_infomap& m,
                const ::std::string& e,
                ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::aguilaCursor (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  aguilaCursor (::xercesc::DOMDocument& d,
                const ::pcrxml::Cursor& s,
                ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "aguilaCursor" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "aguilaCursor",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  aguilaCursor (const ::pcrxml::Cursor& s,
                const ::xml_schema::namespace_infomap& m,
                ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "aguilaCursor",
        "http://www.pcraster.nl/pcrxml",
        m, f));

    ::pcrxml::aguilaCursor (*d, s, f);
    return d;
  }

  void
  operator<< (::xercesc::DOMElement& e, const Aguila& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // multiView
    //
    if (i.multiView ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "multiView",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.multiView ();
    }

    // visualisationGroup
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "visualisationGroup",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.visualisationGroup ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const VisualisationGroup& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // cursorValueMonitorFile
    //
    if (i.cursorValueMonitorFile ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "cursorValueMonitorFile",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.cursorValueMonitorFile ();
    }

    // fileToGetCursorValue
    //
    if (i.fileToGetCursorValue ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "fileToGetCursorValue",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.fileToGetCursorValue ();
    }

    // searchSpace
    //
    if (i.searchSpace ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "searchSpace",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.searchSpace ();
    }

    // data
    //
    for (VisualisationGroup::data_const_iterator
         b (i.data ().begin ()), n (i.data ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "data",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }

    // view
    //
    for (VisualisationGroup::view_const_iterator
         b (i.view ().begin ()), n (i.view ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "view",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const DataSpace& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // scenarios
    //
    for (DataSpace::scenarios_const_iterator
         b (i.scenarios ().begin ()), n (i.scenarios ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "scenarios",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }

    // quantiles
    //
    for (DataSpace::quantiles_const_iterator
         b (i.quantiles ().begin ()), n (i.quantiles ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "quantiles",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }

    // timesteps
    //
    for (DataSpace::timesteps_const_iterator
         b (i.timesteps ().begin ()), n (i.timesteps ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "timesteps",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const Timesteps& i)
  {
    e << static_cast< const ::pcrxml::OneBasedIntegerRangeOrSet& > (i);

    // dateMapper
    //
    if (i.dateMapper ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "dateMapper",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.dateMapper ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const DateMapper& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // index
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "index",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.index ();
    }

    // timeOfIndex
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "timeOfIndex",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.timeOfIndex ();
    }

    // duration
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "duration",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.duration ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const AguilaView& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // map
    //
    if (i.map ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "map",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.map ();
    }

    // drape
    //
    if (i.drape ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "drape",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.drape ();
    }

    // timeGraph
    //
    if (i.timeGraph ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "timeGraph",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.timeGraph ();
    }

    // probabilityGraph
    //
    if (i.probabilityGraph ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "probabilityGraph",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.probabilityGraph ();
    }

    // valueOnly
    //
    if (i.valueOnly ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "valueOnly",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.valueOnly ();
    }

    // default
    //
    if (i.default_ ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "default",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.default_ ();
    }

    // test
    //
    if (i.test ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "test",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.test ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const AguilaData& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // name
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "name",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.name ();
    }

    // dataSpace
    //
    if (i.dataSpace ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "dataSpace",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.dataSpace ();
    }

    // drawProperties
    //
    if (i.drawProperties ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "drawProperties",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.drawProperties ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const DrawProperties& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // legendBorderValuesType
    //
    if (i.legendBorderValuesType ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "legendBorderValuesType",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.legendBorderValuesType ();
    }

    // minimumCutOff
    //
    if (i.minimumCutOff ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "minimumCutOff",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << ::xml_schema::as_double(*i.minimumCutOff ());
    }

    // maximumCutOff
    //
    if (i.maximumCutOff ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "maximumCutOff",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << ::xml_schema::as_double(*i.maximumCutOff ());
    }

    // numberOfColours
    //
    if (i.numberOfColours ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "numberOfColours",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.numberOfColours ();
    }

    // colourAssignment
    //
    if (i.colourAssignment ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "colourAssignment",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.colourAssignment ();
    }

    // drawMode
    //
    if (i.drawMode ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "drawMode",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.drawMode ();
    }

    // palette
    //
    if (i.palette ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "palette",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.palette ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const Palette& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // rgb
    //
    for (Palette::rgb_const_iterator
         b (i.rgb ().begin ()), n (i.rgb ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "rgb",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const Rgb& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // r
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "r",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.r ();
    }

    // g
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "g",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.g ();
    }

    // b
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "b",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.b ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const LegendBorderValuesType& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // rounded
    //
    if (i.rounded ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "rounded",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.rounded ();
    }

    // exact
    //
    if (i.exact ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "exact",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.exact ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const ColourAssignment& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // linear
    //
    if (i.linear ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "linear",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.linear ();
    }

    // trueLogarithmic
    //
    if (i.trueLogarithmic ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "trueLogarithmic",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.trueLogarithmic ();
    }

    // shiftedLogarithmic
    //
    if (i.shiftedLogarithmic ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "shiftedLogarithmic",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.shiftedLogarithmic ();
    }

    // confidenceLevel
    //
    if (i.confidenceLevel ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "confidenceLevel",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.confidenceLevel ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const ConfidenceLevel& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // value
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "value",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << ::xml_schema::as_double(i.value ());
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const DrawMode& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // fill
    //
    if (i.fill ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "fill",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.fill ();
    }

    // contour
    //
    if (i.contour ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "contour",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.contour ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const AguilaCursorValues& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // aguilaCursorValue
    //
    for (AguilaCursorValues::aguilaCursorValue_const_iterator
         b (i.aguilaCursorValue ().begin ()), n (i.aguilaCursorValue ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "aguilaCursorValue",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const AguilaCursorValue& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // cursor
    //
    if (i.cursor ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "cursor",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.cursor ();
    }

    // dataValue
    //
    for (AguilaCursorValue::dataValue_const_iterator
         b (i.dataValue ().begin ()), n (i.dataValue ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "dataValue",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const Cursor& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // time
    //
    if (i.time ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "time",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.time ();
    }

    // date
    //
    if (i.date ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "date",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.date ();
    }

    // x
    //
    if (i.x ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "x",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << ::xml_schema::as_double(*i.x ());
    }

    // y
    //
    if (i.y ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "y",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << ::xml_schema::as_double(*i.y ());
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const DataValue& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // name
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "name",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.name ();
    }

    // value
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "value",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.value ();
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

