// Copyright (c) 2005-2017 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef PCRASTER_XSD_H
#define PCRASTER_XSD_H

#ifndef XSD_CXX11
#define XSD_CXX11
#endif

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/config.hxx>

#if (XSD_INT_VERSION != 4009911L)
#error XSD runtime version mismatch
#endif

#include <xsd/cxx/pre.hxx>

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>

#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

#include <xsd/cxx/tree/parsing.hxx>
#include <xsd/cxx/tree/parsing/byte.hxx>
#include <xsd/cxx/tree/parsing/unsigned-byte.hxx>
#include <xsd/cxx/tree/parsing/short.hxx>
#include <xsd/cxx/tree/parsing/unsigned-short.hxx>
#include <xsd/cxx/tree/parsing/int.hxx>
#include <xsd/cxx/tree/parsing/unsigned-int.hxx>
#include <xsd/cxx/tree/parsing/long.hxx>
#include <xsd/cxx/tree/parsing/unsigned-long.hxx>
#include <xsd/cxx/tree/parsing/boolean.hxx>
#include <xsd/cxx/tree/parsing/float.hxx>
#include <xsd/cxx/tree/parsing/double.hxx>
#include <xsd/cxx/tree/parsing/decimal.hxx>

#include <xsd/cxx/xml/dom/serialization-header.hxx>
#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/tree/serialization/byte.hxx>
#include <xsd/cxx/tree/serialization/unsigned-byte.hxx>
#include <xsd/cxx/tree/serialization/short.hxx>
#include <xsd/cxx/tree/serialization/unsigned-short.hxx>
#include <xsd/cxx/tree/serialization/int.hxx>
#include <xsd/cxx/tree/serialization/unsigned-int.hxx>
#include <xsd/cxx/tree/serialization/long.hxx>
#include <xsd/cxx/tree/serialization/unsigned-long.hxx>
#include <xsd/cxx/tree/serialization/boolean.hxx>
#include <xsd/cxx/tree/serialization/float.hxx>
#include <xsd/cxx/tree/serialization/double.hxx>
#include <xsd/cxx/tree/serialization/decimal.hxx>

#include <xsd/cxx/tree/std-ostream-operators.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type< char, type > simple_type;
  typedef ::xsd::cxx::tree::type container;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef long long non_positive_integer;
  typedef unsigned long long non_negative_integer;
  typedef unsigned long long positive_integer;
  typedef long long negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken > nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< char, ncname, type > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::time_zone time_zone;
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::gday< char, simple_type > gday;
  typedef ::xsd::cxx::tree::gmonth< char, simple_type > gmonth;
  typedef ::xsd::cxx::tree::gmonth_day< char, simple_type > gmonth_day;
  typedef ::xsd::cxx::tree::gyear< char, simple_type > gyear;
  typedef ::xsd::cxx::tree::gyear_month< char, simple_type > gyear_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  typedef ::xsd::cxx::tree::content_order content_order;
  // Namespace information and list stream. Used in
  // serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info< char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap< char > namespace_infomap;
  typedef ::xsd::cxx::tree::list_stream< char > list_stream;
  typedef ::xsd::cxx::tree::as_double< double_ > as_double;
  typedef ::xsd::cxx::tree::as_decimal< decimal > as_decimal;
  typedef ::xsd::cxx::tree::facet facet;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // Parsing/serialization diagnostics.
  //
  typedef ::xsd::cxx::tree::severity severity;
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::diagnostics< char > diagnostics;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::bounds< char > bounds;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::serialization< char > serialization;

  // Error handler callback interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // DOM interaction.
  //
  namespace dom
  {
    // Automatic pointer for DOMDocument.
    //
    using ::xsd::cxx::xml::dom::unique_ptr;

#ifndef XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY__XML_SCHEMA
    // DOM user data key for back pointers to tree nodes.
    //
    const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;
#endif
  }
}

// Forward declarations.
//
namespace pcrxml
{
  class SpatialType;
  class SpatialTypeOfValue;
  class MemoryExchange;
  class Exchange;
  class Description;
  class ModelInputType;
  class ModelOutputType;
  class ModelExchange;
  class LookupColumn;
  class OutputMapFormat;
  class CellCoordinate;
  class DirectionalValueUnit;
  class LddCreateDemMethod;
  class DynamicWaveRoughness;
  class ExecutionOptions;
  class Script;
  class Model;
  class TextStatisticsSubject;
  class TextStatistics;
  class LookupRow;
  class Relation;
  class ArrayDimensionDataType;
  class ArrayValueDataType;
  class IndexedArray;
  class LookupTable;
  class FieldValueOrType;
  class Definition;
  class Boolean;
  class Nominal;
  class Ordinal;
  class Directional;
  class Ldd;
  class Scalar;
  class DataType;
  class DataTypeOfValue;
  class CoordinateMask;
  class AreaMap;
  class FieldReference;
  class AreaMapScript;
  class MaskMapType;
  class ComputationMaskByAreaMap;
  class ComputationMask;
  class TimerOfModel;
  class IntegerTimer;
  class TimerContext;
  class CheckContext;
  class RunContext;
  class LinkInLibraryManifest;
  class LinkInClassManifest;
  class LinkInClassConstructor;
  class FieldType;
  class FieldTypeOfValue;
  class LinkInClassMethod;
  class LinkInFunctionManifest;
  class CallPoint;
  class LinkInCheckInput;
  class LinkInCheckResult;
  class LinkInExecuteInput;
  class LinkInExecuteResult;
  class object;
  class function;
}


#include <memory>    // ::std::unique_ptr
#include <limits>    // std::numeric_limits
#include <algorithm> // std::binary_search
#include <utility>   // std::move

#include <xsd/cxx/xml/char-utf8.hxx>

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

#include <xsd/cxx/xml/dom/parsing-header.hxx>

#include "commonTypesXSD.h"

namespace pcrxml
{
  class SpatialType: public ::xml_schema::string
  {
    public:
    enum value
    {
      Spatial,
      NonSpatial,
      Either
    };

    SpatialType (value v);

    SpatialType (const char* v);

    SpatialType (const ::std::string& v);

    SpatialType (const ::xml_schema::string& v);

    SpatialType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    SpatialType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    SpatialType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    SpatialType (const SpatialType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual SpatialType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    SpatialType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_SpatialType_convert ();
    }

    protected:
    value
    _xsd_SpatialType_convert () const;

    public:
    static const char* const _xsd_SpatialType_literals_[3];
    static const value _xsd_SpatialType_indexes_[3];
  };

  class SpatialTypeOfValue: public ::pcrxml::SpatialType
  {
    public:
    typedef ::pcrxml::SpatialType::value value;

    SpatialTypeOfValue (value v);

    SpatialTypeOfValue (const char* v);

    SpatialTypeOfValue (const ::std::string& v);

    SpatialTypeOfValue (const ::pcrxml::SpatialType& v);

    SpatialTypeOfValue (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    SpatialTypeOfValue (const ::xercesc::DOMAttr& a,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    SpatialTypeOfValue (const ::std::string& s,
                        const ::xercesc::DOMElement* e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    SpatialTypeOfValue (const SpatialTypeOfValue& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual SpatialTypeOfValue*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    SpatialTypeOfValue&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_SpatialTypeOfValue_convert ();
    }

    protected:
    value
    _xsd_SpatialTypeOfValue_convert () const;

    public:
    static const char* const* _xsd_SpatialTypeOfValue_literals_;
    static const value _xsd_SpatialTypeOfValue_indexes_[2];
  };

  class MemoryExchange: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >
  {
    public:
    // Constructors.
    //
    MemoryExchange (const ::xml_schema::unsigned_int&);

    MemoryExchange (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    MemoryExchange (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    MemoryExchange (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    MemoryExchange (const MemoryExchange& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual MemoryExchange*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~MemoryExchange ();
  };

  class Exchange: public ::xml_schema::type
  {
    public:
    // external
    //
    typedef ::xml_schema::string external_type;
    typedef ::xsd::cxx::tree::optional< external_type > external_optional;
    typedef ::xsd::cxx::tree::traits< external_type, char > external_traits;

    const external_optional&
    external () const;

    external_optional&
    external ();

    void
    external (const external_type& x);

    void
    external (const external_optional& x);

    void
    external (::std::unique_ptr< external_type > p);

    // memoryExchange
    //
    typedef ::pcrxml::MemoryExchange memoryExchange_type;
    typedef ::xsd::cxx::tree::optional< memoryExchange_type > memoryExchange_optional;
    typedef ::xsd::cxx::tree::traits< memoryExchange_type, char > memoryExchange_traits;

    const memoryExchange_optional&
    memoryExchange () const;

    memoryExchange_optional&
    memoryExchange ();

    void
    memoryExchange (const memoryExchange_type& x);

    void
    memoryExchange (const memoryExchange_optional& x);

    void
    memoryExchange (::std::unique_ptr< memoryExchange_type > p);

    // Constructors.
    //
    Exchange ();

    Exchange (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    Exchange (const Exchange& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual Exchange*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Exchange&
    operator= (const Exchange& x);

    virtual
    ~Exchange ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    external_optional external_;
    memoryExchange_optional memoryExchange_;
  };

  class Description: public ::xml_schema::type
  {
    public:
    // text
    //
    typedef ::xml_schema::string text_type;
    typedef ::xsd::cxx::tree::traits< text_type, char > text_traits;

    const text_type&
    text () const;

    text_type&
    text ();

    void
    text (const text_type& x);

    void
    text (::std::unique_ptr< text_type > p);

    // Constructors.
    //
    Description (const text_type&);

    Description (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    Description (const Description& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual Description*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Description&
    operator= (const Description& x);

    virtual
    ~Description ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< text_type > text_;
  };

  class ModelInputType: public ::xml_schema::string
  {
    public:
    enum value
    {
      Constant,
      None,
      Initial,
      Dynamic
    };

    ModelInputType (value v);

    ModelInputType (const char* v);

    ModelInputType (const ::std::string& v);

    ModelInputType (const ::xml_schema::string& v);

    ModelInputType (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ModelInputType (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ModelInputType (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    ModelInputType (const ModelInputType& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual ModelInputType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ModelInputType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_ModelInputType_convert ();
    }

    protected:
    value
    _xsd_ModelInputType_convert () const;

    public:
    static const char* const _xsd_ModelInputType_literals_[4];
    static const value _xsd_ModelInputType_indexes_[4];
  };

  class ModelOutputType: public ::xml_schema::string
  {
    public:
    enum value
    {
      Fixed,
      Initial,
      Dynamic
    };

    ModelOutputType (value v);

    ModelOutputType (const char* v);

    ModelOutputType (const ::std::string& v);

    ModelOutputType (const ::xml_schema::string& v);

    ModelOutputType (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ModelOutputType (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ModelOutputType (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ModelOutputType (const ModelOutputType& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual ModelOutputType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ModelOutputType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_ModelOutputType_convert ();
    }

    protected:
    value
    _xsd_ModelOutputType_convert () const;

    public:
    static const char* const _xsd_ModelOutputType_literals_[3];
    static const value _xsd_ModelOutputType_indexes_[3];
  };

  class ModelExchange: public ::xml_schema::type
  {
    public:
    // input
    //
    typedef ::pcrxml::ModelInputType input_type;
    typedef ::xsd::cxx::tree::optional< input_type > input_optional;
    typedef ::xsd::cxx::tree::traits< input_type, char > input_traits;

    const input_optional&
    input () const;

    input_optional&
    input ();

    void
    input (const input_type& x);

    void
    input (const input_optional& x);

    void
    input (::std::unique_ptr< input_type > p);

    // output
    //
    typedef ::pcrxml::ModelOutputType output_type;
    typedef ::xsd::cxx::tree::optional< output_type > output_optional;
    typedef ::xsd::cxx::tree::traits< output_type, char > output_traits;

    const output_optional&
    output () const;

    output_optional&
    output ();

    void
    output (const output_type& x);

    void
    output (const output_optional& x);

    void
    output (::std::unique_ptr< output_type > p);

    // Constructors.
    //
    ModelExchange ();

    ModelExchange (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    ModelExchange (const ModelExchange& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual ModelExchange*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ModelExchange&
    operator= (const ModelExchange& x);

    virtual
    ~ModelExchange ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    input_optional input_;
    output_optional output_;
  };

  class LookupColumn: public ::xml_schema::string
  {
    public:
    // Constructors.
    //
    LookupColumn ();

    LookupColumn (const char*);

    LookupColumn (const ::std::string&);

    LookupColumn (const ::xml_schema::string&);

    LookupColumn (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    LookupColumn (const ::xercesc::DOMAttr& a,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    LookupColumn (const ::std::string& s,
                  const ::xercesc::DOMElement* e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    LookupColumn (const LookupColumn& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual LookupColumn*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~LookupColumn ();
  };

  class OutputMapFormat: public ::xml_schema::type
  {
    public:
    // pcrasterMapFormat
    //
    typedef ::pcrxml::EmptyElement pcrasterMapFormat_type;
    typedef ::xsd::cxx::tree::optional< pcrasterMapFormat_type > pcrasterMapFormat_optional;
    typedef ::xsd::cxx::tree::traits< pcrasterMapFormat_type, char > pcrasterMapFormat_traits;

    const pcrasterMapFormat_optional&
    pcrasterMapFormat () const;

    pcrasterMapFormat_optional&
    pcrasterMapFormat ();

    void
    pcrasterMapFormat (const pcrasterMapFormat_type& x);

    void
    pcrasterMapFormat (const pcrasterMapFormat_optional& x);

    void
    pcrasterMapFormat (::std::unique_ptr< pcrasterMapFormat_type > p);

    // bandMapFormat
    //
    typedef ::pcrxml::EmptyElement bandMapFormat_type;
    typedef ::xsd::cxx::tree::optional< bandMapFormat_type > bandMapFormat_optional;
    typedef ::xsd::cxx::tree::traits< bandMapFormat_type, char > bandMapFormat_traits;

    const bandMapFormat_optional&
    bandMapFormat () const;

    bandMapFormat_optional&
    bandMapFormat ();

    void
    bandMapFormat (const bandMapFormat_type& x);

    void
    bandMapFormat (const bandMapFormat_optional& x);

    void
    bandMapFormat (::std::unique_ptr< bandMapFormat_type > p);

    // esriGridFormat
    //
    typedef ::pcrxml::EmptyElement esriGridFormat_type;
    typedef ::xsd::cxx::tree::optional< esriGridFormat_type > esriGridFormat_optional;
    typedef ::xsd::cxx::tree::traits< esriGridFormat_type, char > esriGridFormat_traits;

    const esriGridFormat_optional&
    esriGridFormat () const;

    esriGridFormat_optional&
    esriGridFormat ();

    void
    esriGridFormat (const esriGridFormat_type& x);

    void
    esriGridFormat (const esriGridFormat_optional& x);

    void
    esriGridFormat (::std::unique_ptr< esriGridFormat_type > p);

    // Constructors.
    //
    OutputMapFormat ();

    OutputMapFormat (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    OutputMapFormat (const OutputMapFormat& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual OutputMapFormat*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    OutputMapFormat&
    operator= (const OutputMapFormat& x);

    virtual
    ~OutputMapFormat ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    pcrasterMapFormat_optional pcrasterMapFormat_;
    bandMapFormat_optional bandMapFormat_;
    esriGridFormat_optional esriGridFormat_;
  };

  class CellCoordinate: public ::xml_schema::string
  {
    public:
    enum value
    {
      Centre,
      UpperLeft,
      LowerRight
    };

    CellCoordinate (value v);

    CellCoordinate (const char* v);

    CellCoordinate (const ::std::string& v);

    CellCoordinate (const ::xml_schema::string& v);

    CellCoordinate (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CellCoordinate (const ::xercesc::DOMAttr& a,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CellCoordinate (const ::std::string& s,
                    const ::xercesc::DOMElement* e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CellCoordinate (const CellCoordinate& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual CellCoordinate*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CellCoordinate&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_CellCoordinate_convert ();
    }

    protected:
    value
    _xsd_CellCoordinate_convert () const;

    public:
    static const char* const _xsd_CellCoordinate_literals_[3];
    static const value _xsd_CellCoordinate_indexes_[3];
  };

  class DirectionalValueUnit: public ::xml_schema::string
  {
    public:
    enum value
    {
      Degrees,
      Radians
    };

    DirectionalValueUnit (value v);

    DirectionalValueUnit (const char* v);

    DirectionalValueUnit (const ::std::string& v);

    DirectionalValueUnit (const ::xml_schema::string& v);

    DirectionalValueUnit (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DirectionalValueUnit (const ::xercesc::DOMAttr& a,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DirectionalValueUnit (const ::std::string& s,
                          const ::xercesc::DOMElement* e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DirectionalValueUnit (const DirectionalValueUnit& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual DirectionalValueUnit*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DirectionalValueUnit&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_DirectionalValueUnit_convert ();
    }

    protected:
    value
    _xsd_DirectionalValueUnit_convert () const;

    public:
    static const char* const _xsd_DirectionalValueUnit_literals_[2];
    static const value _xsd_DirectionalValueUnit_indexes_[2];
  };

  class LddCreateDemMethod: public ::xml_schema::string
  {
    public:
    enum value
    {
      Fill,
      Cut
    };

    LddCreateDemMethod (value v);

    LddCreateDemMethod (const char* v);

    LddCreateDemMethod (const ::std::string& v);

    LddCreateDemMethod (const ::xml_schema::string& v);

    LddCreateDemMethod (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    LddCreateDemMethod (const ::xercesc::DOMAttr& a,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    LddCreateDemMethod (const ::std::string& s,
                        const ::xercesc::DOMElement* e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    LddCreateDemMethod (const LddCreateDemMethod& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual LddCreateDemMethod*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LddCreateDemMethod&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_LddCreateDemMethod_convert ();
    }

    protected:
    value
    _xsd_LddCreateDemMethod_convert () const;

    public:
    static const char* const _xsd_LddCreateDemMethod_literals_[2];
    static const value _xsd_LddCreateDemMethod_indexes_[2];
  };

  class DynamicWaveRoughness: public ::xml_schema::string
  {
    public:
    enum value
    {
      Manning,
      Chezy
    };

    DynamicWaveRoughness (value v);

    DynamicWaveRoughness (const char* v);

    DynamicWaveRoughness (const ::std::string& v);

    DynamicWaveRoughness (const ::xml_schema::string& v);

    DynamicWaveRoughness (const ::xercesc::DOMElement& e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DynamicWaveRoughness (const ::xercesc::DOMAttr& a,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DynamicWaveRoughness (const ::std::string& s,
                          const ::xercesc::DOMElement* e,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    DynamicWaveRoughness (const DynamicWaveRoughness& x,
                          ::xml_schema::flags f = 0,
                          ::xml_schema::container* c = 0);

    virtual DynamicWaveRoughness*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DynamicWaveRoughness&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_DynamicWaveRoughness_convert ();
    }

    protected:
    value
    _xsd_DynamicWaveRoughness_convert () const;

    public:
    static const char* const _xsd_DynamicWaveRoughness_literals_[2];
    static const value _xsd_DynamicWaveRoughness_indexes_[2];
  };

  class ExecutionOptions: public ::xml_schema::type
  {
    public:
    // outputMapFormat
    //
    typedef ::pcrxml::OutputMapFormat outputMapFormat_type;
    typedef ::xsd::cxx::tree::optional< outputMapFormat_type > outputMapFormat_optional;
    typedef ::xsd::cxx::tree::traits< outputMapFormat_type, char > outputMapFormat_traits;

    const outputMapFormat_optional&
    outputMapFormat () const;

    outputMapFormat_optional&
    outputMapFormat ();

    void
    outputMapFormat (const outputMapFormat_type& x);

    void
    outputMapFormat (const outputMapFormat_optional& x);

    void
    outputMapFormat (::std::unique_ptr< outputMapFormat_type > p);

    // diagonal
    //
    typedef ::xml_schema::boolean diagonal_type;
    typedef ::xsd::cxx::tree::optional< diagonal_type > diagonal_optional;
    typedef ::xsd::cxx::tree::traits< diagonal_type, char > diagonal_traits;

    const diagonal_optional&
    diagonal () const;

    diagonal_optional&
    diagonal ();

    void
    diagonal (const diagonal_type& x);

    void
    diagonal (const diagonal_optional& x);

    // twoColumnTableAsMatrix
    //
    typedef ::xml_schema::boolean twoColumnTableAsMatrix_type;
    typedef ::xsd::cxx::tree::optional< twoColumnTableAsMatrix_type > twoColumnTableAsMatrix_optional;
    typedef ::xsd::cxx::tree::traits< twoColumnTableAsMatrix_type, char > twoColumnTableAsMatrix_traits;

    const twoColumnTableAsMatrix_optional&
    twoColumnTableAsMatrix () const;

    twoColumnTableAsMatrix_optional&
    twoColumnTableAsMatrix ();

    void
    twoColumnTableAsMatrix (const twoColumnTableAsMatrix_type& x);

    void
    twoColumnTableAsMatrix (const twoColumnTableAsMatrix_optional& x);

    // keepEdgePits
    //
    typedef ::xml_schema::boolean keepEdgePits_type;
    typedef ::xsd::cxx::tree::optional< keepEdgePits_type > keepEdgePits_optional;
    typedef ::xsd::cxx::tree::traits< keepEdgePits_type, char > keepEdgePits_traits;

    const keepEdgePits_optional&
    keepEdgePits () const;

    keepEdgePits_optional&
    keepEdgePits ();

    void
    keepEdgePits (const keepEdgePits_type& x);

    void
    keepEdgePits (const keepEdgePits_optional& x);

    // trueCellUnits
    //
    typedef ::xml_schema::boolean trueCellUnits_type;
    typedef ::xsd::cxx::tree::optional< trueCellUnits_type > trueCellUnits_optional;
    typedef ::xsd::cxx::tree::traits< trueCellUnits_type, char > trueCellUnits_traits;

    const trueCellUnits_optional&
    trueCellUnits () const;

    trueCellUnits_optional&
    trueCellUnits ();

    void
    trueCellUnits (const trueCellUnits_type& x);

    void
    trueCellUnits (const trueCellUnits_optional& x);

    // cellCoordinate
    //
    typedef ::pcrxml::CellCoordinate cellCoordinate_type;
    typedef ::xsd::cxx::tree::optional< cellCoordinate_type > cellCoordinate_optional;
    typedef ::xsd::cxx::tree::traits< cellCoordinate_type, char > cellCoordinate_traits;

    const cellCoordinate_optional&
    cellCoordinate () const;

    cellCoordinate_optional&
    cellCoordinate ();

    void
    cellCoordinate (const cellCoordinate_type& x);

    void
    cellCoordinate (const cellCoordinate_optional& x);

    void
    cellCoordinate (::std::unique_ptr< cellCoordinate_type > p);

    // directionalValueUnit
    //
    typedef ::pcrxml::DirectionalValueUnit directionalValueUnit_type;
    typedef ::xsd::cxx::tree::optional< directionalValueUnit_type > directionalValueUnit_optional;
    typedef ::xsd::cxx::tree::traits< directionalValueUnit_type, char > directionalValueUnit_traits;

    const directionalValueUnit_optional&
    directionalValueUnit () const;

    directionalValueUnit_optional&
    directionalValueUnit ();

    void
    directionalValueUnit (const directionalValueUnit_type& x);

    void
    directionalValueUnit (const directionalValueUnit_optional& x);

    void
    directionalValueUnit (::std::unique_ptr< directionalValueUnit_type > p);

    // lddCreateDemMethod
    //
    typedef ::pcrxml::LddCreateDemMethod lddCreateDemMethod_type;
    typedef ::xsd::cxx::tree::optional< lddCreateDemMethod_type > lddCreateDemMethod_optional;
    typedef ::xsd::cxx::tree::traits< lddCreateDemMethod_type, char > lddCreateDemMethod_traits;

    const lddCreateDemMethod_optional&
    lddCreateDemMethod () const;

    lddCreateDemMethod_optional&
    lddCreateDemMethod ();

    void
    lddCreateDemMethod (const lddCreateDemMethod_type& x);

    void
    lddCreateDemMethod (const lddCreateDemMethod_optional& x);

    void
    lddCreateDemMethod (::std::unique_ptr< lddCreateDemMethod_type > p);

    // dynamicWaveRoughness
    //
    typedef ::pcrxml::DynamicWaveRoughness dynamicWaveRoughness_type;
    typedef ::xsd::cxx::tree::optional< dynamicWaveRoughness_type > dynamicWaveRoughness_optional;
    typedef ::xsd::cxx::tree::traits< dynamicWaveRoughness_type, char > dynamicWaveRoughness_traits;

    const dynamicWaveRoughness_optional&
    dynamicWaveRoughness () const;

    dynamicWaveRoughness_optional&
    dynamicWaveRoughness ();

    void
    dynamicWaveRoughness (const dynamicWaveRoughness_type& x);

    void
    dynamicWaveRoughness (const dynamicWaveRoughness_optional& x);

    void
    dynamicWaveRoughness (::std::unique_ptr< dynamicWaveRoughness_type > p);

    // runDirectory
    //
    typedef ::xml_schema::string runDirectory_type;
    typedef ::xsd::cxx::tree::optional< runDirectory_type > runDirectory_optional;
    typedef ::xsd::cxx::tree::traits< runDirectory_type, char > runDirectory_traits;

    const runDirectory_optional&
    runDirectory () const;

    runDirectory_optional&
    runDirectory ();

    void
    runDirectory (const runDirectory_type& x);

    void
    runDirectory (const runDirectory_optional& x);

    void
    runDirectory (::std::unique_ptr< runDirectory_type > p);

    // randomGeneratorSeed
    //
    typedef ::pcrxml::Non0UnsignedInt randomGeneratorSeed_type;
    typedef ::xsd::cxx::tree::optional< randomGeneratorSeed_type > randomGeneratorSeed_optional;
    typedef ::xsd::cxx::tree::traits< randomGeneratorSeed_type, char > randomGeneratorSeed_traits;

    const randomGeneratorSeed_optional&
    randomGeneratorSeed () const;

    randomGeneratorSeed_optional&
    randomGeneratorSeed ();

    void
    randomGeneratorSeed (const randomGeneratorSeed_type& x);

    void
    randomGeneratorSeed (const randomGeneratorSeed_optional& x);

    void
    randomGeneratorSeed (::std::unique_ptr< randomGeneratorSeed_type > p);

    // maskCompression
    //
    typedef ::pcrxml::EmptyElement maskCompression_type;
    typedef ::xsd::cxx::tree::optional< maskCompression_type > maskCompression_optional;
    typedef ::xsd::cxx::tree::traits< maskCompression_type, char > maskCompression_traits;

    const maskCompression_optional&
    maskCompression () const;

    maskCompression_optional&
    maskCompression ();

    void
    maskCompression (const maskCompression_type& x);

    void
    maskCompression (const maskCompression_optional& x);

    void
    maskCompression (::std::unique_ptr< maskCompression_type > p);

    // useDiskStorage
    //
    typedef ::pcrxml::EmptyElement useDiskStorage_type;
    typedef ::xsd::cxx::tree::optional< useDiskStorage_type > useDiskStorage_optional;
    typedef ::xsd::cxx::tree::traits< useDiskStorage_type, char > useDiskStorage_traits;

    const useDiskStorage_optional&
    useDiskStorage () const;

    useDiskStorage_optional&
    useDiskStorage ();

    void
    useDiskStorage (const useDiskStorage_type& x);

    void
    useDiskStorage (const useDiskStorage_optional& x);

    void
    useDiskStorage (::std::unique_ptr< useDiskStorage_type > p);

    // Constructors.
    //
    ExecutionOptions ();

    ExecutionOptions (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    ExecutionOptions (const ExecutionOptions& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual ExecutionOptions*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ExecutionOptions&
    operator= (const ExecutionOptions& x);

    virtual
    ~ExecutionOptions ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    outputMapFormat_optional outputMapFormat_;
    diagonal_optional diagonal_;
    twoColumnTableAsMatrix_optional twoColumnTableAsMatrix_;
    keepEdgePits_optional keepEdgePits_;
    trueCellUnits_optional trueCellUnits_;
    cellCoordinate_optional cellCoordinate_;
    directionalValueUnit_optional directionalValueUnit_;
    lddCreateDemMethod_optional lddCreateDemMethod_;
    dynamicWaveRoughness_optional dynamicWaveRoughness_;
    runDirectory_optional runDirectory_;
    randomGeneratorSeed_optional randomGeneratorSeed_;
    maskCompression_optional maskCompression_;
    useDiskStorage_optional useDiskStorage_;
  };

  class Script: public ::xml_schema::type
  {
    public:
    // executionOptions
    //
    typedef ::pcrxml::ExecutionOptions executionOptions_type;
    typedef ::xsd::cxx::tree::optional< executionOptions_type > executionOptions_optional;
    typedef ::xsd::cxx::tree::traits< executionOptions_type, char > executionOptions_traits;

    const executionOptions_optional&
    executionOptions () const;

    executionOptions_optional&
    executionOptions ();

    void
    executionOptions (const executionOptions_type& x);

    void
    executionOptions (const executionOptions_optional& x);

    void
    executionOptions (::std::unique_ptr< executionOptions_type > p);

    // areaMap
    //
    typedef ::pcrxml::AreaMapScript areaMap_type;
    typedef ::xsd::cxx::tree::optional< areaMap_type > areaMap_optional;
    typedef ::xsd::cxx::tree::traits< areaMap_type, char > areaMap_traits;

    const areaMap_optional&
    areaMap () const;

    areaMap_optional&
    areaMap ();

    void
    areaMap (const areaMap_type& x);

    void
    areaMap (const areaMap_optional& x);

    void
    areaMap (::std::unique_ptr< areaMap_type > p);

    // computationMask
    //
    typedef ::pcrxml::ComputationMask computationMask_type;
    typedef ::xsd::cxx::tree::optional< computationMask_type > computationMask_optional;
    typedef ::xsd::cxx::tree::traits< computationMask_type, char > computationMask_traits;

    const computationMask_optional&
    computationMask () const;

    computationMask_optional&
    computationMask ();

    void
    computationMask (const computationMask_type& x);

    void
    computationMask (const computationMask_optional& x);

    void
    computationMask (::std::unique_ptr< computationMask_type > p);

    // definition
    //
    typedef ::pcrxml::Definition definition_type;
    typedef ::xsd::cxx::tree::sequence< definition_type > definition_sequence;
    typedef definition_sequence::iterator definition_iterator;
    typedef definition_sequence::const_iterator definition_const_iterator;
    typedef ::xsd::cxx::tree::traits< definition_type, char > definition_traits;

    const definition_sequence&
    definition () const;

    definition_sequence&
    definition ();

    void
    definition (const definition_sequence& s);

    // timer
    //
    typedef ::pcrxml::TimerOfModel timer_type;
    typedef ::xsd::cxx::tree::optional< timer_type > timer_optional;
    typedef ::xsd::cxx::tree::traits< timer_type, char > timer_traits;

    const timer_optional&
    timer () const;

    timer_optional&
    timer ();

    void
    timer (const timer_type& x);

    void
    timer (const timer_optional& x);

    void
    timer (::std::unique_ptr< timer_type > p);

    // model
    //
    typedef ::pcrxml::Model model_type;
    typedef ::xsd::cxx::tree::optional< model_type > model_optional;
    typedef ::xsd::cxx::tree::traits< model_type, char > model_traits;

    const model_optional&
    model () const;

    model_optional&
    model ();

    void
    model (const model_type& x);

    void
    model (const model_optional& x);

    void
    model (::std::unique_ptr< model_type > p);

    // textStatistics
    //
    typedef ::pcrxml::TextStatistics textStatistics_type;
    typedef ::xsd::cxx::tree::sequence< textStatistics_type > textStatistics_sequence;
    typedef textStatistics_sequence::iterator textStatistics_iterator;
    typedef textStatistics_sequence::const_iterator textStatistics_const_iterator;
    typedef ::xsd::cxx::tree::traits< textStatistics_type, char > textStatistics_traits;

    const textStatistics_sequence&
    textStatistics () const;

    textStatistics_sequence&
    textStatistics ();

    void
    textStatistics (const textStatistics_sequence& s);

    // Constructors.
    //
    Script ();

    Script (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    Script (const Script& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual Script*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Script&
    operator= (const Script& x);

    virtual
    ~Script ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    executionOptions_optional executionOptions_;
    areaMap_optional areaMap_;
    computationMask_optional computationMask_;
    definition_sequence definition_;
    timer_optional timer_;
    model_optional model_;
    textStatistics_sequence textStatistics_;
  };

  class Model: public ::xml_schema::type
  {
    public:
    // textModel
    //
    typedef ::xml_schema::string textModel_type;
    typedef ::xsd::cxx::tree::traits< textModel_type, char > textModel_traits;

    const textModel_type&
    textModel () const;

    textModel_type&
    textModel ();

    void
    textModel (const textModel_type& x);

    void
    textModel (::std::unique_ptr< textModel_type > p);

    // Constructors.
    //
    Model (const textModel_type&);

    Model (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    Model (const Model& x,
           ::xml_schema::flags f = 0,
           ::xml_schema::container* c = 0);

    virtual Model*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Model&
    operator= (const Model& x);

    virtual
    ~Model ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< textModel_type > textModel_;
  };

  class TextStatisticsSubject: public ::xml_schema::type
  {
    public:
    // fieldRef
    //
    typedef ::xml_schema::idref fieldRef_type;
    typedef ::xsd::cxx::tree::traits< fieldRef_type, char > fieldRef_traits;

    const fieldRef_type&
    fieldRef () const;

    fieldRef_type&
    fieldRef ();

    void
    fieldRef (const fieldRef_type& x);

    void
    fieldRef (::std::unique_ptr< fieldRef_type > p);

    // intervalRef
    //
    typedef ::xml_schema::idref intervalRef_type;
    typedef ::xsd::cxx::tree::optional< intervalRef_type > intervalRef_optional;
    typedef ::xsd::cxx::tree::traits< intervalRef_type, char > intervalRef_traits;

    const intervalRef_optional&
    intervalRef () const;

    intervalRef_optional&
    intervalRef ();

    void
    intervalRef (const intervalRef_type& x);

    void
    intervalRef (const intervalRef_optional& x);

    void
    intervalRef (::std::unique_ptr< intervalRef_type > p);

    // Constructors.
    //
    TextStatisticsSubject (const fieldRef_type&);

    TextStatisticsSubject (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    TextStatisticsSubject (const TextStatisticsSubject& x,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    virtual TextStatisticsSubject*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextStatisticsSubject&
    operator= (const TextStatisticsSubject& x);

    virtual
    ~TextStatisticsSubject ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< fieldRef_type > fieldRef_;
    intervalRef_optional intervalRef_;
  };

  class TextStatistics: public ::xml_schema::type
  {
    public:
    // textStatisticsSubject
    //
    typedef ::pcrxml::TextStatisticsSubject textStatisticsSubject_type;
    typedef ::xsd::cxx::tree::sequence< textStatisticsSubject_type > textStatisticsSubject_sequence;
    typedef textStatisticsSubject_sequence::iterator textStatisticsSubject_iterator;
    typedef textStatisticsSubject_sequence::const_iterator textStatisticsSubject_const_iterator;
    typedef ::xsd::cxx::tree::traits< textStatisticsSubject_type, char > textStatisticsSubject_traits;

    const textStatisticsSubject_sequence&
    textStatisticsSubject () const;

    textStatisticsSubject_sequence&
    textStatisticsSubject ();

    void
    textStatisticsSubject (const textStatisticsSubject_sequence& s);

    // name
    //
    typedef ::xml_schema::idref name_type;
    typedef ::xsd::cxx::tree::optional< name_type > name_optional;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_optional&
    name () const;

    name_optional&
    name ();

    void
    name (const name_type& x);

    void
    name (const name_optional& x);

    void
    name (::std::unique_ptr< name_type > p);

    // Constructors.
    //
    TextStatistics ();

    TextStatistics (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    TextStatistics (const TextStatistics& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual TextStatistics*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TextStatistics&
    operator= (const TextStatistics& x);

    virtual
    ~TextStatistics ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    textStatisticsSubject_sequence textStatisticsSubject_;
    name_optional name_;
  };

  class LookupRow: public ::xml_schema::type
  {
    public:
    // lookupColumn
    //
    typedef ::pcrxml::LookupColumn lookupColumn_type;
    typedef ::xsd::cxx::tree::sequence< lookupColumn_type > lookupColumn_sequence;
    typedef lookupColumn_sequence::iterator lookupColumn_iterator;
    typedef lookupColumn_sequence::const_iterator lookupColumn_const_iterator;
    typedef ::xsd::cxx::tree::traits< lookupColumn_type, char > lookupColumn_traits;

    const lookupColumn_sequence&
    lookupColumn () const;

    lookupColumn_sequence&
    lookupColumn ();

    void
    lookupColumn (const lookupColumn_sequence& s);

    // Constructors.
    //
    LookupRow ();

    LookupRow (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    LookupRow (const LookupRow& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual LookupRow*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LookupRow&
    operator= (const LookupRow& x);

    virtual
    ~LookupRow ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    lookupColumn_sequence lookupColumn_;
  };

  class Relation: public ::xml_schema::type
  {
    public:
    // lookupTable
    //
    typedef ::pcrxml::LookupTable lookupTable_type;
    typedef ::xsd::cxx::tree::optional< lookupTable_type > lookupTable_optional;
    typedef ::xsd::cxx::tree::traits< lookupTable_type, char > lookupTable_traits;

    const lookupTable_optional&
    lookupTable () const;

    lookupTable_optional&
    lookupTable ();

    void
    lookupTable (const lookupTable_type& x);

    void
    lookupTable (const lookupTable_optional& x);

    void
    lookupTable (::std::unique_ptr< lookupTable_type > p);

    // indexedArray
    //
    typedef ::pcrxml::IndexedArray indexedArray_type;
    typedef ::xsd::cxx::tree::optional< indexedArray_type > indexedArray_optional;
    typedef ::xsd::cxx::tree::traits< indexedArray_type, char > indexedArray_traits;

    const indexedArray_optional&
    indexedArray () const;

    indexedArray_optional&
    indexedArray ();

    void
    indexedArray (const indexedArray_type& x);

    void
    indexedArray (const indexedArray_optional& x);

    void
    indexedArray (::std::unique_ptr< indexedArray_type > p);

    // Constructors.
    //
    Relation ();

    Relation (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    Relation (const Relation& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual Relation*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Relation&
    operator= (const Relation& x);

    virtual
    ~Relation ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    lookupTable_optional lookupTable_;
    indexedArray_optional indexedArray_;
  };

  class ArrayDimensionDataType: public ::xml_schema::string
  {
    public:
    enum value
    {
      unsignedInt
    };

    ArrayDimensionDataType (value v);

    ArrayDimensionDataType (const char* v);

    ArrayDimensionDataType (const ::std::string& v);

    ArrayDimensionDataType (const ::xml_schema::string& v);

    ArrayDimensionDataType (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    ArrayDimensionDataType (const ::xercesc::DOMAttr& a,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    ArrayDimensionDataType (const ::std::string& s,
                            const ::xercesc::DOMElement* e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    ArrayDimensionDataType (const ArrayDimensionDataType& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual ArrayDimensionDataType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ArrayDimensionDataType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_ArrayDimensionDataType_convert ();
    }

    protected:
    value
    _xsd_ArrayDimensionDataType_convert () const;

    public:
    static const char* const _xsd_ArrayDimensionDataType_literals_[1];
    static const value _xsd_ArrayDimensionDataType_indexes_[1];
  };

  class ArrayValueDataType: public ::xml_schema::string
  {
    public:
    enum value
    {
      int_,
      float_,
      double_
    };

    ArrayValueDataType (value v);

    ArrayValueDataType (const char* v);

    ArrayValueDataType (const ::std::string& v);

    ArrayValueDataType (const ::xml_schema::string& v);

    ArrayValueDataType (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    ArrayValueDataType (const ::xercesc::DOMAttr& a,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    ArrayValueDataType (const ::std::string& s,
                        const ::xercesc::DOMElement* e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    ArrayValueDataType (const ArrayValueDataType& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual ArrayValueDataType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ArrayValueDataType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_ArrayValueDataType_convert ();
    }

    protected:
    value
    _xsd_ArrayValueDataType_convert () const;

    public:
    static const char* const _xsd_ArrayValueDataType_literals_[3];
    static const value _xsd_ArrayValueDataType_indexes_[3];
  };

  class IndexedArray: public ::xml_schema::type
  {
    public:
    // dimensionDataType
    //
    typedef ::pcrxml::ArrayDimensionDataType dimensionDataType_type;
    typedef ::xsd::cxx::tree::traits< dimensionDataType_type, char > dimensionDataType_traits;

    const dimensionDataType_type&
    dimensionDataType () const;

    dimensionDataType_type&
    dimensionDataType ();

    void
    dimensionDataType (const dimensionDataType_type& x);

    void
    dimensionDataType (::std::unique_ptr< dimensionDataType_type > p);

    // valueDataType
    //
    typedef ::pcrxml::ArrayValueDataType valueDataType_type;
    typedef ::xsd::cxx::tree::traits< valueDataType_type, char > valueDataType_traits;

    const valueDataType_type&
    valueDataType () const;

    valueDataType_type&
    valueDataType ();

    void
    valueDataType (const valueDataType_type& x);

    void
    valueDataType (::std::unique_ptr< valueDataType_type > p);

    // Constructors.
    //
    IndexedArray (const dimensionDataType_type&,
                  const valueDataType_type&);

    IndexedArray (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    IndexedArray (const IndexedArray& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual IndexedArray*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    IndexedArray&
    operator= (const IndexedArray& x);

    virtual
    ~IndexedArray ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< dimensionDataType_type > dimensionDataType_;
    ::xsd::cxx::tree::one< valueDataType_type > valueDataType_;
  };

  class LookupTable: public ::xml_schema::type
  {
    public:
    // lookupRow
    //
    typedef ::pcrxml::LookupRow lookupRow_type;
    typedef ::xsd::cxx::tree::sequence< lookupRow_type > lookupRow_sequence;
    typedef lookupRow_sequence::iterator lookupRow_iterator;
    typedef lookupRow_sequence::const_iterator lookupRow_const_iterator;
    typedef ::xsd::cxx::tree::traits< lookupRow_type, char > lookupRow_traits;

    const lookupRow_sequence&
    lookupRow () const;

    lookupRow_sequence&
    lookupRow ();

    void
    lookupRow (const lookupRow_sequence& s);

    // Constructors.
    //
    LookupTable ();

    LookupTable (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    LookupTable (const LookupTable& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual LookupTable*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LookupTable&
    operator= (const LookupTable& x);

    virtual
    ~LookupTable ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    lookupRow_sequence lookupRow_;
  };

  class FieldValueOrType: public ::xml_schema::type
  {
    public:
    // dataType
    //
    typedef ::pcrxml::DataType dataType_type;
    typedef ::xsd::cxx::tree::optional< dataType_type > dataType_optional;
    typedef ::xsd::cxx::tree::traits< dataType_type, char > dataType_traits;

    const dataType_optional&
    dataType () const;

    dataType_optional&
    dataType ();

    void
    dataType (const dataType_type& x);

    void
    dataType (const dataType_optional& x);

    void
    dataType (::std::unique_ptr< dataType_type > p);

    // number
    //
    typedef ::xml_schema::double_ number_type;
    typedef ::xsd::cxx::tree::optional< number_type > number_optional;
    typedef ::xsd::cxx::tree::traits< number_type, char, ::xsd::cxx::tree::schema_type::double_ > number_traits;

    const number_optional&
    number () const;

    number_optional&
    number ();

    void
    number (const number_type& x);

    void
    number (const number_optional& x);

    // spatialType
    //
    typedef ::pcrxml::SpatialType spatialType_type;
    typedef ::xsd::cxx::tree::optional< spatialType_type > spatialType_optional;
    typedef ::xsd::cxx::tree::traits< spatialType_type, char > spatialType_traits;

    const spatialType_optional&
    spatialType () const;

    spatialType_optional&
    spatialType ();

    void
    spatialType (const spatialType_type& x);

    void
    spatialType (const spatialType_optional& x);

    void
    spatialType (::std::unique_ptr< spatialType_type > p);

    // Constructors.
    //
    FieldValueOrType ();

    FieldValueOrType (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    FieldValueOrType (const FieldValueOrType& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual FieldValueOrType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FieldValueOrType&
    operator= (const FieldValueOrType& x);

    virtual
    ~FieldValueOrType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    dataType_optional dataType_;
    number_optional number_;
    spatialType_optional spatialType_;
  };

  class Definition: public ::xml_schema::type
  {
    public:
    // description
    //
    typedef ::pcrxml::Description description_type;
    typedef ::xsd::cxx::tree::optional< description_type > description_optional;
    typedef ::xsd::cxx::tree::traits< description_type, char > description_traits;

    const description_optional&
    description () const;

    description_optional&
    description ();

    void
    description (const description_type& x);

    void
    description (const description_optional& x);

    void
    description (::std::unique_ptr< description_type > p);

    // field
    //
    typedef ::pcrxml::FieldValueOrType field_type;
    typedef ::xsd::cxx::tree::optional< field_type > field_optional;
    typedef ::xsd::cxx::tree::traits< field_type, char > field_traits;

    const field_optional&
    field () const;

    field_optional&
    field ();

    void
    field (const field_type& x);

    void
    field (const field_optional& x);

    void
    field (::std::unique_ptr< field_type > p);

    // relation
    //
    typedef ::pcrxml::Relation relation_type;
    typedef ::xsd::cxx::tree::optional< relation_type > relation_optional;
    typedef ::xsd::cxx::tree::traits< relation_type, char > relation_traits;

    const relation_optional&
    relation () const;

    relation_optional&
    relation ();

    void
    relation (const relation_type& x);

    void
    relation (const relation_optional& x);

    void
    relation (::std::unique_ptr< relation_type > p);

    // modelExchange
    //
    typedef ::pcrxml::ModelExchange modelExchange_type;
    typedef ::xsd::cxx::tree::optional< modelExchange_type > modelExchange_optional;
    typedef ::xsd::cxx::tree::traits< modelExchange_type, char > modelExchange_traits;

    const modelExchange_optional&
    modelExchange () const;

    modelExchange_optional&
    modelExchange ();

    void
    modelExchange (const modelExchange_type& x);

    void
    modelExchange (const modelExchange_optional& x);

    void
    modelExchange (::std::unique_ptr< modelExchange_type > p);

    // scriptInput
    //
    typedef ::pcrxml::Exchange scriptInput_type;
    typedef ::xsd::cxx::tree::optional< scriptInput_type > scriptInput_optional;
    typedef ::xsd::cxx::tree::traits< scriptInput_type, char > scriptInput_traits;

    const scriptInput_optional&
    scriptInput () const;

    scriptInput_optional&
    scriptInput ();

    void
    scriptInput (const scriptInput_type& x);

    void
    scriptInput (const scriptInput_optional& x);

    void
    scriptInput (::std::unique_ptr< scriptInput_type > p);

    // scriptOutput
    //
    typedef ::pcrxml::Exchange scriptOutput_type;
    typedef ::xsd::cxx::tree::optional< scriptOutput_type > scriptOutput_optional;
    typedef ::xsd::cxx::tree::traits< scriptOutput_type, char > scriptOutput_traits;

    const scriptOutput_optional&
    scriptOutput () const;

    scriptOutput_optional&
    scriptOutput ();

    void
    scriptOutput (const scriptOutput_type& x);

    void
    scriptOutput (const scriptOutput_optional& x);

    void
    scriptOutput (::std::unique_ptr< scriptOutput_type > p);

    // name
    //
    typedef ::xml_schema::id name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // Constructors.
    //
    Definition (const name_type&);

    Definition (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    Definition (const Definition& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual Definition*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Definition&
    operator= (const Definition& x);

    virtual
    ~Definition ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    description_optional description_;
    field_optional field_;
    relation_optional relation_;
    modelExchange_optional modelExchange_;
    scriptInput_optional scriptInput_;
    scriptOutput_optional scriptOutput_;
    ::xsd::cxx::tree::one< name_type > name_;
  };

  class Boolean: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    Boolean ();

    Boolean (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Boolean (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Boolean (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Boolean (const Boolean& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual Boolean*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~Boolean ();
  };

  class Nominal: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    Nominal ();

    Nominal (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Nominal (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Nominal (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Nominal (const Nominal& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual Nominal*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~Nominal ();
  };

  class Ordinal: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    Ordinal ();

    Ordinal (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Ordinal (const ::xercesc::DOMAttr& a,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Ordinal (const ::std::string& s,
             const ::xercesc::DOMElement* e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    Ordinal (const Ordinal& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual Ordinal*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~Ordinal ();
  };

  class Directional: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    Directional ();

    Directional (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    Directional (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    Directional (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    Directional (const Directional& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual Directional*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~Directional ();
  };

  class Ldd: public ::xml_schema::type
  {
    public:
    // Constructors.
    //
    Ldd ();

    Ldd (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f = 0,
         ::xml_schema::container* c = 0);

    Ldd (const ::xercesc::DOMAttr& a,
         ::xml_schema::flags f = 0,
         ::xml_schema::container* c = 0);

    Ldd (const ::std::string& s,
         const ::xercesc::DOMElement* e,
         ::xml_schema::flags f = 0,
         ::xml_schema::container* c = 0);

    Ldd (const Ldd& x,
         ::xml_schema::flags f = 0,
         ::xml_schema::container* c = 0);

    virtual Ldd*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    virtual
    ~Ldd ();
  };

  class Scalar: public ::xml_schema::type
  {
    public:
    // length
    //
    typedef ::xml_schema::double_ length_type;
    typedef ::xsd::cxx::tree::optional< length_type > length_optional;
    typedef ::xsd::cxx::tree::traits< length_type, char, ::xsd::cxx::tree::schema_type::double_ > length_traits;

    const length_optional&
    length () const;

    length_optional&
    length ();

    void
    length (const length_type& x);

    void
    length (const length_optional& x);

    // mass
    //
    typedef ::xml_schema::double_ mass_type;
    typedef ::xsd::cxx::tree::optional< mass_type > mass_optional;
    typedef ::xsd::cxx::tree::traits< mass_type, char, ::xsd::cxx::tree::schema_type::double_ > mass_traits;

    const mass_optional&
    mass () const;

    mass_optional&
    mass ();

    void
    mass (const mass_type& x);

    void
    mass (const mass_optional& x);

    // time
    //
    typedef ::xml_schema::double_ time_type;
    typedef ::xsd::cxx::tree::optional< time_type > time_optional;
    typedef ::xsd::cxx::tree::traits< time_type, char, ::xsd::cxx::tree::schema_type::double_ > time_traits;

    const time_optional&
    time () const;

    time_optional&
    time ();

    void
    time (const time_type& x);

    void
    time (const time_optional& x);

    // electricCurrent
    //
    typedef ::xml_schema::double_ electricCurrent_type;
    typedef ::xsd::cxx::tree::optional< electricCurrent_type > electricCurrent_optional;
    typedef ::xsd::cxx::tree::traits< electricCurrent_type, char, ::xsd::cxx::tree::schema_type::double_ > electricCurrent_traits;

    const electricCurrent_optional&
    electricCurrent () const;

    electricCurrent_optional&
    electricCurrent ();

    void
    electricCurrent (const electricCurrent_type& x);

    void
    electricCurrent (const electricCurrent_optional& x);

    // temperature
    //
    typedef ::xml_schema::double_ temperature_type;
    typedef ::xsd::cxx::tree::optional< temperature_type > temperature_optional;
    typedef ::xsd::cxx::tree::traits< temperature_type, char, ::xsd::cxx::tree::schema_type::double_ > temperature_traits;

    const temperature_optional&
    temperature () const;

    temperature_optional&
    temperature ();

    void
    temperature (const temperature_type& x);

    void
    temperature (const temperature_optional& x);

    // amountOfSubstance
    //
    typedef ::xml_schema::double_ amountOfSubstance_type;
    typedef ::xsd::cxx::tree::optional< amountOfSubstance_type > amountOfSubstance_optional;
    typedef ::xsd::cxx::tree::traits< amountOfSubstance_type, char, ::xsd::cxx::tree::schema_type::double_ > amountOfSubstance_traits;

    const amountOfSubstance_optional&
    amountOfSubstance () const;

    amountOfSubstance_optional&
    amountOfSubstance ();

    void
    amountOfSubstance (const amountOfSubstance_type& x);

    void
    amountOfSubstance (const amountOfSubstance_optional& x);

    // luminousIntensity
    //
    typedef ::xml_schema::double_ luminousIntensity_type;
    typedef ::xsd::cxx::tree::optional< luminousIntensity_type > luminousIntensity_optional;
    typedef ::xsd::cxx::tree::traits< luminousIntensity_type, char, ::xsd::cxx::tree::schema_type::double_ > luminousIntensity_traits;

    const luminousIntensity_optional&
    luminousIntensity () const;

    luminousIntensity_optional&
    luminousIntensity ();

    void
    luminousIntensity (const luminousIntensity_type& x);

    void
    luminousIntensity (const luminousIntensity_optional& x);

    // currency
    //
    typedef ::xml_schema::double_ currency_type;
    typedef ::xsd::cxx::tree::optional< currency_type > currency_optional;
    typedef ::xsd::cxx::tree::traits< currency_type, char, ::xsd::cxx::tree::schema_type::double_ > currency_traits;

    const currency_optional&
    currency () const;

    currency_optional&
    currency ();

    void
    currency (const currency_type& x);

    void
    currency (const currency_optional& x);

    // Constructors.
    //
    Scalar ();

    Scalar (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    Scalar (const Scalar& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual Scalar*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    Scalar&
    operator= (const Scalar& x);

    virtual
    ~Scalar ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    length_optional length_;
    mass_optional mass_;
    time_optional time_;
    electricCurrent_optional electricCurrent_;
    temperature_optional temperature_;
    amountOfSubstance_optional amountOfSubstance_;
    luminousIntensity_optional luminousIntensity_;
    currency_optional currency_;
  };

  class DataType: public ::xml_schema::type
  {
    public:
    // boolean
    //
    typedef ::pcrxml::Boolean boolean_type;
    typedef ::xsd::cxx::tree::optional< boolean_type > boolean_optional;
    typedef ::xsd::cxx::tree::traits< boolean_type, char > boolean_traits;

    const boolean_optional&
    boolean () const;

    boolean_optional&
    boolean ();

    void
    boolean (const boolean_type& x);

    void
    boolean (const boolean_optional& x);

    void
    boolean (::std::unique_ptr< boolean_type > p);

    // nominal
    //
    typedef ::pcrxml::Nominal nominal_type;
    typedef ::xsd::cxx::tree::optional< nominal_type > nominal_optional;
    typedef ::xsd::cxx::tree::traits< nominal_type, char > nominal_traits;

    const nominal_optional&
    nominal () const;

    nominal_optional&
    nominal ();

    void
    nominal (const nominal_type& x);

    void
    nominal (const nominal_optional& x);

    void
    nominal (::std::unique_ptr< nominal_type > p);

    // ordinal
    //
    typedef ::pcrxml::Ordinal ordinal_type;
    typedef ::xsd::cxx::tree::optional< ordinal_type > ordinal_optional;
    typedef ::xsd::cxx::tree::traits< ordinal_type, char > ordinal_traits;

    const ordinal_optional&
    ordinal () const;

    ordinal_optional&
    ordinal ();

    void
    ordinal (const ordinal_type& x);

    void
    ordinal (const ordinal_optional& x);

    void
    ordinal (::std::unique_ptr< ordinal_type > p);

    // scalar
    //
    typedef ::pcrxml::Scalar scalar_type;
    typedef ::xsd::cxx::tree::optional< scalar_type > scalar_optional;
    typedef ::xsd::cxx::tree::traits< scalar_type, char > scalar_traits;

    const scalar_optional&
    scalar () const;

    scalar_optional&
    scalar ();

    void
    scalar (const scalar_type& x);

    void
    scalar (const scalar_optional& x);

    void
    scalar (::std::unique_ptr< scalar_type > p);

    // directional
    //
    typedef ::pcrxml::Directional directional_type;
    typedef ::xsd::cxx::tree::optional< directional_type > directional_optional;
    typedef ::xsd::cxx::tree::traits< directional_type, char > directional_traits;

    const directional_optional&
    directional () const;

    directional_optional&
    directional ();

    void
    directional (const directional_type& x);

    void
    directional (const directional_optional& x);

    void
    directional (::std::unique_ptr< directional_type > p);

    // ldd
    //
    typedef ::pcrxml::Ldd ldd_type;
    typedef ::xsd::cxx::tree::optional< ldd_type > ldd_optional;
    typedef ::xsd::cxx::tree::traits< ldd_type, char > ldd_traits;

    const ldd_optional&
    ldd () const;

    ldd_optional&
    ldd ();

    void
    ldd (const ldd_type& x);

    void
    ldd (const ldd_optional& x);

    void
    ldd (::std::unique_ptr< ldd_type > p);

    // Constructors.
    //
    DataType ();

    DataType (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    DataType (const DataType& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual DataType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DataType&
    operator= (const DataType& x);

    virtual
    ~DataType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    boolean_optional boolean_;
    nominal_optional nominal_;
    ordinal_optional ordinal_;
    scalar_optional scalar_;
    directional_optional directional_;
    ldd_optional ldd_;
  };

  class DataTypeOfValue: public ::xml_schema::type
  {
    public:
    // boolean
    //
    typedef ::pcrxml::Boolean boolean_type;
    typedef ::xsd::cxx::tree::optional< boolean_type > boolean_optional;
    typedef ::xsd::cxx::tree::traits< boolean_type, char > boolean_traits;

    const boolean_optional&
    boolean () const;

    boolean_optional&
    boolean ();

    void
    boolean (const boolean_type& x);

    void
    boolean (const boolean_optional& x);

    void
    boolean (::std::unique_ptr< boolean_type > p);

    // ldd
    //
    typedef ::pcrxml::Ldd ldd_type;
    typedef ::xsd::cxx::tree::optional< ldd_type > ldd_optional;
    typedef ::xsd::cxx::tree::traits< ldd_type, char > ldd_traits;

    const ldd_optional&
    ldd () const;

    ldd_optional&
    ldd ();

    void
    ldd (const ldd_type& x);

    void
    ldd (const ldd_optional& x);

    void
    ldd (::std::unique_ptr< ldd_type > p);

    // nominal
    //
    typedef ::pcrxml::Nominal nominal_type;
    typedef ::xsd::cxx::tree::optional< nominal_type > nominal_optional;
    typedef ::xsd::cxx::tree::traits< nominal_type, char > nominal_traits;

    const nominal_optional&
    nominal () const;

    nominal_optional&
    nominal ();

    void
    nominal (const nominal_type& x);

    void
    nominal (const nominal_optional& x);

    void
    nominal (::std::unique_ptr< nominal_type > p);

    // ordinal
    //
    typedef ::pcrxml::Ordinal ordinal_type;
    typedef ::xsd::cxx::tree::optional< ordinal_type > ordinal_optional;
    typedef ::xsd::cxx::tree::traits< ordinal_type, char > ordinal_traits;

    const ordinal_optional&
    ordinal () const;

    ordinal_optional&
    ordinal ();

    void
    ordinal (const ordinal_type& x);

    void
    ordinal (const ordinal_optional& x);

    void
    ordinal (::std::unique_ptr< ordinal_type > p);

    // scalar
    //
    typedef ::pcrxml::Scalar scalar_type;
    typedef ::xsd::cxx::tree::optional< scalar_type > scalar_optional;
    typedef ::xsd::cxx::tree::traits< scalar_type, char > scalar_traits;

    const scalar_optional&
    scalar () const;

    scalar_optional&
    scalar ();

    void
    scalar (const scalar_type& x);

    void
    scalar (const scalar_optional& x);

    void
    scalar (::std::unique_ptr< scalar_type > p);

    // directional
    //
    typedef ::pcrxml::Directional directional_type;
    typedef ::xsd::cxx::tree::optional< directional_type > directional_optional;
    typedef ::xsd::cxx::tree::traits< directional_type, char > directional_traits;

    const directional_optional&
    directional () const;

    directional_optional&
    directional ();

    void
    directional (const directional_type& x);

    void
    directional (const directional_optional& x);

    void
    directional (::std::unique_ptr< directional_type > p);

    // Constructors.
    //
    DataTypeOfValue ();

    DataTypeOfValue (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    DataTypeOfValue (const DataTypeOfValue& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual DataTypeOfValue*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    DataTypeOfValue&
    operator= (const DataTypeOfValue& x);

    virtual
    ~DataTypeOfValue ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    boolean_optional boolean_;
    ldd_optional ldd_;
    nominal_optional nominal_;
    ordinal_optional ordinal_;
    scalar_optional scalar_;
    directional_optional directional_;
  };

  class CoordinateMask: public ::xml_schema::type
  {
    public:
    // xMinimum
    //
    typedef ::xml_schema::double_ xMinimum_type;
    typedef ::xsd::cxx::tree::traits< xMinimum_type, char, ::xsd::cxx::tree::schema_type::double_ > xMinimum_traits;

    const xMinimum_type&
    xMinimum () const;

    xMinimum_type&
    xMinimum ();

    void
    xMinimum (const xMinimum_type& x);

    // xMaximum
    //
    typedef ::xml_schema::double_ xMaximum_type;
    typedef ::xsd::cxx::tree::traits< xMaximum_type, char, ::xsd::cxx::tree::schema_type::double_ > xMaximum_traits;

    const xMaximum_type&
    xMaximum () const;

    xMaximum_type&
    xMaximum ();

    void
    xMaximum (const xMaximum_type& x);

    // yMinimum
    //
    typedef ::xml_schema::double_ yMinimum_type;
    typedef ::xsd::cxx::tree::traits< yMinimum_type, char, ::xsd::cxx::tree::schema_type::double_ > yMinimum_traits;

    const yMinimum_type&
    yMinimum () const;

    yMinimum_type&
    yMinimum ();

    void
    yMinimum (const yMinimum_type& x);

    // yMaximum
    //
    typedef ::xml_schema::double_ yMaximum_type;
    typedef ::xsd::cxx::tree::traits< yMaximum_type, char, ::xsd::cxx::tree::schema_type::double_ > yMaximum_traits;

    const yMaximum_type&
    yMaximum () const;

    yMaximum_type&
    yMaximum ();

    void
    yMaximum (const yMaximum_type& x);

    // Constructors.
    //
    CoordinateMask (const xMinimum_type&,
                    const xMaximum_type&,
                    const yMinimum_type&,
                    const yMaximum_type&);

    CoordinateMask (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    CoordinateMask (const CoordinateMask& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual CoordinateMask*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CoordinateMask&
    operator= (const CoordinateMask& x);

    virtual
    ~CoordinateMask ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< xMinimum_type > xMinimum_;
    ::xsd::cxx::tree::one< xMaximum_type > xMaximum_;
    ::xsd::cxx::tree::one< yMinimum_type > yMinimum_;
    ::xsd::cxx::tree::one< yMaximum_type > yMaximum_;
  };

  class AreaMap: public ::xml_schema::type
  {
    public:
    // nrRows
    //
    typedef ::pcrxml::Non0UnsignedInt nrRows_type;
    typedef ::xsd::cxx::tree::traits< nrRows_type, char > nrRows_traits;

    const nrRows_type&
    nrRows () const;

    nrRows_type&
    nrRows ();

    void
    nrRows (const nrRows_type& x);

    void
    nrRows (::std::unique_ptr< nrRows_type > p);

    // nrCols
    //
    typedef ::pcrxml::Non0UnsignedInt nrCols_type;
    typedef ::xsd::cxx::tree::traits< nrCols_type, char > nrCols_traits;

    const nrCols_type&
    nrCols () const;

    nrCols_type&
    nrCols ();

    void
    nrCols (const nrCols_type& x);

    void
    nrCols (::std::unique_ptr< nrCols_type > p);

    // cellSize
    //
    typedef ::xml_schema::double_ cellSize_type;
    typedef ::xsd::cxx::tree::optional< cellSize_type > cellSize_optional;
    typedef ::xsd::cxx::tree::traits< cellSize_type, char, ::xsd::cxx::tree::schema_type::double_ > cellSize_traits;

    const cellSize_optional&
    cellSize () const;

    cellSize_optional&
    cellSize ();

    void
    cellSize (const cellSize_type& x);

    void
    cellSize (const cellSize_optional& x);

    static cellSize_type
    cellSize_default_value ();

    // xLowerLeftCorner
    //
    typedef ::xml_schema::double_ xLowerLeftCorner_type;
    typedef ::xsd::cxx::tree::optional< xLowerLeftCorner_type > xLowerLeftCorner_optional;
    typedef ::xsd::cxx::tree::traits< xLowerLeftCorner_type, char, ::xsd::cxx::tree::schema_type::double_ > xLowerLeftCorner_traits;

    const xLowerLeftCorner_optional&
    xLowerLeftCorner () const;

    xLowerLeftCorner_optional&
    xLowerLeftCorner ();

    void
    xLowerLeftCorner (const xLowerLeftCorner_type& x);

    void
    xLowerLeftCorner (const xLowerLeftCorner_optional& x);

    static xLowerLeftCorner_type
    xLowerLeftCorner_default_value ();

    // yLowerLeftCorner
    //
    typedef ::xml_schema::double_ yLowerLeftCorner_type;
    typedef ::xsd::cxx::tree::optional< yLowerLeftCorner_type > yLowerLeftCorner_optional;
    typedef ::xsd::cxx::tree::traits< yLowerLeftCorner_type, char, ::xsd::cxx::tree::schema_type::double_ > yLowerLeftCorner_traits;

    const yLowerLeftCorner_optional&
    yLowerLeftCorner () const;

    yLowerLeftCorner_optional&
    yLowerLeftCorner ();

    void
    yLowerLeftCorner (const yLowerLeftCorner_type& x);

    void
    yLowerLeftCorner (const yLowerLeftCorner_optional& x);

    static yLowerLeftCorner_type
    yLowerLeftCorner_default_value ();

    // Constructors.
    //
    AreaMap (const nrRows_type&,
             const nrCols_type&);

    AreaMap (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    AreaMap (const AreaMap& x,
             ::xml_schema::flags f = 0,
             ::xml_schema::container* c = 0);

    virtual AreaMap*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AreaMap&
    operator= (const AreaMap& x);

    virtual
    ~AreaMap ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< nrRows_type > nrRows_;
    ::xsd::cxx::tree::one< nrCols_type > nrCols_;
    cellSize_optional cellSize_;
    xLowerLeftCorner_optional xLowerLeftCorner_;
    yLowerLeftCorner_optional yLowerLeftCorner_;
  };

  class FieldReference: public ::xml_schema::type
  {
    public:
    // ref
    //
    typedef ::xml_schema::idref ref_type;
    typedef ::xsd::cxx::tree::traits< ref_type, char > ref_traits;

    const ref_type&
    ref () const;

    ref_type&
    ref ();

    void
    ref (const ref_type& x);

    void
    ref (::std::unique_ptr< ref_type > p);

    // Constructors.
    //
    FieldReference (const ref_type&);

    FieldReference (const ::xercesc::DOMElement& e,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    FieldReference (const FieldReference& x,
                    ::xml_schema::flags f = 0,
                    ::xml_schema::container* c = 0);

    virtual FieldReference*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FieldReference&
    operator= (const FieldReference& x);

    virtual
    ~FieldReference ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< ref_type > ref_;
  };

  class AreaMapScript: public ::xml_schema::type
  {
    public:
    // fieldReference
    //
    typedef ::pcrxml::FieldReference fieldReference_type;
    typedef ::xsd::cxx::tree::optional< fieldReference_type > fieldReference_optional;
    typedef ::xsd::cxx::tree::traits< fieldReference_type, char > fieldReference_traits;

    const fieldReference_optional&
    fieldReference () const;

    fieldReference_optional&
    fieldReference ();

    void
    fieldReference (const fieldReference_type& x);

    void
    fieldReference (const fieldReference_optional& x);

    void
    fieldReference (::std::unique_ptr< fieldReference_type > p);

    // nrRows
    //
    typedef ::pcrxml::Non0UnsignedInt nrRows_type;
    typedef ::xsd::cxx::tree::optional< nrRows_type > nrRows_optional;
    typedef ::xsd::cxx::tree::traits< nrRows_type, char > nrRows_traits;

    const nrRows_optional&
    nrRows () const;

    nrRows_optional&
    nrRows ();

    void
    nrRows (const nrRows_type& x);

    void
    nrRows (const nrRows_optional& x);

    void
    nrRows (::std::unique_ptr< nrRows_type > p);

    // nrCols
    //
    typedef ::pcrxml::Non0UnsignedInt nrCols_type;
    typedef ::xsd::cxx::tree::optional< nrCols_type > nrCols_optional;
    typedef ::xsd::cxx::tree::traits< nrCols_type, char > nrCols_traits;

    const nrCols_optional&
    nrCols () const;

    nrCols_optional&
    nrCols ();

    void
    nrCols (const nrCols_type& x);

    void
    nrCols (const nrCols_optional& x);

    void
    nrCols (::std::unique_ptr< nrCols_type > p);

    // cellSize
    //
    typedef ::xml_schema::double_ cellSize_type;
    typedef ::xsd::cxx::tree::optional< cellSize_type > cellSize_optional;
    typedef ::xsd::cxx::tree::traits< cellSize_type, char, ::xsd::cxx::tree::schema_type::double_ > cellSize_traits;

    const cellSize_optional&
    cellSize () const;

    cellSize_optional&
    cellSize ();

    void
    cellSize (const cellSize_type& x);

    void
    cellSize (const cellSize_optional& x);

    static cellSize_type
    cellSize_default_value ();

    // xLowerLeftCorner
    //
    typedef ::xml_schema::double_ xLowerLeftCorner_type;
    typedef ::xsd::cxx::tree::optional< xLowerLeftCorner_type > xLowerLeftCorner_optional;
    typedef ::xsd::cxx::tree::traits< xLowerLeftCorner_type, char, ::xsd::cxx::tree::schema_type::double_ > xLowerLeftCorner_traits;

    const xLowerLeftCorner_optional&
    xLowerLeftCorner () const;

    xLowerLeftCorner_optional&
    xLowerLeftCorner ();

    void
    xLowerLeftCorner (const xLowerLeftCorner_type& x);

    void
    xLowerLeftCorner (const xLowerLeftCorner_optional& x);

    static xLowerLeftCorner_type
    xLowerLeftCorner_default_value ();

    // yLowerLeftCorner
    //
    typedef ::xml_schema::double_ yLowerLeftCorner_type;
    typedef ::xsd::cxx::tree::optional< yLowerLeftCorner_type > yLowerLeftCorner_optional;
    typedef ::xsd::cxx::tree::traits< yLowerLeftCorner_type, char, ::xsd::cxx::tree::schema_type::double_ > yLowerLeftCorner_traits;

    const yLowerLeftCorner_optional&
    yLowerLeftCorner () const;

    yLowerLeftCorner_optional&
    yLowerLeftCorner ();

    void
    yLowerLeftCorner (const yLowerLeftCorner_type& x);

    void
    yLowerLeftCorner (const yLowerLeftCorner_optional& x);

    static yLowerLeftCorner_type
    yLowerLeftCorner_default_value ();

    // Constructors.
    //
    AreaMapScript ();

    AreaMapScript (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    AreaMapScript (const AreaMapScript& x,
                   ::xml_schema::flags f = 0,
                   ::xml_schema::container* c = 0);

    virtual AreaMapScript*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    AreaMapScript&
    operator= (const AreaMapScript& x);

    virtual
    ~AreaMapScript ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    fieldReference_optional fieldReference_;
    nrRows_optional nrRows_;
    nrCols_optional nrCols_;
    cellSize_optional cellSize_;
    xLowerLeftCorner_optional xLowerLeftCorner_;
    yLowerLeftCorner_optional yLowerLeftCorner_;
  };

  class MaskMapType: public ::xml_schema::string
  {
    public:
    enum value
    {
      computeAtNonMissingValues,
      computeAtNonZeroValues
    };

    MaskMapType (value v);

    MaskMapType (const char* v);

    MaskMapType (const ::std::string& v);

    MaskMapType (const ::xml_schema::string& v);

    MaskMapType (const ::xercesc::DOMElement& e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    MaskMapType (const ::xercesc::DOMAttr& a,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    MaskMapType (const ::std::string& s,
                 const ::xercesc::DOMElement* e,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    MaskMapType (const MaskMapType& x,
                 ::xml_schema::flags f = 0,
                 ::xml_schema::container* c = 0);

    virtual MaskMapType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    MaskMapType&
    operator= (value v);

    virtual
    operator value () const
    {
      return _xsd_MaskMapType_convert ();
    }

    protected:
    value
    _xsd_MaskMapType_convert () const;

    public:
    static const char* const _xsd_MaskMapType_literals_[2];
    static const value _xsd_MaskMapType_indexes_[2];
  };

  class ComputationMaskByAreaMap: public ::xml_schema::type
  {
    public:
    // maskType
    //
    typedef ::pcrxml::MaskMapType maskType_type;
    typedef ::xsd::cxx::tree::traits< maskType_type, char > maskType_traits;

    const maskType_type&
    maskType () const;

    maskType_type&
    maskType ();

    void
    maskType (const maskType_type& x);

    void
    maskType (::std::unique_ptr< maskType_type > p);

    // Constructors.
    //
    ComputationMaskByAreaMap (const maskType_type&);

    ComputationMaskByAreaMap (const ::xercesc::DOMElement& e,
                              ::xml_schema::flags f = 0,
                              ::xml_schema::container* c = 0);

    ComputationMaskByAreaMap (const ComputationMaskByAreaMap& x,
                              ::xml_schema::flags f = 0,
                              ::xml_schema::container* c = 0);

    virtual ComputationMaskByAreaMap*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ComputationMaskByAreaMap&
    operator= (const ComputationMaskByAreaMap& x);

    virtual
    ~ComputationMaskByAreaMap ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< maskType_type > maskType_;
  };

  class ComputationMask: public ::xml_schema::type
  {
    public:
    // areaMap
    //
    typedef ::pcrxml::ComputationMaskByAreaMap areaMap_type;
    typedef ::xsd::cxx::tree::optional< areaMap_type > areaMap_optional;
    typedef ::xsd::cxx::tree::traits< areaMap_type, char > areaMap_traits;

    const areaMap_optional&
    areaMap () const;

    areaMap_optional&
    areaMap ();

    void
    areaMap (const areaMap_type& x);

    void
    areaMap (const areaMap_optional& x);

    void
    areaMap (::std::unique_ptr< areaMap_type > p);

    // coordinates
    //
    typedef ::pcrxml::CoordinateMask coordinates_type;
    typedef ::xsd::cxx::tree::optional< coordinates_type > coordinates_optional;
    typedef ::xsd::cxx::tree::traits< coordinates_type, char > coordinates_traits;

    const coordinates_optional&
    coordinates () const;

    coordinates_optional&
    coordinates ();

    void
    coordinates (const coordinates_type& x);

    void
    coordinates (const coordinates_optional& x);

    void
    coordinates (::std::unique_ptr< coordinates_type > p);

    // Constructors.
    //
    ComputationMask ();

    ComputationMask (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    ComputationMask (const ComputationMask& x,
                     ::xml_schema::flags f = 0,
                     ::xml_schema::container* c = 0);

    virtual ComputationMask*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    ComputationMask&
    operator= (const ComputationMask& x);

    virtual
    ~ComputationMask ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    areaMap_optional areaMap_;
    coordinates_optional coordinates_;
  };

  class TimerOfModel: public ::xml_schema::type
  {
    public:
    // integer
    //
    typedef ::pcrxml::IntegerTimer integer_type;
    typedef ::xsd::cxx::tree::traits< integer_type, char > integer_traits;

    const integer_type&
    integer () const;

    integer_type&
    integer ();

    void
    integer (const integer_type& x);

    void
    integer (::std::unique_ptr< integer_type > p);

    // Constructors.
    //
    TimerOfModel (const integer_type&);

    TimerOfModel (::std::unique_ptr< integer_type >);

    TimerOfModel (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    TimerOfModel (const TimerOfModel& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual TimerOfModel*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TimerOfModel&
    operator= (const TimerOfModel& x);

    virtual
    ~TimerOfModel ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< integer_type > integer_;
  };

  class IntegerTimer: public ::xml_schema::type
  {
    public:
    // start
    //
    typedef ::pcrxml::Non0UnsignedInt start_type;
    typedef ::xsd::cxx::tree::traits< start_type, char > start_traits;

    const start_type&
    start () const;

    start_type&
    start ();

    void
    start (const start_type& x);

    void
    start (::std::unique_ptr< start_type > p);

    // end
    //
    typedef ::pcrxml::Non0UnsignedInt end_type;
    typedef ::xsd::cxx::tree::optional< end_type > end_optional;
    typedef ::xsd::cxx::tree::traits< end_type, char > end_traits;

    const end_optional&
    end () const;

    end_optional&
    end ();

    void
    end (const end_type& x);

    void
    end (const end_optional& x);

    void
    end (::std::unique_ptr< end_type > p);

    // Constructors.
    //
    IntegerTimer (const start_type&);

    IntegerTimer (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    IntegerTimer (const IntegerTimer& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual IntegerTimer*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    IntegerTimer&
    operator= (const IntegerTimer& x);

    virtual
    ~IntegerTimer ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< start_type > start_;
    end_optional end_;
  };

  class TimerContext: public ::xml_schema::type
  {
    public:
    // current
    //
    typedef ::xml_schema::unsigned_int current_type;
    typedef ::xsd::cxx::tree::traits< current_type, char > current_traits;

    const current_type&
    current () const;

    current_type&
    current ();

    void
    current (const current_type& x);

    // start
    //
    typedef ::xml_schema::unsigned_int start_type;
    typedef ::xsd::cxx::tree::optional< start_type > start_optional;
    typedef ::xsd::cxx::tree::traits< start_type, char > start_traits;

    const start_optional&
    start () const;

    start_optional&
    start ();

    void
    start (const start_type& x);

    void
    start (const start_optional& x);

    // end
    //
    typedef ::xml_schema::unsigned_int end_type;
    typedef ::xsd::cxx::tree::optional< end_type > end_optional;
    typedef ::xsd::cxx::tree::traits< end_type, char > end_traits;

    const end_optional&
    end () const;

    end_optional&
    end ();

    void
    end (const end_type& x);

    void
    end (const end_optional& x);

    // Constructors.
    //
    TimerContext (const current_type&);

    TimerContext (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    TimerContext (const TimerContext& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual TimerContext*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    TimerContext&
    operator= (const TimerContext& x);

    virtual
    ~TimerContext ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< current_type > current_;
    start_optional start_;
    end_optional end_;
  };

  class CheckContext: public ::xml_schema::type
  {
    public:
    // areaMap
    //
    typedef ::pcrxml::AreaMap areaMap_type;
    typedef ::xsd::cxx::tree::optional< areaMap_type > areaMap_optional;
    typedef ::xsd::cxx::tree::traits< areaMap_type, char > areaMap_traits;

    const areaMap_optional&
    areaMap () const;

    areaMap_optional&
    areaMap ();

    void
    areaMap (const areaMap_type& x);

    void
    areaMap (const areaMap_optional& x);

    void
    areaMap (::std::unique_ptr< areaMap_type > p);

    // computationMask
    //
    typedef ::pcrxml::ComputationMask computationMask_type;
    typedef ::xsd::cxx::tree::optional< computationMask_type > computationMask_optional;
    typedef ::xsd::cxx::tree::traits< computationMask_type, char > computationMask_traits;

    const computationMask_optional&
    computationMask () const;

    computationMask_optional&
    computationMask ();

    void
    computationMask (const computationMask_type& x);

    void
    computationMask (const computationMask_optional& x);

    void
    computationMask (::std::unique_ptr< computationMask_type > p);

    // timer
    //
    typedef ::pcrxml::TimerContext timer_type;
    typedef ::xsd::cxx::tree::optional< timer_type > timer_optional;
    typedef ::xsd::cxx::tree::traits< timer_type, char > timer_traits;

    const timer_optional&
    timer () const;

    timer_optional&
    timer ();

    void
    timer (const timer_type& x);

    void
    timer (const timer_optional& x);

    void
    timer (::std::unique_ptr< timer_type > p);

    // Constructors.
    //
    CheckContext ();

    CheckContext (const ::xercesc::DOMElement& e,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    CheckContext (const CheckContext& x,
                  ::xml_schema::flags f = 0,
                  ::xml_schema::container* c = 0);

    virtual CheckContext*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CheckContext&
    operator= (const CheckContext& x);

    virtual
    ~CheckContext ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    areaMap_optional areaMap_;
    computationMask_optional computationMask_;
    timer_optional timer_;
  };

  class RunContext: public ::xml_schema::type
  {
    public:
    // areaMap
    //
    typedef ::pcrxml::AreaMap areaMap_type;
    typedef ::xsd::cxx::tree::traits< areaMap_type, char > areaMap_traits;

    const areaMap_type&
    areaMap () const;

    areaMap_type&
    areaMap ();

    void
    areaMap (const areaMap_type& x);

    void
    areaMap (::std::unique_ptr< areaMap_type > p);

    // computationMask
    //
    typedef ::pcrxml::ComputationMask computationMask_type;
    typedef ::xsd::cxx::tree::optional< computationMask_type > computationMask_optional;
    typedef ::xsd::cxx::tree::traits< computationMask_type, char > computationMask_traits;

    const computationMask_optional&
    computationMask () const;

    computationMask_optional&
    computationMask ();

    void
    computationMask (const computationMask_type& x);

    void
    computationMask (const computationMask_optional& x);

    void
    computationMask (::std::unique_ptr< computationMask_type > p);

    // timer
    //
    typedef ::pcrxml::TimerContext timer_type;
    typedef ::xsd::cxx::tree::traits< timer_type, char > timer_traits;

    const timer_type&
    timer () const;

    timer_type&
    timer ();

    void
    timer (const timer_type& x);

    void
    timer (::std::unique_ptr< timer_type > p);

    // Constructors.
    //
    RunContext (const areaMap_type&,
                const timer_type&);

    RunContext (::std::unique_ptr< areaMap_type >,
                ::std::unique_ptr< timer_type >);

    RunContext (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    RunContext (const RunContext& x,
                ::xml_schema::flags f = 0,
                ::xml_schema::container* c = 0);

    virtual RunContext*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    RunContext&
    operator= (const RunContext& x);

    virtual
    ~RunContext ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< areaMap_type > areaMap_;
    computationMask_optional computationMask_;
    ::xsd::cxx::tree::one< timer_type > timer_;
  };

  class LinkInLibraryManifest: public ::xml_schema::type
  {
    public:
    // function
    //
    typedef ::pcrxml::LinkInFunctionManifest function_type;
    typedef ::xsd::cxx::tree::sequence< function_type > function_sequence;
    typedef function_sequence::iterator function_iterator;
    typedef function_sequence::const_iterator function_const_iterator;
    typedef ::xsd::cxx::tree::traits< function_type, char > function_traits;

    const function_sequence&
    function () const;

    function_sequence&
    function ();

    void
    function (const function_sequence& s);

    // class
    //
    typedef ::pcrxml::LinkInClassManifest class_type;
    typedef ::xsd::cxx::tree::sequence< class_type > class_sequence;
    typedef class_sequence::iterator class_iterator;
    typedef class_sequence::const_iterator class_const_iterator;
    typedef ::xsd::cxx::tree::traits< class_type, char > class_traits;

    const class_sequence&
    class_ () const;

    class_sequence&
    class_ ();

    void
    class_ (const class_sequence& s);

    // Constructors.
    //
    LinkInLibraryManifest ();

    LinkInLibraryManifest (const ::xercesc::DOMElement& e,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    LinkInLibraryManifest (const LinkInLibraryManifest& x,
                           ::xml_schema::flags f = 0,
                           ::xml_schema::container* c = 0);

    virtual LinkInLibraryManifest*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInLibraryManifest&
    operator= (const LinkInLibraryManifest& x);

    virtual
    ~LinkInLibraryManifest ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    function_sequence function_;
    class_sequence class__;
  };

  class LinkInClassManifest: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::pcrxml::Identifier name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // constructor
    //
    typedef ::pcrxml::LinkInClassConstructor constructor_type;
    typedef ::xsd::cxx::tree::traits< constructor_type, char > constructor_traits;

    const constructor_type&
    constructor () const;

    constructor_type&
    constructor ();

    void
    constructor (const constructor_type& x);

    void
    constructor (::std::unique_ptr< constructor_type > p);

    // method
    //
    typedef ::pcrxml::LinkInClassMethod method_type;
    typedef ::xsd::cxx::tree::sequence< method_type > method_sequence;
    typedef method_sequence::iterator method_iterator;
    typedef method_sequence::const_iterator method_const_iterator;
    typedef ::xsd::cxx::tree::traits< method_type, char > method_traits;

    const method_sequence&
    method () const;

    method_sequence&
    method ();

    void
    method (const method_sequence& s);

    // Constructors.
    //
    LinkInClassManifest (const name_type&,
                         const constructor_type&);

    LinkInClassManifest (const name_type&,
                         ::std::unique_ptr< constructor_type >);

    LinkInClassManifest (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    LinkInClassManifest (const LinkInClassManifest& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual LinkInClassManifest*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInClassManifest&
    operator= (const LinkInClassManifest& x);

    virtual
    ~LinkInClassManifest ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
    ::xsd::cxx::tree::one< constructor_type > constructor_;
    method_sequence method_;
  };

  class LinkInClassConstructor: public ::xml_schema::type
  {
    public:
    // stringArgument
    //
    typedef ::pcrxml::SpaceTrimmedToken stringArgument_type;
    typedef ::xsd::cxx::tree::optional< stringArgument_type > stringArgument_optional;
    typedef ::xsd::cxx::tree::traits< stringArgument_type, char > stringArgument_traits;

    const stringArgument_optional&
    stringArgument () const;

    stringArgument_optional&
    stringArgument ();

    void
    stringArgument (const stringArgument_type& x);

    void
    stringArgument (const stringArgument_optional& x);

    void
    stringArgument (::std::unique_ptr< stringArgument_type > p);

    // argument
    //
    typedef ::pcrxml::FieldType argument_type;
    typedef ::xsd::cxx::tree::sequence< argument_type > argument_sequence;
    typedef argument_sequence::iterator argument_iterator;
    typedef argument_sequence::const_iterator argument_const_iterator;
    typedef ::xsd::cxx::tree::traits< argument_type, char > argument_traits;

    const argument_sequence&
    argument () const;

    argument_sequence&
    argument ();

    void
    argument (const argument_sequence& s);

    // Constructors.
    //
    LinkInClassConstructor ();

    LinkInClassConstructor (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    LinkInClassConstructor (const LinkInClassConstructor& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual LinkInClassConstructor*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInClassConstructor&
    operator= (const LinkInClassConstructor& x);

    virtual
    ~LinkInClassConstructor ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    stringArgument_optional stringArgument_;
    argument_sequence argument_;
  };

  class FieldType: public ::xml_schema::type
  {
    public:
    // dataType
    //
    typedef ::pcrxml::DataType dataType_type;
    typedef ::xsd::cxx::tree::traits< dataType_type, char > dataType_traits;

    const dataType_type&
    dataType () const;

    dataType_type&
    dataType ();

    void
    dataType (const dataType_type& x);

    void
    dataType (::std::unique_ptr< dataType_type > p);

    // spatialType
    //
    typedef ::pcrxml::SpatialType spatialType_type;
    typedef ::xsd::cxx::tree::traits< spatialType_type, char > spatialType_traits;

    const spatialType_type&
    spatialType () const;

    spatialType_type&
    spatialType ();

    void
    spatialType (const spatialType_type& x);

    void
    spatialType (::std::unique_ptr< spatialType_type > p);

    // Constructors.
    //
    FieldType (const dataType_type&,
               const spatialType_type&);

    FieldType (::std::unique_ptr< dataType_type >,
               const spatialType_type&);

    FieldType (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    FieldType (const FieldType& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual FieldType*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FieldType&
    operator= (const FieldType& x);

    virtual
    ~FieldType ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< dataType_type > dataType_;
    ::xsd::cxx::tree::one< spatialType_type > spatialType_;
  };

  class FieldTypeOfValue: public ::xml_schema::type
  {
    public:
    // dataType
    //
    typedef ::pcrxml::DataTypeOfValue dataType_type;
    typedef ::xsd::cxx::tree::traits< dataType_type, char > dataType_traits;

    const dataType_type&
    dataType () const;

    dataType_type&
    dataType ();

    void
    dataType (const dataType_type& x);

    void
    dataType (::std::unique_ptr< dataType_type > p);

    // spatialType
    //
    typedef ::pcrxml::SpatialTypeOfValue spatialType_type;
    typedef ::xsd::cxx::tree::traits< spatialType_type, char > spatialType_traits;

    const spatialType_type&
    spatialType () const;

    spatialType_type&
    spatialType ();

    void
    spatialType (const spatialType_type& x);

    void
    spatialType (::std::unique_ptr< spatialType_type > p);

    // Constructors.
    //
    FieldTypeOfValue (const dataType_type&,
                      const spatialType_type&);

    FieldTypeOfValue (::std::unique_ptr< dataType_type >,
                      const spatialType_type&);

    FieldTypeOfValue (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    FieldTypeOfValue (const FieldTypeOfValue& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual FieldTypeOfValue*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    FieldTypeOfValue&
    operator= (const FieldTypeOfValue& x);

    virtual
    ~FieldTypeOfValue ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< dataType_type > dataType_;
    ::xsd::cxx::tree::one< spatialType_type > spatialType_;
  };

  class LinkInClassMethod: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::pcrxml::Identifier name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // result
    //
    typedef ::pcrxml::FieldType result_type;
    typedef ::xsd::cxx::tree::sequence< result_type > result_sequence;
    typedef result_sequence::iterator result_iterator;
    typedef result_sequence::const_iterator result_const_iterator;
    typedef ::xsd::cxx::tree::traits< result_type, char > result_traits;

    const result_sequence&
    result () const;

    result_sequence&
    result ();

    void
    result (const result_sequence& s);

    // stringArgument
    //
    typedef ::pcrxml::SpaceTrimmedToken stringArgument_type;
    typedef ::xsd::cxx::tree::optional< stringArgument_type > stringArgument_optional;
    typedef ::xsd::cxx::tree::traits< stringArgument_type, char > stringArgument_traits;

    const stringArgument_optional&
    stringArgument () const;

    stringArgument_optional&
    stringArgument ();

    void
    stringArgument (const stringArgument_type& x);

    void
    stringArgument (const stringArgument_optional& x);

    void
    stringArgument (::std::unique_ptr< stringArgument_type > p);

    // argument
    //
    typedef ::pcrxml::FieldType argument_type;
    typedef ::xsd::cxx::tree::sequence< argument_type > argument_sequence;
    typedef argument_sequence::iterator argument_iterator;
    typedef argument_sequence::const_iterator argument_const_iterator;
    typedef ::xsd::cxx::tree::traits< argument_type, char > argument_traits;

    const argument_sequence&
    argument () const;

    argument_sequence&
    argument ();

    void
    argument (const argument_sequence& s);

    // Constructors.
    //
    LinkInClassMethod (const name_type&);

    LinkInClassMethod (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    LinkInClassMethod (const LinkInClassMethod& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual LinkInClassMethod*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInClassMethod&
    operator= (const LinkInClassMethod& x);

    virtual
    ~LinkInClassMethod ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
    result_sequence result_;
    stringArgument_optional stringArgument_;
    argument_sequence argument_;
  };

  class LinkInFunctionManifest: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::pcrxml::Identifier name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // result
    //
    typedef ::pcrxml::FieldType result_type;
    typedef ::xsd::cxx::tree::sequence< result_type > result_sequence;
    typedef result_sequence::iterator result_iterator;
    typedef result_sequence::const_iterator result_const_iterator;
    typedef ::xsd::cxx::tree::traits< result_type, char > result_traits;

    const result_sequence&
    result () const;

    result_sequence&
    result ();

    void
    result (const result_sequence& s);

    // stringArgument
    //
    typedef ::pcrxml::SpaceTrimmedToken stringArgument_type;
    typedef ::xsd::cxx::tree::optional< stringArgument_type > stringArgument_optional;
    typedef ::xsd::cxx::tree::traits< stringArgument_type, char > stringArgument_traits;

    const stringArgument_optional&
    stringArgument () const;

    stringArgument_optional&
    stringArgument ();

    void
    stringArgument (const stringArgument_type& x);

    void
    stringArgument (const stringArgument_optional& x);

    void
    stringArgument (::std::unique_ptr< stringArgument_type > p);

    // argument
    //
    typedef ::pcrxml::FieldType argument_type;
    typedef ::xsd::cxx::tree::sequence< argument_type > argument_sequence;
    typedef argument_sequence::iterator argument_iterator;
    typedef argument_sequence::const_iterator argument_const_iterator;
    typedef ::xsd::cxx::tree::traits< argument_type, char > argument_traits;

    const argument_sequence&
    argument () const;

    argument_sequence&
    argument ();

    void
    argument (const argument_sequence& s);

    // Constructors.
    //
    LinkInFunctionManifest (const name_type&);

    LinkInFunctionManifest (const ::xercesc::DOMElement& e,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    LinkInFunctionManifest (const LinkInFunctionManifest& x,
                            ::xml_schema::flags f = 0,
                            ::xml_schema::container* c = 0);

    virtual LinkInFunctionManifest*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInFunctionManifest&
    operator= (const LinkInFunctionManifest& x);

    virtual
    ~LinkInFunctionManifest ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
    result_sequence result_;
    stringArgument_optional stringArgument_;
    argument_sequence argument_;
  };

  class CallPoint: public ::xml_schema::type
  {
    public:
    // object
    //
    typedef ::pcrxml::object object_type;
    typedef ::xsd::cxx::tree::optional< object_type > object_optional;
    typedef ::xsd::cxx::tree::traits< object_type, char > object_traits;

    const object_optional&
    object () const;

    object_optional&
    object ();

    void
    object (const object_type& x);

    void
    object (const object_optional& x);

    void
    object (::std::unique_ptr< object_type > p);

    // function
    //
    typedef ::pcrxml::function function_type;
    typedef ::xsd::cxx::tree::optional< function_type > function_optional;
    typedef ::xsd::cxx::tree::traits< function_type, char > function_traits;

    const function_optional&
    function () const;

    function_optional&
    function ();

    void
    function (const function_type& x);

    void
    function (const function_optional& x);

    void
    function (::std::unique_ptr< function_type > p);

    // Constructors.
    //
    CallPoint ();

    CallPoint (const ::xercesc::DOMElement& e,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    CallPoint (const CallPoint& x,
               ::xml_schema::flags f = 0,
               ::xml_schema::container* c = 0);

    virtual CallPoint*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    CallPoint&
    operator= (const CallPoint& x);

    virtual
    ~CallPoint ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    object_optional object_;
    function_optional function_;
  };

  class LinkInCheckInput: public ::xml_schema::type
  {
    public:
    // context
    //
    typedef ::pcrxml::CheckContext context_type;
    typedef ::xsd::cxx::tree::traits< context_type, char > context_traits;

    const context_type&
    context () const;

    context_type&
    context ();

    void
    context (const context_type& x);

    void
    context (::std::unique_ptr< context_type > p);

    // callPoint
    //
    typedef ::pcrxml::CallPoint callPoint_type;
    typedef ::xsd::cxx::tree::traits< callPoint_type, char > callPoint_traits;

    const callPoint_type&
    callPoint () const;

    callPoint_type&
    callPoint ();

    void
    callPoint (const callPoint_type& x);

    void
    callPoint (::std::unique_ptr< callPoint_type > p);

    // result
    //
    typedef ::pcrxml::FieldType result_type;
    typedef ::xsd::cxx::tree::sequence< result_type > result_sequence;
    typedef result_sequence::iterator result_iterator;
    typedef result_sequence::const_iterator result_const_iterator;
    typedef ::xsd::cxx::tree::traits< result_type, char > result_traits;

    const result_sequence&
    result () const;

    result_sequence&
    result ();

    void
    result (const result_sequence& s);

    // stringArgument
    //
    typedef ::pcrxml::SpaceTrimmedToken stringArgument_type;
    typedef ::xsd::cxx::tree::optional< stringArgument_type > stringArgument_optional;
    typedef ::xsd::cxx::tree::traits< stringArgument_type, char > stringArgument_traits;

    const stringArgument_optional&
    stringArgument () const;

    stringArgument_optional&
    stringArgument ();

    void
    stringArgument (const stringArgument_type& x);

    void
    stringArgument (const stringArgument_optional& x);

    void
    stringArgument (::std::unique_ptr< stringArgument_type > p);

    // argument
    //
    typedef ::pcrxml::FieldType argument_type;
    typedef ::xsd::cxx::tree::sequence< argument_type > argument_sequence;
    typedef argument_sequence::iterator argument_iterator;
    typedef argument_sequence::const_iterator argument_const_iterator;
    typedef ::xsd::cxx::tree::traits< argument_type, char > argument_traits;

    const argument_sequence&
    argument () const;

    argument_sequence&
    argument ();

    void
    argument (const argument_sequence& s);

    // Constructors.
    //
    LinkInCheckInput (const context_type&,
                      const callPoint_type&);

    LinkInCheckInput (::std::unique_ptr< context_type >,
                      ::std::unique_ptr< callPoint_type >);

    LinkInCheckInput (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    LinkInCheckInput (const LinkInCheckInput& x,
                      ::xml_schema::flags f = 0,
                      ::xml_schema::container* c = 0);

    virtual LinkInCheckInput*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInCheckInput&
    operator= (const LinkInCheckInput& x);

    virtual
    ~LinkInCheckInput ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< context_type > context_;
    ::xsd::cxx::tree::one< callPoint_type > callPoint_;
    result_sequence result_;
    stringArgument_optional stringArgument_;
    argument_sequence argument_;
  };

  class LinkInCheckResult: public ::xml_schema::type
  {
    public:
    // error
    //
    typedef ::xml_schema::string error_type;
    typedef ::xsd::cxx::tree::optional< error_type > error_optional;
    typedef ::xsd::cxx::tree::traits< error_type, char > error_traits;

    const error_optional&
    error () const;

    error_optional&
    error ();

    void
    error (const error_type& x);

    void
    error (const error_optional& x);

    void
    error (::std::unique_ptr< error_type > p);

    // result
    //
    typedef ::pcrxml::FieldType result_type;
    typedef ::xsd::cxx::tree::sequence< result_type > result_sequence;
    typedef result_sequence::iterator result_iterator;
    typedef result_sequence::const_iterator result_const_iterator;
    typedef ::xsd::cxx::tree::traits< result_type, char > result_traits;

    const result_sequence&
    result () const;

    result_sequence&
    result ();

    void
    result (const result_sequence& s);

    // argument
    //
    typedef ::pcrxml::FieldType argument_type;
    typedef ::xsd::cxx::tree::sequence< argument_type > argument_sequence;
    typedef argument_sequence::iterator argument_iterator;
    typedef argument_sequence::const_iterator argument_const_iterator;
    typedef ::xsd::cxx::tree::traits< argument_type, char > argument_traits;

    const argument_sequence&
    argument () const;

    argument_sequence&
    argument ();

    void
    argument (const argument_sequence& s);

    // Constructors.
    //
    LinkInCheckResult ();

    LinkInCheckResult (const ::xercesc::DOMElement& e,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    LinkInCheckResult (const LinkInCheckResult& x,
                       ::xml_schema::flags f = 0,
                       ::xml_schema::container* c = 0);

    virtual LinkInCheckResult*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInCheckResult&
    operator= (const LinkInCheckResult& x);

    virtual
    ~LinkInCheckResult ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    error_optional error_;
    result_sequence result_;
    argument_sequence argument_;
  };

  class LinkInExecuteInput: public ::xml_schema::type
  {
    public:
    // context
    //
    typedef ::pcrxml::RunContext context_type;
    typedef ::xsd::cxx::tree::traits< context_type, char > context_traits;

    const context_type&
    context () const;

    context_type&
    context ();

    void
    context (const context_type& x);

    void
    context (::std::unique_ptr< context_type > p);

    // callPoint
    //
    typedef ::pcrxml::CallPoint callPoint_type;
    typedef ::xsd::cxx::tree::traits< callPoint_type, char > callPoint_traits;

    const callPoint_type&
    callPoint () const;

    callPoint_type&
    callPoint ();

    void
    callPoint (const callPoint_type& x);

    void
    callPoint (::std::unique_ptr< callPoint_type > p);

    // result
    //
    typedef ::pcrxml::FieldTypeOfValue result_type;
    typedef ::xsd::cxx::tree::sequence< result_type > result_sequence;
    typedef result_sequence::iterator result_iterator;
    typedef result_sequence::const_iterator result_const_iterator;
    typedef ::xsd::cxx::tree::traits< result_type, char > result_traits;

    const result_sequence&
    result () const;

    result_sequence&
    result ();

    void
    result (const result_sequence& s);

    // stringArgument
    //
    typedef ::pcrxml::SpaceTrimmedToken stringArgument_type;
    typedef ::xsd::cxx::tree::optional< stringArgument_type > stringArgument_optional;
    typedef ::xsd::cxx::tree::traits< stringArgument_type, char > stringArgument_traits;

    const stringArgument_optional&
    stringArgument () const;

    stringArgument_optional&
    stringArgument ();

    void
    stringArgument (const stringArgument_type& x);

    void
    stringArgument (const stringArgument_optional& x);

    void
    stringArgument (::std::unique_ptr< stringArgument_type > p);

    // argument
    //
    typedef ::pcrxml::FieldTypeOfValue argument_type;
    typedef ::xsd::cxx::tree::sequence< argument_type > argument_sequence;
    typedef argument_sequence::iterator argument_iterator;
    typedef argument_sequence::const_iterator argument_const_iterator;
    typedef ::xsd::cxx::tree::traits< argument_type, char > argument_traits;

    const argument_sequence&
    argument () const;

    argument_sequence&
    argument ();

    void
    argument (const argument_sequence& s);

    // Constructors.
    //
    LinkInExecuteInput (const context_type&,
                        const callPoint_type&);

    LinkInExecuteInput (::std::unique_ptr< context_type >,
                        ::std::unique_ptr< callPoint_type >);

    LinkInExecuteInput (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    LinkInExecuteInput (const LinkInExecuteInput& x,
                        ::xml_schema::flags f = 0,
                        ::xml_schema::container* c = 0);

    virtual LinkInExecuteInput*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInExecuteInput&
    operator= (const LinkInExecuteInput& x);

    virtual
    ~LinkInExecuteInput ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< context_type > context_;
    ::xsd::cxx::tree::one< callPoint_type > callPoint_;
    result_sequence result_;
    stringArgument_optional stringArgument_;
    argument_sequence argument_;
  };

  class LinkInExecuteResult: public ::xml_schema::type
  {
    public:
    // error
    //
    typedef ::xml_schema::string error_type;
    typedef ::xsd::cxx::tree::optional< error_type > error_optional;
    typedef ::xsd::cxx::tree::traits< error_type, char > error_traits;

    const error_optional&
    error () const;

    error_optional&
    error ();

    void
    error (const error_type& x);

    void
    error (const error_optional& x);

    void
    error (::std::unique_ptr< error_type > p);

    // Constructors.
    //
    LinkInExecuteResult ();

    LinkInExecuteResult (const ::xercesc::DOMElement& e,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    LinkInExecuteResult (const LinkInExecuteResult& x,
                         ::xml_schema::flags f = 0,
                         ::xml_schema::container* c = 0);

    virtual LinkInExecuteResult*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    LinkInExecuteResult&
    operator= (const LinkInExecuteResult& x);

    virtual
    ~LinkInExecuteResult ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    error_optional error_;
  };

  class object: public ::xml_schema::type
  {
    public:
    // className
    //
    typedef ::pcrxml::Identifier className_type;
    typedef ::xsd::cxx::tree::traits< className_type, char > className_traits;

    const className_type&
    className () const;

    className_type&
    className ();

    void
    className (const className_type& x);

    void
    className (::std::unique_ptr< className_type > p);

    // objectName
    //
    typedef ::pcrxml::Identifier objectName_type;
    typedef ::xsd::cxx::tree::traits< objectName_type, char > objectName_traits;

    const objectName_type&
    objectName () const;

    objectName_type&
    objectName ();

    void
    objectName (const objectName_type& x);

    void
    objectName (::std::unique_ptr< objectName_type > p);

    // constructor
    //
    typedef ::pcrxml::EmptyElement constructor_type;
    typedef ::xsd::cxx::tree::optional< constructor_type > constructor_optional;
    typedef ::xsd::cxx::tree::traits< constructor_type, char > constructor_traits;

    const constructor_optional&
    constructor () const;

    constructor_optional&
    constructor ();

    void
    constructor (const constructor_type& x);

    void
    constructor (const constructor_optional& x);

    void
    constructor (::std::unique_ptr< constructor_type > p);

    // methodName
    //
    typedef ::pcrxml::Identifier methodName_type;
    typedef ::xsd::cxx::tree::optional< methodName_type > methodName_optional;
    typedef ::xsd::cxx::tree::traits< methodName_type, char > methodName_traits;

    const methodName_optional&
    methodName () const;

    methodName_optional&
    methodName ();

    void
    methodName (const methodName_type& x);

    void
    methodName (const methodName_optional& x);

    void
    methodName (::std::unique_ptr< methodName_type > p);

    // Constructors.
    //
    object (const className_type&,
            const objectName_type&);

    object (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    object (const object& x,
            ::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0);

    virtual object*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    object&
    operator= (const object& x);

    virtual
    ~object ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< className_type > className_;
    ::xsd::cxx::tree::one< objectName_type > objectName_;
    constructor_optional constructor_;
    methodName_optional methodName_;
  };

  class function: public ::xml_schema::type
  {
    public:
    // name
    //
    typedef ::pcrxml::Identifier name_type;
    typedef ::xsd::cxx::tree::traits< name_type, char > name_traits;

    const name_type&
    name () const;

    name_type&
    name ();

    void
    name (const name_type& x);

    void
    name (::std::unique_ptr< name_type > p);

    // Constructors.
    //
    function (const name_type&);

    function (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    function (const function& x,
              ::xml_schema::flags f = 0,
              ::xml_schema::container* c = 0);

    virtual function*
    _clone (::xml_schema::flags f = 0,
            ::xml_schema::container* c = 0) const;

    function&
    operator= (const function& x);

    virtual
    ~function ();

    // Implementation.
    //
    protected:
    void
    parse (::xsd::cxx::xml::dom::parser< char >&,
           ::xml_schema::flags);

    protected:
    ::xsd::cxx::tree::one< name_type > name_;
  };
}

#include <iosfwd>

namespace pcrxml
{
  ::std::ostream&
  operator<< (::std::ostream&, SpatialType::value);

  ::std::ostream&
  operator<< (::std::ostream&, const SpatialType&);

  ::std::ostream&
  operator<< (::std::ostream&, const SpatialTypeOfValue&);

  ::std::ostream&
  operator<< (::std::ostream&, const MemoryExchange&);

  ::std::ostream&
  operator<< (::std::ostream&, const Exchange&);

  ::std::ostream&
  operator<< (::std::ostream&, const Description&);

  ::std::ostream&
  operator<< (::std::ostream&, ModelInputType::value);

  ::std::ostream&
  operator<< (::std::ostream&, const ModelInputType&);

  ::std::ostream&
  operator<< (::std::ostream&, ModelOutputType::value);

  ::std::ostream&
  operator<< (::std::ostream&, const ModelOutputType&);

  ::std::ostream&
  operator<< (::std::ostream&, const ModelExchange&);

  ::std::ostream&
  operator<< (::std::ostream&, const LookupColumn&);

  ::std::ostream&
  operator<< (::std::ostream&, const OutputMapFormat&);

  ::std::ostream&
  operator<< (::std::ostream&, CellCoordinate::value);

  ::std::ostream&
  operator<< (::std::ostream&, const CellCoordinate&);

  ::std::ostream&
  operator<< (::std::ostream&, DirectionalValueUnit::value);

  ::std::ostream&
  operator<< (::std::ostream&, const DirectionalValueUnit&);

  ::std::ostream&
  operator<< (::std::ostream&, LddCreateDemMethod::value);

  ::std::ostream&
  operator<< (::std::ostream&, const LddCreateDemMethod&);

  ::std::ostream&
  operator<< (::std::ostream&, DynamicWaveRoughness::value);

  ::std::ostream&
  operator<< (::std::ostream&, const DynamicWaveRoughness&);

  ::std::ostream&
  operator<< (::std::ostream&, const ExecutionOptions&);

  ::std::ostream&
  operator<< (::std::ostream&, const Script&);

  ::std::ostream&
  operator<< (::std::ostream&, const Model&);

  ::std::ostream&
  operator<< (::std::ostream&, const TextStatisticsSubject&);

  ::std::ostream&
  operator<< (::std::ostream&, const TextStatistics&);

  ::std::ostream&
  operator<< (::std::ostream&, const LookupRow&);

  ::std::ostream&
  operator<< (::std::ostream&, const Relation&);

  ::std::ostream&
  operator<< (::std::ostream&, ArrayDimensionDataType::value);

  ::std::ostream&
  operator<< (::std::ostream&, const ArrayDimensionDataType&);

  ::std::ostream&
  operator<< (::std::ostream&, ArrayValueDataType::value);

  ::std::ostream&
  operator<< (::std::ostream&, const ArrayValueDataType&);

  ::std::ostream&
  operator<< (::std::ostream&, const IndexedArray&);

  ::std::ostream&
  operator<< (::std::ostream&, const LookupTable&);

  ::std::ostream&
  operator<< (::std::ostream&, const FieldValueOrType&);

  ::std::ostream&
  operator<< (::std::ostream&, const Definition&);

  ::std::ostream&
  operator<< (::std::ostream&, const Boolean&);

  ::std::ostream&
  operator<< (::std::ostream&, const Nominal&);

  ::std::ostream&
  operator<< (::std::ostream&, const Ordinal&);

  ::std::ostream&
  operator<< (::std::ostream&, const Directional&);

  ::std::ostream&
  operator<< (::std::ostream&, const Ldd&);

  ::std::ostream&
  operator<< (::std::ostream&, const Scalar&);

  ::std::ostream&
  operator<< (::std::ostream&, const DataType&);

  ::std::ostream&
  operator<< (::std::ostream&, const DataTypeOfValue&);

  ::std::ostream&
  operator<< (::std::ostream&, const CoordinateMask&);

  ::std::ostream&
  operator<< (::std::ostream&, const AreaMap&);

  ::std::ostream&
  operator<< (::std::ostream&, const FieldReference&);

  ::std::ostream&
  operator<< (::std::ostream&, const AreaMapScript&);

  ::std::ostream&
  operator<< (::std::ostream&, MaskMapType::value);

  ::std::ostream&
  operator<< (::std::ostream&, const MaskMapType&);

  ::std::ostream&
  operator<< (::std::ostream&, const ComputationMaskByAreaMap&);

  ::std::ostream&
  operator<< (::std::ostream&, const ComputationMask&);

  ::std::ostream&
  operator<< (::std::ostream&, const TimerOfModel&);

  ::std::ostream&
  operator<< (::std::ostream&, const IntegerTimer&);

  ::std::ostream&
  operator<< (::std::ostream&, const TimerContext&);

  ::std::ostream&
  operator<< (::std::ostream&, const CheckContext&);

  ::std::ostream&
  operator<< (::std::ostream&, const RunContext&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInLibraryManifest&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInClassManifest&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInClassConstructor&);

  ::std::ostream&
  operator<< (::std::ostream&, const FieldType&);

  ::std::ostream&
  operator<< (::std::ostream&, const FieldTypeOfValue&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInClassMethod&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInFunctionManifest&);

  ::std::ostream&
  operator<< (::std::ostream&, const CallPoint&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInCheckInput&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInCheckResult&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInExecuteInput&);

  ::std::ostream&
  operator<< (::std::ostream&, const LinkInExecuteResult&);

  ::std::ostream&
  operator<< (::std::ostream&, const object&);

  ::std::ostream&
  operator<< (::std::ostream&, const function&);
}

#include <iosfwd>

#include <xercesc/sax/InputSource.hpp>
#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace pcrxml
{
  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::Script >
  script (const ::std::string& uri,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (const ::std::string& uri,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (const ::std::string& uri,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::Script >
  script (::std::istream& is,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::std::istream& is,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::std::istream& is,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::std::istream& is,
          const ::std::string& id,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::std::istream& is,
          const ::std::string& id,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::std::istream& is,
          const ::std::string& id,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::Script >
  script (::xercesc::InputSource& is,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::xercesc::InputSource& is,
          ::xml_schema::error_handler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::xercesc::InputSource& is,
          ::xercesc::DOMErrorHandler& eh,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::Script >
  script (const ::xercesc::DOMDocument& d,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Script >
  script (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
          ::xml_schema::flags f = 0,
          const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (const ::std::string& uri,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (const ::std::string& uri,
                         ::xml_schema::error_handler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (const ::std::string& uri,
                         ::xercesc::DOMErrorHandler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::std::istream& is,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::std::istream& is,
                         ::xml_schema::error_handler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::std::istream& is,
                         ::xercesc::DOMErrorHandler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::std::istream& is,
                         const ::std::string& id,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::std::istream& is,
                         const ::std::string& id,
                         ::xml_schema::error_handler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::std::istream& is,
                         const ::std::string& id,
                         ::xercesc::DOMErrorHandler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::xercesc::InputSource& is,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::xercesc::InputSource& is,
                         ::xml_schema::error_handler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::xercesc::InputSource& is,
                         ::xercesc::DOMErrorHandler& eh,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (const ::xercesc::DOMDocument& d,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInLibraryManifest >
  linkInLibraryManifest (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                         ::xml_schema::flags f = 0,
                         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (const ::std::string& uri,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (const ::std::string& uri,
                    ::xml_schema::error_handler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (const ::std::string& uri,
                    ::xercesc::DOMErrorHandler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::std::istream& is,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::std::istream& is,
                    ::xml_schema::error_handler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::std::istream& is,
                    ::xercesc::DOMErrorHandler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::std::istream& is,
                    const ::std::string& id,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::std::istream& is,
                    const ::std::string& id,
                    ::xml_schema::error_handler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::std::istream& is,
                    const ::std::string& id,
                    ::xercesc::DOMErrorHandler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::xercesc::InputSource& is,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::xercesc::InputSource& is,
                    ::xml_schema::error_handler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::xercesc::InputSource& is,
                    ::xercesc::DOMErrorHandler& eh,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (const ::xercesc::DOMDocument& d,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckInput >
  linkInCheckInput (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                    ::xml_schema::flags f = 0,
                    const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (const ::std::string& uri,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (const ::std::string& uri,
                     ::xml_schema::error_handler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (const ::std::string& uri,
                     ::xercesc::DOMErrorHandler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::std::istream& is,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::std::istream& is,
                     ::xml_schema::error_handler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::std::istream& is,
                     ::xercesc::DOMErrorHandler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::std::istream& is,
                     const ::std::string& id,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::std::istream& is,
                     const ::std::string& id,
                     ::xml_schema::error_handler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::std::istream& is,
                     const ::std::string& id,
                     ::xercesc::DOMErrorHandler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::xercesc::InputSource& is,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::xercesc::InputSource& is,
                     ::xml_schema::error_handler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::xercesc::InputSource& is,
                     ::xercesc::DOMErrorHandler& eh,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (const ::xercesc::DOMDocument& d,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInCheckResult >
  linkInCheckResult (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                     ::xml_schema::flags f = 0,
                     const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (const ::std::string& uri,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (const ::std::string& uri,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (const ::std::string& uri,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::std::istream& is,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::std::istream& is,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::std::istream& is,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::std::istream& is,
                      const ::std::string& id,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::std::istream& is,
                      const ::std::string& id,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::std::istream& is,
                      const ::std::string& id,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::xercesc::InputSource& is,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::xercesc::InputSource& is,
                      ::xml_schema::error_handler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::xercesc::InputSource& is,
                      ::xercesc::DOMErrorHandler& eh,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (const ::xercesc::DOMDocument& d,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteInput >
  linkInExecuteInput (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                      ::xml_schema::flags f = 0,
                      const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (const ::std::string& uri,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (const ::std::string& uri,
                       ::xml_schema::error_handler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (const ::std::string& uri,
                       ::xercesc::DOMErrorHandler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::std::istream& is,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::std::istream& is,
                       ::xml_schema::error_handler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::std::istream& is,
                       ::xercesc::DOMErrorHandler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::std::istream& is,
                       const ::std::string& id,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::std::istream& is,
                       const ::std::string& id,
                       ::xml_schema::error_handler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::std::istream& is,
                       const ::std::string& id,
                       ::xercesc::DOMErrorHandler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::xercesc::InputSource& is,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::xercesc::InputSource& is,
                       ::xml_schema::error_handler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::xercesc::InputSource& is,
                       ::xercesc::DOMErrorHandler& eh,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (const ::xercesc::DOMDocument& d,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::LinkInExecuteResult >
  linkInExecuteResult (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                       ::xml_schema::flags f = 0,
                       const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (const ::std::string& uri,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (const ::std::string& uri,
           ::xml_schema::error_handler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (const ::std::string& uri,
           ::xercesc::DOMErrorHandler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::std::istream& is,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::std::istream& is,
           ::xml_schema::error_handler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::std::istream& is,
           ::xercesc::DOMErrorHandler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::std::istream& is,
           const ::std::string& id,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::std::istream& is,
           const ::std::string& id,
           ::xml_schema::error_handler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::std::istream& is,
           const ::std::string& id,
           ::xercesc::DOMErrorHandler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::xercesc::InputSource& is,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::xercesc::InputSource& is,
           ::xml_schema::error_handler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::xercesc::InputSource& is,
           ::xercesc::DOMErrorHandler& eh,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (const ::xercesc::DOMDocument& d,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::AreaMap >
  areaMap (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
           ::xml_schema::flags f = 0,
           const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (const ::std::string& uri,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (const ::std::string& uri,
              ::xml_schema::error_handler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (const ::std::string& uri,
              ::xercesc::DOMErrorHandler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::std::istream& is,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::std::istream& is,
              ::xml_schema::error_handler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::std::istream& is,
              ::xercesc::DOMErrorHandler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::std::istream& is,
              const ::std::string& id,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::std::istream& is,
              const ::std::string& id,
              ::xml_schema::error_handler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::std::istream& is,
              const ::std::string& id,
              ::xercesc::DOMErrorHandler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::xercesc::InputSource& is,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::xercesc::InputSource& is,
              ::xml_schema::error_handler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::xercesc::InputSource& is,
              ::xercesc::DOMErrorHandler& eh,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (const ::xercesc::DOMDocument& d,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Definition >
  definition (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
              ::xml_schema::flags f = 0,
              const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::Model >
  model (const ::std::string& uri,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (const ::std::string& uri,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (const ::std::string& uri,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::Model >
  model (::std::istream& is,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::std::istream& is,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::std::istream& is,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::std::istream& is,
         const ::std::string& id,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::std::istream& is,
         const ::std::string& id,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::std::istream& is,
         const ::std::string& id,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::Model >
  model (::xercesc::InputSource& is,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::xercesc::InputSource& is,
         ::xml_schema::error_handler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::xercesc::InputSource& is,
         ::xercesc::DOMErrorHandler& eh,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::Model >
  model (const ::xercesc::DOMDocument& d,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::Model >
  model (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
         ::xml_schema::flags f = 0,
         const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse a URI or a local file.
  //

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (const ::std::string& uri,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (const ::std::string& uri,
                  ::xml_schema::error_handler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (const ::std::string& uri,
                  ::xercesc::DOMErrorHandler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse std::istream.
  //

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::std::istream& is,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::std::istream& is,
                  ::xml_schema::error_handler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::std::istream& is,
                  ::xercesc::DOMErrorHandler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::std::istream& is,
                  const ::std::string& id,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::std::istream& is,
                  const ::std::string& id,
                  ::xml_schema::error_handler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::std::istream& is,
                  const ::std::string& id,
                  ::xercesc::DOMErrorHandler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::InputSource.
  //

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::xercesc::InputSource& is,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::xercesc::InputSource& is,
                  ::xml_schema::error_handler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::xercesc::InputSource& is,
                  ::xercesc::DOMErrorHandler& eh,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  // Parse xercesc::DOMDocument.
  //

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (const ::xercesc::DOMDocument& d,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());

  ::std::unique_ptr< ::pcrxml::TextStatistics >
  textStatistics (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                  ::xml_schema::flags f = 0,
                  const ::xml_schema::properties& p = ::xml_schema::properties ());
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace pcrxml
{
  // Serialize to std::ostream.
  //

  void
  script (::std::ostream& os,
          const ::pcrxml::Script& x,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  script (::std::ostream& os,
          const ::pcrxml::Script& x,
          ::xml_schema::error_handler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  script (::std::ostream& os,
          const ::pcrxml::Script& x,
          ::xercesc::DOMErrorHandler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  script (::xercesc::XMLFormatTarget& ft,
          const ::pcrxml::Script& x,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  script (::xercesc::XMLFormatTarget& ft,
          const ::pcrxml::Script& x,
          ::xml_schema::error_handler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  void
  script (::xercesc::XMLFormatTarget& ft,
          const ::pcrxml::Script& x,
          ::xercesc::DOMErrorHandler& eh,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          const ::std::string& e = "UTF-8",
          ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  script (::xercesc::DOMDocument& d,
          const ::pcrxml::Script& x,
          ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  script (const ::pcrxml::Script& x,
          const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
          ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  linkInLibraryManifest (::std::ostream& os,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         const ::std::string& e = "UTF-8",
                         ::xml_schema::flags f = 0);

  void
  linkInLibraryManifest (::std::ostream& os,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         ::xml_schema::error_handler& eh,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         const ::std::string& e = "UTF-8",
                         ::xml_schema::flags f = 0);

  void
  linkInLibraryManifest (::std::ostream& os,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         ::xercesc::DOMErrorHandler& eh,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         const ::std::string& e = "UTF-8",
                         ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  linkInLibraryManifest (::xercesc::XMLFormatTarget& ft,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         const ::std::string& e = "UTF-8",
                         ::xml_schema::flags f = 0);

  void
  linkInLibraryManifest (::xercesc::XMLFormatTarget& ft,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         ::xml_schema::error_handler& eh,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         const ::std::string& e = "UTF-8",
                         ::xml_schema::flags f = 0);

  void
  linkInLibraryManifest (::xercesc::XMLFormatTarget& ft,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         ::xercesc::DOMErrorHandler& eh,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         const ::std::string& e = "UTF-8",
                         ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  linkInLibraryManifest (::xercesc::DOMDocument& d,
                         const ::pcrxml::LinkInLibraryManifest& x,
                         ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  linkInLibraryManifest (const ::pcrxml::LinkInLibraryManifest& x,
                         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                         ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  linkInCheckInput (::std::ostream& os,
                    const ::pcrxml::LinkInCheckInput& x,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    const ::std::string& e = "UTF-8",
                    ::xml_schema::flags f = 0);

  void
  linkInCheckInput (::std::ostream& os,
                    const ::pcrxml::LinkInCheckInput& x,
                    ::xml_schema::error_handler& eh,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    const ::std::string& e = "UTF-8",
                    ::xml_schema::flags f = 0);

  void
  linkInCheckInput (::std::ostream& os,
                    const ::pcrxml::LinkInCheckInput& x,
                    ::xercesc::DOMErrorHandler& eh,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    const ::std::string& e = "UTF-8",
                    ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  linkInCheckInput (::xercesc::XMLFormatTarget& ft,
                    const ::pcrxml::LinkInCheckInput& x,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    const ::std::string& e = "UTF-8",
                    ::xml_schema::flags f = 0);

  void
  linkInCheckInput (::xercesc::XMLFormatTarget& ft,
                    const ::pcrxml::LinkInCheckInput& x,
                    ::xml_schema::error_handler& eh,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    const ::std::string& e = "UTF-8",
                    ::xml_schema::flags f = 0);

  void
  linkInCheckInput (::xercesc::XMLFormatTarget& ft,
                    const ::pcrxml::LinkInCheckInput& x,
                    ::xercesc::DOMErrorHandler& eh,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    const ::std::string& e = "UTF-8",
                    ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  linkInCheckInput (::xercesc::DOMDocument& d,
                    const ::pcrxml::LinkInCheckInput& x,
                    ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  linkInCheckInput (const ::pcrxml::LinkInCheckInput& x,
                    const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                    ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  linkInCheckResult (::std::ostream& os,
                     const ::pcrxml::LinkInCheckResult& x,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     const ::std::string& e = "UTF-8",
                     ::xml_schema::flags f = 0);

  void
  linkInCheckResult (::std::ostream& os,
                     const ::pcrxml::LinkInCheckResult& x,
                     ::xml_schema::error_handler& eh,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     const ::std::string& e = "UTF-8",
                     ::xml_schema::flags f = 0);

  void
  linkInCheckResult (::std::ostream& os,
                     const ::pcrxml::LinkInCheckResult& x,
                     ::xercesc::DOMErrorHandler& eh,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     const ::std::string& e = "UTF-8",
                     ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  linkInCheckResult (::xercesc::XMLFormatTarget& ft,
                     const ::pcrxml::LinkInCheckResult& x,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     const ::std::string& e = "UTF-8",
                     ::xml_schema::flags f = 0);

  void
  linkInCheckResult (::xercesc::XMLFormatTarget& ft,
                     const ::pcrxml::LinkInCheckResult& x,
                     ::xml_schema::error_handler& eh,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     const ::std::string& e = "UTF-8",
                     ::xml_schema::flags f = 0);

  void
  linkInCheckResult (::xercesc::XMLFormatTarget& ft,
                     const ::pcrxml::LinkInCheckResult& x,
                     ::xercesc::DOMErrorHandler& eh,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     const ::std::string& e = "UTF-8",
                     ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  linkInCheckResult (::xercesc::DOMDocument& d,
                     const ::pcrxml::LinkInCheckResult& x,
                     ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  linkInCheckResult (const ::pcrxml::LinkInCheckResult& x,
                     const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                     ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  linkInExecuteInput (::std::ostream& os,
                      const ::pcrxml::LinkInExecuteInput& x,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  linkInExecuteInput (::std::ostream& os,
                      const ::pcrxml::LinkInExecuteInput& x,
                      ::xml_schema::error_handler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  linkInExecuteInput (::std::ostream& os,
                      const ::pcrxml::LinkInExecuteInput& x,
                      ::xercesc::DOMErrorHandler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  linkInExecuteInput (::xercesc::XMLFormatTarget& ft,
                      const ::pcrxml::LinkInExecuteInput& x,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  linkInExecuteInput (::xercesc::XMLFormatTarget& ft,
                      const ::pcrxml::LinkInExecuteInput& x,
                      ::xml_schema::error_handler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  void
  linkInExecuteInput (::xercesc::XMLFormatTarget& ft,
                      const ::pcrxml::LinkInExecuteInput& x,
                      ::xercesc::DOMErrorHandler& eh,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      const ::std::string& e = "UTF-8",
                      ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  linkInExecuteInput (::xercesc::DOMDocument& d,
                      const ::pcrxml::LinkInExecuteInput& x,
                      ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  linkInExecuteInput (const ::pcrxml::LinkInExecuteInput& x,
                      const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                      ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  linkInExecuteResult (::std::ostream& os,
                       const ::pcrxml::LinkInExecuteResult& x,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       const ::std::string& e = "UTF-8",
                       ::xml_schema::flags f = 0);

  void
  linkInExecuteResult (::std::ostream& os,
                       const ::pcrxml::LinkInExecuteResult& x,
                       ::xml_schema::error_handler& eh,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       const ::std::string& e = "UTF-8",
                       ::xml_schema::flags f = 0);

  void
  linkInExecuteResult (::std::ostream& os,
                       const ::pcrxml::LinkInExecuteResult& x,
                       ::xercesc::DOMErrorHandler& eh,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       const ::std::string& e = "UTF-8",
                       ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  linkInExecuteResult (::xercesc::XMLFormatTarget& ft,
                       const ::pcrxml::LinkInExecuteResult& x,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       const ::std::string& e = "UTF-8",
                       ::xml_schema::flags f = 0);

  void
  linkInExecuteResult (::xercesc::XMLFormatTarget& ft,
                       const ::pcrxml::LinkInExecuteResult& x,
                       ::xml_schema::error_handler& eh,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       const ::std::string& e = "UTF-8",
                       ::xml_schema::flags f = 0);

  void
  linkInExecuteResult (::xercesc::XMLFormatTarget& ft,
                       const ::pcrxml::LinkInExecuteResult& x,
                       ::xercesc::DOMErrorHandler& eh,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       const ::std::string& e = "UTF-8",
                       ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  linkInExecuteResult (::xercesc::DOMDocument& d,
                       const ::pcrxml::LinkInExecuteResult& x,
                       ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  linkInExecuteResult (const ::pcrxml::LinkInExecuteResult& x,
                       const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                       ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  areaMap (::std::ostream& os,
           const ::pcrxml::AreaMap& x,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           const ::std::string& e = "UTF-8",
           ::xml_schema::flags f = 0);

  void
  areaMap (::std::ostream& os,
           const ::pcrxml::AreaMap& x,
           ::xml_schema::error_handler& eh,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           const ::std::string& e = "UTF-8",
           ::xml_schema::flags f = 0);

  void
  areaMap (::std::ostream& os,
           const ::pcrxml::AreaMap& x,
           ::xercesc::DOMErrorHandler& eh,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           const ::std::string& e = "UTF-8",
           ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  areaMap (::xercesc::XMLFormatTarget& ft,
           const ::pcrxml::AreaMap& x,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           const ::std::string& e = "UTF-8",
           ::xml_schema::flags f = 0);

  void
  areaMap (::xercesc::XMLFormatTarget& ft,
           const ::pcrxml::AreaMap& x,
           ::xml_schema::error_handler& eh,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           const ::std::string& e = "UTF-8",
           ::xml_schema::flags f = 0);

  void
  areaMap (::xercesc::XMLFormatTarget& ft,
           const ::pcrxml::AreaMap& x,
           ::xercesc::DOMErrorHandler& eh,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           const ::std::string& e = "UTF-8",
           ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  areaMap (::xercesc::DOMDocument& d,
           const ::pcrxml::AreaMap& x,
           ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  areaMap (const ::pcrxml::AreaMap& x,
           const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
           ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  definition (::std::ostream& os,
              const ::pcrxml::Definition& x,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              const ::std::string& e = "UTF-8",
              ::xml_schema::flags f = 0);

  void
  definition (::std::ostream& os,
              const ::pcrxml::Definition& x,
              ::xml_schema::error_handler& eh,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              const ::std::string& e = "UTF-8",
              ::xml_schema::flags f = 0);

  void
  definition (::std::ostream& os,
              const ::pcrxml::Definition& x,
              ::xercesc::DOMErrorHandler& eh,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              const ::std::string& e = "UTF-8",
              ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  definition (::xercesc::XMLFormatTarget& ft,
              const ::pcrxml::Definition& x,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              const ::std::string& e = "UTF-8",
              ::xml_schema::flags f = 0);

  void
  definition (::xercesc::XMLFormatTarget& ft,
              const ::pcrxml::Definition& x,
              ::xml_schema::error_handler& eh,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              const ::std::string& e = "UTF-8",
              ::xml_schema::flags f = 0);

  void
  definition (::xercesc::XMLFormatTarget& ft,
              const ::pcrxml::Definition& x,
              ::xercesc::DOMErrorHandler& eh,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              const ::std::string& e = "UTF-8",
              ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  definition (::xercesc::DOMDocument& d,
              const ::pcrxml::Definition& x,
              ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  definition (const ::pcrxml::Definition& x,
              const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
              ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  model (::std::ostream& os,
         const ::pcrxml::Model& x,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         const ::std::string& e = "UTF-8",
         ::xml_schema::flags f = 0);

  void
  model (::std::ostream& os,
         const ::pcrxml::Model& x,
         ::xml_schema::error_handler& eh,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         const ::std::string& e = "UTF-8",
         ::xml_schema::flags f = 0);

  void
  model (::std::ostream& os,
         const ::pcrxml::Model& x,
         ::xercesc::DOMErrorHandler& eh,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         const ::std::string& e = "UTF-8",
         ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  model (::xercesc::XMLFormatTarget& ft,
         const ::pcrxml::Model& x,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         const ::std::string& e = "UTF-8",
         ::xml_schema::flags f = 0);

  void
  model (::xercesc::XMLFormatTarget& ft,
         const ::pcrxml::Model& x,
         ::xml_schema::error_handler& eh,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         const ::std::string& e = "UTF-8",
         ::xml_schema::flags f = 0);

  void
  model (::xercesc::XMLFormatTarget& ft,
         const ::pcrxml::Model& x,
         ::xercesc::DOMErrorHandler& eh,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         const ::std::string& e = "UTF-8",
         ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  model (::xercesc::DOMDocument& d,
         const ::pcrxml::Model& x,
         ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  model (const ::pcrxml::Model& x,
         const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
         ::xml_schema::flags f = 0);

  // Serialize to std::ostream.
  //

  void
  textStatistics (::std::ostream& os,
                  const ::pcrxml::TextStatistics& x,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  const ::std::string& e = "UTF-8",
                  ::xml_schema::flags f = 0);

  void
  textStatistics (::std::ostream& os,
                  const ::pcrxml::TextStatistics& x,
                  ::xml_schema::error_handler& eh,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  const ::std::string& e = "UTF-8",
                  ::xml_schema::flags f = 0);

  void
  textStatistics (::std::ostream& os,
                  const ::pcrxml::TextStatistics& x,
                  ::xercesc::DOMErrorHandler& eh,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  const ::std::string& e = "UTF-8",
                  ::xml_schema::flags f = 0);

  // Serialize to xercesc::XMLFormatTarget.
  //

  void
  textStatistics (::xercesc::XMLFormatTarget& ft,
                  const ::pcrxml::TextStatistics& x,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  const ::std::string& e = "UTF-8",
                  ::xml_schema::flags f = 0);

  void
  textStatistics (::xercesc::XMLFormatTarget& ft,
                  const ::pcrxml::TextStatistics& x,
                  ::xml_schema::error_handler& eh,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  const ::std::string& e = "UTF-8",
                  ::xml_schema::flags f = 0);

  void
  textStatistics (::xercesc::XMLFormatTarget& ft,
                  const ::pcrxml::TextStatistics& x,
                  ::xercesc::DOMErrorHandler& eh,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  const ::std::string& e = "UTF-8",
                  ::xml_schema::flags f = 0);

  // Serialize to an existing xercesc::DOMDocument.
  //

  void
  textStatistics (::xercesc::DOMDocument& d,
                  const ::pcrxml::TextStatistics& x,
                  ::xml_schema::flags f = 0);

  // Serialize to a new xercesc::DOMDocument.
  //

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  textStatistics (const ::pcrxml::TextStatistics& x,
                  const ::xml_schema::namespace_infomap& m = ::xml_schema::namespace_infomap (),
                  ::xml_schema::flags f = 0);

  void
  operator<< (::xercesc::DOMElement&, const SpatialType&);

  void
  operator<< (::xercesc::DOMAttr&, const SpatialType&);

  void
  operator<< (::xml_schema::list_stream&,
              const SpatialType&);

  void
  operator<< (::xercesc::DOMElement&, const SpatialTypeOfValue&);

  void
  operator<< (::xercesc::DOMAttr&, const SpatialTypeOfValue&);

  void
  operator<< (::xml_schema::list_stream&,
              const SpatialTypeOfValue&);

  void
  operator<< (::xercesc::DOMElement&, const MemoryExchange&);

  void
  operator<< (::xercesc::DOMAttr&, const MemoryExchange&);

  void
  operator<< (::xml_schema::list_stream&,
              const MemoryExchange&);

  void
  operator<< (::xercesc::DOMElement&, const Exchange&);

  void
  operator<< (::xercesc::DOMElement&, const Description&);

  void
  operator<< (::xercesc::DOMElement&, const ModelInputType&);

  void
  operator<< (::xercesc::DOMAttr&, const ModelInputType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ModelInputType&);

  void
  operator<< (::xercesc::DOMElement&, const ModelOutputType&);

  void
  operator<< (::xercesc::DOMAttr&, const ModelOutputType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ModelOutputType&);

  void
  operator<< (::xercesc::DOMElement&, const ModelExchange&);

  void
  operator<< (::xercesc::DOMElement&, const LookupColumn&);

  void
  operator<< (::xercesc::DOMAttr&, const LookupColumn&);

  void
  operator<< (::xml_schema::list_stream&,
              const LookupColumn&);

  void
  operator<< (::xercesc::DOMElement&, const OutputMapFormat&);

  void
  operator<< (::xercesc::DOMElement&, const CellCoordinate&);

  void
  operator<< (::xercesc::DOMAttr&, const CellCoordinate&);

  void
  operator<< (::xml_schema::list_stream&,
              const CellCoordinate&);

  void
  operator<< (::xercesc::DOMElement&, const DirectionalValueUnit&);

  void
  operator<< (::xercesc::DOMAttr&, const DirectionalValueUnit&);

  void
  operator<< (::xml_schema::list_stream&,
              const DirectionalValueUnit&);

  void
  operator<< (::xercesc::DOMElement&, const LddCreateDemMethod&);

  void
  operator<< (::xercesc::DOMAttr&, const LddCreateDemMethod&);

  void
  operator<< (::xml_schema::list_stream&,
              const LddCreateDemMethod&);

  void
  operator<< (::xercesc::DOMElement&, const DynamicWaveRoughness&);

  void
  operator<< (::xercesc::DOMAttr&, const DynamicWaveRoughness&);

  void
  operator<< (::xml_schema::list_stream&,
              const DynamicWaveRoughness&);

  void
  operator<< (::xercesc::DOMElement&, const ExecutionOptions&);

  void
  operator<< (::xercesc::DOMElement&, const Script&);

  void
  operator<< (::xercesc::DOMElement&, const Model&);

  void
  operator<< (::xercesc::DOMElement&, const TextStatisticsSubject&);

  void
  operator<< (::xercesc::DOMElement&, const TextStatistics&);

  void
  operator<< (::xercesc::DOMElement&, const LookupRow&);

  void
  operator<< (::xercesc::DOMElement&, const Relation&);

  void
  operator<< (::xercesc::DOMElement&, const ArrayDimensionDataType&);

  void
  operator<< (::xercesc::DOMAttr&, const ArrayDimensionDataType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ArrayDimensionDataType&);

  void
  operator<< (::xercesc::DOMElement&, const ArrayValueDataType&);

  void
  operator<< (::xercesc::DOMAttr&, const ArrayValueDataType&);

  void
  operator<< (::xml_schema::list_stream&,
              const ArrayValueDataType&);

  void
  operator<< (::xercesc::DOMElement&, const IndexedArray&);

  void
  operator<< (::xercesc::DOMElement&, const LookupTable&);

  void
  operator<< (::xercesc::DOMElement&, const FieldValueOrType&);

  void
  operator<< (::xercesc::DOMElement&, const Definition&);

  void
  operator<< (::xercesc::DOMElement&, const Boolean&);

  void
  operator<< (::xercesc::DOMAttr&, const Boolean&);

  void
  operator<< (::xml_schema::list_stream&,
              const Boolean&);

  void
  operator<< (::xercesc::DOMElement&, const Nominal&);

  void
  operator<< (::xercesc::DOMAttr&, const Nominal&);

  void
  operator<< (::xml_schema::list_stream&,
              const Nominal&);

  void
  operator<< (::xercesc::DOMElement&, const Ordinal&);

  void
  operator<< (::xercesc::DOMAttr&, const Ordinal&);

  void
  operator<< (::xml_schema::list_stream&,
              const Ordinal&);

  void
  operator<< (::xercesc::DOMElement&, const Directional&);

  void
  operator<< (::xercesc::DOMAttr&, const Directional&);

  void
  operator<< (::xml_schema::list_stream&,
              const Directional&);

  void
  operator<< (::xercesc::DOMElement&, const Ldd&);

  void
  operator<< (::xercesc::DOMAttr&, const Ldd&);

  void
  operator<< (::xml_schema::list_stream&,
              const Ldd&);

  void
  operator<< (::xercesc::DOMElement&, const Scalar&);

  void
  operator<< (::xercesc::DOMElement&, const DataType&);

  void
  operator<< (::xercesc::DOMElement&, const DataTypeOfValue&);

  void
  operator<< (::xercesc::DOMElement&, const CoordinateMask&);

  void
  operator<< (::xercesc::DOMElement&, const AreaMap&);

  void
  operator<< (::xercesc::DOMElement&, const FieldReference&);

  void
  operator<< (::xercesc::DOMElement&, const AreaMapScript&);

  void
  operator<< (::xercesc::DOMElement&, const MaskMapType&);

  void
  operator<< (::xercesc::DOMAttr&, const MaskMapType&);

  void
  operator<< (::xml_schema::list_stream&,
              const MaskMapType&);

  void
  operator<< (::xercesc::DOMElement&, const ComputationMaskByAreaMap&);

  void
  operator<< (::xercesc::DOMElement&, const ComputationMask&);

  void
  operator<< (::xercesc::DOMElement&, const TimerOfModel&);

  void
  operator<< (::xercesc::DOMElement&, const IntegerTimer&);

  void
  operator<< (::xercesc::DOMElement&, const TimerContext&);

  void
  operator<< (::xercesc::DOMElement&, const CheckContext&);

  void
  operator<< (::xercesc::DOMElement&, const RunContext&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInLibraryManifest&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInClassManifest&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInClassConstructor&);

  void
  operator<< (::xercesc::DOMElement&, const FieldType&);

  void
  operator<< (::xercesc::DOMElement&, const FieldTypeOfValue&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInClassMethod&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInFunctionManifest&);

  void
  operator<< (::xercesc::DOMElement&, const CallPoint&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInCheckInput&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInCheckResult&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInExecuteInput&);

  void
  operator<< (::xercesc::DOMElement&, const LinkInExecuteResult&);

  void
  operator<< (::xercesc::DOMElement&, const object&);

  void
  operator<< (::xercesc::DOMElement&, const function&);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
#ifndef INCLUDED_SSTREAM
#include <sstream>
#define INCLUDED_SSTREAM
#endif
#ifndef INCLUDED_STRING
#include <string>
#define INCLUDED_STRING
#endif
#ifndef INCLUDED_PCRXSD_SUPPORTEDSCHEMA
#include "pcrxsd_supportedschema.h"
#define INCLUDED_PCRXSD_SUPPORTEDSCHEMA
#endif
namespace pcrxsd {
  inline xml_schema::namespace_infomap namespaceInfoMap(
      const char* schemaSystemId) {

    // should know schema
    assert(SupportedSchema::findBySystemId(schemaSystemId));

    xml_schema::namespace_infomap map;
    map["pcr"].name = "http://www.pcraster.nl/pcrxml";
    map["pcr"].schema = schemaSystemId;

    return map;
   }

  //! convert an xs:string type to std::string
  /*!
     It is a template version because I have no clue what the actual
     type is :-)
   */
  template<typename T>
   inline std::string toString(
       T const& xsStringTypeValue)
  {
      std::ostringstream s;
      s << xsStringTypeValue;
      return s.str();
  }

//! function template to cast types derived from xsd fundamental types
/*!
 * suppress gcc warnings like:
 * \verbatim
 *  choosing 'xsd::cxx::tree::fundamental_base<X>::operator X&() [with X = unsigned int]' over 'xsd::cxx::tree::fundamental_base<X>::operator Y() const [with Y = unsigned int, X = unsigned int]'
 *    for conversion from 'pcrxml::Non0UnsignedInt' to 'unsigned int'
 *    because conversion sequence for the argument is better
 * \endverbatim
 *
 * generated from types derived from fundamental types like:
 * \verbatim
 * <xs:simpleType name="Non0UnsignedInt">
 *  <xs:restriction base="xs:unsignedInt">
 *    <xs:minInclusive value="1"/>
 *     </xs:restriction>
 *     </xs:simpleType>
 * \endverbatim
 *
 * solution is inspired by xsd/examples/cxx/tree/library/library.cxx
 *
 * MSVC-8.0 does not compile the solution, but also does not complain about
 * this issue. Hence, for MSVC this function is a NO-OP
 *
 * the macro (NOT USED)
 * #define XSD_CAST(type,value) \
 * (static_cast< ::xsd::cxx::tree::fundamental_base< type > const& >(value))
 */
template<
  typename T,
  typename V>
inline T fundamentalBaseCast(V value) {
#ifdef _MSC_VER
   return value;
#else
   return value;
//   return static_cast< ::xsd::cxx::tree::fundamental_base<T> const& >(value);
#endif
  }
}
//
// End epilogue.

#endif // PCRASTER_XSD_H
