// Copyright (c) 2005-2017 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "commonTypesXSD.h"

namespace pcrxml
{
  // Non0UnsignedInt
  // 


  // EmptyElement
  // 


  // TimeDuration
  // 

  const TimeDuration::hours_optional& TimeDuration::
  hours () const
  {
    return this->hours_;
  }

  TimeDuration::hours_optional& TimeDuration::
  hours ()
  {
    return this->hours_;
  }

  void TimeDuration::
  hours (const hours_type& x)
  {
    this->hours_.set (x);
  }

  void TimeDuration::
  hours (const hours_optional& x)
  {
    this->hours_ = x;
  }

  const TimeDuration::minutes_optional& TimeDuration::
  minutes () const
  {
    return this->minutes_;
  }

  TimeDuration::minutes_optional& TimeDuration::
  minutes ()
  {
    return this->minutes_;
  }

  void TimeDuration::
  minutes (const minutes_type& x)
  {
    this->minutes_.set (x);
  }

  void TimeDuration::
  minutes (const minutes_optional& x)
  {
    this->minutes_ = x;
  }

  const TimeDuration::seconds_optional& TimeDuration::
  seconds () const
  {
    return this->seconds_;
  }

  TimeDuration::seconds_optional& TimeDuration::
  seconds ()
  {
    return this->seconds_;
  }

  void TimeDuration::
  seconds (const seconds_type& x)
  {
    this->seconds_.set (x);
  }

  void TimeDuration::
  seconds (const seconds_optional& x)
  {
    this->seconds_ = x;
  }


  // OneBasedIntegerSet
  // 

  const OneBasedIntegerSet::item_sequence& OneBasedIntegerSet::
  item () const
  {
    return this->item_;
  }

  OneBasedIntegerSet::item_sequence& OneBasedIntegerSet::
  item ()
  {
    return this->item_;
  }

  void OneBasedIntegerSet::
  item (const item_sequence& s)
  {
    this->item_ = s;
  }


  // OneBasedIntegerRange
  // 

  const OneBasedIntegerRange::begin_type& OneBasedIntegerRange::
  begin () const
  {
    return this->begin_.get ();
  }

  OneBasedIntegerRange::begin_type& OneBasedIntegerRange::
  begin ()
  {
    return this->begin_.get ();
  }

  void OneBasedIntegerRange::
  begin (const begin_type& x)
  {
    this->begin_.set (x);
  }

  void OneBasedIntegerRange::
  begin (::std::unique_ptr< begin_type > x)
  {
    this->begin_.set (std::move (x));
  }

  const OneBasedIntegerRange::end_type& OneBasedIntegerRange::
  end () const
  {
    return this->end_.get ();
  }

  OneBasedIntegerRange::end_type& OneBasedIntegerRange::
  end ()
  {
    return this->end_.get ();
  }

  void OneBasedIntegerRange::
  end (const end_type& x)
  {
    this->end_.set (x);
  }

  void OneBasedIntegerRange::
  end (::std::unique_ptr< end_type > x)
  {
    this->end_.set (std::move (x));
  }

  const OneBasedIntegerRange::increment_type& OneBasedIntegerRange::
  increment () const
  {
    return this->increment_.get ();
  }

  OneBasedIntegerRange::increment_type& OneBasedIntegerRange::
  increment ()
  {
    return this->increment_.get ();
  }

  void OneBasedIntegerRange::
  increment (const increment_type& x)
  {
    this->increment_.set (x);
  }

  void OneBasedIntegerRange::
  increment (::std::unique_ptr< increment_type > x)
  {
    this->increment_.set (std::move (x));
  }


  // OneBasedIntegerRangeOrSet
  // 

  const OneBasedIntegerRangeOrSet::range_optional& OneBasedIntegerRangeOrSet::
  range () const
  {
    return this->range_;
  }

  OneBasedIntegerRangeOrSet::range_optional& OneBasedIntegerRangeOrSet::
  range ()
  {
    return this->range_;
  }

  void OneBasedIntegerRangeOrSet::
  range (const range_type& x)
  {
    this->range_.set (x);
  }

  void OneBasedIntegerRangeOrSet::
  range (const range_optional& x)
  {
    this->range_ = x;
  }

  void OneBasedIntegerRangeOrSet::
  range (::std::unique_ptr< range_type > x)
  {
    this->range_.set (std::move (x));
  }

  const OneBasedIntegerRangeOrSet::set_optional& OneBasedIntegerRangeOrSet::
  set () const
  {
    return this->set_;
  }

  OneBasedIntegerRangeOrSet::set_optional& OneBasedIntegerRangeOrSet::
  set ()
  {
    return this->set_;
  }

  void OneBasedIntegerRangeOrSet::
  set (const set_type& x)
  {
    this->set_.set (x);
  }

  void OneBasedIntegerRangeOrSet::
  set (const set_optional& x)
  {
    this->set_ = x;
  }

  void OneBasedIntegerRangeOrSet::
  set (::std::unique_ptr< set_type > x)
  {
    this->set_.set (std::move (x));
  }


  // StringSet
  // 

  const StringSet::item_sequence& StringSet::
  item () const
  {
    return this->item_;
  }

  StringSet::item_sequence& StringSet::
  item ()
  {
    return this->item_;
  }

  void StringSet::
  item (const item_sequence& s)
  {
    this->item_ = s;
  }


  // FloatSet
  // 

  const FloatSet::item_sequence& FloatSet::
  item () const
  {
    return this->item_;
  }

  FloatSet::item_sequence& FloatSet::
  item ()
  {
    return this->item_;
  }

  void FloatSet::
  item (const item_sequence& s)
  {
    this->item_ = s;
  }


  // FloatRange
  // 

  const FloatRange::begin_type& FloatRange::
  begin () const
  {
    return this->begin_.get ();
  }

  FloatRange::begin_type& FloatRange::
  begin ()
  {
    return this->begin_.get ();
  }

  void FloatRange::
  begin (const begin_type& x)
  {
    this->begin_.set (x);
  }

  const FloatRange::end_type& FloatRange::
  end () const
  {
    return this->end_.get ();
  }

  FloatRange::end_type& FloatRange::
  end ()
  {
    return this->end_.get ();
  }

  void FloatRange::
  end (const end_type& x)
  {
    this->end_.set (x);
  }

  const FloatRange::increment_type& FloatRange::
  increment () const
  {
    return this->increment_.get ();
  }

  FloatRange::increment_type& FloatRange::
  increment ()
  {
    return this->increment_.get ();
  }

  void FloatRange::
  increment (const increment_type& x)
  {
    this->increment_.set (x);
  }


  // FloatRangeOrSet
  // 

  const FloatRangeOrSet::range_optional& FloatRangeOrSet::
  range () const
  {
    return this->range_;
  }

  FloatRangeOrSet::range_optional& FloatRangeOrSet::
  range ()
  {
    return this->range_;
  }

  void FloatRangeOrSet::
  range (const range_type& x)
  {
    this->range_.set (x);
  }

  void FloatRangeOrSet::
  range (const range_optional& x)
  {
    this->range_ = x;
  }

  void FloatRangeOrSet::
  range (::std::unique_ptr< range_type > x)
  {
    this->range_.set (std::move (x));
  }

  const FloatRangeOrSet::set_optional& FloatRangeOrSet::
  set () const
  {
    return this->set_;
  }

  FloatRangeOrSet::set_optional& FloatRangeOrSet::
  set ()
  {
    return this->set_;
  }

  void FloatRangeOrSet::
  set (const set_type& x)
  {
    this->set_.set (x);
  }

  void FloatRangeOrSet::
  set (const set_optional& x)
  {
    this->set_ = x;
  }

  void FloatRangeOrSet::
  set (::std::unique_ptr< set_type > x)
  {
    this->set_.set (std::move (x));
  }


  // NrRowsNrCols
  // 

  const NrRowsNrCols::nrRows_type& NrRowsNrCols::
  nrRows () const
  {
    return this->nrRows_.get ();
  }

  NrRowsNrCols::nrRows_type& NrRowsNrCols::
  nrRows ()
  {
    return this->nrRows_.get ();
  }

  void NrRowsNrCols::
  nrRows (const nrRows_type& x)
  {
    this->nrRows_.set (x);
  }

  void NrRowsNrCols::
  nrRows (::std::unique_ptr< nrRows_type > x)
  {
    this->nrRows_.set (std::move (x));
  }

  const NrRowsNrCols::nrCols_type& NrRowsNrCols::
  nrCols () const
  {
    return this->nrCols_.get ();
  }

  NrRowsNrCols::nrCols_type& NrRowsNrCols::
  nrCols ()
  {
    return this->nrCols_.get ();
  }

  void NrRowsNrCols::
  nrCols (const nrCols_type& x)
  {
    this->nrCols_.set (x);
  }

  void NrRowsNrCols::
  nrCols (::std::unique_ptr< nrCols_type > x)
  {
    this->nrCols_.set (std::move (x));
  }


  // SpaceTrimmedToken
  // 


  // Identifier
  // 
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

namespace pcrxml
{
  // Non0UnsignedInt
  //

  Non0UnsignedInt::
  Non0UnsignedInt (const ::xml_schema::unsigned_int& _xsd_unsigned_int_base)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (_xsd_unsigned_int_base)
  {
  }

  Non0UnsignedInt::
  Non0UnsignedInt (const Non0UnsignedInt& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  Non0UnsignedInt::
  Non0UnsignedInt (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  Non0UnsignedInt::
  Non0UnsignedInt (const ::xercesc::DOMAttr& a,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  Non0UnsignedInt::
  Non0UnsignedInt (const ::std::string& s,
                   const ::xercesc::DOMElement* e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  Non0UnsignedInt* Non0UnsignedInt::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Non0UnsignedInt (*this, f, c);
  }

  Non0UnsignedInt::
  ~Non0UnsignedInt ()
  {
  }

  // EmptyElement
  //

  EmptyElement::
  EmptyElement ()
  : ::xml_schema::type ()
  {
  }

  EmptyElement::
  EmptyElement (const EmptyElement& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c)
  {
  }

  EmptyElement::
  EmptyElement (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (e, f, c)
  {
  }

  EmptyElement::
  EmptyElement (const ::xercesc::DOMAttr& a,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (a, f, c)
  {
  }

  EmptyElement::
  EmptyElement (const ::std::string& s,
                const ::xercesc::DOMElement* e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (s, e, f, c)
  {
  }

  EmptyElement* EmptyElement::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class EmptyElement (*this, f, c);
  }

  EmptyElement::
  ~EmptyElement ()
  {
  }

  // TimeDuration
  //

  TimeDuration::
  TimeDuration ()
  : ::xml_schema::type (),
    hours_ (this),
    minutes_ (this),
    seconds_ (this)
  {
  }

  TimeDuration::
  TimeDuration (const TimeDuration& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    hours_ (x.hours_, f, this),
    minutes_ (x.minutes_, f, this),
    seconds_ (x.seconds_, f, this)
  {
  }

  TimeDuration::
  TimeDuration (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    hours_ (this),
    minutes_ (this),
    seconds_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void TimeDuration::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // hours
      //
      if (n.name () == "hours" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->hours_)
        {
          this->hours_.set (hours_traits::create (i, f, this));
          continue;
        }
      }

      // minutes
      //
      if (n.name () == "minutes" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->minutes_)
        {
          this->minutes_.set (minutes_traits::create (i, f, this));
          continue;
        }
      }

      // seconds
      //
      if (n.name () == "seconds" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!this->seconds_)
        {
          this->seconds_.set (seconds_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }
  }

  TimeDuration* TimeDuration::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class TimeDuration (*this, f, c);
  }

  TimeDuration& TimeDuration::
  operator= (const TimeDuration& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->hours_ = x.hours_;
      this->minutes_ = x.minutes_;
      this->seconds_ = x.seconds_;
    }

    return *this;
  }

  TimeDuration::
  ~TimeDuration ()
  {
  }

  // OneBasedIntegerSet
  //

  OneBasedIntegerSet::
  OneBasedIntegerSet ()
  : ::xml_schema::type (),
    item_ (this)
  {
  }

  OneBasedIntegerSet::
  OneBasedIntegerSet (const OneBasedIntegerSet& x,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    item_ (x.item_, f, this)
  {
  }

  OneBasedIntegerSet::
  OneBasedIntegerSet (const ::xercesc::DOMElement& e,
                      ::xml_schema::flags f,
                      ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    item_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void OneBasedIntegerSet::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // item
      //
      if (n.name () == "item" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< item_type > r (
          item_traits::create (i, f, this));

        this->item_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  OneBasedIntegerSet* OneBasedIntegerSet::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class OneBasedIntegerSet (*this, f, c);
  }

  OneBasedIntegerSet& OneBasedIntegerSet::
  operator= (const OneBasedIntegerSet& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->item_ = x.item_;
    }

    return *this;
  }

  OneBasedIntegerSet::
  ~OneBasedIntegerSet ()
  {
  }

  // OneBasedIntegerRange
  //

  OneBasedIntegerRange::
  OneBasedIntegerRange (const begin_type& begin,
                        const end_type& end,
                        const increment_type& increment)
  : ::xml_schema::type (),
    begin_ (begin, this),
    end_ (end, this),
    increment_ (increment, this)
  {
  }

  OneBasedIntegerRange::
  OneBasedIntegerRange (const OneBasedIntegerRange& x,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    begin_ (x.begin_, f, this),
    end_ (x.end_, f, this),
    increment_ (x.increment_, f, this)
  {
  }

  OneBasedIntegerRange::
  OneBasedIntegerRange (const ::xercesc::DOMElement& e,
                        ::xml_schema::flags f,
                        ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    begin_ (this),
    end_ (this),
    increment_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void OneBasedIntegerRange::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // begin
      //
      if (n.name () == "begin" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< begin_type > r (
          begin_traits::create (i, f, this));

        if (!begin_.present ())
        {
          this->begin_.set (::std::move (r));
          continue;
        }
      }

      // end
      //
      if (n.name () == "end" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< end_type > r (
          end_traits::create (i, f, this));

        if (!end_.present ())
        {
          this->end_.set (::std::move (r));
          continue;
        }
      }

      // increment
      //
      if (n.name () == "increment" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< increment_type > r (
          increment_traits::create (i, f, this));

        if (!increment_.present ())
        {
          this->increment_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!begin_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "begin",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!end_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "end",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!increment_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "increment",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  OneBasedIntegerRange* OneBasedIntegerRange::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class OneBasedIntegerRange (*this, f, c);
  }

  OneBasedIntegerRange& OneBasedIntegerRange::
  operator= (const OneBasedIntegerRange& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->begin_ = x.begin_;
      this->end_ = x.end_;
      this->increment_ = x.increment_;
    }

    return *this;
  }

  OneBasedIntegerRange::
  ~OneBasedIntegerRange ()
  {
  }

  // OneBasedIntegerRangeOrSet
  //

  OneBasedIntegerRangeOrSet::
  OneBasedIntegerRangeOrSet ()
  : ::xml_schema::type (),
    range_ (this),
    set_ (this)
  {
  }

  OneBasedIntegerRangeOrSet::
  OneBasedIntegerRangeOrSet (const OneBasedIntegerRangeOrSet& x,
                             ::xml_schema::flags f,
                             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    range_ (x.range_, f, this),
    set_ (x.set_, f, this)
  {
  }

  OneBasedIntegerRangeOrSet::
  OneBasedIntegerRangeOrSet (const ::xercesc::DOMElement& e,
                             ::xml_schema::flags f,
                             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    range_ (this),
    set_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void OneBasedIntegerRangeOrSet::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // range
      //
      if (n.name () == "range" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< range_type > r (
          range_traits::create (i, f, this));

        if (!this->range_)
        {
          this->range_.set (::std::move (r));
          continue;
        }
      }

      // set
      //
      if (n.name () == "set" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< set_type > r (
          set_traits::create (i, f, this));

        if (!this->set_)
        {
          this->set_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  OneBasedIntegerRangeOrSet* OneBasedIntegerRangeOrSet::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class OneBasedIntegerRangeOrSet (*this, f, c);
  }

  OneBasedIntegerRangeOrSet& OneBasedIntegerRangeOrSet::
  operator= (const OneBasedIntegerRangeOrSet& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->range_ = x.range_;
      this->set_ = x.set_;
    }

    return *this;
  }

  OneBasedIntegerRangeOrSet::
  ~OneBasedIntegerRangeOrSet ()
  {
  }

  // StringSet
  //

  StringSet::
  StringSet ()
  : ::xml_schema::type (),
    item_ (this)
  {
  }

  StringSet::
  StringSet (const StringSet& x,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    item_ (x.item_, f, this)
  {
  }

  StringSet::
  StringSet (const ::xercesc::DOMElement& e,
             ::xml_schema::flags f,
             ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    item_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void StringSet::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // item
      //
      if (n.name () == "item" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< item_type > r (
          item_traits::create (i, f, this));

        this->item_.push_back (::std::move (r));
        continue;
      }

      break;
    }
  }

  StringSet* StringSet::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class StringSet (*this, f, c);
  }

  StringSet& StringSet::
  operator= (const StringSet& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->item_ = x.item_;
    }

    return *this;
  }

  StringSet::
  ~StringSet ()
  {
  }

  // FloatSet
  //

  FloatSet::
  FloatSet ()
  : ::xml_schema::type (),
    item_ (this)
  {
  }

  FloatSet::
  FloatSet (const FloatSet& x,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    item_ (x.item_, f, this)
  {
  }

  FloatSet::
  FloatSet (const ::xercesc::DOMElement& e,
            ::xml_schema::flags f,
            ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    item_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void FloatSet::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // item
      //
      if (n.name () == "item" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        this->item_.push_back (item_traits::create (i, f, this));
        continue;
      }

      break;
    }
  }

  FloatSet* FloatSet::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FloatSet (*this, f, c);
  }

  FloatSet& FloatSet::
  operator= (const FloatSet& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->item_ = x.item_;
    }

    return *this;
  }

  FloatSet::
  ~FloatSet ()
  {
  }

  // FloatRange
  //

  FloatRange::
  FloatRange (const begin_type& begin,
              const end_type& end,
              const increment_type& increment)
  : ::xml_schema::type (),
    begin_ (begin, this),
    end_ (end, this),
    increment_ (increment, this)
  {
  }

  FloatRange::
  FloatRange (const FloatRange& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    begin_ (x.begin_, f, this),
    end_ (x.end_, f, this),
    increment_ (x.increment_, f, this)
  {
  }

  FloatRange::
  FloatRange (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    begin_ (this),
    end_ (this),
    increment_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void FloatRange::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // begin
      //
      if (n.name () == "begin" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!begin_.present ())
        {
          this->begin_.set (begin_traits::create (i, f, this));
          continue;
        }
      }

      // end
      //
      if (n.name () == "end" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!end_.present ())
        {
          this->end_.set (end_traits::create (i, f, this));
          continue;
        }
      }

      // increment
      //
      if (n.name () == "increment" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        if (!increment_.present ())
        {
          this->increment_.set (increment_traits::create (i, f, this));
          continue;
        }
      }

      break;
    }

    if (!begin_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "begin",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!end_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "end",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!increment_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "increment",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  FloatRange* FloatRange::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FloatRange (*this, f, c);
  }

  FloatRange& FloatRange::
  operator= (const FloatRange& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->begin_ = x.begin_;
      this->end_ = x.end_;
      this->increment_ = x.increment_;
    }

    return *this;
  }

  FloatRange::
  ~FloatRange ()
  {
  }

  // FloatRangeOrSet
  //

  FloatRangeOrSet::
  FloatRangeOrSet ()
  : ::xml_schema::type (),
    range_ (this),
    set_ (this)
  {
  }

  FloatRangeOrSet::
  FloatRangeOrSet (const FloatRangeOrSet& x,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    range_ (x.range_, f, this),
    set_ (x.set_, f, this)
  {
  }

  FloatRangeOrSet::
  FloatRangeOrSet (const ::xercesc::DOMElement& e,
                   ::xml_schema::flags f,
                   ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    range_ (this),
    set_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void FloatRangeOrSet::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // range
      //
      if (n.name () == "range" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< range_type > r (
          range_traits::create (i, f, this));

        if (!this->range_)
        {
          this->range_.set (::std::move (r));
          continue;
        }
      }

      // set
      //
      if (n.name () == "set" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< set_type > r (
          set_traits::create (i, f, this));

        if (!this->set_)
        {
          this->set_.set (::std::move (r));
          continue;
        }
      }

      break;
    }
  }

  FloatRangeOrSet* FloatRangeOrSet::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class FloatRangeOrSet (*this, f, c);
  }

  FloatRangeOrSet& FloatRangeOrSet::
  operator= (const FloatRangeOrSet& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->range_ = x.range_;
      this->set_ = x.set_;
    }

    return *this;
  }

  FloatRangeOrSet::
  ~FloatRangeOrSet ()
  {
  }

  // NrRowsNrCols
  //

  NrRowsNrCols::
  NrRowsNrCols (const nrRows_type& nrRows,
                const nrCols_type& nrCols)
  : ::xml_schema::type (),
    nrRows_ (nrRows, this),
    nrCols_ (nrCols, this)
  {
  }

  NrRowsNrCols::
  NrRowsNrCols (const NrRowsNrCols& x,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (x, f, c),
    nrRows_ (x.nrRows_, f, this),
    nrCols_ (x.nrCols_, f, this)
  {
  }

  NrRowsNrCols::
  NrRowsNrCols (const ::xercesc::DOMElement& e,
                ::xml_schema::flags f,
                ::xml_schema::container* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    nrRows_ (this),
    nrCols_ (this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e, true, false, false);
      this->parse (p, f);
    }
  }

  void NrRowsNrCols::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_content (); p.next_content (false))
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // nrRows
      //
      if (n.name () == "nrRows" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< nrRows_type > r (
          nrRows_traits::create (i, f, this));

        if (!nrRows_.present ())
        {
          this->nrRows_.set (::std::move (r));
          continue;
        }
      }

      // nrCols
      //
      if (n.name () == "nrCols" && n.namespace_ () == "http://www.pcraster.nl/pcrxml")
      {
        ::std::unique_ptr< nrCols_type > r (
          nrCols_traits::create (i, f, this));

        if (!nrCols_.present ())
        {
          this->nrCols_.set (::std::move (r));
          continue;
        }
      }

      break;
    }

    if (!nrRows_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "nrRows",
        "http://www.pcraster.nl/pcrxml");
    }

    if (!nrCols_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "nrCols",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  NrRowsNrCols* NrRowsNrCols::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class NrRowsNrCols (*this, f, c);
  }

  NrRowsNrCols& NrRowsNrCols::
  operator= (const NrRowsNrCols& x)
  {
    if (this != &x)
    {
      static_cast< ::xml_schema::type& > (*this) = x;
      this->nrRows_ = x.nrRows_;
      this->nrCols_ = x.nrCols_;
    }

    return *this;
  }

  NrRowsNrCols::
  ~NrRowsNrCols ()
  {
  }

  // SpaceTrimmedToken
  //

  SpaceTrimmedToken::
  SpaceTrimmedToken ()
  : ::xml_schema::string ()
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const SpaceTrimmedToken& x,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const ::xercesc::DOMElement& e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const ::xercesc::DOMAttr& a,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  SpaceTrimmedToken::
  SpaceTrimmedToken (const ::std::string& s,
                     const ::xercesc::DOMElement* e,
                     ::xml_schema::flags f,
                     ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  SpaceTrimmedToken* SpaceTrimmedToken::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class SpaceTrimmedToken (*this, f, c);
  }

  SpaceTrimmedToken::
  ~SpaceTrimmedToken ()
  {
  }

  // Identifier
  //

  Identifier::
  Identifier ()
  : ::xml_schema::string ()
  {
  }

  Identifier::
  Identifier (const char* _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  Identifier::
  Identifier (const ::std::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  Identifier::
  Identifier (const ::xml_schema::string& _xsd_string_base)
  : ::xml_schema::string (_xsd_string_base)
  {
  }

  Identifier::
  Identifier (const Identifier& x,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::string (x, f, c)
  {
  }

  Identifier::
  Identifier (const ::xercesc::DOMElement& e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::string (e, f, c)
  {
  }

  Identifier::
  Identifier (const ::xercesc::DOMAttr& a,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::string (a, f, c)
  {
  }

  Identifier::
  Identifier (const ::std::string& s,
              const ::xercesc::DOMElement* e,
              ::xml_schema::flags f,
              ::xml_schema::container* c)
  : ::xml_schema::string (s, e, f, c)
  {
  }

  Identifier* Identifier::
  _clone (::xml_schema::flags f,
          ::xml_schema::container* c) const
  {
    return new class Identifier (*this, f, c);
  }

  Identifier::
  ~Identifier ()
  {
  }
}

#include <ostream>

namespace pcrxml
{
  ::std::ostream&
  operator<< (::std::ostream& o, const Non0UnsignedInt& i)
  {
    o << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const EmptyElement&)
  {
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const TimeDuration& i)
  {
    if (i.hours ())
    {
      o << ::std::endl << "hours: " << *i.hours ();
    }

    if (i.minutes ())
    {
      o << ::std::endl << "minutes: " << *i.minutes ();
    }

    if (i.seconds ())
    {
      o << ::std::endl << "seconds: " << *i.seconds ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const OneBasedIntegerSet& i)
  {
    for (OneBasedIntegerSet::item_const_iterator
         b (i.item ().begin ()), e (i.item ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "item: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const OneBasedIntegerRange& i)
  {
    o << ::std::endl << "begin: " << i.begin ();
    o << ::std::endl << "end: " << i.end ();
    o << ::std::endl << "increment: " << i.increment ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const OneBasedIntegerRangeOrSet& i)
  {
    if (i.range ())
    {
      o << ::std::endl << "range: " << *i.range ();
    }

    if (i.set ())
    {
      o << ::std::endl << "set: " << *i.set ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const StringSet& i)
  {
    for (StringSet::item_const_iterator
         b (i.item ().begin ()), e (i.item ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "item: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const FloatSet& i)
  {
    for (FloatSet::item_const_iterator
         b (i.item ().begin ()), e (i.item ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "item: " << *b;
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const FloatRange& i)
  {
    o << ::std::endl << "begin: " << i.begin ();
    o << ::std::endl << "end: " << i.end ();
    o << ::std::endl << "increment: " << i.increment ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const FloatRangeOrSet& i)
  {
    if (i.range ())
    {
      o << ::std::endl << "range: " << *i.range ();
    }

    if (i.set ())
    {
      o << ::std::endl << "set: " << *i.set ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const NrRowsNrCols& i)
  {
    o << ::std::endl << "nrRows: " << i.nrRows ();
    o << ::std::endl << "nrCols: " << i.nrCols ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const SpaceTrimmedToken& i)
  {
    o << static_cast< const ::xml_schema::string& > (i);

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const Identifier& i)
  {
    o << static_cast< const ::xml_schema::string& > (i);

    return o;
  }
}

#include <istream>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace pcrxml
{
  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (const ::std::string& u,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::TimeDuration > (
      ::pcrxml::unitTestOnlyDuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (const ::std::string& u,
                        ::xml_schema::error_handler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::TimeDuration > (
      ::pcrxml::unitTestOnlyDuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (const ::std::string& u,
                        ::xercesc::DOMErrorHandler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        u, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::TimeDuration > (
      ::pcrxml::unitTestOnlyDuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::std::istream& is,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::unitTestOnlyDuration (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::std::istream& is,
                        ::xml_schema::error_handler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::unitTestOnlyDuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::std::istream& is,
                        ::xercesc::DOMErrorHandler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    return ::pcrxml::unitTestOnlyDuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::std::istream& is,
                        const ::std::string& sid,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::unitTestOnlyDuration (isrc, f, p);
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::std::istream& is,
                        const ::std::string& sid,
                        ::xml_schema::error_handler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::unitTestOnlyDuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::std::istream& is,
                        const ::std::string& sid,
                        ::xercesc::DOMErrorHandler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    return ::pcrxml::unitTestOnlyDuration (isrc, h, f, p);
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::xercesc::InputSource& i,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::std::unique_ptr< ::pcrxml::TimeDuration > (
      ::pcrxml::unitTestOnlyDuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::xercesc::InputSource& i,
                        ::xml_schema::error_handler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::TimeDuration > (
      ::pcrxml::unitTestOnlyDuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::xercesc::InputSource& i,
                        ::xercesc::DOMErrorHandler& h,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (
        i, h, p, f));

    if (!d.get ())
      throw ::xsd::cxx::tree::parsing< char > ();

    return ::std::unique_ptr< ::pcrxml::TimeDuration > (
      ::pcrxml::unitTestOnlyDuration (
        std::move (d), f | ::xml_schema::flags::own_dom, p));
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (const ::xercesc::DOMDocument& doc,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
        static_cast< ::xercesc::DOMDocument* > (doc.cloneNode (true)));

      return ::std::unique_ptr< ::pcrxml::TimeDuration > (
        ::pcrxml::unitTestOnlyDuration (
          std::move (d), f | ::xml_schema::flags::own_dom, p));
    }

    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "unitTestOnlyDuration" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::TimeDuration > r (
        ::xsd::cxx::tree::traits< ::pcrxml::TimeDuration, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "unitTestOnlyDuration",
      "http://www.pcraster.nl/pcrxml");
  }

  ::std::unique_ptr< ::pcrxml::TimeDuration >
  unitTestOnlyDuration (::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d,
                        ::xml_schema::flags f,
                        const ::xml_schema::properties&)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    ::xercesc::DOMDocument& doc (c.get () ? *c : *d);
    const ::xercesc::DOMElement& e (*doc.getDocumentElement ());

    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (f & ::xml_schema::flags::keep_dom)
      doc.setUserData (::xml_schema::dom::tree_node_key,
                       (c.get () ? &c : &d),
                       0);

    if (n.name () == "unitTestOnlyDuration" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      ::std::unique_ptr< ::pcrxml::TimeDuration > r (
        ::xsd::cxx::tree::traits< ::pcrxml::TimeDuration, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "unitTestOnlyDuration",
      "http://www.pcraster.nl/pcrxml");
  }
}

#include <ostream>
#include <xsd/cxx/tree/error-handler.hxx>
#include <xsd/cxx/xml/dom/serialization-source.hxx>

namespace pcrxml
{
  void
  operator<< (::xercesc::DOMElement& e, const Non0UnsignedInt& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const Non0UnsignedInt& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const Non0UnsignedInt& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const EmptyElement& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr&, const EmptyElement&)
  {
  }

  void
  operator<< (::xml_schema::list_stream&,
              const EmptyElement&)
  {
  }

  void
  operator<< (::xercesc::DOMElement& e, const TimeDuration& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // hours
    //
    if (i.hours ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "hours",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.hours ();
    }

    // minutes
    //
    if (i.minutes ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "minutes",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.minutes ();
    }

    // seconds
    //
    if (i.seconds ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "seconds",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.seconds ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const OneBasedIntegerSet& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // item
    //
    for (OneBasedIntegerSet::item_const_iterator
         b (i.item ().begin ()), n (i.item ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "item",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const OneBasedIntegerRange& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // begin
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "begin",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.begin ();
    }

    // end
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "end",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.end ();
    }

    // increment
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "increment",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.increment ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const OneBasedIntegerRangeOrSet& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // range
    //
    if (i.range ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "range",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.range ();
    }

    // set
    //
    if (i.set ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "set",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.set ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const StringSet& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // item
    //
    for (StringSet::item_const_iterator
         b (i.item ().begin ()), n (i.item ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "item",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const FloatSet& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // item
    //
    for (FloatSet::item_const_iterator
         b (i.item ().begin ()), n (i.item ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "item",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *b;
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const FloatRange& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // begin
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "begin",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.begin ();
    }

    // end
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "end",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.end ();
    }

    // increment
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "increment",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.increment ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const FloatRangeOrSet& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // range
    //
    if (i.range ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "range",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.range ();
    }

    // set
    //
    if (i.set ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "set",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << *i.set ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const NrRowsNrCols& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // nrRows
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "nrRows",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.nrRows ();
    }

    // nrCols
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "nrCols",
          "http://www.pcraster.nl/pcrxml",
          e));

      s << i.nrCols ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const SpaceTrimmedToken& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const SpaceTrimmedToken& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const SpaceTrimmedToken& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const Identifier& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const Identifier& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xml_schema::list_stream& l,
              const Identifier& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  unitTestOnlyDuration (::std::ostream& o,
                        const ::pcrxml::TimeDuration& s,
                        const ::xml_schema::namespace_infomap& m,
                        const ::std::string& e,
                        ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::unitTestOnlyDuration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  unitTestOnlyDuration (::std::ostream& o,
                        const ::pcrxml::TimeDuration& s,
                        ::xml_schema::error_handler& h,
                        const ::xml_schema::namespace_infomap& m,
                        const ::std::string& e,
                        ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::unitTestOnlyDuration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  unitTestOnlyDuration (::std::ostream& o,
                        const ::pcrxml::TimeDuration& s,
                        ::xercesc::DOMErrorHandler& h,
                        const ::xml_schema::namespace_infomap& m,
                        const ::std::string& e,
                        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::unitTestOnlyDuration (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  unitTestOnlyDuration (::xercesc::XMLFormatTarget& t,
                        const ::pcrxml::TimeDuration& s,
                        const ::xml_schema::namespace_infomap& m,
                        const ::std::string& e,
                        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::unitTestOnlyDuration (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  unitTestOnlyDuration (::xercesc::XMLFormatTarget& t,
                        const ::pcrxml::TimeDuration& s,
                        ::xml_schema::error_handler& h,
                        const ::xml_schema::namespace_infomap& m,
                        const ::std::string& e,
                        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::unitTestOnlyDuration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  unitTestOnlyDuration (::xercesc::XMLFormatTarget& t,
                        const ::pcrxml::TimeDuration& s,
                        ::xercesc::DOMErrorHandler& h,
                        const ::xml_schema::namespace_infomap& m,
                        const ::std::string& e,
                        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::pcrxml::unitTestOnlyDuration (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  unitTestOnlyDuration (::xercesc::DOMDocument& d,
                        const ::pcrxml::TimeDuration& s,
                        ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "unitTestOnlyDuration" &&
        n.namespace_ () == "http://www.pcraster.nl/pcrxml")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "unitTestOnlyDuration",
        "http://www.pcraster.nl/pcrxml");
    }
  }

  ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument >
  unitTestOnlyDuration (const ::pcrxml::TimeDuration& s,
                        const ::xml_schema::namespace_infomap& m,
                        ::xml_schema::flags f)
  {
    ::xml_schema::dom::unique_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::serialize< char > (
        "unitTestOnlyDuration",
        "http://www.pcraster.nl/pcrxml",
        m, f));

    ::pcrxml::unitTestOnlyDuration (*d, s, f);
    return d;
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
#include "commonTypesUtilEpilogueImpl.h"
//
// End epilogue.

