/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.duplicates;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.MessageDispatcher;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class StrictDuplicateCodeCheck
extends AbstractFileSetCheck {
    private static final Log LOG = LogFactory.getLog(StrictDuplicateCodeCheck.class);
    private static final long IGNORE = Long.MIN_VALUE;
    private static final int DEFAULT_MIN_DUPLICATE_LINES = 12;
    private int mMin = 12;
    private String mBasedir;
    private long[][] mLineChecksums;
    private long[][] mSortedRelevantChecksums;
    private File[] mFiles;
    private int mDuplicates;
    private int mLoc;
    private long mCacheMisses;
    private long mCacheHits;

    public void setMin(int aMin) {
        this.mMin = aMin;
    }

    public void setBasedir(String aBasedir) {
        this.mBasedir = aBasedir;
    }

    public synchronized void process(File[] aFiles) {
        long start = System.currentTimeMillis();
        this.mLoc = 0;
        this.mDuplicates = 0;
        this.mFiles = this.filter(aFiles);
        this.mLineChecksums = new long[this.mFiles.length][];
        this.mSortedRelevantChecksums = new long[this.mFiles.length][];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading input files");
        }
        for (int i = 0; i < this.mFiles.length; ++i) {
            try {
                File file = this.mFiles[i];
                String[] lines = Utils.getLines(file.getPath(), this.getCharset());
                ChecksumGenerator transformer = this.findChecksumGenerator(file);
                this.mLineChecksums[i] = transformer.convertLines(lines);
                continue;
            }
            catch (IOException ex) {
                LOG.error("Cannot access files to check, giving up: " + ex.getMessage(), ex);
                this.mLineChecksums = new long[0][0];
            }
        }
        this.fillSortedRelevantChecksums();
        long endReading = System.currentTimeMillis();
        this.findDuplicates();
        long endSearching = System.currentTimeMillis();
        this.dumpStats(start, endReading, endSearching);
        this.mLineChecksums = null;
        this.mSortedRelevantChecksums = null;
    }

    private ChecksumGenerator findChecksumGenerator(File aFile) {
        if (aFile.getName().endsWith(".java")) {
            return new JavaChecksumGenerator();
        }
        return new TextfileChecksumGenerator();
    }

    private void dumpStats(long aStart, long aEndReading, long aEndSearching) {
        if (LOG.isDebugEnabled()) {
            long cacheLookups = this.mCacheHits + this.mCacheMisses;
            long initTime = aEndReading - aStart;
            long workTime = aEndSearching - aEndReading;
            LOG.debug("cache hits = " + this.mCacheHits + "/" + cacheLookups);
            LOG.debug("files = " + this.mFiles.length);
            LOG.debug("loc = " + this.mLoc);
            LOG.debug("duplicates = " + this.mDuplicates);
            LOG.debug("Runtime = " + initTime + " + " + workTime);
        }
    }

    private void fillSortedRelevantChecksums() {
        for (int i = 0; i < this.mLineChecksums.length; ++i) {
            int count = 0;
            long[] checksums = this.mLineChecksums[i];
            long[] relevant = new long[checksums.length];
            for (int j = 0; j < checksums.length; ++j) {
                long checksum = checksums[j];
                if (checksum == Long.MIN_VALUE) continue;
                relevant[count++] = checksum;
            }
            Arrays.sort(relevant, 0, count);
            long[] result = new long[count];
            System.arraycopy(relevant, 0, result, 0, count);
            this.mSortedRelevantChecksums[i] = result;
        }
    }

    private void findDuplicates() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Analysis phase");
        }
        for (int i = 0; i < this.mFiles.length; ++i) {
            String path = this.mFiles[i].getPath();
            this.getMessageCollector().reset();
            MessageDispatcher dispatcher = this.getMessageDispatcher();
            dispatcher.fireFileStarted(path);
            this.mLoc += this.mLineChecksums[i].length;
            for (int j = 0; j <= i; ++j) {
                this.findDuplicatesInFiles(i, j);
            }
            this.fireErrors(path);
            dispatcher.fireFileFinished(path);
        }
    }

    private void findDuplicatesInFiles(int aI, int aJ) {
        int iLine;
        int iFileLength = this.mLineChecksums[aI].length;
        boolean[] iLineOccurInJ = new boolean[iFileLength];
        for (iLine = 0; iLine < iFileLength; ++iLine) {
            iLineOccurInJ[iLine] = Arrays.binarySearch(this.mSortedRelevantChecksums[aJ], this.mLineChecksums[aI][iLine]) >= 0;
        }
        for (iLine = 0; iLine < iFileLength - this.mMin; ++iLine) {
            boolean fastExit = false;
            int kLimit = iFileLength - iLine;
            for (int k = 0; k < Math.min(this.mMin, kLimit); ++k) {
                if (iLineOccurInJ[iLine + k]) continue;
                fastExit = true;
                break;
            }
            if (!fastExit) {
                ++this.mCacheMisses;
                iLine = this.findDuplicateFromLine(aI, aJ, iLine);
                continue;
            }
            ++this.mCacheHits;
        }
    }

    private int findDuplicateFromLine(int aI, int aJ, int aILine) {
        int iFileLength = this.mLineChecksums[aI].length;
        int jFileLength = this.mLineChecksums[aJ].length;
        for (int jLine = 0; jLine < jFileLength - this.mMin; ++jLine) {
            if (aI == aJ && aILine == jLine) continue;
            int equivalent = 0;
            while (aILine + equivalent < iFileLength && jLine + equivalent < jFileLength && this.mLineChecksums[aI][aILine + equivalent] != Long.MIN_VALUE && this.mLineChecksums[aI][aILine + equivalent] == this.mLineChecksums[aJ][jLine + equivalent]) {
                ++equivalent;
            }
            if (aI == aJ && aILine >= jLine || equivalent < this.mMin) continue;
            this.reportDuplicate(equivalent, aILine, this.mFiles[aJ], jLine);
            aILine += equivalent;
        }
        return aILine;
    }

    private void reportDuplicate(int aEquivalent, int aILine, File aJFile, int aJLine) {
        Integer dupLines = new Integer(aEquivalent);
        Integer startLine = new Integer(aJLine + 1);
        String fileName = Utils.getStrippedFileName(this.mBasedir, aJFile.getPath());
        this.log(aILine + 1, "duplicates.lines", new Object[]{dupLines, fileName, startLine});
        ++this.mDuplicates;
    }

    private class JavaChecksumGenerator
    extends TextfileChecksumGenerator {
        private JavaChecksumGenerator() {
        }

        protected long calcChecksum(String aLine) {
            if (aLine.startsWith("import ")) {
                return Long.MIN_VALUE;
            }
            return super.calcChecksum(aLine);
        }
    }

    private class TextfileChecksumGenerator
    implements ChecksumGenerator {
        private TextfileChecksumGenerator() {
        }

        public long[] convertLines(String[] aOriginalLines) {
            long[] checkSums = new long[aOriginalLines.length];
            for (int i = 0; i < aOriginalLines.length; ++i) {
                String line = aOriginalLines[i].trim();
                checkSums[i] = this.calcChecksum(line);
            }
            return checkSums;
        }

        protected long calcChecksum(String aLine) {
            int bigPrime = 317;
            long result = 0L;
            for (int i = 0; i < aLine.length(); ++i) {
                long c = aLine.charAt(i);
                result += (long)(317 * i) + c;
            }
            return result;
        }
    }

    private static interface ChecksumGenerator {
        public long[] convertLines(String[] var1);
    }
}

