/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.wrapping;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.LongEdgeJoiner;
import org.eclipse.elk.alg.layered.intermediate.wrapping.BreakingPointInserter;
import org.eclipse.elk.alg.layered.intermediate.wrapping.CuttingUtils;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class BreakingPointProcessor
implements ILayoutProcessor<LGraph> {
    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Breaking Point Processor", 1.0f);
        this.performWrapping(graph);
        if (graph.getProperty(LayeredOptions.WRAPPING_MULTI_EDGE_IMPROVE_WRAPPED_EDGES).booleanValue()) {
            for (Layer l : graph.getLayers()) {
                int index = 0;
                for (LNode n : l.getNodes()) {
                    n.id = index++;
                }
            }
            this.improveMultiCutIndexEdges(graph);
            this.improveUnneccesarilyLongEdges(graph, true);
            this.improveUnneccesarilyLongEdges(graph, false);
        }
        progressMonitor.done();
    }

    private void performWrapping(LGraph graph) {
        List<Layer> layers = graph.getLayers();
        ListIterator<Layer> layerIt = layers.listIterator();
        layerIt.add(new Layer(graph));
        boolean reverse = false;
        int idx = 1;
        while (layerIt.hasNext()) {
            LNode aNode;
            Layer layer = layerIt.next();
            Layer newLayer = layers.get(idx);
            ArrayList<LNode> nodesToMove = Lists.newArrayList(layer.getNodes());
            int offset = nodesToMove.size();
            for (LNode n : nodesToMove) {
                n.setLayer(newLayer);
            }
            if (reverse) {
                for (LNode n : Lists.reverse(nodesToMove)) {
                    for (LEdge e : Lists.newArrayList(n.getIncomingEdges())) {
                        e.reverse(graph, true);
                        graph.setProperty(InternalProperties.CYCLIC, (Object)true);
                        List<LEdge> dummyEdges = CuttingUtils.insertDummies(graph, e, offset);
                        BreakingPointInserter.BPInfo bpi = n.getProperty(InternalProperties.BREAKING_POINT_INFO);
                        LEdge startInLayerEdge = dummyEdges.get(dummyEdges.size() - 1);
                        bpi.startInLayerDummy = startInLayerEdge.getSource().getNode();
                        bpi.startInLayerEdge = startInLayerEdge;
                        bpi.endInLayerDummy = e.getTarget().getNode();
                        bpi.endInLayerEdge = e;
                    }
                }
                reverse = false;
            } else if (!nodesToMove.isEmpty() && (aNode = (LNode)nodesToMove.get(0)).getType() == LNode.NodeType.BREAKING_POINT) {
                reverse = true;
                idx = -1;
            }
            ++idx;
        }
        ListIterator<Layer> it = graph.getLayers().listIterator();
        while (it.hasNext()) {
            Layer l = it.next();
            if (!l.getNodes().isEmpty()) continue;
            it.remove();
        }
    }

    private void improveMultiCutIndexEdges(LGraph graph) {
        for (Layer l : graph.getLayers()) {
            for (LNode n : Lists.newArrayList(l.getNodes())) {
                if (!BreakingPointInserter.BPInfo.isStart(n)) continue;
                BreakingPointInserter.BPInfo info = n.getProperty(InternalProperties.BREAKING_POINT_INFO);
                if (info.prev != null || info.next == null) continue;
                BreakingPointInserter.BPInfo current = info;
                BreakingPointInserter.BPInfo next = info.next;
                while (next != null) {
                    this.dropDummies(next.start, next.startInLayerDummy, false, true);
                    this.updateIndexesAfter(current.end);
                    this.updateIndexesAfter(next.start);
                    this.updateIndexesAfter(next.startInLayerDummy);
                    this.updateIndexesAfter(next.endInLayerDummy);
                    next.endInLayerEdge.setTarget(current.endInLayerEdge.getTarget());
                    current.endInLayerEdge.setTarget(null);
                    current.end.setLayer(null);
                    next.start.setLayer(null);
                    next.startInLayerDummy.setLayer(null);
                    next.endInLayerDummy.setLayer(null);
                    BreakingPointInserter.BPInfo newInfo = new BreakingPointInserter.BPInfo(current.start, next.end, current.nodeStartEdge, next.startEndEdge, next.originalEdge);
                    newInfo.startInLayerDummy = current.startInLayerDummy;
                    newInfo.startInLayerEdge = current.startInLayerEdge;
                    newInfo.endInLayerDummy = current.endInLayerDummy;
                    newInfo.endInLayerEdge = next.endInLayerEdge;
                    newInfo.prev = current.prev;
                    newInfo.next = next.next;
                    current.start.setProperty(InternalProperties.BREAKING_POINT_INFO, newInfo);
                    next.end.setProperty(InternalProperties.BREAKING_POINT_INFO, newInfo);
                    next = next.next;
                    current = newInfo;
                }
            }
        }
    }

    private void improveUnneccesarilyLongEdges(LGraph graph, boolean forwards) {
        Predicate<LNode> check = forwards ? BreakingPointInserter.BPInfo::isEnd : BreakingPointInserter.BPInfo::isStart;
        boolean didsome = false;
        do {
            didsome = false;
            List<Layer> layers = forwards ? Lists.reverse(graph.getLayers()) : graph.getLayers();
            for (Layer layer : layers) {
                ArrayList<LNode> nodes = Lists.newArrayList(layer.getNodes());
                if (!forwards) {
                    Lists.reverse(nodes);
                }
                for (LNode n : nodes) {
                    if (!check.test(n)) continue;
                    LNode bpNode = n;
                    BreakingPointInserter.BPInfo bpInfo = n.getProperty(InternalProperties.BREAKING_POINT_INFO);
                    LNode dummy = forwards ? bpInfo.endInLayerDummy : bpInfo.startInLayerDummy;
                    didsome = this.dropDummies(bpNode, dummy, forwards, false);
                }
            }
        } while (didsome);
    }

    private boolean dropDummies(LNode bpNode, LNode inLayerDummy, boolean forwards, boolean force) {
        LNode predOne = this.nextLongEdgeDummy(bpNode, forwards);
        LNode predTwo = this.nextLongEdgeDummy(inLayerDummy, forwards);
        boolean didsome = false;
        while (predOne != null && predTwo != null) {
            if (!force && !this.isAdjacentOrSeparatedByBreakingpoints(predOne, predTwo, forwards)) break;
            LNode nextOne = this.nextLongEdgeDummy(predOne, forwards);
            LNode nextTwo = this.nextLongEdgeDummy(predTwo, forwards);
            this.updateIndexesAfter(inLayerDummy);
            this.updateIndexesAfter(bpNode);
            Layer newLayer = predOne.getLayer();
            LongEdgeJoiner.joinAt(predOne, false);
            LongEdgeJoiner.joinAt(predTwo, false);
            if (forwards) {
                inLayerDummy.setLayer(predTwo.id, newLayer);
                inLayerDummy.id = predTwo.id;
                bpNode.setLayer(predOne.id + 1, newLayer);
                bpNode.id = predOne.id;
            } else {
                bpNode.setLayer(predOne.id, newLayer);
                bpNode.id = predOne.id;
                inLayerDummy.setLayer(predTwo.id + 1, newLayer);
                inLayerDummy.id = predTwo.id;
            }
            predOne.setLayer(null);
            predTwo.setLayer(null);
            predOne = nextOne;
            predTwo = nextTwo;
            didsome = true;
        }
        return didsome;
    }

    private boolean isAdjacentOrSeparatedByBreakingpoints(LNode dummy1, LNode dummy2, boolean forwards) {
        Layer layer = dummy1.getLayer();
        LNode start = forwards ? dummy2 : dummy1;
        LNode end = forwards ? dummy1 : dummy2;
        int i = start.id + 1;
        while (i < end.id) {
            LNode node = layer.getNodes().get(i);
            if (node.getType() != LNode.NodeType.BREAKING_POINT && !this.isInLayerDummy(node)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private LNode nextLongEdgeDummy(LNode start, boolean forwards) {
        Iterable<LEdge> edges = forwards ? start.getOutgoingEdges() : start.getIncomingEdges();
        for (LEdge e : edges) {
            LNode other = e.getOther(start);
            if (other.getType() != LNode.NodeType.LONG_EDGE || other.getLayer() == start.getLayer()) continue;
            return other;
        }
        return null;
    }

    private boolean isInLayerDummy(LNode node) {
        if (node.getType() == LNode.NodeType.LONG_EDGE) {
            for (LEdge e : node.getConnectedEdges()) {
                if (e.isSelfLoop() || node.getLayer() != e.getOther(node).getLayer()) continue;
                return true;
            }
        }
        return false;
    }

    private void updateIndexesAfter(LNode node) {
        int i = node.id + 1;
        while (i < node.getLayer().getNodes().size()) {
            --node.getLayer().getNodes().get((int)i).id;
            ++i;
        }
    }
}

