import 'dart:io';

import 'package:build_verify/build_verify.dart';
import 'package:path/path.dart';
import 'package:test/test.dart';

void main() {
  test('ensure_build', expectBuildClean);
  test('install scripts have been moved', () {
    final sourceInstall = File(join('scripts', 'install.sh'));
    final sourceUninstall = File(join('scripts', 'uninstall.sh'));

    final targetInstall = File(join('docs', 'public', 'install.sh'));
    final targetUninstall = File(join('docs', 'public', 'uninstall.sh'));

    expect(
      sourceInstall.existsSync() && sourceUninstall.existsSync(),
      isTrue,
      reason: 'install.sh and uninstall.sh exist',
    );
    expect(
      sourceInstall.readAsStringSync(),
      targetInstall.readAsStringSync(),
      reason: 'Install scripts are the same',
    );

    expect(
      sourceUninstall.readAsStringSync(),
      targetUninstall.readAsStringSync(),
      reason: 'Uninstall scripts are the same',
    );
  });
}
