// Copyright (c) 2018, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
// VMOptions=--verbose_debug

import 'dart:developer';

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_D = 32;
const LINE_A = 33;
const LINE_B = 34;
const LINE_C = 35;
// AUTOGENERATED END

Future<void> foo() async {}

Future<void> doAsync(stop) async {
  // Flutter issue 18877:
  // If a closure is defined in the context of an async method, stepping over
  // an await causes the implicit breakpoint to be set for that closure instead
  // of the async_op, resulting in the debugger falling through.
  // ignore: prefer_function_declarations_over_variables
  final baz = () => print('doAsync($stop) done!');
  if (stop) debugger(); // LINE_D
  await foo(); // LINE_A
  await foo(); // LINE_B
  await foo(); // LINE_C
  baz();
}

void testMain() {
  // With two runs of doAsync floating around, async step should only cause
  // us to stop in the run we started in.
  doAsync(false);
  doAsync(true);
}

final tests = <IsolateTest>[
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_D),
  stepOver, // foo()
  stoppedAtLine(LINE_A),
  stepOver, // foo()
  stoppedAtLine(LINE_A),
  asyncNext,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_B),
  stepOver, // foo()
  stoppedAtLine(LINE_B),
  asyncNext,
  hasStoppedAtBreakpoint,
  stoppedAtLine(LINE_C),
  resumeIsolate,
];

void main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'async_next_regression_18877_test.dart',
      testeeConcurrent: testMain,
    );
