// Copyright (c) 2023, the Dart project authors. Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

import 'common/service_test_common.dart';
import 'common/test_helper.dart';

// AUTOGENERATED START
//
// Update these constants by running:
//
// dart pkg/vm_service/test/update_line_numbers.dart <test.dart>
//
const LINE_A = 22;
const LINE_B = 25;
// AUTOGENERATED END

const String shortFile = 'break_on_function_declared_inside_map_test.dart';

void testMain() {
  final funcs = {
    /* LINE_A */ 'a': () {
      print('a');
    },
    /* LINE_B */ 'b': () {
      print('b');
    },
  };

  funcs['a']!();
  funcs['b']!();
}

final stops = <String>[];

const expected = <String>[
  '$shortFile:$LINE_A:23', // on '(' of '()'
  '$shortFile:$LINE_B:23', // on '(' of '()'
];

final tests = <IsolateTest>[
  hasPausedAtStart,
  setBreakpointAtLineColumn(LINE_A, 24), // on ')' of '()'
  setBreakpointAtLine(LINE_B),
  resumeProgramRecordingStops(stops, false),
  checkRecordedStops(stops, expected),
];

Future<void> main([args = const <String>[]]) => runIsolateTests(
      args,
      tests,
      'break_on_function_declared_inside_map_test.dart',
      testeeConcurrent: testMain,
      pauseOnStart: true,
      pauseOnExit: true,
    );
