/* ----------------------------------------------------------------------------
| Copyright (c) Jupyter Development Team.
| Distributed under the terms of the Modified BSD License.
|----------------------------------------------------------------------------*/
import { DataConnector } from '@jupyterlab/statedb';
import { Token } from '@lumino/coreutils';
import { requestTranslationsAPI } from './server';
/**
 * A service to connect to the server translation endpoint
 */
export const ITranslatorConnector = new Token('@jupyterlab/translation:ITranslatorConnector', 'A service to connect to the server translation endpoint.');
export class TranslatorConnector extends DataConnector {
    constructor(translationsUrl = '', serverSettings) {
        super();
        this._translationsUrl = translationsUrl;
        this._serverSettings = serverSettings;
    }
    async fetch(opts) {
        return requestTranslationsAPI(this._translationsUrl, opts.language, {}, this._serverSettings);
    }
}
/**
 * Translation provider token
 */
export const ITranslator = new Token('@jupyterlab/translation:ITranslator', 'A service to translate strings.');
//# sourceMappingURL=tokens.js.map