import { Message } from '@lumino/messaging';
import { Widget } from '@lumino/widgets';
import { Signal } from '@lumino/signaling';
/**
 * A handle that allows to change input/output proportions in side-by-side mode.
 */
export declare class ResizeHandle extends Widget {
    protected targetNode: HTMLElement;
    constructor(targetNode: HTMLElement);
    /**
     * Dispose the resizer handle.
     */
    dispose(): void;
    /**
     * Handle the DOM events for the widget.
     *
     * @param event - The DOM event sent to the widget.
     *
     */
    handleEvent(event: Event): void;
    /**
     * Handle `after-attach` messages.
     */
    protected onAfterAttach(msg: Message): void;
    /**
     * Handle `before-detach` messages.
     */
    protected onBeforeDetach(msg: Message): void;
    private _resize;
    private _isActive;
    private _isDragging;
    private _resizer;
    /**
     * A public signal used to indicate the size of the cell and output has changed.
     */
    readonly sizeChanged: Signal<this, number>;
}
