import { ILSPCodeExtractorsManager } from '../tokens';
import { IForeignCodeExtractor } from './types';
/**
 * Manager for the code extractors
 */
export declare class CodeExtractorsManager implements ILSPCodeExtractorsManager {
    constructor();
    /**
     * Get the extractors for the input cell type and the main language of
     * the document
     *
     * @param  cellType - type of cell
     * @param  hostLanguage - main language of the document
     */
    getExtractors(cellType: string, hostLanguage: string | null): IForeignCodeExtractor[];
    /**
     * Register an extractor to extract foreign code from host documents of specified language.
     */
    register(extractor: IForeignCodeExtractor, hostLanguage: string | null): void;
    /**
     * The map with key is the type of cell, value is another map between
     * the language of cell and its code extractor.
     */
    private _extractorMap;
    /**
     * The map with key is the cell type, value is the code extractor associated
     * with this cell type, this is used for the non-code cell types.
     */
    private _extractorMapAnyLanguage;
}
