import { ISignal } from '@lumino/signaling';
import { ClientCapabilities } from './lsp';
import { IFeature, ILSPFeatureManager } from './tokens';
/**
 * Class to manager the registered features of the language servers.
 */
export declare class FeatureManager implements ILSPFeatureManager {
    constructor();
    /**
     * List of registered features
     */
    readonly features: Array<IFeature>;
    /**
     * Signal emitted when a new feature is registered.
     */
    get featuresRegistered(): ISignal<ILSPFeatureManager, IFeature>;
    /**
     * Register a new feature, skip if it is already registered.
     */
    register(feature: IFeature): void;
    /**
     * Get the capabilities of all clients.
     */
    clientCapabilities(): ClientCapabilities;
    private _featuresRegistered;
}
