#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from __future__ import with_statement
from gui.window import window
from gui.pluggable import pluggable
from model import fitting
import gtk
class importExportWindow(window):
    def __init__(self, master, name, state, stuff = None):
        self.master = master
        self.state = state
        signalsDict = {'confirm' : self.confirm,
                       'delete' : self.exit,
                       'exitRequest' : self.exit,
                       'saveLoadXml' : self.saveLoadXml}
        
        window.__init__(self, "importExportWindow", signalsDict)
        self.initPluggable()
        self.window.set_title("pyfa - " + state.capitalize())
        self.name = name
        self.btnSaveLoadXml.set_use_stock(True)
        if state == "export":
            self.fit = stuff
            self.btnSaveLoadXml.set_label(gtk.STOCK_SAVE_AS)
            buffer = self.txwEftFormat.get_buffer()
            buffer.set_text(self.fit.exportEft(name))
            buffer = self.txwXmlFormat.get_buffer()
            buffer.set_text(self.fit.exportXml(name))
            self.txwStats.get_buffer().set_text(self.fit.exportStats())
            self.txwEftFormat.set_editable(False)
            self.txwEftFormat.set_cursor_visible(False)
            self.txwXmlFormat.set_editable(False)
            self.txwXmlFormat.set_cursor_visible(False)
            self.btnOk.set_label("Copy")
            self.btnCancel.set_label("Close")
            self.btnCancel.show()
        elif state == "import":
            self.callback = stuff
            self.btnSaveLoadXml.set_label(gtk.STOCK_OPEN)
            self.btnCancel.show()
            self.lblStatsFormatHeader.set_sensitive(False)
            self.nbImportExport.connect("switch-page", self.blockStatsPage)
        self.initAllSections()
        self.window.show()
    
    def blockStatsPage(self, nb, page, page_num):
        if page_num == nb.page_num(self.scwStats):
            nb.emit_stop_by_name("switch-page")
        
    def confirm(self, *stuff):
        if self.state == "export" or self.state == "import":
            notebook = self.nbImportExport
            pageNumber = self.nbImportExport.get_current_page()
            pageLabel = notebook.get_tab_label_text(notebook.get_nth_page(pageNumber)).lower()
            if pageLabel == "eft": buffer = self.txwEftFormat.get_buffer()
            elif pageLabel == "xml": buffer = self.txwXmlFormat.get_buffer()
            else: buffer = self.txwStats.get_buffer()
            text = buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter())
            if self.state == "export":
                clipboard = gtk.clipboard_get()
                clipboard.set_text(text)
                clipboard.store()
                return self.exit()
            if pageLabel == "eft":
                if self.callback('eft', text): return self.exit()
            elif pageLabel == "xml":
                if self.callback('xml', text): return self.exit()
            else: return self.exit()

        return False

    def exit(self, *stuff):
        self.window.destroy()
        return False   
    
    def saveLoadXml(self, *stuff):
        self.fileChooser = gtk.FileChooserDialog("XML " + self.state.capitalize(),
                                                 None,
                                                 gtk.FILE_CHOOSER_ACTION_SAVE)
        self.fileChooser.add_button(gtk.STOCK_CANCEL, 0)
        self.fileChooser.add_button(gtk.STOCK_OK, 1)
        self.fileChooser.set_current_name(self.name + ".xml")
        self.fileChooser.connect("response", self.processResponse)
        self.fileChooser.show()
        
    def processResponse(self, widget, response):
        if response == 0: self.fileChooser.destroy()
        elif response == 1:
            path = self.fileChooser.get_filename()
            if path != None:
                if self.state == "export":
                    with open(path, "w") as f: f.write(self.fit.exportXml(self.name))
                elif self.state == "import":
                    try:
                        with open(path, "r") as f: xml = f.read()
                    except: xml = ""
                    self.txwXmlFormat.get_buffer().set_text(xml)
                self.fileChooser.destroy()
                
importExportWindow = pluggable(importExportWindow)