#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
__all__ = ["characterSelection", "damagePatternMenu", "droneBrowser", "fittingPane",
           "gangBrowser", "groupBrowser", "implantsBoostersBrowser", "importExport",
           "itemBrowser", "missingSkillsIcon", "priceCheckInterface", "projectedBrowser",
           "reloadTimeMenu", "setupBrowser"]

import gtk
import sys
from gui.pluggable import pluggable
from gui.window import window
from model import fitting, character, dataFolder, priceCheck, sql
import itertools
import gobject

#Without this we'll get thread problems
gtk.gdk.threads_init()

class mainWindow(window):
    _instance = None
    def __init__(self):
        mainWindow._instance = self
        window.__init__(self, "main")
        self.initPluggable()
        
        self.fits = fitting.loadFits()
        self.characters = character.loadCharacters()
        self.guiSettings = dataFolder.pickleFileToObj("guiSettings") or {}
        
        self.btnClose.connect("clicked", self.exit)
        self.window.connect("destroy", self.exit)
        
        gobject.signal_new("save-request", self, gobject.SIGNAL_RUN_LAST,
                       gobject.TYPE_NONE, ())
        
        for name in __all__:
            section = __import__("gui.mainWindow." + name,fromlist=True)
            self.addSection(name, section)
        self.initAllSections()
        ##Check to see if any sizing was saved, if there was, use it
        if "windowMaximized" in self.guiSettings and self.guiSettings["windowMaximized"]:
            self.window.maximize()
        else:
            if "windowPosition" in self.guiSettings:
                self.window.move(*self.guiSettings["windowPosition"])
            if "windowSize" in self.guiSettings:
                self.window.set_default_size(*self.guiSettings["windowSize"])
            
        #Hack to get window position reliably
        self.window.connect('configure-event', self.__store_position)
        
        self.window.show()
    
    def __store_position(self, event, position):
        self.window._position = (position.x, position.y) 
    
    @staticmethod 
    def main():
        gtk.gdk.threads_enter()
        gtk.main()
        gtk.gdk.threads_leave()
    
    def exit(self, *stuff):
        #Before gtk dies out, we need to save our window's state
        self.guiSettings["windowMaximized"] = self.window.maximize_initially
        pos = self.window.get_position()
        if pos[0] or pos[1]:
            self.guiSettings["windowPosition"] = self.window.get_position()
        else:
            self.guiSettings["windowPosition"] = self.window._position
        self.guiSettings["windowSize"] = self.window.get_size()
        self.emit("save-request")
        gtk.main_quit()
        fitting.saveFits(self.fits)
        character.saveCharacters(self.characters)
        dataFolder.pickleObjToFile((self.activePattern, self.damagePatterns), "dmg")
        dataFolder.pickleObjToFile(self.guiSettings, "guiSettings")
        priceCheck.savePriceCache()
        sql.getConnection().close()
        sys.exit()
            
    def generateMenu(self, entries, *args):
        menu = gtk.Menu()
        for widget, callback in entries.iteritems():
            menu.append(self.generateMenuItem(widget, callback, *args))
        return menu
    
    def generateMenuItem(self, widget, callback, *args):
        menuItem = gtk.MenuItem()
        menuItem.add(widget)
        try: widget.set_alignment(0, 0.5)
        except: pass
        if callback: menuItem.connect("activate", callback, *args)
        return menuItem
    
    def generateHBox(self, *widgets):
        box = gtk.HBox()
        for widget in widgets: box.pack_start(widget, False)
        return box
        
    def generateVBox(self, *widgets):
        box = gtk.VBox()
        for widget in widgets: box.pack_start(widget, False)
        return box
    
mainWindow = pluggable(mainWindow)