#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
import fittingPane
from gui.characterEditorWindow import characterEditorWindow

dependencies = (fittingPane,)
def init(self):
    store = gtk.ListStore(str, object)
    self.cmbCharacter.set_model(store)
    nameRenderer = gtk.CellRendererText()
    self.cmbCharacter.pack_start(nameRenderer, True)
    self.cmbCharacter.add_attribute(nameRenderer, 'text', 0)
    store.set_sort_column_id(0, gtk.SORT_ASCENDING)
    if not "activeCharacter" in self.guiSettings:
        self.guiSettings["activeCharacter"] = "All 0"
    self.activeCharacter = self.guiSettings["activeCharacter"]
    
    for name, char in self.characters.iteritems():
        iter = store.append((name, char))
        if name == self.activeCharacter: self.cmbCharacter.set_active_iter(iter)
        
    self.cmbCharacter.connect("changed", self.activeCharacterChanged)
    self.btnEditCharacter.connect("clicked", self.characterEditor)
    
    #Set tooltips
    self.setTooltips(**{"btnEditCharacter" : "Manage characters"})

def activeCharacterChanged(self, *stuff):
    self.emit("fitting-changed")

def getActiveCharacter(self):
    store = self.cmbCharacter.get_model()
    iter = self.cmbCharacter.get_active_iter()
    if iter == None: return None
    return store.get(iter, 1)[0]
    
def characterEditor(self, source):
    store = self.cmbCharacter.get_model()
    path = self.cmbCharacter.get_active()
    if path == -1 or path == None:
        self.activeCharacter = None
    else:
        iter = store.get_iter(path)
        char = store.get(iter, 1)[0]
        self.activeCharacter = char.name
    editor = characterEditorWindow(self)
    
def updateCharacters(self):
    store = self.cmbCharacter.get_model()
    store.clear()

    for name, char in self.characters.iteritems():
        store.append((name, char))
    if self.activeCharacter:
        self.guiSettings["activeCharacter"] = self.activeCharacter
        iter = store.get_iter_first()
        while iter:
            char = store.get(iter, 1)[0]
            if char.name == self.activeCharacter:
                path = store.get_path(iter)[0]
                self.cmbCharacter.set_active(path)
                return
            iter = store.iter_next(iter)
        
    self.cmbCharacter.set_active(0)
    
def generateCharacterMenu(self, callback, parent = None):
    store = self.cmbCharacter.get_model()
    iter = store.iter_children(parent)
    if iter == None: return
    menu = gtk.Menu()
    while iter:
        menuItem = gtk.MenuItem()
        char, name = store.get(iter, 1, 0)
        lbl = gtk.Label(name)
        lbl.set_alignment(0.0, 0.5)
        menuItem.add(lbl)
        menuItem.show_all()
        menuItem.connect("activate", callback, char)
        menu.append(menuItem)
        iter = store.iter_next(iter)
        
    return menu