#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from model import priceCheck
from gui import pixbufLoader
import gobject
import implantsBoostersBrowser, fittingPane, droneBrowser
dependencies = (implantsBoostersBrowser, fittingPane, droneBrowser)
def init(self):
    self.eboxPrice.connect("button-press-event", self.priceCheckWidgetClicked)
    self.connect("fitting-changed", self.requestPrices)
    #Load the price cache from disk
    priceCheck.loadPriceCache()
    #Make a thread to fetch price updates
    priceCheck.startThread()
    #Set option to default value if it's not there
    if not "priceColumn" in self.guiSettings:
        self.guiSettings["priceColumn"] = False
    self.priceColumnEnabled = False
    #Make menu so users can disable/enable price checking
    self.priceCheckMenu = gtk.Menu()
    menuItem = gtk.MenuItem()
    self.priceCheckToggle = gtk.CheckButton("Fetch item prices")
    #Set to "not" enabled because the updater method inverses it
    self.priceCheckToggle.set_active(not priceCheck.enabled)
    menuItem.add(self.priceCheckToggle)
    menuItem.connect("activate", self.updatePriceCheckStatus)
    self.priceCheckMenu.add(menuItem)
    #Menu for adding the column
    menuItem = gtk.MenuItem()
    self.priceColumnToggle = gtk.CheckButton("Add price column")
    self.priceColumnToggle.set_active(not self.guiSettings["priceColumn"])
    menuItem.add(self.priceColumnToggle)
    menuItem.connect("activate", self.updatePriceColumnStatus)
    self.priceCheckMenu.add(menuItem)
    #Clear price cache menu
    menuItem = gtk.MenuItem()
    menuItem.add(gtk.Label("Clear price cache"))
    menuItem.connect("activate", self.clearPriceCache)
    self.priceCheckMenu.add(menuItem)
    #Column for pricing info on modules
    self.priceColumn = gtk.TreeViewColumn()
    textRenderer = gtk.CellRendererText()
    self.priceColumn.pack_start(textRenderer, False)
    self.priceColumn.add_attribute(textRenderer, 'text', 13)
    #same for drones
    self.priceColumnDrone = gtk.TreeViewColumn()
    textRenderer = gtk.CellRendererText()
    self.priceColumnDrone.pack_start(textRenderer, False)
    self.priceColumnDrone.add_attribute(textRenderer, 'text', 5)
    #And now implants
    self.priceColumnImplants = gtk.TreeViewColumn()
    textRenderer = gtk.CellRendererText()
    self.priceColumnImplants.pack_start(textRenderer, False)
    self.priceColumnImplants.add_attribute(textRenderer, 'text', 5)
    
    self.updatePriceCheckStatus()
    self.updatePriceColumnStatus()

def priceCheckWidgetClicked(self, widget, event):
    if event.button == 3:
        self.priceCheckMenu.show_all()
        self.priceCheckMenu.popup(None, None, None, event.button, event.time)

def clearPriceCache(self, *stuff):
    priceCheck.clearCache()
    self.requestPrices()
    
def priceUpdateCallback(self):
    #We can't change things directly without running into a GIL
    #Schedule gtk to run it in the next idle cycle
    gobject.idle_add(self.priceUpdate)
    
def updatePriceCheckStatus(self, *stuff):
    enabled = not self.priceCheckToggle.get_active()
    self.priceCheckToggle.set_active(enabled)
    priceCheck.enabled = enabled
    self.requestPrices()
    self.priceColumnToggle.set_active(not self.priceColumnToggle.get_active())
    self.updatePriceColumnStatus()
    
def updatePriceColumnStatus(self, *stuff):
    priceCheckEnabled = self.priceCheckToggle.get_active()
    enabled = not self.priceColumnToggle.get_active()
    self.priceColumnToggle.set_active(enabled)
    self.guiSettings["priceColumn"] = enabled
    if enabled and priceCheckEnabled and not self.priceColumnEnabled:
        self.tvwModules.insert_column(self.priceColumn, 5)
        self.tvwDrones.append_column(self.priceColumnDrone)
        self.tvwImplantsBoosters.append_column(self.priceColumnImplants)
        #images are shy, REALLY shy
        pixbuf = pixbufLoader.getPixbuf("isk")
        imgModulesIsk = gtk.image_new_from_pixbuf(pixbuf)
        imgModulesIsk.show()
        self.priceColumn.set_widget(imgModulesIsk)
        imgDroneIsk = gtk.image_new_from_pixbuf(pixbuf)
        imgDroneIsk.show()
        self.priceColumnDrone.set_widget(imgDroneIsk)
        imgImplantIsk = gtk.image_new_from_pixbuf(pixbuf)
        imgImplantIsk.show()
        self.priceColumnImplants.set_widget(imgImplantIsk)
        self.priceColumnEnabled = True
    elif (not enabled or not priceCheckEnabled) and self.priceColumnEnabled:
        self.tvwModules.remove_column(self.priceColumn)
        self.tvwDrones.remove_column(self.priceColumnDrone)
        self.tvwImplantsBoosters.remove_column(self.priceColumnImplants)
        self.priceColumnEnabled = False

def requestPrices(self, *stuff):
    self.lblPriceShipUnit.set_text(" ISK")
    self.lblPriceFittingsUnit.set_text(" ISK")
    self.lblPriceTotalUnit.set_text(" ISK")
    fit = self.getActiveFit()
    if priceCheck.enabled and fit != None:
        self.lblPriceShip.set_text("...")
        self.lblPriceFittings.set_text("...")
        self.lblPriceTotal.set_text("...")
        
        priceCheck.scheduleRequest(fit.ship.ID, self.priceUpdateCallback)
        
        for mod in fit.modules:
            priceCheck.scheduleRequest(mod.getItem().ID, self.priceUpdateCallback)
            
        for drone in fit.drones:
            priceCheck.scheduleRequest(drone.getItem().ID, self.priceUpdateCallback)
            
        for implant in fit.implants.itervalues():
            priceCheck.scheduleRequest(implant.ID, self.priceUpdateCallback)
            
        priceCheck.update()
    else:
        for lbl in ("lblPriceShip", "lblPriceFittings", "lblPriceTotal"):
            getattr(self, lbl).set_text("0.00")
            getattr(self, lbl + "Unit").set_text(" ISK")
            
    #Do a first update of the prices to display prices we already got immediatly
    self.priceUpdate()
        
def formatPrice(self, price):
    if price >= 1000000000:
        price /= 1000000000.0
        unit = "b"
    elif price >= 1000000:
        price /= 1000000.0
        unit = "m"
    else:
        price /= 1000.0
        unit = "k"
    return price, unit

def priceUpdate(self):
    fit = self.getActiveFit()
    if fit == None: return True
    price = 0
    shipPrice = priceCheck.getPrice(fit.ship.ID)
    for module in fit.modules:
        currPrice = priceCheck.getPrice(module.getItem().ID)
        module.price = currPrice
        price += currPrice
        
    for drone in fit.drones:
        currPrice = priceCheck.getPrice(drone.getItem().ID)
        drone.price = currPrice
        price += currPrice * drone.getAmountTotal()
        
    for implant in fit.implants.itervalues():
        currPrice = priceCheck.getPrice(implant.ID)
        implant.price = currPrice
        price += currPrice
    
        
    store = self.tvwModules.get_model()
    iter = store.get_iter_first()
    while iter:
        mod = store.get_value(iter, 9)
        if mod:
            modPrice, unit = self.formatPrice(mod.price)
            if unit != "k": store.set(iter, 13, "%.1f%s" % (modPrice, unit))
            elif modPrice == 0: store.set(iter, 13, "N/A")
            else: store.set(iter, 13, "%.0f%s" % (modPrice, unit))
        iter = store.iter_next(iter)
    store = self.tvwDrones.get_model()
    iter = store.get_iter_first()
    while iter:
        drone, active = store.get(iter, 4, 3)
        ##Make sure the drone is still there, it could have been removed while we fetch
        if drone in fit.drones:
            totalAmount, activeAmount = drone.getAmountTotal(), drone.getAmountActive()
            amount = active and activeAmount or totalAmount - activeAmount
            dronePrice, unit = self.formatPrice(drone.price * amount)
            if unit != "k": store.set(iter, 5, "%.1f%s" % (dronePrice, unit))
            elif dronePrice == 0: store.set(iter, 5, "N/A")
            else: store.set(iter, 5, "%.0f%s" % (dronePrice, unit))
            iter = store.iter_next(iter)
    store = self.tvwImplantsBoosters.get_model()
    iter = store.get_iter_first()
    while iter:
        type = store.get_value(iter, 1)
        if type == "Implants":
            iter = store.iter_children(iter)
            while iter:
                implant = store.get_value(iter, 4)
                implantPrice, unit = self.formatPrice(implant.price)
                if unit != "k": store.set(iter, 5, "%.1f%s" % (implantPrice, unit))
                elif implantPrice == 0: store.set(iter, 5, "N/A")
                else: store.set(iter, 5, "%.0f%s" % (implantPrice, unit))
                iter = store.iter_next(iter)
            break
        iter = store.iter_next(iter)
    
    todo = ((shipPrice, "lblPriceShip"),
            (price, "lblPriceFittings"),
            (price + shipPrice, "lblPriceTotal"))
    for price, label in todo:
        price, unit = self.formatPrice(price)
        getattr(self, label + "Unit").set_text(" " + unit + " ISK")
        getattr(self, label).set_text("%.2f" % price)
    return False
