#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from model import item, fitting
from model.fitting import projectedEffect, module
from gui import pixbufLoader
from gui.itemStatsWindow import itemStatsWindow

def init(self):
    self.connect("fitting-changed", self.handleFittingChangedProj)
    self.tvwProj.connect("button-press-event", self.tvwProjClicked)
    self.tvwItems.connect("button-press-event", self.manageProjectedItemEntry)
        
    #State, pixbuf, amount, name, description, module
    store = gtk.ListStore(bool, gtk.gdk.Pixbuf, str, str, str, object)
    self.tvwProj.set_model(store)
    self.tvwProj.set_tooltip_column(4)
    activeRenderer = gtk.CellRendererToggle()
    activeRenderer.set_property("activatable", True)
    pixbufRenderer = gtk.CellRendererPixbuf()
    amountRenderer = gtk.CellRendererText()
    nameRenderer = gtk.CellRendererText()
    
    nameCol = gtk.TreeViewColumn('Item')
    self.projStateCol = gtk.TreeViewColumn()
    
    self.projStateCol.pack_start(activeRenderer, False)
    nameCol.pack_start(pixbufRenderer, False)
    nameCol.pack_start(amountRenderer, False)
    nameCol.pack_start(nameRenderer, False)
    
    self.projStateCol.add_attribute(activeRenderer, 'active', 0)
    nameCol.add_attribute(pixbufRenderer, 'pixbuf', 1)
    nameCol.add_attribute(amountRenderer, 'text', 2)
    nameCol.add_attribute(nameRenderer, 'text', 3)
    
    self.tvwProj.append_column(self.projStateCol)
    self.tvwProj.append_column(nameCol)
    
    #Generate menus
    self.projectedViewStatsLabel = gtk.Label("Stats")
    self.projectedViewStatsEntry = self.generateMenuItem(self.projectedViewStatsLabel, self.projItemStats)
    self.projectedViewGroupLabel = gtk.Label("Market Group")
    self.projectedViewGroupEntry = self.generateMenuItem(self.projectedViewGroupLabel, self.projItemGroup)
    self.projectedAddLabel = gtk.Label("Add as Projected Effect")
    self.projectedAddEntry = self.generateMenuItem(self.projectedAddLabel, self.addProjModule)
    self.projectedMenu = self.generateMenu({})

    shipPixbuf = pixbufLoader.getPixbuf("ships")
    box = self.generateHBox(gtk.image_new_from_pixbuf(shipPixbuf), gtk.Label("Add Fit"))
    self.projectedAddFitEntry = self.generateMenuItem(box, None)
    self.projectedMenu.append(self.projectedAddFitEntry)

def handleFittingChangedProj(self, *stuff):
    fit = self.getActiveFit()
    if fit == None: self.tvwProj.get_model().clear()
    else: self.updateProjectedEffects()
    
def projItemStats(self, *stuff):
    effect = self.getSelectedProjEffect()
    source = effect.getSource()
    if isinstance(source, fitting.fitting):
        source = source.ship
        icon = pixbufLoader.getPixbuf(effect.race)
    else:
        source = source.getItem()
        icon = None
    itemStatsWindow(source, self.getActiveFit(), icon)
    
def projItemGroup(self, *stuff): self.expandToItem(self.getSelectedProjEffect())

def getSelectedProjEffect(self):
    store = self.tvwProj.get_model()
    select = self.tvwProj.get_cursor()[0]
    if select == -1 or select == None: return
    iter = store.get_iter(select)
    return store.get_value(iter, 5)

def manageProjectedItemEntry(self, widget, event):
    widget.do_button_press_event(widget, event)
    item = self.getSelectedItem()
    if item == None: return
    fit = self.getActiveFit()
    if fit == None: return
    if "projected" in item.getType() and not self.projectedAddEntry in self.itemBrowserItemMenuExternals:
        self.itemBrowserItemMenuExternals.append(self.projectedAddEntry)
        self.projectedAddEntry.show_all()
    elif (not "projected" in item.getType() or fit == None) and self.projectedAddEntry in self.itemBrowserItemMenuExternals:
        self.itemBrowserItemMenuExternals.remove(self.projectedAddEntry)
 
def updateProjectedEffects(self):
    fit = self.getActiveFit()
    if fit == None: return
    store = self.tvwProj.get_model()
    select = self.tvwProj.get_cursor()[0]
    store.clear()
    for projEffect in fit.projEffects:
        source = projEffect.getSource()
        if isinstance(source, module.module):
            item = source.getItem()
            icon = pixbufLoader.getPixbuf(item.icon, True, "16x16")
            name = item.name
            description = item.description
        else:
            icon = pixbufLoader.getPixbuf("ships")
            name = None
            if source.ship.group in self.fits and source.ship in self.fits[source.ship.group]:
                fits = self.fits[source.ship.group][source.ship]
                description = "%s - %s" % (source.ship.name, source.ship.group.name)
                for n, fit in fits.iteritems():
                    if fit == source:
                        name = n
                        break
            else: continue
        active = projEffect.getAmountActive() > 0
        amount = projEffect.getAmountTotal()
        if name != None: store.append((active, icon, "%dx" % amount, name, description, projEffect))
    
    l = len(fit.projEffects) -1
    if select != None and select != -1 and select[0] <= l and l != 0: self.tvwProj.set_cursor(select)
    
def tvwProjClicked(self, widget, event):
    widget.do_button_press_event(widget, event)
    col = widget.get_path_at_pos(int(event.x), int(event.y))
    if col and col[1] == self.projStateCol:
        col = col[1]
        if event.button == 1:
            fit = self.getActiveFit()
            if fit == None: return
            path = widget.get_cursor()[0]
            store = widget.get_model()
            iter = store.get_iter(path)
            projEffect = store.get_value(iter, 5)
            if projEffect.getAmountActive() > 0: newAmount = 0
            else: newAmount = projEffect.getAmountTotal()
            projEffect.setAmountActive(newAmount)
            self.emit("fitting-changed")
            
    elif event.button == 1 and event.type == gtk.gdk._2BUTTON_PRESS:
        effect = self.getSelectedProjEffect()
        fit = self.getActiveFit()
        if fit == None or effect == None: return
        newTotal = effect.getAmountTotal() - 1
        if newTotal == 0: fit.projEffects.remove(effect)
        else: effect.setAmountTotal(newTotal)
        if isinstance(effect.getSource(), item.item): self.manageRecent(effect.getSource())
        self.emit("fitting-changed")
    elif event.button == 3:
        fit = self.getActiveFit()
        if fit == None: return
        self.projectedAddFitEntry.set_submenu(self.generateFitMenu(self.addProjFit))
        effect = self.getSelectedProjEffect()
        children = self.projectedMenu.get_children()
        if effect and not self.projectedViewStatsEntry in children:
            self.projectedMenu.append(self.projectedViewStatsEntry)
        elif not effect and self.projectedViewStatsEntry in children:
            self.projectedMenu.remove(self.projectedViewStatsEntry)
            
        if effect and not isinstance(effect.getSource(), fitting.fitting)\
         and not self.projectedViewGroupEntry in children:
            self.projectedMenu.append(self.projectedViewGroupEntry)
        elif (not effect or isinstance(effect.getSource(), fitting.fitting))\
         and  self.projectedViewGroupEntry in children:
            self.projectedMenu.remove(self.projectedViewGroupEntry)

        self.projectedMenu.show_all()
        self.projectedMenu.popup(None, None, None, event.button, event.time)

def addProjEffect(self, fit, newEffect):
    existing = None
    for effect in fit.projEffects:
        source = effect.getSource()
        if (isinstance(source, fitting.fitting) and source == newEffect) or \
           (isinstance(source, module.module) and source.getItem() == newEffect):
            existing = effect
            break
    
    if isinstance(newEffect, item.item):
        newEffect = module.module(newEffect, fit, fitting.STATE_ACTIVE)
        
    if not existing:
        existing = projectedEffect.projectedEffect(newEffect, fit, 0, 0)
        fit.projEffects.append(existing)
        
    total = existing.getAmountTotal() + 1
    existing.setAmountTotal(total)
    existing.setAmountActive(total)
    
def addProjModule(self, *stuff):
    activeFit = self.getActiveFit()
    if activeFit == None: return
    mod = self.getSelectedItem()
    self.addProjEffect(activeFit, mod)
    self.emit("fitting-changed")
    
def addProjFit(self, widget, fit):
    activeFit = self.getActiveFit()
    if activeFit == None: return
    self.addProjEffect(activeFit, fit)
    self.emit("fitting-changed")
