#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk.gdk
from model.dataFolder import dataFolder
import os.path
import launch
pixbufCache = {}

def getPixbuf(name, extern = False, format = None):
    if name:
        try:
            return pixbufCache[name]
        except KeyError:
            if extern:
                path = os.path.join(dataFolder,
                                    "icons/",
                                    format.replace("x", "_"),
                                    "icon" + name.strip() + ".png")
            else:
                path = os.path.join(launch.basePath, "gui", "icons/", name.strip() + ".png")
            if os.path.exists(path):
                pixbuf = gtk.gdk.pixbuf_new_from_file(path)
            else:
                print "missing Icon:", path
                pixbuf = None
                
            pixbufCache[name] = pixbuf
            return pixbuf
    else:
        return None
