from model import dataFolder
import os
import types
import sys

sys.path.append(os.path.join(os.getcwd(), "plugins"))
sys.path.append(os.path.join(dataFolder.dataFolder, "plugins"))   

blockedSections = set()
def block(section): blockedSections.add(section)

def load():
    basePaths = []
    if os.path.exists(os.path.join(dataFolder.dataFolder, "plugins")):
        basePaths.append(os.path.join(dataFolder.dataFolder, "plugins"))
    if os.path.exists("plugins"): basePaths.append("plugins")
    for path in basePaths:
        for plugin in os.listdir(path):
            __import__(plugin)

def pluggable(cl):
    def initPluggable(self):
        self.initedSections = set()
    
    @staticmethod
    def addSection(name, section):
        cl.sections[name] = section
        
    def initAllSections(self):
        for section in cl.sections.itervalues(): self.initSection(section)
        
    def initSection(self, section):
        sections = self.sections
        initedSections = self.initedSections
        if not section in initedSections and not section in blockedSections:
            for name in dir(section):
                elem = getattr(section, name)
                if type(elem) == types.FunctionType: setattr(cl, name, elem)
            #Put in this module in the initedSections set before figuring out depencies
            #This way circular depencies don't crash us
            initedSections.add(section)
            try:
                dependencies = getattr(section, "dependencies")
                for dependency in dependencies:
                    if not dependency in initedSections: self.initSection(dependency)
            except: pass
            try: init = getattr(section, "init")
            except: init = None
            if init != None: 
                try:
                    init(self)
                except:
                    import traceback
                    traceback.print_exc()
        
    cl.sections = {}
    cl.initPluggable = initPluggable
    cl.initAllSections = initAllSections
    cl.initSection = initSection
    cl.addSection = addSection
    return cl

