#!/usr/bin/env python
#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import sys
import os.path
from multiprocessing import freeze_support

if hasattr(sys, "frozen"): basePath = os.path.dirname(unicode(sys.executable, sys.getfilesystemencoding( )))
else: basePath = os.path.dirname(unicode(__file__, sys.getfilesystemencoding( )))
sys.path.append(basePath)
if __name__ == "__main__":
    freeze_support()
    import platform
    import gtk
    import warnings
    import thread
    import os.path
    from optparse import OptionParser
    from model import sql, updater, dataFolder
    from model.dataFolder import setDataFolder
    from gui import mainWindow, pluggable, preloader, updaterDialog
    version = platform.python_version_tuple()
    if int(version[0]) is 2 and int(version[1]) < 6:
        sys.stderr.write("WARNING: Python version needs to be at least 2.6.\n")
        sys.stderr.write("trying to run anyway, but expect errors or missing stats.\n")
    
    usage = "usage: %prog [options]"
    parser = OptionParser(usage=usage)
    parser.add_option("-s", "--silent", action="store_false", dest="verbose", help="suppress all errors", default=True)
    parser.add_option("-g", "--gtkverbose", action="store_true", dest="gtkverbose", help="show gtk errors", default=False)
    parser.add_option("-l", "--nopreload", action="store_false", dest="preload", help="disable preload", default=True)
    parser.add_option("-p", "--noplugins", action="store_false", dest="plugins", help="ignore plugins", default=True)
    parser.add_option("-u", "--noupdate", action="store_false", dest="update", help="Don't autoupdate", default=True)
    parser.add_option("-d", "--datafolder", help="folder to store data, you can specify 'root', 'home' or a direct path. The default is home", default="home")
    (options, args) = parser.parse_args()

    setDataFolder(os.path.expanduser(options.datafolder))
    
    if options.verbose == False:
        f = open(os.path.join(dataFolder.dataFolder, "pyfa.log"), "w")
        sys.stderr = f
        sys.stdout = f
    
    if options.gtkverbose == False:
        import pango
        warnings.simplefilter('ignore', gtk.Warning)
        warnings.simplefilter('ignore', pango.Warning)

    
    if options.plugins == True:
        pluggable.load()

    if os.path.exists(os.path.join(dataFolder.dataFolder, "eve.db")):
        sql.connect("sqlite")
        window = mainWindow.mainWindow()
        if options.preload == True:
            thread.start_new_thread(preloader.preload, (window, ))
    
    if options.update == True:
        updaterDialog.checkAndRun()
        
    mainWindow.mainWindow.main()
