import __init__ as fitting
class module(object):
    def __init__(self, item, fit = None, state = None, ammo = None):
        self.setItem(item)
        self.setAmmo(ammo)
        self.setFit(fit)
        self.setState(state)
        
    def getItem(self): return self.__item
    def setItem(self, item): self.__item = item
    
    def getSlot(self):
        #We can't assume calculateModifiedAttributes() has been called before. Work around it.
        slot = self.getItem().getModifiedAttribute("_slot")
        if slot: return slot
        for effect in self.getItem().effects:
            try: effect.func(effect, None, None)
            except Exception: pass
        
        return self.getItem().getModifiedAttribute("_slot")
    
    def getFit(self): return self.__fit
    def setFit(self, fit): self.__fit = fit
    
    def getState(self): return self.__state
    def setState(self, state):
        """A bare setter - does not call isValidState because we need to set module states outside of a fit"""
        self.__state = state
    
    def isValidState(self, state):
        canChange = True
        item = self.getItem()
        if not isinstance(state, int): canChange = False
        elif state == fitting.STATE_INACTIVE: canChange = "active" in item.getType()
        elif state == fitting.STATE_OVERLOADED: canChange = "overload" in item.getType()
        if state >= fitting.STATE_ACTIVE and canChange:
            maxGroupActive = item.getModifiedAttribute("maxGroupActive")
            if (self.getFit() and item in self.getFit().blockedItems) or item.ID == 0:
                canChange = False
            elif maxGroupActive == None:
                canChange = True
            else:
                #Check for a maxGroupActive limit
                canChange = len(
                    [ mod for mod in self.getFit().modules if self.isSameModuleGroup(mod) and mod.getState() >= fitting.STATE_ACTIVE ]
                ) <= maxGroupActive
        
        return canChange

    def isSameModuleGroup(self, other_module):
        return other_module.getItem().ID != 0 and other_module.getItem().group.name == self.getItem().group.name
    
    def getAmmo(self): return self.__ammo
    def setAmmo(self, ammo): self.__ammo = ammo
        
    def isValidAmmo(self, ammo):
        #Check sizes, if ammo size > module volume it won't fit
        if ammo == None: return True
        item = self.getItem()
        chargeVolume = ammo.getModifiedAttribute("volume")
        moduleCapacity = item.getModifiedAttribute("capacity")
        if chargeVolume > moduleCapacity: return False
        
        chargeSize = item.getModifiedAttribute("chargeSize")
        if chargeSize != None:
            ammoSize = ammo.getModifiedAttribute('chargeSize')
            if chargeSize != ammoSize: return False

        ammoGroup = ammo.groupID
        for i in range(5):
            chargeGroup = item.getModifiedAttribute('chargeGroup' + str(i))
            if chargeGroup == None: continue
            if ammoGroup == chargeGroup: return True
            
        return False
