import sys
import os
import dataFolder

def override(object, override):
    if override:
        for key in dir(override):
            if key[:2] != "__":
                setattr(object, key, getattr(override, key))
        
def getOverride(itemName, path, key): return getattr(getOverrideModule(itemName, path), key)

def getOverrideModule(itemName, path):
    for basePath in (dataFolder.dataFolder, "", "model"):
        fullPath = os.path.join(basePath, "overrides", itemName, *path[:-1]).encode("ascii", "ignore")
        if os.path.isdir(fullPath):
            sys.path.append(fullPath)
            modName = path[len(path) - 1]
            try:
                overrides = __import__(modName)
                #Remove the freshly loaded module from the module cache
                #If we don't do this we can get very weird mixups
                del sys.modules[modName]
            except: overrides = None
            sys.path.pop()
            if overrides: return overrides
    return None

def getDirList(itemName, path):
    l = []
    for basePath in (dataFolder.dataFolder, ""):
        fullPath = os.path.join(basePath, "overrides", itemName, *path).encode("ascii", "ignore")
        if os.path.isdir(fullPath):
            l += os.listdir(fullPath)
            i = len(l) -1
            while i >= 0:
                elem = l[i]
                if not os.path.isdir(os.path.join("overrides", itemName, *(path + (elem,))).encode("ascii", "ignore")): del l[i]
                i -= 1
    return set(l)

def getModList(itemName, path):
    l = []
    for basePath in (dataFolder.dataFolder, ""):
        fullPath = os.path.join(basePath, "overrides", itemName, *path)
        if os.path.isdir(fullPath):
            l += os.listdir(fullPath)
            i = len(l) -1
            while i >= 0:
                elem = l[i]
                if elem[-3:] != ".py" or \
                  os.path.isdir(os.path.join("overrides", itemName, *(path + (elem,)))):
                    del l[i]
                else: l[i] = elem[:-3]
                i -= 1
    return set(l)

def getItemList():
    l = []
    for basePath in (dataFolder.dataFolder, ""):
        fullPath = os.path.join(basePath, "overrides").encode("ascii", "ignore")
        if os.path.isdir(fullPath): l += os.listdir(fullPath)
    return set(l)
