from model import dataFolder
from xml.dom import minidom
import urllib2
import string
import time
import threading

priceCache = None
enabled = None
updateRequests = {}
ev = threading.Event()

class priceUpdaterThread(threading.Thread):               
    def run(self):
        while True: processUpdates()

def startThread():
    thread = priceUpdaterThread()
    thread.daemon = True
    thread.start()

def clearCache(): priceCache.clear()
    
def update(): ev.set()
    
def scheduleRequest(typeID, callback): updateRequests[typeID] = callback
    
def getPrice(typeID):
    if typeID in priceCache:
        p = priceCache[typeID][0]
    else:
        p = None
    return p or 0

def processNow():
    ev.set()
    processUpdates()
    
def processUpdates():
    ev.wait()
    ev.clear()
    currentTime = time.time()
    callbacks = set()
    idstr = ""
    for typeID in updateRequests.keys():
        callbacks.add(updateRequests[typeID])
        if not typeID in priceCache or currentTime - priceCache[typeID][1] >= 86400:
            idstr += "%s%d" % (len(idstr) > 0 and "," or "", typeID)

    if idstr:
        requestString = "http://eve-metrics.com/api/item.xml?key=0CA18A72373F05EA4CA53&region_ids=10000002regionlimit=10000002&type_ids=" + idstr
        request = urllib2.Request(requestString, None, {"User-Agent" : "pyfa"})
        try: f = urllib2.urlopen(request)
        except:
            #We got an error, fill the prices with zeros with  minutes cache time
            #and call callbacks
            for typeID in updateRequests.iterkeys():
                currPrice = typeID in priceCache and priceCache[typeID][0] or 0
                priceCache[typeID] = (currPrice, currentTime - 86401)
            updateRequests.clear()
            for callback in callbacks: callback()
            return
        
        xml = minidom.parse(f)
        marketStat = xml.getElementsByTagName("evemetrics").item(0)
        if marketStat != None:
            types = marketStat.getElementsByTagName("type")
            for type in types:
                id = int(type.getAttribute("id"))
                region = type.getElementsByTagName("region").item(0)
                sell = type.getElementsByTagName("sell").item(0)
                median = float(sell.getElementsByTagName("median").item(0).firstChild.data)
                priceCache[id] = (median, currentTime)

    #The remaining requests failed
    for typeID in updateRequests.iterkeys():
        if not typeID in priceCache: priceCache[typeID] = (0, currentTime)
    updateRequests.clear()
    for callback in callbacks: callback()
    
def loadPriceCache():
    global priceCache, enabled
    data = dataFolder.pickleFileToObj("priceCache")
    if isinstance(data, tuple):
        enabled = data[0]
        priceCache = data[1]
    else:
        enabled = False
        priceCache = {}
        
def savePriceCache():
    global priceCache, enabled
    dataFolder.pickleObjToFile((enabled, priceCache), "priceCache")