#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.

import dataFolder
import os.path
import threading

local = threading.local()
def getConnection():
    return hasattr(local, "connection") and getattr(local, "connection") or None

def getDbType():
    return hasattr(local, "dbType") and getattr(local, "dbType") or None
    
def connect(t, host = None, username = None, pw = None, db = None):
    if t == "sqlite":
        import sqlite3
        local.connection = sqlite3.connect(os.path.join(dataFolder.dataFolder, "eve.db"))
    elif t == "mysql":
        import MySQLdb
        local.connection = MySQLdb.connect(host = host, user = username, passwd = pw, db = db)
    
    local.dbType = t

if __name__ == "__main__":
    print("This module defines the following:\n")
    for name in vars().keys():
        print("{0:20} = {1}".format(name, vars()[name]))
