/* -*- mode: c++; indent-tabs-mode: nil -*- */
/** @file InputStreamSaxIterator.qpp defines the InputStreamSaxIterator class */
/*
  QC_InputStreamSaxIterator.qpp

  Qore Programming Language

  Copyright (C) 2016 - 2022 Qore Technologies, s.r.o.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "qore-xml-module.h"

#include "QC_SaxIterator.h"
/* Qore class Qore::Xml::InputStreamSaxIterator */

qore_classid_t CID_INPUTSTREAMSAXITERATOR;
QoreClass* QC_INPUTSTREAMSAXITERATOR;

// InputStreamSaxIterator::constructor(Qore::InputStream is, string element_name, *string encoding) {}
static void InputStreamSaxIterator_constructor_C11InputStreamVsNs(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    HARD_QORE_VALUE_OBJ_DATA(is, InputStream, args, 0, CID_INPUTSTREAM, "InputStreamSaxIterator::constructor()", "Qore::InputStream", xsink);
    if (*xsink)
        return;
    const QoreStringNode* element_name = HARD_QORE_VALUE_STRING(args, 1);
    const QoreStringNode* encoding = get_param_value(args, 2).get<const QoreStringNode>();
# 48 "QC_InputStreamSaxIterator.qpp"
ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(is, element_name->getBuffer(), encoding ? encoding->getBuffer() : nullptr, nullptr, xsink), xsink);
   if (*xsink)
      return;
   self->setPrivate(CID_INPUTSTREAMSAXITERATOR, holder.release());
   self->setValue("is", static_cast<QoreObject *>(obj_is->refSelf()), xsink);
}

// InputStreamSaxIterator::constructor(Qore::InputStream is, string element_name, hash opts) {}
static void InputStreamSaxIterator_constructor_C11InputStreamVsVh(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    HARD_QORE_VALUE_OBJ_DATA(is, InputStream, args, 0, CID_INPUTSTREAM, "InputStreamSaxIterator::constructor()", "Qore::InputStream", xsink);
    if (*xsink)
        return;
    const QoreStringNode* element_name = HARD_QORE_VALUE_STRING(args, 1);
    const QoreHashNode* opts = HARD_QORE_VALUE_HASH(args, 2);
# 76 "QC_InputStreamSaxIterator.qpp"
const char* encoding = QoreSaxIterator::processOptionsGetEncoding(opts, "INPUTSTREAMSAXITERATOR-OPTION-ERROR", xsink);
   if (*xsink)
      return;
   ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(is, element_name->c_str(), encoding, opts, xsink), xsink);
   if (*xsink)
      return;
   self->setPrivate(CID_INPUTSTREAMSAXITERATOR, holder.release());
   self->setValue("is", static_cast<QoreObject*>(obj_is->refSelf()), xsink);
}

// InputStreamSaxIterator::copy() {}
static void InputStreamSaxIterator_copy(QoreObject* self, QoreObject* old, QoreSaxIterator* i, ExceptionSink* xsink) {
# 91 "QC_InputStreamSaxIterator.qpp"
xsink->raiseException("INPUTSTREAMSAXITERATOR-COPY-ERROR", "objects of this class cannot be copied");
}

DLLLOCAL void preinitInputStreamSaxIteratorClass() {
    QC_INPUTSTREAMSAXITERATOR = new QoreClass("InputStreamSaxIterator", "::Qore::Xml::InputStreamSaxIterator", QDOM_DEFAULT);
    CID_INPUTSTREAMSAXITERATOR = QC_INPUTSTREAMSAXITERATOR->getID();
    QC_INPUTSTREAMSAXITERATOR->setSystem();
}

DLLLOCAL QoreClass* initInputStreamSaxIteratorClass(QoreNamespace& ns) {
    if (!QC_INPUTSTREAMSAXITERATOR)
        preinitInputStreamSaxIteratorClass();

    // set parent class
    assert(QC_SAXITERATOR);
    QC_INPUTSTREAMSAXITERATOR->addBuiltinVirtualBaseClass(QC_SAXITERATOR);

    // private:internal members
    QC_INPUTSTREAMSAXITERATOR->addMember("is", Internal, QC_INPUTSTREAM->getTypeInfo());

    // InputStreamSaxIterator::constructor(Qore::InputStream is, string element_name, *string encoding) {}
    QC_INPUTSTREAMSAXITERATOR->addConstructor(InputStreamSaxIterator_constructor_C11InputStreamVsNs, Public, QCF_NO_FLAGS, QDOM_FILESYSTEM, 3, QC_INPUTSTREAM->getTypeInfo(), QORE_PARAM_NO_ARG, "is", stringTypeInfo, QORE_PARAM_NO_ARG, "element_name", stringOrNothingTypeInfo, QORE_PARAM_NO_ARG, "encoding");

    // InputStreamSaxIterator::constructor(Qore::InputStream is, string element_name, hash opts) {}
    QC_INPUTSTREAMSAXITERATOR->addConstructor(InputStreamSaxIterator_constructor_C11InputStreamVsVh, Public, QCF_NO_FLAGS, QDOM_FILESYSTEM, 3, QC_INPUTSTREAM->getTypeInfo(), QORE_PARAM_NO_ARG, "is", stringTypeInfo, QORE_PARAM_NO_ARG, "element_name", hashTypeInfo, QORE_PARAM_NO_ARG, "opts");

    // InputStreamSaxIterator::copy() {}
    QC_INPUTSTREAMSAXITERATOR->setCopy((q_copy_t)InputStreamSaxIterator_copy);

    return QC_INPUTSTREAMSAXITERATOR;
}
