use v6.d;
# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.p6.
# Generated from Unicode version 11.0.0.

use Test;

plan 500;

ok Uni.new(0x1E0A, 0x0323).NFC.list ~~ (0x1E0C, 0x0307,), '1E0A 0323 -> 1E0C 0307';
ok Uni.new(0x0044, 0x0307, 0x0323).NFC.list ~~ (0x1E0C, 0x0307,), '0044 0307 0323 -> 1E0C 0307';
ok Uni.new(0x0044, 0x0323, 0x0307).NFC.list ~~ (0x1E0C, 0x0307,), '0044 0323 0307 -> 1E0C 0307';
ok Uni.new(0x1E0A, 0x031B).NFC.list ~~ (0x1E0A, 0x031B,), '1E0A 031B -> 1E0A 031B';
ok Uni.new(0x1E0A, 0x031B, 0x0323).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '1E0A 031B 0323 -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0307, 0x0323).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0307 0323 -> 1E0C 031B 0307';
ok Uni.new(0x0044, 0x031B, 0x0323, 0x0307).NFC.list ~~ (0x1E0C, 0x031B, 0x0307,), '0044 031B 0323 0307 -> 1E0C 031B 0307';
ok Uni.new(0x00C8).NFC.list ~~ (0x00C8,), '00C8 -> 00C8';
ok Uni.new(0x0045, 0x0300).NFC.list ~~ (0x00C8,), '0045 0300 -> 00C8';
ok Uni.new(0x0045, 0x0304).NFC.list ~~ (0x0112,), '0045 0304 -> 0112';
ok Uni.new(0x0112, 0x0300).NFC.list ~~ (0x1E14,), '0112 0300 -> 1E14';
ok Uni.new(0x1E14, 0x0304).NFC.list ~~ (0x1E14, 0x0304,), '1E14 0304 -> 1E14 0304';
ok Uni.new(0x0045, 0x0304, 0x0300).NFC.list ~~ (0x1E14,), '0045 0304 0300 -> 1E14';
ok Uni.new(0x0045, 0x0300, 0x0304).NFC.list ~~ (0x00C8, 0x0304,), '0045 0300 0304 -> 00C8 0304';
ok Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).NFC.list ~~ (0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F,), '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F -> 05B1 05B8 05B9 0591 05C3 05B0 05AC 059F';
ok Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).NFC.list ~~ (0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4,), '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD -> 05B0 05B7 05BC 05A5 0592 05C0 05AD 05C4';
ok Uni.new(0x1100, 0xAC00, 0x11A8).NFC.list ~~ (0x1100, 0xAC01,), '1100 AC00 11A8 -> 1100 AC01';
ok Uni.new(0x1100, 0xAC00, 0x11A8, 0x11A8).NFC.list ~~ (0x1100, 0xAC01, 0x11A8,), '1100 AC00 11A8 11A8 -> 1100 AC01 11A8';
ok Uni.new(0x00A0).NFC.list ~~ (0x00A0,), '00A0 -> 00A0';
ok Uni.new(0x00A8).NFC.list ~~ (0x00A8,), '00A8 -> 00A8';
ok Uni.new(0x0340).NFC.list ~~ (0x0300,), '0340 -> 0300';
ok Uni.new(0x0341).NFC.list ~~ (0x0301,), '0341 -> 0301';
ok Uni.new(0x0343).NFC.list ~~ (0x0313,), '0343 -> 0313';
ok Uni.new(0x0344).NFC.list ~~ (0x0308, 0x0301,), '0344 -> 0308 0301';
ok Uni.new(0x0374).NFC.list ~~ (0x02B9,), '0374 -> 02B9';
ok Uni.new(0x037A).NFC.list ~~ (0x037A,), '037A -> 037A';
ok Uni.new(0x037E).NFC.list ~~ (0x003B,), '037E -> 003B';
ok Uni.new(0x0384).NFC.list ~~ (0x0384,), '0384 -> 0384';
ok Uni.new(0x0387).NFC.list ~~ (0x00B7,), '0387 -> 00B7';
ok Uni.new(0x0958).NFC.list ~~ (0x0915, 0x093C,), '0958 -> 0915 093C';
ok Uni.new(0x0959).NFC.list ~~ (0x0916, 0x093C,), '0959 -> 0916 093C';
ok Uni.new(0x095A).NFC.list ~~ (0x0917, 0x093C,), '095A -> 0917 093C';
ok Uni.new(0x095B).NFC.list ~~ (0x091C, 0x093C,), '095B -> 091C 093C';
ok Uni.new(0x095C).NFC.list ~~ (0x0921, 0x093C,), '095C -> 0921 093C';
ok Uni.new(0x095D).NFC.list ~~ (0x0922, 0x093C,), '095D -> 0922 093C';
ok Uni.new(0x095E).NFC.list ~~ (0x092B, 0x093C,), '095E -> 092B 093C';
ok Uni.new(0x095F).NFC.list ~~ (0x092F, 0x093C,), '095F -> 092F 093C';
ok Uni.new(0x09CB).NFC.list ~~ (0x09CB,), '09CB -> 09CB';
ok Uni.new(0x09CC).NFC.list ~~ (0x09CC,), '09CC -> 09CC';
ok Uni.new(0x09DC).NFC.list ~~ (0x09A1, 0x09BC,), '09DC -> 09A1 09BC';
ok Uni.new(0x09DD).NFC.list ~~ (0x09A2, 0x09BC,), '09DD -> 09A2 09BC';
ok Uni.new(0x09DF).NFC.list ~~ (0x09AF, 0x09BC,), '09DF -> 09AF 09BC';
ok Uni.new(0x0A33).NFC.list ~~ (0x0A32, 0x0A3C,), '0A33 -> 0A32 0A3C';
ok Uni.new(0x0A36).NFC.list ~~ (0x0A38, 0x0A3C,), '0A36 -> 0A38 0A3C';
ok Uni.new(0x0A59).NFC.list ~~ (0x0A16, 0x0A3C,), '0A59 -> 0A16 0A3C';
ok Uni.new(0x0A5A).NFC.list ~~ (0x0A17, 0x0A3C,), '0A5A -> 0A17 0A3C';
ok Uni.new(0x0A5B).NFC.list ~~ (0x0A1C, 0x0A3C,), '0A5B -> 0A1C 0A3C';
ok Uni.new(0x0A5E).NFC.list ~~ (0x0A2B, 0x0A3C,), '0A5E -> 0A2B 0A3C';
ok Uni.new(0x0B48).NFC.list ~~ (0x0B48,), '0B48 -> 0B48';
ok Uni.new(0x0B4B).NFC.list ~~ (0x0B4B,), '0B4B -> 0B4B';
ok Uni.new(0x0B4C).NFC.list ~~ (0x0B4C,), '0B4C -> 0B4C';
ok Uni.new(0x0B5C).NFC.list ~~ (0x0B21, 0x0B3C,), '0B5C -> 0B21 0B3C';
ok Uni.new(0x0B5D).NFC.list ~~ (0x0B22, 0x0B3C,), '0B5D -> 0B22 0B3C';
ok Uni.new(0x0B94).NFC.list ~~ (0x0B94,), '0B94 -> 0B94';
ok Uni.new(0x0F43).NFC.list ~~ (0x0F42, 0x0FB7,), '0F43 -> 0F42 0FB7';
ok Uni.new(0x0F4D).NFC.list ~~ (0x0F4C, 0x0FB7,), '0F4D -> 0F4C 0FB7';
ok Uni.new(0x0F52).NFC.list ~~ (0x0F51, 0x0FB7,), '0F52 -> 0F51 0FB7';
ok Uni.new(0x0F57).NFC.list ~~ (0x0F56, 0x0FB7,), '0F57 -> 0F56 0FB7';
ok Uni.new(0x0F5C).NFC.list ~~ (0x0F5B, 0x0FB7,), '0F5C -> 0F5B 0FB7';
ok Uni.new(0x0F69).NFC.list ~~ (0x0F40, 0x0FB5,), '0F69 -> 0F40 0FB5';
ok Uni.new(0x0F73).NFC.list ~~ (0x0F71, 0x0F72,), '0F73 -> 0F71 0F72';
ok Uni.new(0x0F75).NFC.list ~~ (0x0F71, 0x0F74,), '0F75 -> 0F71 0F74';
ok Uni.new(0x0F76).NFC.list ~~ (0x0FB2, 0x0F80,), '0F76 -> 0FB2 0F80';
ok Uni.new(0x0F77).NFC.list ~~ (0x0F77,), '0F77 -> 0F77';
ok Uni.new(0x0F78).NFC.list ~~ (0x0FB3, 0x0F80,), '0F78 -> 0FB3 0F80';
ok Uni.new(0x0F79).NFC.list ~~ (0x0F79,), '0F79 -> 0F79';
ok Uni.new(0x0F81).NFC.list ~~ (0x0F71, 0x0F80,), '0F81 -> 0F71 0F80';
ok Uni.new(0x0F93).NFC.list ~~ (0x0F92, 0x0FB7,), '0F93 -> 0F92 0FB7';
ok Uni.new(0x0F9D).NFC.list ~~ (0x0F9C, 0x0FB7,), '0F9D -> 0F9C 0FB7';
ok Uni.new(0x0FA2).NFC.list ~~ (0x0FA1, 0x0FB7,), '0FA2 -> 0FA1 0FB7';
ok Uni.new(0x0FA7).NFC.list ~~ (0x0FA6, 0x0FB7,), '0FA7 -> 0FA6 0FB7';
ok Uni.new(0x0FAC).NFC.list ~~ (0x0FAB, 0x0FB7,), '0FAC -> 0FAB 0FB7';
ok Uni.new(0x0FB9).NFC.list ~~ (0x0F90, 0x0FB5,), '0FB9 -> 0F90 0FB5';
ok Uni.new(0x1026).NFC.list ~~ (0x1026,), '1026 -> 1026';
ok Uni.new(0x10FC).NFC.list ~~ (0x10FC,), '10FC -> 10FC';
ok Uni.new(0x1B06).NFC.list ~~ (0x1B06,), '1B06 -> 1B06';
ok Uni.new(0x1B08).NFC.list ~~ (0x1B08,), '1B08 -> 1B08';
ok Uni.new(0x1F71).NFC.list ~~ (0x03AC,), '1F71 -> 03AC';
ok Uni.new(0x1F73).NFC.list ~~ (0x03AD,), '1F73 -> 03AD';
ok Uni.new(0x1F74).NFC.list ~~ (0x1F74,), '1F74 -> 1F74';
ok Uni.new(0x1F75).NFC.list ~~ (0x03AE,), '1F75 -> 03AE';
ok Uni.new(0x1F77).NFC.list ~~ (0x03AF,), '1F77 -> 03AF';
ok Uni.new(0x1F79).NFC.list ~~ (0x03CC,), '1F79 -> 03CC';
ok Uni.new(0x1F7A).NFC.list ~~ (0x1F7A,), '1F7A -> 1F7A';
ok Uni.new(0x1F7B).NFC.list ~~ (0x03CD,), '1F7B -> 03CD';
ok Uni.new(0x1F7D).NFC.list ~~ (0x03CE,), '1F7D -> 03CE';
ok Uni.new(0x1FBB).NFC.list ~~ (0x0386,), '1FBB -> 0386';
ok Uni.new(0x1FBC).NFC.list ~~ (0x1FBC,), '1FBC -> 1FBC';
ok Uni.new(0x1FBE).NFC.list ~~ (0x03B9,), '1FBE -> 03B9';
ok Uni.new(0x1FC9).NFC.list ~~ (0x0388,), '1FC9 -> 0388';
ok Uni.new(0x1FCB).NFC.list ~~ (0x0389,), '1FCB -> 0389';
ok Uni.new(0x1FCC).NFC.list ~~ (0x1FCC,), '1FCC -> 1FCC';
ok Uni.new(0x1FD3).NFC.list ~~ (0x0390,), '1FD3 -> 0390';
ok Uni.new(0x1FDB).NFC.list ~~ (0x038A,), '1FDB -> 038A';
ok Uni.new(0x1FE3).NFC.list ~~ (0x03B0,), '1FE3 -> 03B0';
ok Uni.new(0x1FE4).NFC.list ~~ (0x1FE4,), '1FE4 -> 1FE4';
ok Uni.new(0x1FEB).NFC.list ~~ (0x038E,), '1FEB -> 038E';
ok Uni.new(0x1FEE).NFC.list ~~ (0x0385,), '1FEE -> 0385';
ok Uni.new(0x1FEF).NFC.list ~~ (0x0060,), '1FEF -> 0060';
ok Uni.new(0x1FF2).NFC.list ~~ (0x1FF2,), '1FF2 -> 1FF2';
ok Uni.new(0x1FF9).NFC.list ~~ (0x038C,), '1FF9 -> 038C';
ok Uni.new(0x1FFB).NFC.list ~~ (0x038F,), '1FFB -> 038F';
ok Uni.new(0x1FFD).NFC.list ~~ (0x00B4,), '1FFD -> 00B4';
ok Uni.new(0x1FFE).NFC.list ~~ (0x1FFE,), '1FFE -> 1FFE';
ok Uni.new(0x2000).NFC.list ~~ (0x2002,), '2000 -> 2002';
ok Uni.new(0x2001).NFC.list ~~ (0x2003,), '2001 -> 2003';
ok Uni.new(0x2126).NFC.list ~~ (0x03A9,), '2126 -> 03A9';
ok Uni.new(0x2128).NFC.list ~~ (0x2128,), '2128 -> 2128';
ok Uni.new(0x212A).NFC.list ~~ (0x004B,), '212A -> 004B';
ok Uni.new(0x212B).NFC.list ~~ (0x00C5,), '212B -> 00C5';
ok Uni.new(0x2329).NFC.list ~~ (0x3008,), '2329 -> 3008';
ok Uni.new(0x232A).NFC.list ~~ (0x3009,), '232A -> 3009';
ok Uni.new(0x2460).NFC.list ~~ (0x2460,), '2460 -> 2460';
ok Uni.new(0x2ADC).NFC.list ~~ (0x2ADD, 0x0338,), '2ADC -> 2ADD 0338';
ok Uni.new(0xF900).NFC.list ~~ (0x8C48,), 'F900 -> 8C48';
ok Uni.new(0xF901).NFC.list ~~ (0x66F4,), 'F901 -> 66F4';
ok Uni.new(0xF902).NFC.list ~~ (0x8ECA,), 'F902 -> 8ECA';
ok Uni.new(0xF903).NFC.list ~~ (0x8CC8,), 'F903 -> 8CC8';
ok Uni.new(0xF904).NFC.list ~~ (0x6ED1,), 'F904 -> 6ED1';
ok Uni.new(0xF905).NFC.list ~~ (0x4E32,), 'F905 -> 4E32';
ok Uni.new(0xF906).NFC.list ~~ (0x53E5,), 'F906 -> 53E5';
ok Uni.new(0xF907).NFC.list ~~ (0x9F9C,), 'F907 -> 9F9C';
ok Uni.new(0xF908).NFC.list ~~ (0x9F9C,), 'F908 -> 9F9C';
ok Uni.new(0xF909).NFC.list ~~ (0x5951,), 'F909 -> 5951';
ok Uni.new(0xF90A).NFC.list ~~ (0x91D1,), 'F90A -> 91D1';
ok Uni.new(0xF90B).NFC.list ~~ (0x5587,), 'F90B -> 5587';
ok Uni.new(0xF90C).NFC.list ~~ (0x5948,), 'F90C -> 5948';
ok Uni.new(0xF90D).NFC.list ~~ (0x61F6,), 'F90D -> 61F6';
ok Uni.new(0xF90E).NFC.list ~~ (0x7669,), 'F90E -> 7669';
ok Uni.new(0xF90F).NFC.list ~~ (0x7F85,), 'F90F -> 7F85';
ok Uni.new(0xF910).NFC.list ~~ (0x863F,), 'F910 -> 863F';
ok Uni.new(0xF911).NFC.list ~~ (0x87BA,), 'F911 -> 87BA';
ok Uni.new(0xF912).NFC.list ~~ (0x88F8,), 'F912 -> 88F8';
ok Uni.new(0xF913).NFC.list ~~ (0x908F,), 'F913 -> 908F';
ok Uni.new(0xF914).NFC.list ~~ (0x6A02,), 'F914 -> 6A02';
ok Uni.new(0xF915).NFC.list ~~ (0x6D1B,), 'F915 -> 6D1B';
ok Uni.new(0xF916).NFC.list ~~ (0x70D9,), 'F916 -> 70D9';
ok Uni.new(0xF917).NFC.list ~~ (0x73DE,), 'F917 -> 73DE';
ok Uni.new(0xF918).NFC.list ~~ (0x843D,), 'F918 -> 843D';
ok Uni.new(0xF919).NFC.list ~~ (0x916A,), 'F919 -> 916A';
ok Uni.new(0xF91A).NFC.list ~~ (0x99F1,), 'F91A -> 99F1';
ok Uni.new(0xF91B).NFC.list ~~ (0x4E82,), 'F91B -> 4E82';
ok Uni.new(0xF91C).NFC.list ~~ (0x5375,), 'F91C -> 5375';
ok Uni.new(0xF91D).NFC.list ~~ (0x6B04,), 'F91D -> 6B04';
ok Uni.new(0xF91E).NFC.list ~~ (0x721B,), 'F91E -> 721B';
ok Uni.new(0xF91F).NFC.list ~~ (0x862D,), 'F91F -> 862D';
ok Uni.new(0xF920).NFC.list ~~ (0x9E1E,), 'F920 -> 9E1E';
ok Uni.new(0xF921).NFC.list ~~ (0x5D50,), 'F921 -> 5D50';
ok Uni.new(0xF922).NFC.list ~~ (0x6FEB,), 'F922 -> 6FEB';
ok Uni.new(0xF923).NFC.list ~~ (0x85CD,), 'F923 -> 85CD';
ok Uni.new(0xF924).NFC.list ~~ (0x8964,), 'F924 -> 8964';
ok Uni.new(0xF925).NFC.list ~~ (0x62C9,), 'F925 -> 62C9';
ok Uni.new(0xF926).NFC.list ~~ (0x81D8,), 'F926 -> 81D8';
ok Uni.new(0xF927).NFC.list ~~ (0x881F,), 'F927 -> 881F';
ok Uni.new(0xF928).NFC.list ~~ (0x5ECA,), 'F928 -> 5ECA';
ok Uni.new(0xF929).NFC.list ~~ (0x6717,), 'F929 -> 6717';
ok Uni.new(0xF92A).NFC.list ~~ (0x6D6A,), 'F92A -> 6D6A';
ok Uni.new(0xF92B).NFC.list ~~ (0x72FC,), 'F92B -> 72FC';
ok Uni.new(0xF92C).NFC.list ~~ (0x90CE,), 'F92C -> 90CE';
ok Uni.new(0xF92D).NFC.list ~~ (0x4F86,), 'F92D -> 4F86';
ok Uni.new(0xF92E).NFC.list ~~ (0x51B7,), 'F92E -> 51B7';
ok Uni.new(0xF92F).NFC.list ~~ (0x52DE,), 'F92F -> 52DE';
ok Uni.new(0xF930).NFC.list ~~ (0x64C4,), 'F930 -> 64C4';
ok Uni.new(0xF931).NFC.list ~~ (0x6AD3,), 'F931 -> 6AD3';
ok Uni.new(0xF932).NFC.list ~~ (0x7210,), 'F932 -> 7210';
ok Uni.new(0xF933).NFC.list ~~ (0x76E7,), 'F933 -> 76E7';
ok Uni.new(0xF934).NFC.list ~~ (0x8001,), 'F934 -> 8001';
ok Uni.new(0xF935).NFC.list ~~ (0x8606,), 'F935 -> 8606';
ok Uni.new(0xF936).NFC.list ~~ (0x865C,), 'F936 -> 865C';
ok Uni.new(0xF937).NFC.list ~~ (0x8DEF,), 'F937 -> 8DEF';
ok Uni.new(0xF938).NFC.list ~~ (0x9732,), 'F938 -> 9732';
ok Uni.new(0xF939).NFC.list ~~ (0x9B6F,), 'F939 -> 9B6F';
ok Uni.new(0xF93A).NFC.list ~~ (0x9DFA,), 'F93A -> 9DFA';
ok Uni.new(0xF93B).NFC.list ~~ (0x788C,), 'F93B -> 788C';
ok Uni.new(0xF93C).NFC.list ~~ (0x797F,), 'F93C -> 797F';
ok Uni.new(0xF93D).NFC.list ~~ (0x7DA0,), 'F93D -> 7DA0';
ok Uni.new(0xF93E).NFC.list ~~ (0x83C9,), 'F93E -> 83C9';
ok Uni.new(0xF93F).NFC.list ~~ (0x9304,), 'F93F -> 9304';
ok Uni.new(0xF940).NFC.list ~~ (0x9E7F,), 'F940 -> 9E7F';
ok Uni.new(0xF941).NFC.list ~~ (0x8AD6,), 'F941 -> 8AD6';
ok Uni.new(0xF942).NFC.list ~~ (0x58DF,), 'F942 -> 58DF';
ok Uni.new(0xF943).NFC.list ~~ (0x5F04,), 'F943 -> 5F04';
ok Uni.new(0xF944).NFC.list ~~ (0x7C60,), 'F944 -> 7C60';
ok Uni.new(0xF945).NFC.list ~~ (0x807E,), 'F945 -> 807E';
ok Uni.new(0xF946).NFC.list ~~ (0x7262,), 'F946 -> 7262';
ok Uni.new(0xF947).NFC.list ~~ (0x78CA,), 'F947 -> 78CA';
ok Uni.new(0xF948).NFC.list ~~ (0x8CC2,), 'F948 -> 8CC2';
ok Uni.new(0xF949).NFC.list ~~ (0x96F7,), 'F949 -> 96F7';
ok Uni.new(0xF94A).NFC.list ~~ (0x58D8,), 'F94A -> 58D8';
ok Uni.new(0xF94B).NFC.list ~~ (0x5C62,), 'F94B -> 5C62';
ok Uni.new(0xF94C).NFC.list ~~ (0x6A13,), 'F94C -> 6A13';
ok Uni.new(0xF94D).NFC.list ~~ (0x6DDA,), 'F94D -> 6DDA';
ok Uni.new(0xF94E).NFC.list ~~ (0x6F0F,), 'F94E -> 6F0F';
ok Uni.new(0xF94F).NFC.list ~~ (0x7D2F,), 'F94F -> 7D2F';
ok Uni.new(0xF950).NFC.list ~~ (0x7E37,), 'F950 -> 7E37';
ok Uni.new(0xF951).NFC.list ~~ (0x964B,), 'F951 -> 964B';
ok Uni.new(0xF952).NFC.list ~~ (0x52D2,), 'F952 -> 52D2';
ok Uni.new(0xF953).NFC.list ~~ (0x808B,), 'F953 -> 808B';
ok Uni.new(0xF954).NFC.list ~~ (0x51DC,), 'F954 -> 51DC';
ok Uni.new(0xF955).NFC.list ~~ (0x51CC,), 'F955 -> 51CC';
ok Uni.new(0xF956).NFC.list ~~ (0x7A1C,), 'F956 -> 7A1C';
ok Uni.new(0xF957).NFC.list ~~ (0x7DBE,), 'F957 -> 7DBE';
ok Uni.new(0xF958).NFC.list ~~ (0x83F1,), 'F958 -> 83F1';
ok Uni.new(0xF959).NFC.list ~~ (0x9675,), 'F959 -> 9675';
ok Uni.new(0xF95A).NFC.list ~~ (0x8B80,), 'F95A -> 8B80';
ok Uni.new(0xF95B).NFC.list ~~ (0x62CF,), 'F95B -> 62CF';
ok Uni.new(0xF95C).NFC.list ~~ (0x6A02,), 'F95C -> 6A02';
ok Uni.new(0xF95D).NFC.list ~~ (0x8AFE,), 'F95D -> 8AFE';
ok Uni.new(0xF95E).NFC.list ~~ (0x4E39,), 'F95E -> 4E39';
ok Uni.new(0xF95F).NFC.list ~~ (0x5BE7,), 'F95F -> 5BE7';
ok Uni.new(0xF960).NFC.list ~~ (0x6012,), 'F960 -> 6012';
ok Uni.new(0xF961).NFC.list ~~ (0x7387,), 'F961 -> 7387';
ok Uni.new(0xF962).NFC.list ~~ (0x7570,), 'F962 -> 7570';
ok Uni.new(0xF963).NFC.list ~~ (0x5317,), 'F963 -> 5317';
ok Uni.new(0xF964).NFC.list ~~ (0x78FB,), 'F964 -> 78FB';
ok Uni.new(0xF965).NFC.list ~~ (0x4FBF,), 'F965 -> 4FBF';
ok Uni.new(0xF966).NFC.list ~~ (0x5FA9,), 'F966 -> 5FA9';
ok Uni.new(0xF967).NFC.list ~~ (0x4E0D,), 'F967 -> 4E0D';
ok Uni.new(0xF968).NFC.list ~~ (0x6CCC,), 'F968 -> 6CCC';
ok Uni.new(0xF969).NFC.list ~~ (0x6578,), 'F969 -> 6578';
ok Uni.new(0xF96A).NFC.list ~~ (0x7D22,), 'F96A -> 7D22';
ok Uni.new(0xF96B).NFC.list ~~ (0x53C3,), 'F96B -> 53C3';
ok Uni.new(0xF96C).NFC.list ~~ (0x585E,), 'F96C -> 585E';
ok Uni.new(0xF96D).NFC.list ~~ (0x7701,), 'F96D -> 7701';
ok Uni.new(0xF96E).NFC.list ~~ (0x8449,), 'F96E -> 8449';
ok Uni.new(0xF96F).NFC.list ~~ (0x8AAA,), 'F96F -> 8AAA';
ok Uni.new(0xF970).NFC.list ~~ (0x6BBA,), 'F970 -> 6BBA';
ok Uni.new(0xF971).NFC.list ~~ (0x8FB0,), 'F971 -> 8FB0';
ok Uni.new(0xF972).NFC.list ~~ (0x6C88,), 'F972 -> 6C88';
ok Uni.new(0xF973).NFC.list ~~ (0x62FE,), 'F973 -> 62FE';
ok Uni.new(0xF974).NFC.list ~~ (0x82E5,), 'F974 -> 82E5';
ok Uni.new(0xF975).NFC.list ~~ (0x63A0,), 'F975 -> 63A0';
ok Uni.new(0xF976).NFC.list ~~ (0x7565,), 'F976 -> 7565';
ok Uni.new(0xF977).NFC.list ~~ (0x4EAE,), 'F977 -> 4EAE';
ok Uni.new(0xF978).NFC.list ~~ (0x5169,), 'F978 -> 5169';
ok Uni.new(0xF979).NFC.list ~~ (0x51C9,), 'F979 -> 51C9';
ok Uni.new(0xF97A).NFC.list ~~ (0x6881,), 'F97A -> 6881';
ok Uni.new(0xF97B).NFC.list ~~ (0x7CE7,), 'F97B -> 7CE7';
ok Uni.new(0xF97C).NFC.list ~~ (0x826F,), 'F97C -> 826F';
ok Uni.new(0xF97D).NFC.list ~~ (0x8AD2,), 'F97D -> 8AD2';
ok Uni.new(0xF97E).NFC.list ~~ (0x91CF,), 'F97E -> 91CF';
ok Uni.new(0xF97F).NFC.list ~~ (0x52F5,), 'F97F -> 52F5';
ok Uni.new(0xF980).NFC.list ~~ (0x5442,), 'F980 -> 5442';
ok Uni.new(0xF981).NFC.list ~~ (0x5973,), 'F981 -> 5973';
ok Uni.new(0xF982).NFC.list ~~ (0x5EEC,), 'F982 -> 5EEC';
ok Uni.new(0xF983).NFC.list ~~ (0x65C5,), 'F983 -> 65C5';
ok Uni.new(0xF984).NFC.list ~~ (0x6FFE,), 'F984 -> 6FFE';
ok Uni.new(0xF985).NFC.list ~~ (0x792A,), 'F985 -> 792A';
ok Uni.new(0xF986).NFC.list ~~ (0x95AD,), 'F986 -> 95AD';
ok Uni.new(0xF987).NFC.list ~~ (0x9A6A,), 'F987 -> 9A6A';
ok Uni.new(0xF988).NFC.list ~~ (0x9E97,), 'F988 -> 9E97';
ok Uni.new(0xF989).NFC.list ~~ (0x9ECE,), 'F989 -> 9ECE';
ok Uni.new(0xF98A).NFC.list ~~ (0x529B,), 'F98A -> 529B';
ok Uni.new(0xF98B).NFC.list ~~ (0x66C6,), 'F98B -> 66C6';
ok Uni.new(0xF98C).NFC.list ~~ (0x6B77,), 'F98C -> 6B77';
ok Uni.new(0xF98D).NFC.list ~~ (0x8F62,), 'F98D -> 8F62';
ok Uni.new(0xF98E).NFC.list ~~ (0x5E74,), 'F98E -> 5E74';
ok Uni.new(0xF98F).NFC.list ~~ (0x6190,), 'F98F -> 6190';
ok Uni.new(0xF990).NFC.list ~~ (0x6200,), 'F990 -> 6200';
ok Uni.new(0xF991).NFC.list ~~ (0x649A,), 'F991 -> 649A';
ok Uni.new(0xF992).NFC.list ~~ (0x6F23,), 'F992 -> 6F23';
ok Uni.new(0xF993).NFC.list ~~ (0x7149,), 'F993 -> 7149';
ok Uni.new(0xF994).NFC.list ~~ (0x7489,), 'F994 -> 7489';
ok Uni.new(0xF995).NFC.list ~~ (0x79CA,), 'F995 -> 79CA';
ok Uni.new(0xF996).NFC.list ~~ (0x7DF4,), 'F996 -> 7DF4';
ok Uni.new(0xF997).NFC.list ~~ (0x806F,), 'F997 -> 806F';
ok Uni.new(0xF998).NFC.list ~~ (0x8F26,), 'F998 -> 8F26';
ok Uni.new(0xF999).NFC.list ~~ (0x84EE,), 'F999 -> 84EE';
ok Uni.new(0xF99A).NFC.list ~~ (0x9023,), 'F99A -> 9023';
ok Uni.new(0xF99B).NFC.list ~~ (0x934A,), 'F99B -> 934A';
ok Uni.new(0xF99C).NFC.list ~~ (0x5217,), 'F99C -> 5217';
ok Uni.new(0xF99D).NFC.list ~~ (0x52A3,), 'F99D -> 52A3';
ok Uni.new(0xF99E).NFC.list ~~ (0x54BD,), 'F99E -> 54BD';
ok Uni.new(0xF99F).NFC.list ~~ (0x70C8,), 'F99F -> 70C8';
ok Uni.new(0xF9A0).NFC.list ~~ (0x88C2,), 'F9A0 -> 88C2';
ok Uni.new(0xF9A1).NFC.list ~~ (0x8AAA,), 'F9A1 -> 8AAA';
ok Uni.new(0xF9A2).NFC.list ~~ (0x5EC9,), 'F9A2 -> 5EC9';
ok Uni.new(0xF9A3).NFC.list ~~ (0x5FF5,), 'F9A3 -> 5FF5';
ok Uni.new(0xF9A4).NFC.list ~~ (0x637B,), 'F9A4 -> 637B';
ok Uni.new(0xF9A5).NFC.list ~~ (0x6BAE,), 'F9A5 -> 6BAE';
ok Uni.new(0xF9A6).NFC.list ~~ (0x7C3E,), 'F9A6 -> 7C3E';
ok Uni.new(0xF9A7).NFC.list ~~ (0x7375,), 'F9A7 -> 7375';
ok Uni.new(0xF9A8).NFC.list ~~ (0x4EE4,), 'F9A8 -> 4EE4';
ok Uni.new(0xF9A9).NFC.list ~~ (0x56F9,), 'F9A9 -> 56F9';
ok Uni.new(0xF9AA).NFC.list ~~ (0x5BE7,), 'F9AA -> 5BE7';
ok Uni.new(0xF9AB).NFC.list ~~ (0x5DBA,), 'F9AB -> 5DBA';
ok Uni.new(0xF9AC).NFC.list ~~ (0x601C,), 'F9AC -> 601C';
ok Uni.new(0xF9AD).NFC.list ~~ (0x73B2,), 'F9AD -> 73B2';
ok Uni.new(0xF9AE).NFC.list ~~ (0x7469,), 'F9AE -> 7469';
ok Uni.new(0xF9AF).NFC.list ~~ (0x7F9A,), 'F9AF -> 7F9A';
ok Uni.new(0xF9B0).NFC.list ~~ (0x8046,), 'F9B0 -> 8046';
ok Uni.new(0xF9B1).NFC.list ~~ (0x9234,), 'F9B1 -> 9234';
ok Uni.new(0xF9B2).NFC.list ~~ (0x96F6,), 'F9B2 -> 96F6';
ok Uni.new(0xF9B3).NFC.list ~~ (0x9748,), 'F9B3 -> 9748';
ok Uni.new(0xF9B4).NFC.list ~~ (0x9818,), 'F9B4 -> 9818';
ok Uni.new(0xF9B5).NFC.list ~~ (0x4F8B,), 'F9B5 -> 4F8B';
ok Uni.new(0xF9B6).NFC.list ~~ (0x79AE,), 'F9B6 -> 79AE';
ok Uni.new(0xF9B7).NFC.list ~~ (0x91B4,), 'F9B7 -> 91B4';
ok Uni.new(0xF9B8).NFC.list ~~ (0x96B8,), 'F9B8 -> 96B8';
ok Uni.new(0xF9B9).NFC.list ~~ (0x60E1,), 'F9B9 -> 60E1';
ok Uni.new(0xF9BA).NFC.list ~~ (0x4E86,), 'F9BA -> 4E86';
ok Uni.new(0xF9BB).NFC.list ~~ (0x50DA,), 'F9BB -> 50DA';
ok Uni.new(0xF9BC).NFC.list ~~ (0x5BEE,), 'F9BC -> 5BEE';
ok Uni.new(0xF9BD).NFC.list ~~ (0x5C3F,), 'F9BD -> 5C3F';
ok Uni.new(0xF9BE).NFC.list ~~ (0x6599,), 'F9BE -> 6599';
ok Uni.new(0xF9BF).NFC.list ~~ (0x6A02,), 'F9BF -> 6A02';
ok Uni.new(0xF9C0).NFC.list ~~ (0x71CE,), 'F9C0 -> 71CE';
ok Uni.new(0xF9C1).NFC.list ~~ (0x7642,), 'F9C1 -> 7642';
ok Uni.new(0xF9C2).NFC.list ~~ (0x84FC,), 'F9C2 -> 84FC';
ok Uni.new(0xF9C3).NFC.list ~~ (0x907C,), 'F9C3 -> 907C';
ok Uni.new(0xF9C4).NFC.list ~~ (0x9F8D,), 'F9C4 -> 9F8D';
ok Uni.new(0xF9C5).NFC.list ~~ (0x6688,), 'F9C5 -> 6688';
ok Uni.new(0xF9C6).NFC.list ~~ (0x962E,), 'F9C6 -> 962E';
ok Uni.new(0xF9C7).NFC.list ~~ (0x5289,), 'F9C7 -> 5289';
ok Uni.new(0xF9C8).NFC.list ~~ (0x677B,), 'F9C8 -> 677B';
ok Uni.new(0xF9C9).NFC.list ~~ (0x67F3,), 'F9C9 -> 67F3';
ok Uni.new(0xF9CA).NFC.list ~~ (0x6D41,), 'F9CA -> 6D41';
ok Uni.new(0xF9CB).NFC.list ~~ (0x6E9C,), 'F9CB -> 6E9C';
ok Uni.new(0xF9CC).NFC.list ~~ (0x7409,), 'F9CC -> 7409';
ok Uni.new(0xF9CD).NFC.list ~~ (0x7559,), 'F9CD -> 7559';
ok Uni.new(0xF9CE).NFC.list ~~ (0x786B,), 'F9CE -> 786B';
ok Uni.new(0xF9CF).NFC.list ~~ (0x7D10,), 'F9CF -> 7D10';
ok Uni.new(0xF9D0).NFC.list ~~ (0x985E,), 'F9D0 -> 985E';
ok Uni.new(0xF9D1).NFC.list ~~ (0x516D,), 'F9D1 -> 516D';
ok Uni.new(0xF9D2).NFC.list ~~ (0x622E,), 'F9D2 -> 622E';
ok Uni.new(0xF9D3).NFC.list ~~ (0x9678,), 'F9D3 -> 9678';
ok Uni.new(0xF9D4).NFC.list ~~ (0x502B,), 'F9D4 -> 502B';
ok Uni.new(0xF9D5).NFC.list ~~ (0x5D19,), 'F9D5 -> 5D19';
ok Uni.new(0xF9D6).NFC.list ~~ (0x6DEA,), 'F9D6 -> 6DEA';
ok Uni.new(0xF9D7).NFC.list ~~ (0x8F2A,), 'F9D7 -> 8F2A';
ok Uni.new(0xF9D8).NFC.list ~~ (0x5F8B,), 'F9D8 -> 5F8B';
ok Uni.new(0xF9D9).NFC.list ~~ (0x6144,), 'F9D9 -> 6144';
ok Uni.new(0xF9DA).NFC.list ~~ (0x6817,), 'F9DA -> 6817';
ok Uni.new(0xF9DB).NFC.list ~~ (0x7387,), 'F9DB -> 7387';
ok Uni.new(0xF9DC).NFC.list ~~ (0x9686,), 'F9DC -> 9686';
ok Uni.new(0xF9DD).NFC.list ~~ (0x5229,), 'F9DD -> 5229';
ok Uni.new(0xF9DE).NFC.list ~~ (0x540F,), 'F9DE -> 540F';
ok Uni.new(0xF9DF).NFC.list ~~ (0x5C65,), 'F9DF -> 5C65';
ok Uni.new(0xF9E0).NFC.list ~~ (0x6613,), 'F9E0 -> 6613';
ok Uni.new(0xF9E1).NFC.list ~~ (0x674E,), 'F9E1 -> 674E';
ok Uni.new(0xF9E2).NFC.list ~~ (0x68A8,), 'F9E2 -> 68A8';
ok Uni.new(0xF9E3).NFC.list ~~ (0x6CE5,), 'F9E3 -> 6CE5';
ok Uni.new(0xF9E4).NFC.list ~~ (0x7406,), 'F9E4 -> 7406';
ok Uni.new(0xF9E5).NFC.list ~~ (0x75E2,), 'F9E5 -> 75E2';
ok Uni.new(0xF9E6).NFC.list ~~ (0x7F79,), 'F9E6 -> 7F79';
ok Uni.new(0xF9E7).NFC.list ~~ (0x88CF,), 'F9E7 -> 88CF';
ok Uni.new(0xF9E8).NFC.list ~~ (0x88E1,), 'F9E8 -> 88E1';
ok Uni.new(0xF9E9).NFC.list ~~ (0x91CC,), 'F9E9 -> 91CC';
ok Uni.new(0xF9EA).NFC.list ~~ (0x96E2,), 'F9EA -> 96E2';
ok Uni.new(0xF9EB).NFC.list ~~ (0x533F,), 'F9EB -> 533F';
ok Uni.new(0xF9EC).NFC.list ~~ (0x6EBA,), 'F9EC -> 6EBA';
ok Uni.new(0xF9ED).NFC.list ~~ (0x541D,), 'F9ED -> 541D';
ok Uni.new(0xF9EE).NFC.list ~~ (0x71D0,), 'F9EE -> 71D0';
ok Uni.new(0xF9EF).NFC.list ~~ (0x7498,), 'F9EF -> 7498';
ok Uni.new(0xF9F0).NFC.list ~~ (0x85FA,), 'F9F0 -> 85FA';
ok Uni.new(0xF9F1).NFC.list ~~ (0x96A3,), 'F9F1 -> 96A3';
ok Uni.new(0xF9F2).NFC.list ~~ (0x9C57,), 'F9F2 -> 9C57';
ok Uni.new(0xF9F3).NFC.list ~~ (0x9E9F,), 'F9F3 -> 9E9F';
ok Uni.new(0xF9F4).NFC.list ~~ (0x6797,), 'F9F4 -> 6797';
ok Uni.new(0xF9F5).NFC.list ~~ (0x6DCB,), 'F9F5 -> 6DCB';
ok Uni.new(0xF9F6).NFC.list ~~ (0x81E8,), 'F9F6 -> 81E8';
ok Uni.new(0xF9F7).NFC.list ~~ (0x7ACB,), 'F9F7 -> 7ACB';
ok Uni.new(0xF9F8).NFC.list ~~ (0x7B20,), 'F9F8 -> 7B20';
ok Uni.new(0xF9F9).NFC.list ~~ (0x7C92,), 'F9F9 -> 7C92';
ok Uni.new(0xF9FA).NFC.list ~~ (0x72C0,), 'F9FA -> 72C0';
ok Uni.new(0xF9FB).NFC.list ~~ (0x7099,), 'F9FB -> 7099';
ok Uni.new(0xF9FC).NFC.list ~~ (0x8B58,), 'F9FC -> 8B58';
ok Uni.new(0xF9FD).NFC.list ~~ (0x4EC0,), 'F9FD -> 4EC0';
ok Uni.new(0xF9FE).NFC.list ~~ (0x8336,), 'F9FE -> 8336';
ok Uni.new(0xF9FF).NFC.list ~~ (0x523A,), 'F9FF -> 523A';
ok Uni.new(0xFA00).NFC.list ~~ (0x5207,), 'FA00 -> 5207';
ok Uni.new(0xFA01).NFC.list ~~ (0x5EA6,), 'FA01 -> 5EA6';
ok Uni.new(0xFA02).NFC.list ~~ (0x62D3,), 'FA02 -> 62D3';
ok Uni.new(0xFA03).NFC.list ~~ (0x7CD6,), 'FA03 -> 7CD6';
ok Uni.new(0xFA04).NFC.list ~~ (0x5B85,), 'FA04 -> 5B85';
ok Uni.new(0xFA05).NFC.list ~~ (0x6D1E,), 'FA05 -> 6D1E';
ok Uni.new(0xFA06).NFC.list ~~ (0x66B4,), 'FA06 -> 66B4';
ok Uni.new(0xFA07).NFC.list ~~ (0x8F3B,), 'FA07 -> 8F3B';
ok Uni.new(0xFA08).NFC.list ~~ (0x884C,), 'FA08 -> 884C';
ok Uni.new(0xFA09).NFC.list ~~ (0x964D,), 'FA09 -> 964D';
ok Uni.new(0xFA0A).NFC.list ~~ (0x898B,), 'FA0A -> 898B';
ok Uni.new(0xFA0B).NFC.list ~~ (0x5ED3,), 'FA0B -> 5ED3';
ok Uni.new(0xFA0C).NFC.list ~~ (0x5140,), 'FA0C -> 5140';
ok Uni.new(0xFA0D).NFC.list ~~ (0x55C0,), 'FA0D -> 55C0';
ok Uni.new(0xFA10).NFC.list ~~ (0x585A,), 'FA10 -> 585A';
ok Uni.new(0xFA12).NFC.list ~~ (0x6674,), 'FA12 -> 6674';
ok Uni.new(0xFA15).NFC.list ~~ (0x51DE,), 'FA15 -> 51DE';
ok Uni.new(0xFA16).NFC.list ~~ (0x732A,), 'FA16 -> 732A';
ok Uni.new(0xFA17).NFC.list ~~ (0x76CA,), 'FA17 -> 76CA';
ok Uni.new(0xFA18).NFC.list ~~ (0x793C,), 'FA18 -> 793C';
ok Uni.new(0xFA19).NFC.list ~~ (0x795E,), 'FA19 -> 795E';
ok Uni.new(0xFA1A).NFC.list ~~ (0x7965,), 'FA1A -> 7965';
ok Uni.new(0xFA1B).NFC.list ~~ (0x798F,), 'FA1B -> 798F';
ok Uni.new(0xFA1C).NFC.list ~~ (0x9756,), 'FA1C -> 9756';
ok Uni.new(0xFA1D).NFC.list ~~ (0x7CBE,), 'FA1D -> 7CBE';
ok Uni.new(0xFA1E).NFC.list ~~ (0x7FBD,), 'FA1E -> 7FBD';
ok Uni.new(0xFA20).NFC.list ~~ (0x8612,), 'FA20 -> 8612';
ok Uni.new(0xFA22).NFC.list ~~ (0x8AF8,), 'FA22 -> 8AF8';
ok Uni.new(0xFA25).NFC.list ~~ (0x9038,), 'FA25 -> 9038';
ok Uni.new(0xFA26).NFC.list ~~ (0x90FD,), 'FA26 -> 90FD';
ok Uni.new(0xFA2A).NFC.list ~~ (0x98EF,), 'FA2A -> 98EF';
ok Uni.new(0xFA2B).NFC.list ~~ (0x98FC,), 'FA2B -> 98FC';
ok Uni.new(0xFA2C).NFC.list ~~ (0x9928,), 'FA2C -> 9928';
ok Uni.new(0xFA2D).NFC.list ~~ (0x9DB4,), 'FA2D -> 9DB4';
ok Uni.new(0xFA2E).NFC.list ~~ (0x90DE,), 'FA2E -> 90DE';
ok Uni.new(0xFA2F).NFC.list ~~ (0x96B7,), 'FA2F -> 96B7';
ok Uni.new(0xFA30).NFC.list ~~ (0x4FAE,), 'FA30 -> 4FAE';
ok Uni.new(0xFA31).NFC.list ~~ (0x50E7,), 'FA31 -> 50E7';
ok Uni.new(0xFA32).NFC.list ~~ (0x514D,), 'FA32 -> 514D';
ok Uni.new(0xFA33).NFC.list ~~ (0x52C9,), 'FA33 -> 52C9';
ok Uni.new(0xFA34).NFC.list ~~ (0x52E4,), 'FA34 -> 52E4';
ok Uni.new(0xFA35).NFC.list ~~ (0x5351,), 'FA35 -> 5351';
ok Uni.new(0xFA36).NFC.list ~~ (0x559D,), 'FA36 -> 559D';
ok Uni.new(0xFA37).NFC.list ~~ (0x5606,), 'FA37 -> 5606';
ok Uni.new(0xFA38).NFC.list ~~ (0x5668,), 'FA38 -> 5668';
ok Uni.new(0xFA39).NFC.list ~~ (0x5840,), 'FA39 -> 5840';
ok Uni.new(0xFA3A).NFC.list ~~ (0x58A8,), 'FA3A -> 58A8';
ok Uni.new(0xFA3B).NFC.list ~~ (0x5C64,), 'FA3B -> 5C64';
ok Uni.new(0xFA3C).NFC.list ~~ (0x5C6E,), 'FA3C -> 5C6E';
ok Uni.new(0xFA3D).NFC.list ~~ (0x6094,), 'FA3D -> 6094';
ok Uni.new(0xFA3E).NFC.list ~~ (0x6168,), 'FA3E -> 6168';
ok Uni.new(0xFA3F).NFC.list ~~ (0x618E,), 'FA3F -> 618E';
ok Uni.new(0xFA40).NFC.list ~~ (0x61F2,), 'FA40 -> 61F2';
ok Uni.new(0xFA41).NFC.list ~~ (0x654F,), 'FA41 -> 654F';
ok Uni.new(0xFA42).NFC.list ~~ (0x65E2,), 'FA42 -> 65E2';
ok Uni.new(0xFA43).NFC.list ~~ (0x6691,), 'FA43 -> 6691';
ok Uni.new(0xFA44).NFC.list ~~ (0x6885,), 'FA44 -> 6885';
ok Uni.new(0xFA45).NFC.list ~~ (0x6D77,), 'FA45 -> 6D77';
ok Uni.new(0xFA46).NFC.list ~~ (0x6E1A,), 'FA46 -> 6E1A';
ok Uni.new(0xFA47).NFC.list ~~ (0x6F22,), 'FA47 -> 6F22';
ok Uni.new(0xFA48).NFC.list ~~ (0x716E,), 'FA48 -> 716E';
ok Uni.new(0xFA49).NFC.list ~~ (0x722B,), 'FA49 -> 722B';
ok Uni.new(0xFA4A).NFC.list ~~ (0x7422,), 'FA4A -> 7422';
ok Uni.new(0xFA4B).NFC.list ~~ (0x7891,), 'FA4B -> 7891';
ok Uni.new(0xFA4C).NFC.list ~~ (0x793E,), 'FA4C -> 793E';
ok Uni.new(0xFA4D).NFC.list ~~ (0x7949,), 'FA4D -> 7949';
ok Uni.new(0xFA4E).NFC.list ~~ (0x7948,), 'FA4E -> 7948';
ok Uni.new(0xFA4F).NFC.list ~~ (0x7950,), 'FA4F -> 7950';
ok Uni.new(0xFA50).NFC.list ~~ (0x7956,), 'FA50 -> 7956';
ok Uni.new(0xFA51).NFC.list ~~ (0x795D,), 'FA51 -> 795D';
ok Uni.new(0xFA52).NFC.list ~~ (0x798D,), 'FA52 -> 798D';
ok Uni.new(0xFA53).NFC.list ~~ (0x798E,), 'FA53 -> 798E';
ok Uni.new(0xFA54).NFC.list ~~ (0x7A40,), 'FA54 -> 7A40';
ok Uni.new(0xFA55).NFC.list ~~ (0x7A81,), 'FA55 -> 7A81';
ok Uni.new(0xFA56).NFC.list ~~ (0x7BC0,), 'FA56 -> 7BC0';
ok Uni.new(0xFA57).NFC.list ~~ (0x7DF4,), 'FA57 -> 7DF4';
ok Uni.new(0xFA58).NFC.list ~~ (0x7E09,), 'FA58 -> 7E09';
ok Uni.new(0xFA59).NFC.list ~~ (0x7E41,), 'FA59 -> 7E41';
ok Uni.new(0xFA5A).NFC.list ~~ (0x7F72,), 'FA5A -> 7F72';
ok Uni.new(0xFA5B).NFC.list ~~ (0x8005,), 'FA5B -> 8005';
ok Uni.new(0xFA5C).NFC.list ~~ (0x81ED,), 'FA5C -> 81ED';
ok Uni.new(0xFA5D).NFC.list ~~ (0x8279,), 'FA5D -> 8279';
ok Uni.new(0xFA5E).NFC.list ~~ (0x8279,), 'FA5E -> 8279';
ok Uni.new(0xFA5F).NFC.list ~~ (0x8457,), 'FA5F -> 8457';
ok Uni.new(0xFA60).NFC.list ~~ (0x8910,), 'FA60 -> 8910';
ok Uni.new(0xFA61).NFC.list ~~ (0x8996,), 'FA61 -> 8996';
ok Uni.new(0xFA62).NFC.list ~~ (0x8B01,), 'FA62 -> 8B01';
ok Uni.new(0xFA63).NFC.list ~~ (0x8B39,), 'FA63 -> 8B39';
ok Uni.new(0xFA64).NFC.list ~~ (0x8CD3,), 'FA64 -> 8CD3';
ok Uni.new(0xFA65).NFC.list ~~ (0x8D08,), 'FA65 -> 8D08';
ok Uni.new(0xFA66).NFC.list ~~ (0x8FB6,), 'FA66 -> 8FB6';
ok Uni.new(0xFA67).NFC.list ~~ (0x9038,), 'FA67 -> 9038';
ok Uni.new(0xFA68).NFC.list ~~ (0x96E3,), 'FA68 -> 96E3';
ok Uni.new(0xFA69).NFC.list ~~ (0x97FF,), 'FA69 -> 97FF';
ok Uni.new(0xFA6A).NFC.list ~~ (0x983B,), 'FA6A -> 983B';
ok Uni.new(0xFA6B).NFC.list ~~ (0x6075,), 'FA6B -> 6075';
ok Uni.new(0xFA6C).NFC.list ~~ (0x242EE,), 'FA6C -> 242EE';
ok Uni.new(0xFA6D).NFC.list ~~ (0x8218,), 'FA6D -> 8218';
ok Uni.new(0xFA70).NFC.list ~~ (0x4E26,), 'FA70 -> 4E26';
ok Uni.new(0xFA71).NFC.list ~~ (0x51B5,), 'FA71 -> 51B5';
ok Uni.new(0xFA72).NFC.list ~~ (0x5168,), 'FA72 -> 5168';
ok Uni.new(0xFA73).NFC.list ~~ (0x4F80,), 'FA73 -> 4F80';
ok Uni.new(0xFA74).NFC.list ~~ (0x5145,), 'FA74 -> 5145';
ok Uni.new(0xFA75).NFC.list ~~ (0x5180,), 'FA75 -> 5180';
ok Uni.new(0xFA76).NFC.list ~~ (0x52C7,), 'FA76 -> 52C7';
ok Uni.new(0xFA77).NFC.list ~~ (0x52FA,), 'FA77 -> 52FA';
ok Uni.new(0xFA78).NFC.list ~~ (0x559D,), 'FA78 -> 559D';
ok Uni.new(0xFA79).NFC.list ~~ (0x5555,), 'FA79 -> 5555';
ok Uni.new(0xFA7A).NFC.list ~~ (0x5599,), 'FA7A -> 5599';
ok Uni.new(0xFA7B).NFC.list ~~ (0x55E2,), 'FA7B -> 55E2';
ok Uni.new(0xFA7C).NFC.list ~~ (0x585A,), 'FA7C -> 585A';
ok Uni.new(0xFA7D).NFC.list ~~ (0x58B3,), 'FA7D -> 58B3';
ok Uni.new(0xFA7E).NFC.list ~~ (0x5944,), 'FA7E -> 5944';
ok Uni.new(0xFA7F).NFC.list ~~ (0x5954,), 'FA7F -> 5954';
ok Uni.new(0xFA80).NFC.list ~~ (0x5A62,), 'FA80 -> 5A62';
ok Uni.new(0xFA81).NFC.list ~~ (0x5B28,), 'FA81 -> 5B28';
ok Uni.new(0xFA82).NFC.list ~~ (0x5ED2,), 'FA82 -> 5ED2';
ok Uni.new(0xFA83).NFC.list ~~ (0x5ED9,), 'FA83 -> 5ED9';
ok Uni.new(0xFA84).NFC.list ~~ (0x5F69,), 'FA84 -> 5F69';
ok Uni.new(0xFA85).NFC.list ~~ (0x5FAD,), 'FA85 -> 5FAD';
ok Uni.new(0xFA86).NFC.list ~~ (0x60D8,), 'FA86 -> 60D8';
ok Uni.new(0xFA87).NFC.list ~~ (0x614E,), 'FA87 -> 614E';
ok Uni.new(0xFA88).NFC.list ~~ (0x6108,), 'FA88 -> 6108';
ok Uni.new(0xFA89).NFC.list ~~ (0x618E,), 'FA89 -> 618E';
ok Uni.new(0xFA8A).NFC.list ~~ (0x6160,), 'FA8A -> 6160';
ok Uni.new(0xFA8B).NFC.list ~~ (0x61F2,), 'FA8B -> 61F2';
ok Uni.new(0xFA8C).NFC.list ~~ (0x6234,), 'FA8C -> 6234';
ok Uni.new(0xFA8D).NFC.list ~~ (0x63C4,), 'FA8D -> 63C4';
ok Uni.new(0xFA8E).NFC.list ~~ (0x641C,), 'FA8E -> 641C';
ok Uni.new(0xFA8F).NFC.list ~~ (0x6452,), 'FA8F -> 6452';
