// SPDX-FileCopyrightText: 2021-2023 deroad <wargio@libero.it>
// SPDX-License-Identifier: LGPL-3.0-only

#include "minunit.h"

mu_demangle_tests(java,
	mu_demangle_test("Ljava/lang/String;", "String"),
	mu_demangle_test("Lsome/random/Class;", "some.random.Class"),
	mu_demangle_test("B", "byte"),
	mu_demangle_test("C", "char"),
	mu_demangle_test("D", "double"),
	mu_demangle_test("F", "float"),
	mu_demangle_test("I", "int"),
	mu_demangle_test("J", "long"),
	mu_demangle_test("S", "short"),
	mu_demangle_test("V", "void"),
	mu_demangle_test("Z", "boolean"),

	mu_demangle_test("[Ljava/lang/String;", "String[]"),
	mu_demangle_test("[Lsome/random/Class;", "some.random.Class[]"),
	mu_demangle_test("[B", "byte[]"),
	mu_demangle_test("[C", "char[]"),
	mu_demangle_test("[D", "double[]"),
	mu_demangle_test("[F", "float[]"),
	mu_demangle_test("[I", "int[]"),
	mu_demangle_test("[J", "long[]"),
	mu_demangle_test("[S", "short[]"),
	mu_demangle_test("[V", "void[]"),
	mu_demangle_test("[Z", "boolean[]"),

	// methods
	mu_demangle_test("makeConcatWithConstants(Ljava/lang/String;)Ljava/lang/String;", "String makeConcatWithConstants(String)"),
	mu_demangle_test("Lsome/random/Class;.makeConcatWithConstants(Ljava/lang/String;)Ljava/lang/String;", "String some.random.Class.makeConcatWithConstants(String)"),
	mu_demangle_test("Fake([BCDFIJSZ)Ltest/class/name;", "test.class.name Fake(byte[], char, double, float, int, long, short, boolean)"),
	mu_demangle_test("Fake([BCDFIJSZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ltest/class/name;", "test.class.name Fake(byte[], char, double, float, int, long, short, boolean, String, String, String)"),

	// fields
	mu_demangle_test("makeConcatWithConstants.Ljava/lang/String;", "makeConcatWithConstants:String"),
	mu_demangle_test("Lsome/random/Class;.makeConcatWithConstants.Ljava/lang/String;", "some.random.Class.makeConcatWithConstants:String"),

	// user tests
	mu_demangle_test("Lahmyth/mine/king/ahmyth/R$id;", "ahmyth.mine.king.ahmyth.R$id"),
	mu_demangle_test("Landroid/app/Activity;", "android.app.Activity"),
	mu_demangle_test("Landroid/app/Service;", "android.app.Service"),
	mu_demangle_test("Landroid/content/ComponentName;", "android.content.ComponentName"),
	mu_demangle_test("Landroid/content/Context;", "android.content.Context"),
	mu_demangle_test("Landroid/content/Intent;", "android.content.Intent"),
	mu_demangle_test("Landroid/database/Cursor;", "android.database.Cursor"),
	mu_demangle_test("Landroid/graphics/Bitmap;", "android.graphics.Bitmap"),
	mu_demangle_test("Landroid/hardware/Camera;", "android.hardware.Camera"),
	mu_demangle_test("Landroid/media/MediaRecorder;", "android.media.MediaRecorder"),
	mu_demangle_test("Landroid/net/Uri;", "android.net.Uri"),
	mu_demangle_test("Landroid/os/Build$VERSION;", "android.os.Build$VERSION"),
	mu_demangle_test("Landroid/os/Build;", "android.os.Build"),
	mu_demangle_test("Landroid/os/Bundle;", "android.os.Bundle"),
	mu_demangle_test("Landroid/os/IBinder;", "android.os.IBinder"),
	mu_demangle_test("Landroid/os/Looper;", "android.os.Looper"),
	mu_demangle_test("Landroid/telephony/SmsManager;", "android.telephony.SmsManager"),
	mu_demangle_test("Landroid/util/Log;", "android.util.Log"),
	mu_demangle_test("Ldalvik/annotation/InnerClass;", "dalvik.annotation.InnerClass"),
	mu_demangle_test("Ldalvik/annotation/Signature;", "dalvik.annotation.Signature"),
	mu_demangle_test("Ldalvik/annotation/Throws;", "dalvik.annotation.Throws"),
	mu_demangle_test("Lio/socket/backo/Backoff;", "io.socket.backo.Backoff"),
	mu_demangle_test("Lio/socket/client/Ack;", "io.socket.client.Ack"),
	mu_demangle_test("Lio/socket/client/IO$Options;", "io.socket.client.IO$Options"),
	mu_demangle_test("Lio/socket/client/IO;", "io.socket.client.IO"),
	mu_demangle_test("Lio/socket/client/Manager$1$1;", "io.socket.client.Manager$1$1"),
	mu_demangle_test("Lio/socket/client/Manager$1$2;", "io.socket.client.Manager$1$2"),
	mu_demangle_test("Lio/socket/client/Manager$1$3;", "io.socket.client.Manager$1$3"),
	mu_demangle_test("Lio/socket/client/Manager$1$4;", "io.socket.client.Manager$1$4"),
	mu_demangle_test("Lio/socket/client/Manager$1$5;", "io.socket.client.Manager$1$5"),
	mu_demangle_test("Lio/socket/client/Manager$10;", "io.socket.client.Manager$10"),
	mu_demangle_test("Lio/socket/client/Manager$11$1;", "io.socket.client.Manager$11$1"),
	mu_demangle_test("Lio/socket/client/Manager$11;", "io.socket.client.Manager$11"),
	mu_demangle_test("Lio/socket/client/Manager$12;", "io.socket.client.Manager$12"),
	mu_demangle_test("Lio/socket/client/Manager$1;", "io.socket.client.Manager$1"),
	mu_demangle_test("Lio/socket/client/Manager$2;", "io.socket.client.Manager$2"),
	mu_demangle_test("Lio/socket/client/Manager$3;", "io.socket.client.Manager$3"),
	mu_demangle_test("Lio/socket/client/Manager$4;", "io.socket.client.Manager$4"),
	mu_demangle_test("Lio/socket/client/Manager$5;", "io.socket.client.Manager$5"),
	mu_demangle_test("Lio/socket/client/Manager$6;", "io.socket.client.Manager$6"),
	mu_demangle_test("Lio/socket/client/Manager$7;", "io.socket.client.Manager$7"),
	mu_demangle_test("Lio/socket/client/Manager$8;", "io.socket.client.Manager$8"),
	mu_demangle_test("Lio/socket/client/Manager$9;", "io.socket.client.Manager$9"),
	mu_demangle_test("Lio/socket/client/Manager;", "io.socket.client.Manager"),
	mu_demangle_test("Lio/socket/client/On$1;", "io.socket.client.On$1"),
	mu_demangle_test("Lio/socket/client/On$Handle;", "io.socket.client.On$Handle"),
	mu_demangle_test("Lio/socket/client/On;", "io.socket.client.On"),
	mu_demangle_test("Lio/socket/client/Socket$2$1;", "io.socket.client.Socket$2$1"),
	mu_demangle_test("Lio/socket/client/Socket$2$2;", "io.socket.client.Socket$2$2"),
	mu_demangle_test("Lio/socket/client/Socket$2$3;", "io.socket.client.Socket$2$3"),
	mu_demangle_test("Lio/socket/client/Socket$6$1;", "io.socket.client.Socket$6$1"),
	mu_demangle_test("Lio/socket/client/Socket$7$1;", "io.socket.client.Socket$7$1"),
	mu_demangle_test("Lio/socket/client/Socket;", "io.socket.client.Socket"),
	mu_demangle_test("Lio/socket/client/Url;", "io.socket.client.Url"),
	mu_demangle_test("Lio/socket/global/Global;", "io.socket.global.Global"),
	mu_demangle_test("Lio/socket/hasbinary/HasBinary;", "io.socket.hasbinary.HasBinary"),
	mu_demangle_test("Lio/socket/parser/Binary;", "io.socket.parser.Binary"),
	mu_demangle_test("Lio/socket/parser/Packet;", "io.socket.parser.Packet"),
	mu_demangle_test("Lio/socket/parser/Packet<*>;", "io.socket.parser.Packet<T>"),
	mu_demangle_test("Lio/socket/parser/Packet<TT;>;", "io.socket.parser.Packet<T, T>"),
	mu_demangle_test("Lio/socket/parser/Parser;", "io.socket.parser.Parser"),
	mu_demangle_test("Lio/socket/thread/EventThread;", "io.socket.thread.EventThread"),
	mu_demangle_test("Lio/socket/utf8/UTF8;", "io.socket.utf8.UTF8"),
	mu_demangle_test("Lio/socket/utf8/UTF8Exception;", "io.socket.utf8.UTF8Exception"),
	mu_demangle_test("Lio/socket/yeast/Yeast;", "io.socket.yeast.Yeast"),
	mu_demangle_test("Ljava/io/BufferedInputStream;", "java.io.BufferedInputStream"),
	mu_demangle_test("Ljava/io/BufferedOutputStream;", "java.io.BufferedOutputStream"),
	mu_demangle_test("Ljava/io/BufferedReader;", "java.io.BufferedReader"),
	mu_demangle_test("Ljava/io/ByteArrayOutputStream;", "java.io.ByteArrayOutputStream"),
	mu_demangle_test("Ljava/io/Closeable;", "java.io.Closeable"),
	mu_demangle_test("Ljava/io/EOFException;", "java.io.EOFException"),
	mu_demangle_test("Ljava/io/File;", "java.io.File"),
	mu_demangle_test("Ljava/io/FileInputStream;", "java.io.FileInputStream"),
	mu_demangle_test("Ljava/io/FileNotFoundException;", "java.io.FileNotFoundException"),
	mu_demangle_test("Ljava/io/FileOutputStream;", "java.io.FileOutputStream"),
	mu_demangle_test("Ljava/io/Flushable;", "java.io.Flushable"),
	mu_demangle_test("Ljava/io/InputStream;", "java.io.InputStream"),
	mu_demangle_test("Ljava/io/IOException;", "java.io.IOException"),
	mu_demangle_test("Ljava/io/ObjectOutputStream;", "java.io.ObjectOutputStream"),
	mu_demangle_test("Ljava/io/OutputStream;", "java.io.OutputStream"),
	mu_demangle_test("Ljava/io/RandomAccessFile;", "java.io.RandomAccessFile"),
	mu_demangle_test("Ljava/io/Reader;", "java.io.Reader"),
	mu_demangle_test("Ljava/io/Serializable;", "java.io.Serializable"),
	mu_demangle_test("Ljava/lang/AssertionError;", "java.lang.AssertionError"),
	mu_demangle_test("Ljava/lang/Boolean;", "Boolean"),
	mu_demangle_test("Ljava/lang/Byte;", "Byte"),
	mu_demangle_test("Ljava/lang/Character;", "Character"),
	mu_demangle_test("Ljava/lang/CharSequence;", "java.lang.CharSequence"),
	mu_demangle_test("Ljava/lang/Class;", "Class"),
	mu_demangle_test("Ljava/lang/Class<*>;", "Class<T>"),
	mu_demangle_test("Ljava/lang/Class<TT;>;", "Class<T, T>"),
	mu_demangle_test("Ljava/lang/ClassLoader;", "ClassLoader"),
	mu_demangle_test("Ljava/lang/Cloneable;", "java.lang.Cloneable"),
	mu_demangle_test("Ljava/lang/Comparable;", "java.lang.Comparable"),
	mu_demangle_test("Ljava/lang/Enum;", "Enum"),
	mu_demangle_test("Ljava/lang/Exception;", "Exception"),
	mu_demangle_test("Ljava/lang/IllegalAccessError;", "java.lang.IllegalAccessError"),
	mu_demangle_test("Ljava/lang/Integer;", "Integer"),
	mu_demangle_test("Ljava/lang/LinkageError;", "java.lang.LinkageError"),
	mu_demangle_test("Ljava/lang/Long;", "Long"),
	mu_demangle_test("Ljava/lang/Math;", "Math"),
	mu_demangle_test("Ljava/lang/NoSuchFieldError;", "java.lang.NoSuchFieldError"),
	mu_demangle_test("Ljava/lang/Object;", "Object"),
	mu_demangle_test("Ljava/lang/ref/Reference;", "java.lang.ref.Reference"),
	mu_demangle_test("Ljava/lang/ref/WeakReference;", "java.lang.ref.WeakReference"),
	mu_demangle_test("Ljava/lang/reflect/Array;", "java.lang.reflect.Array"),
	mu_demangle_test("Ljava/lang/reflect/Constructor;", "java.lang.reflect.Constructor"),
	mu_demangle_test("Ljava/lang/reflect/Field;", "java.lang.reflect.Field"),
	mu_demangle_test("Ljava/lang/reflect/Method;", "java.lang.reflect.Method"),
	mu_demangle_test("Ljava/lang/reflect/Proxy;", "java.lang.reflect.Proxy"),
	mu_demangle_test("Ljava/lang/Runnable;", "java.lang.Runnable"),
	mu_demangle_test("Ljava/lang/RuntimeException;", "RuntimeException"),
	mu_demangle_test("Ljava/lang/SecurityException;", "java.lang.SecurityException"),
	mu_demangle_test("Ljava/lang/Short;", "Short"),
	mu_demangle_test("Ljava/lang/String;", "String"),
	mu_demangle_test("Ljava/lang/StringBuilder;", "StringBuilder"),
	mu_demangle_test("Ljava/lang/System;", "System"),
	mu_demangle_test("Ljava/lang/Thread;", "Thread"),
	mu_demangle_test("Ljava/lang/ThreadDeath;", "ThreadDeath"),
	mu_demangle_test("Ljava/lang/ThreadLocal;", "ThreadLocal"),
	mu_demangle_test("Ljava/lang/Throwable;", "Throwable"),
	mu_demangle_test("Ljava/lang/VirtualMachineError;", "java.lang.VirtualMachineError"),
	mu_demangle_test("Ljava/lang/Void;", "Void"),
	mu_demangle_test("Ljava/math/BigDecimal;", "java.math.BigDecimal"),
	mu_demangle_test("Ljava/math/BigInteger;", "java.math.BigInteger"),
	mu_demangle_test("Ljava/net/HttpRetryException;", "java.net.HttpRetryException"),
	mu_demangle_test("Ljava/net/HttpURLConnection;", "java.net.HttpURLConnection"),
	mu_demangle_test("Ljava/net/IDN;", "java.net.IDN"),
	mu_demangle_test("Ljava/net/InetAddress;", "java.net.InetAddress"),
	mu_demangle_test("Ljava/net/InetSocketAddress;", "java.net.InetSocketAddress"),
	mu_demangle_test("Ljava/net/ProtocolException;", "java.net.ProtocolException"),
	mu_demangle_test("Ljava/net/Proxy$Type;", "java.net.Proxy$Type"),
	mu_demangle_test("Ljava/net/Proxy;", "java.net.Proxy"),
	mu_demangle_test("Ljava/net/ProxySelector;", "java.net.ProxySelector"),
	mu_demangle_test("Ljava/net/ServerSocket;", "java.net.ServerSocket"),
	mu_demangle_test("Ljava/net/Socket;", "java.net.Socket"),
	mu_demangle_test("Ljava/net/SocketAddress;", "java.net.SocketAddress"),
	mu_demangle_test("Ljava/net/SocketException;", "java.net.SocketException"),
	mu_demangle_test("Ljava/net/UnknownHostException;", "java.net.UnknownHostException"),
	mu_demangle_test("Ljava/net/URI;", "java.net.URI"),
	mu_demangle_test("Ljava/net/URISyntaxException;", "java.net.URISyntaxException"),
	mu_demangle_test("Ljava/net/URL;", "java.net.URL"),
	mu_demangle_test("Ljava/net/URLConnection;", "java.net.URLConnection"),
	mu_demangle_test("Ljava/net/URLDecoder;", "java.net.URLDecoder"),
	mu_demangle_test("Ljava/net/URLEncoder;", "java.net.URLEncoder"),
	mu_demangle_test("Ljava/nio/Buffer;", "java.nio.Buffer"),
	mu_demangle_test("Ljava/nio/ByteBuffer;", "java.nio.ByteBuffer"),
	mu_demangle_test("Ljava/nio/channels/FileChannel;", "java.nio.channels.FileChannel"),
	mu_demangle_test("Ljava/nio/charset/Charset;", "java.nio.charset.Charset"),
	mu_demangle_test("Ljava/nio/file/Files;", "java.nio.file.Files"),
	mu_demangle_test("Ljava/nio/file/Path;", "java.nio.file.Path"),
	mu_demangle_test("Ljava/security/Key;", "java.security.Key"),
	mu_demangle_test("Ljava/security/KeyStore;", "java.security.KeyStore"),
	mu_demangle_test("Ljava/security/MessageDigest;", "java.security.MessageDigest"),
	mu_demangle_test("Ljava/security/Principal;", "java.security.Principal"),
	mu_demangle_test("Ljava/security/PublicKey;", "java.security.PublicKey"),
	mu_demangle_test("Ljava/security/SecureRandom;", "java.security.SecureRandom"),
	mu_demangle_test("Ljava/text/DateFormat;", "java.text.DateFormat"),
	mu_demangle_test("Ljava/text/ParsePosition;", "java.text.ParsePosition"),
	mu_demangle_test("Ljava/text/SimpleDateFormat;", "java.text.SimpleDateFormat"),
	mu_demangle_test("Ljava/util/AbstractList;", "java.util.AbstractList"),
	mu_demangle_test("Ljava/util/ArrayDeque;", "java.util.ArrayDeque"),
	mu_demangle_test("Ljava/util/ArrayList;", "java.util.ArrayList"),
	mu_demangle_test("Ljava/util/ArrayList<[B>;", "java.util.ArrayList<byte[]>"),
	mu_demangle_test("Ljava/util/Arrays;", "java.util.Arrays"),
	mu_demangle_test("Ljava/util/Calendar;", "java.util.Calendar"),
	mu_demangle_test("Ljava/util/Collection;", "java.util.Collection"),
	mu_demangle_test("Ljava/util/Collection<*>;", "java.util.Collection<T>"),
	mu_demangle_test("Ljava/util/Collections;", "java.util.Collections"),
	mu_demangle_test("Ljava/util/Comparator;", "java.util.Comparator"),
	mu_demangle_test("Ljava/util/concurrent/Executor;", "java.util.concurrent.Executor"),
	mu_demangle_test("Ljava/util/concurrent/Future;", "java.util.concurrent.Future"),
	mu_demangle_test("Ljava/util/concurrent/TimeUnit;", "java.util.concurrent.TimeUnit"),
	mu_demangle_test("Ljava/util/Date;", "java.util.Date"),
	mu_demangle_test("Ljava/util/Deque;", "java.util.Deque"),
	mu_demangle_test("Ljava/util/Deque<TT;>;", "java.util.Deque<T, T>"),
	mu_demangle_test("Ljava/util/GregorianCalendar;", "java.util.GregorianCalendar"),
	mu_demangle_test("Ljava/util/HashMap;", "java.util.HashMap"),
	mu_demangle_test("Ljava/util/HashSet;", "java.util.HashSet"),
	mu_demangle_test("Ljava/util/Iterator;", "java.util.Iterator"),
	mu_demangle_test("Ljava/util/Iterator<*>;", "java.util.Iterator<T>"),
	mu_demangle_test("Ljava/util/LinkedHashMap;", "java.util.LinkedHashMap"),
	mu_demangle_test("Ljava/util/LinkedHashSet;", "java.util.LinkedHashSet"),
	mu_demangle_test("Ljava/util/LinkedList;", "java.util.LinkedList"),
	mu_demangle_test("Ljava/util/List;", "java.util.List"),
	mu_demangle_test("Ljava/util/List<*>;", "java.util.List<T>"),
	mu_demangle_test("Ljava/util/List<[B>;", "java.util.List<byte[]>"),
	mu_demangle_test("Ljava/util/List<TT;>;", "java.util.List<T, T>"),
	mu_demangle_test("Ljava/util/Locale;", "java.util.Locale"),
	mu_demangle_test("Ljava/util/logging/Level;", "java.util.logging.Level"),
	mu_demangle_test("Ljava/util/logging/Logger;", "java.util.logging.Logger"),
	mu_demangle_test("Ljava/util/Map$Entry;", "java.util.Map$Entry"),
	mu_demangle_test("Ljava/util/Map;", "java.util.Map"),
	mu_demangle_test("Ljava/util/Queue;", "java.util.Queue"),
	mu_demangle_test("Ljava/util/Random;", "java.util.Random"),
	mu_demangle_test("Ljava/util/RandomAccess;", "java.util.RandomAccess"),
	mu_demangle_test("Ljava/util/regex/Matcher;", "java.util.regex.Matcher"),
	mu_demangle_test("Ljava/util/regex/Pattern;", "java.util.regex.Pattern"),
	mu_demangle_test("Ljava/util/Set;", "java.util.Set"),
	mu_demangle_test("Ljava/util/Timer;", "java.util.Timer"),
	mu_demangle_test("Ljava/util/TimerTask;", "java.util.TimerTask"),
	mu_demangle_test("Ljava/util/TimeZone;", "java.util.TimeZone"),
	mu_demangle_test("Ljava/util/TreeMap;", "java.util.TreeMap"),
	mu_demangle_test("Ljava/util/TreeSet;", "java.util.TreeSet"),
	mu_demangle_test("Ljava/util/UUID;", "java.util.UUID"),
	mu_demangle_test("Ljava/util/zip/CRC32;", "java.util.zip.CRC32"),
	mu_demangle_test("Ljava/util/zip/Deflater;", "java.util.zip.Deflater"),
	mu_demangle_test("Ljava/util/zip/Inflater;", "java.util.zip.Inflater"),
	mu_demangle_test("Ljavax/crypto/Mac;", "javax.crypto.Mac"),
	mu_demangle_test("Ljavax/net/SocketFactory;", "javax.net.SocketFactory"),
	mu_demangle_test("Ljavax/net/ssl/SSLContext;", "javax.net.ssl.SSLContext"),
	mu_demangle_test("Ljavax/net/ssl/SSLException;", "javax.net.ssl.SSLException"),
	mu_demangle_test("Ljavax/net/ssl/SSLParameters;", "javax.net.ssl.SSLParameters"),
	mu_demangle_test("Ljavax/net/ssl/SSLSession;", "javax.net.ssl.SSLSession"),
	mu_demangle_test("Ljavax/net/ssl/SSLSocket;", "javax.net.ssl.SSLSocket"),
	mu_demangle_test("Lio/socket/engineio/parser/Parser$DecodePayloadCallback<Ljava/lang/String;>;", "io.socket.engineio.parser.Parser$DecodePayloadCallback<String>"),
	mu_demangle_test("Lokhttp3/Address;", "okhttp3.Address"),
	mu_demangle_test("Lokhttp3/Authenticator$1;", "okhttp3.Authenticator$1"),
	mu_demangle_test("Lokhttp3/Authenticator;", "okhttp3.Authenticator"),
	mu_demangle_test("Lokhttp3/Cache$1;", "okhttp3.Cache$1"),
	mu_demangle_test("Lokhttp3/Cache$2;", "okhttp3.Cache$2"),
	mu_demangle_test("Lokhttp3/Cache$Entry;", "okhttp3.Cache$Entry"),
	mu_demangle_test("Lokhttp3/Cache;", "okhttp3.Cache"),
	mu_demangle_test("Lokhttp3/CacheControl$Builder;", "okhttp3.CacheControl$Builder"),
	mu_demangle_test("Lokhttp3/CacheControl;", "okhttp3.CacheControl"),
	mu_demangle_test("Lokhttp3/Call$Factory;", "okhttp3.Call$Factory"),
	mu_demangle_test("Lokhttp3/Call;", "okhttp3.Call"),
	mu_demangle_test("Lokhttp3/Callback;", "okhttp3.Callback"),
	mu_demangle_test("Lokhttp3/CertificatePinner$Pin;", "okhttp3.CertificatePinner$Pin"),
	mu_demangle_test("Lokhttp3/Challenge;", "okhttp3.Challenge"),
	mu_demangle_test("Lokhttp3/CipherSuite;", "okhttp3.CipherSuite"),
	mu_demangle_test("Lokhttp3/Connection;", "okhttp3.Connection"),
	mu_demangle_test("Lokhttp3/ConnectionPool$1;", "okhttp3.ConnectionPool$1"),
	mu_demangle_test("Lokhttp3/ConnectionPool;", "okhttp3.ConnectionPool"),
	mu_demangle_test("Lokhttp3/ConnectionSpec;", "okhttp3.ConnectionSpec"),
	mu_demangle_test("Lokhttp3/Cookie$Builder;", "okhttp3.Cookie$Builder"),
	mu_demangle_test("Lokhttp3/Cookie;", "okhttp3.Cookie"),
	mu_demangle_test("Lokhttp3/CookieJar$1;", "okhttp3.CookieJar$1"),
	mu_demangle_test("Lokhttp3/CookieJar;", "okhttp3.CookieJar"),
	mu_demangle_test("Lokhttp3/Credentials;", "okhttp3.Credentials"),
	mu_demangle_test("Lokhttp3/Dispatcher;", "okhttp3.Dispatcher"),
	mu_demangle_test("Lokhttp3/Dns$1;", "okhttp3.Dns$1"),
	mu_demangle_test("Lokhttp3/FormBody$Builder;", "okhttp3.FormBody$Builder"),
	mu_demangle_test("Lokhttp3/FormBody;", "okhttp3.FormBody"),
	mu_demangle_test("Lokhttp3/Handshake;", "okhttp3.Handshake"),
	mu_demangle_test("Lokhttp3/Headers$Builder;", "okhttp3.Headers$Builder"),
	mu_demangle_test("Lokhttp3/Headers;", "okhttp3.Headers"),
	mu_demangle_test("Lokhttp3/HttpUrl$1;", "okhttp3.HttpUrl$1"),
	mu_demangle_test("Lokhttp3/HttpUrl$Builder;", "okhttp3.HttpUrl$Builder"),
	mu_demangle_test("Lokhttp3/HttpUrl;", "okhttp3.HttpUrl"),
	mu_demangle_test("Lokhttp3/Interceptor;", "okhttp3.Interceptor"),
	mu_demangle_test("Lokhttp3/internal/cache2/Relay;", "okhttp3.internal.cache2.Relay"),
	mu_demangle_test("Lokhttp3/internal/http2/Header;", "okhttp3.internal.http2.Header"),
	mu_demangle_test("Lokhttp3/internal/http2/Hpack;", "okhttp3.internal.http2.Hpack"),
	mu_demangle_test("Lokhttp3/internal/http2/Http2;", "okhttp3.internal.http2.Http2"),
	mu_demangle_test("Lokhttp3/internal/http2/Ping;", "okhttp3.internal.http2.Ping"),
	mu_demangle_test("Lokhttp3/internal/Util$1;", "okhttp3.internal.Util$1"),
	mu_demangle_test("Lokhttp3/internal/Util;", "okhttp3.internal.Util"),
	mu_demangle_test("Lokhttp3/internal/Version;", "okhttp3.internal.Version"),
	mu_demangle_test("Lokhttp3/MediaType;", "okhttp3.MediaType"),
	mu_demangle_test("Lokhttp3/MultipartBody$Builder;", "okhttp3.MultipartBody$Builder"),
	mu_demangle_test("Lokhttp3/MultipartBody$Part;", "okhttp3.MultipartBody$Part"),
	mu_demangle_test("Lokhttp3/MultipartBody;", "okhttp3.MultipartBody"),
	mu_demangle_test("Lokhttp3/OkHttpClient$1;", "okhttp3.OkHttpClient$1"),
	mu_demangle_test("Lokhttp3/OkHttpClient$Builder;", "okhttp3.OkHttpClient$Builder"),
	mu_demangle_test("Lokhttp3/OkHttpClient;", "okhttp3.OkHttpClient"),
	mu_demangle_test("Lokhttp3/Protocol;", "okhttp3.Protocol"),
	mu_demangle_test("Lokhttp3/RealCall$AsyncCall;", "okhttp3.RealCall$AsyncCall"),
	mu_demangle_test("Lokhttp3/RealCall;", "okhttp3.RealCall"),
	mu_demangle_test("Lokhttp3/Request$Builder;", "okhttp3.Request$Builder"),
	mu_demangle_test("Lokhttp3/Request;", "okhttp3.Request"),
	mu_demangle_test("Lokhttp3/RequestBody$1;", "okhttp3.RequestBody$1"),
	mu_demangle_test("Lokhttp3/RequestBody$2;", "okhttp3.RequestBody$2"),
	mu_demangle_test("Lokhttp3/RequestBody$3;", "okhttp3.RequestBody$3"),
	mu_demangle_test("Lokhttp3/RequestBody;", "okhttp3.RequestBody"),
	mu_demangle_test("Lokhttp3/Response$Builder;", "okhttp3.Response$Builder"),
	mu_demangle_test("Lokhttp3/Response;", "okhttp3.Response"),
	mu_demangle_test("Lokhttp3/ResponseBody$1;", "okhttp3.ResponseBody$1"),
	mu_demangle_test("Lokhttp3/ResponseBody;", "okhttp3.ResponseBody"),
	mu_demangle_test("Lokhttp3/Route;", "okhttp3.Route"),
	mu_demangle_test("Lokhttp3/TlsVersion;", "okhttp3.TlsVersion"),
	mu_demangle_test("Lokhttp3/WebSocket;", "okhttp3.WebSocket"),
	mu_demangle_test("Lokio/AsyncTimeout$1;", "okio.AsyncTimeout$1"),
	mu_demangle_test("Lokio/AsyncTimeout$2;", "okio.AsyncTimeout$2"),
	mu_demangle_test("Lokio/AsyncTimeout$Watchdog;", "okio.AsyncTimeout$Watchdog"),
	mu_demangle_test("Lokio/AsyncTimeout;", "okio.AsyncTimeout"),
	mu_demangle_test("Lokio/Buffer$1;", "okio.Buffer$1"),
	mu_demangle_test("Lokio/Buffer$2;", "okio.Buffer$2"),
	mu_demangle_test("Lokio/BufferedSink;", "okio.BufferedSink"),
	mu_demangle_test("Lokio/BufferedSource;", "okio.BufferedSource"),
	mu_demangle_test("Lokio/ByteString;", "okio.ByteString"),
	mu_demangle_test("Lokio/DeflaterSink;", "okio.DeflaterSink"),
	mu_demangle_test("Lokio/ForwardingSink;", "okio.ForwardingSink"),
	mu_demangle_test("Lokio/ForwardingSource;", "okio.ForwardingSource"),
	mu_demangle_test("Lokio/ForwardingTimeout;", "okio.ForwardingTimeout"),
	mu_demangle_test("Lokio/GzipSink;", "okio.GzipSink"),
	mu_demangle_test("Lokio/GzipSource;", "okio.GzipSource"),
	mu_demangle_test("Lokio/HashingSink;", "okio.HashingSink"),
	mu_demangle_test("Lokio/HashingSource;", "okio.HashingSource"),
	mu_demangle_test("Lokio/InflaterSource;", "okio.InflaterSource"),
	mu_demangle_test("Lokio/Options;", "okio.Options"),
	mu_demangle_test("Lokio/Pipe$PipeSink;", "okio.Pipe$PipeSink"),
	mu_demangle_test("Lokio/Pipe$PipeSource;", "okio.Pipe$PipeSource"),
	mu_demangle_test("Lokio/RealBufferedSink$1;", "okio.RealBufferedSink$1"),
	mu_demangle_test("Lokio/RealBufferedSink;", "okio.RealBufferedSink"),
	mu_demangle_test("Lokio/RealBufferedSource;", "okio.RealBufferedSource"),
	mu_demangle_test("Lokio/Segment;", "okio.Segment"),
	mu_demangle_test("Lokio/SegmentedByteString;", "okio.SegmentedByteString"),
	mu_demangle_test("Lokio/SegmentPool;", "okio.SegmentPool"),
	mu_demangle_test("Lokio/Timeout$1;", "okio.Timeout$1"),
	mu_demangle_test("Lokio/Timeout;", "okio.Timeout"),
	mu_demangle_test("Lorg/json/JSONArray;", "org.json.JSONArray"),
	mu_demangle_test("Lorg/json/JSONException;", "org.json.JSONException"),
	mu_demangle_test("Lorg/json/JSONObject;", "org.json.JSONObject"),
	mu_demangle_test("Lorg/json/JSONTokener;", "org.json.JSONTokener"),
	mu_demangle_test("Lsome/jar/Fake<[BCDFIJSZLjava/lang/String;Ljava/lang/String;>", "some.jar.Fake<byte[], char, double, float, int, long, short, boolean, String, String>"),
	mu_demangle_test("Ljava/io/BufferedReader;.<init>(Ljava/io/Reader;)V", "void java.io.BufferedReader.<init>(java.io.Reader)"),
	// end
);

mu_main2(java);
