// Code generated by protoc-gen-go-grpc. DO NOT EDIT.

package v2

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// SkaffoldV2ServiceClient is the client API for SkaffoldV2Service service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SkaffoldV2ServiceClient interface {
	// Returns the state of the current Skaffold execution
	GetState(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*State, error)
	// Returns all the events of the current Skaffold execution from the start
	Events(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (SkaffoldV2Service_EventsClient, error)
	// Returns all the user application logs of the current Skaffold execution
	ApplicationLogs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (SkaffoldV2Service_ApplicationLogsClient, error)
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type skaffoldV2ServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewSkaffoldV2ServiceClient(cc grpc.ClientConnInterface) SkaffoldV2ServiceClient {
	return &skaffoldV2ServiceClient{cc}
}

func (c *skaffoldV2ServiceClient) GetState(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (*State, error) {
	out := new(State)
	err := c.cc.Invoke(ctx, "/proto.v2.SkaffoldV2Service/GetState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldV2ServiceClient) Events(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (SkaffoldV2Service_EventsClient, error) {
	stream, err := c.cc.NewStream(ctx, &SkaffoldV2Service_ServiceDesc.Streams[0], "/proto.v2.SkaffoldV2Service/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldV2ServiceEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SkaffoldV2Service_EventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type skaffoldV2ServiceEventsClient struct {
	grpc.ClientStream
}

func (x *skaffoldV2ServiceEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldV2ServiceClient) ApplicationLogs(ctx context.Context, in *emptypb.Empty, opts ...grpc.CallOption) (SkaffoldV2Service_ApplicationLogsClient, error) {
	stream, err := c.cc.NewStream(ctx, &SkaffoldV2Service_ServiceDesc.Streams[1], "/proto.v2.SkaffoldV2Service/ApplicationLogs", opts...)
	if err != nil {
		return nil, err
	}
	x := &skaffoldV2ServiceApplicationLogsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type SkaffoldV2Service_ApplicationLogsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type skaffoldV2ServiceApplicationLogsClient struct {
	grpc.ClientStream
}

func (x *skaffoldV2ServiceApplicationLogsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *skaffoldV2ServiceClient) Execute(ctx context.Context, in *UserIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.v2.SkaffoldV2Service/Execute", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldV2ServiceClient) AutoBuild(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.v2.SkaffoldV2Service/AutoBuild", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldV2ServiceClient) AutoSync(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.v2.SkaffoldV2Service/AutoSync", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldV2ServiceClient) AutoDeploy(ctx context.Context, in *TriggerRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.v2.SkaffoldV2Service/AutoDeploy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *skaffoldV2ServiceClient) Handle(ctx context.Context, in *Event, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/proto.v2.SkaffoldV2Service/Handle", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SkaffoldV2ServiceServer is the server API for SkaffoldV2Service service.
// All implementations should embed UnimplementedSkaffoldV2ServiceServer
// for forward compatibility
type SkaffoldV2ServiceServer interface {
	// Returns the state of the current Skaffold execution
	GetState(context.Context, *emptypb.Empty) (*State, error)
	// Returns all the events of the current Skaffold execution from the start
	Events(*emptypb.Empty, SkaffoldV2Service_EventsServer) error
	// Returns all the user application logs of the current Skaffold execution
	ApplicationLogs(*emptypb.Empty, SkaffoldV2Service_ApplicationLogsServer) error
	// Allows for a single execution of some or all of the phases (build, sync, deploy) in case autoBuild, autoDeploy or autoSync are disabled.
	Execute(context.Context, *UserIntentRequest) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic build trigger
	AutoBuild(context.Context, *TriggerRequest) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic sync trigger
	AutoSync(context.Context, *TriggerRequest) (*emptypb.Empty, error)
	// Allows for enabling or disabling automatic deploy trigger
	AutoDeploy(context.Context, *TriggerRequest) (*emptypb.Empty, error)
	// EXPERIMENTAL. It allows for custom events to be implemented in custom builders for example.
	Handle(context.Context, *Event) (*emptypb.Empty, error)
}

// UnimplementedSkaffoldV2ServiceServer should be embedded to have forward compatible implementations.
type UnimplementedSkaffoldV2ServiceServer struct {
}

func (UnimplementedSkaffoldV2ServiceServer) GetState(context.Context, *emptypb.Empty) (*State, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetState not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) Events(*emptypb.Empty, SkaffoldV2Service_EventsServer) error {
	return status.Errorf(codes.Unimplemented, "method Events not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) ApplicationLogs(*emptypb.Empty, SkaffoldV2Service_ApplicationLogsServer) error {
	return status.Errorf(codes.Unimplemented, "method ApplicationLogs not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) Execute(context.Context, *UserIntentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Execute not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) AutoBuild(context.Context, *TriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoBuild not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) AutoSync(context.Context, *TriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoSync not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) AutoDeploy(context.Context, *TriggerRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AutoDeploy not implemented")
}
func (UnimplementedSkaffoldV2ServiceServer) Handle(context.Context, *Event) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Handle not implemented")
}

// UnsafeSkaffoldV2ServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SkaffoldV2ServiceServer will
// result in compilation errors.
type UnsafeSkaffoldV2ServiceServer interface {
	mustEmbedUnimplementedSkaffoldV2ServiceServer()
}

func RegisterSkaffoldV2ServiceServer(s grpc.ServiceRegistrar, srv SkaffoldV2ServiceServer) {
	s.RegisterService(&SkaffoldV2Service_ServiceDesc, srv)
}

func _SkaffoldV2Service_GetState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(emptypb.Empty)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldV2ServiceServer).GetState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.v2.SkaffoldV2Service/GetState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldV2ServiceServer).GetState(ctx, req.(*emptypb.Empty))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldV2Service_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SkaffoldV2ServiceServer).Events(m, &skaffoldV2ServiceEventsServer{stream})
}

type SkaffoldV2Service_EventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type skaffoldV2ServiceEventsServer struct {
	grpc.ServerStream
}

func (x *skaffoldV2ServiceEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _SkaffoldV2Service_ApplicationLogs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(emptypb.Empty)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(SkaffoldV2ServiceServer).ApplicationLogs(m, &skaffoldV2ServiceApplicationLogsServer{stream})
}

type SkaffoldV2Service_ApplicationLogsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type skaffoldV2ServiceApplicationLogsServer struct {
	grpc.ServerStream
}

func (x *skaffoldV2ServiceApplicationLogsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _SkaffoldV2Service_Execute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldV2ServiceServer).Execute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.v2.SkaffoldV2Service/Execute",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldV2ServiceServer).Execute(ctx, req.(*UserIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldV2Service_AutoBuild_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldV2ServiceServer).AutoBuild(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.v2.SkaffoldV2Service/AutoBuild",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldV2ServiceServer).AutoBuild(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldV2Service_AutoSync_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldV2ServiceServer).AutoSync(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.v2.SkaffoldV2Service/AutoSync",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldV2ServiceServer).AutoSync(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldV2Service_AutoDeploy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldV2ServiceServer).AutoDeploy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.v2.SkaffoldV2Service/AutoDeploy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldV2ServiceServer).AutoDeploy(ctx, req.(*TriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SkaffoldV2Service_Handle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Event)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SkaffoldV2ServiceServer).Handle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/proto.v2.SkaffoldV2Service/Handle",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SkaffoldV2ServiceServer).Handle(ctx, req.(*Event))
	}
	return interceptor(ctx, in, info, handler)
}

// SkaffoldV2Service_ServiceDesc is the grpc.ServiceDesc for SkaffoldV2Service service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var SkaffoldV2Service_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "proto.v2.SkaffoldV2Service",
	HandlerType: (*SkaffoldV2ServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetState",
			Handler:    _SkaffoldV2Service_GetState_Handler,
		},
		{
			MethodName: "Execute",
			Handler:    _SkaffoldV2Service_Execute_Handler,
		},
		{
			MethodName: "AutoBuild",
			Handler:    _SkaffoldV2Service_AutoBuild_Handler,
		},
		{
			MethodName: "AutoSync",
			Handler:    _SkaffoldV2Service_AutoSync_Handler,
		},
		{
			MethodName: "AutoDeploy",
			Handler:    _SkaffoldV2Service_AutoDeploy_Handler,
		},
		{
			MethodName: "Handle",
			Handler:    _SkaffoldV2Service_Handle_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _SkaffoldV2Service_Events_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ApplicationLogs",
			Handler:       _SkaffoldV2Service_ApplicationLogs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "v2/skaffold.proto",
}
