#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xED, 0x3A, 0xCB, 0xB7, 0xC5, 0xFB, 0xDD, 0x6F, 0xC3, 0xD1, 
	0x24, 0x4C, 0x00, 0x57, 0xC7, 0xF1, 0xC0, 0x5C, 0x72, 0xF3, 
	0x24, 0xB9, 0x8D, 0x77, 0x55, 0xF7, 0xE3, 0x53, 0xA9, 0xAF, 
	0xFF, 0xB9, 0x9F, 0xD8, 0x03, 0x8A, 0x7D, 0x1E, 0xB2, 0xFC, 
	0xC2, 0x63, 0x8E, 0x6A, 0x2D, 0xCE, 0x27, 0x95, 0x87, 0xA5, 
	0xFC, 0x21, 0xA1, 0xBE, 0x15, 0xD5, 0x0E, 0x87, 0x61, 0x4A, 
	0x34, 0x23, 0xBD, 0x2D, 0x7A, 0xA6, 0x1D, 0xCE, 0xD0, 0xC9, 
	0xE9, 0x30, 0x13, 0x99, 0x0F, 0x82, 0x7C, 0x27, 0x47, 0x61, 
	0x65, 0x05, 0xF3, 0x62, 0xA1, 0xF6, 0xC4, 0xCF, 0xBD, 0xDC, 
	0x68, 0x7F, 0xC4, 0xE6, 0xB1, 0xCD, 0x3E, 0xEC, 0xD5, 0x08, 
	0xE0, 0x49, 0xD9, 0x0C, 0x86, 0x60, 0xEF, 0x20, 0x0D, 0x8B, 
	0x1A, 0xFD, 0x25, 0x02, 0xCC, 0xA9, 0xA6, 0x78, 0x87, 0xBA, 
	0x6B, 0xC0, 0x80, 0xFA, 0x09, 0x3A, 0x9C, 0xD5, 0x2C, 0xD6, 
	0x02, 0xE2, 0xA6, 0xBC, 0x07, 0x6B, 0x4F, 0x0D, 0x40, 0x3B, 
	0xEE, 0x68, 0xA4, 0xE7, 0x08, 0x5E, 0x96, 0x17, 0x1E, 0x68, 
	0x31, 0x44, 0x98, 0x04, 0x8E, 0x34, 0xFF, 0xA4, 0x46, 0x4B, 
	0x08, 0xCC, 0x0E, 0x6A, 0x34, 0x6D, 0x14, 0xFD, 0x34, 0x7E, 
	0xBD, 0x64, 0xAA, 0x43, 0x13, 0x93, 0x4C, 0x1A, 0x9A, 0x1E, 
	0xF7, 0xC5, 0x2B, 0x60, 0xD4, 0xF2, 0x0B, 0x02, 0xEC, 0x2B, 
	0xE1, 0x5D, 0x18, 0xC8, 0xBF, 0x6E, 0xB2, 0x92, 0xF2, 0x31, 
	0x3C, 0xEE, 0x45, 0x64, 0x1F, 0x5B, 0xD5, 0x99, 0x89, 0x66, 
	0xAB, 0x84, 0xC2, 0xA4, 0x53, 0xF7, 0x6D, 0x79, 0x16, 0x0C, 
	0xF4, 0x3B, 0x8E, 0x85, 0xEE, 0x23, 0x41, 0x26, 0x92, 0xA8, 
	0xED, 0x99, 0xEB, 0xE5, 0x0A, 0xCC, 0x8E, 0xCF, 0xDD, 0x4A, 
	0x3C, 0xD8, 0xCF, 0xF1, 0x7D, 0xB7, 0x14, 0x58, 0x5E, 0xBA, 
	0x18, 0x14, 0xC9, 0xA1, 0x43, 0x7B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
