#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xA7, 0xF0, 0x97, 0x73, 0x24, 0xDB, 0x0D, 0xF0, 0x3B, 0x18, 
	0x2C, 0xC2, 0xBD, 0xFC, 0xA9, 0xD6, 0x86, 0x3C, 0x19, 0xA9, 
	0x94, 0xF3, 0x40, 0x07, 0x9E, 0x7C, 0xE5, 0xCA, 0xA5, 0x59, 
	0x0B, 0x31, 0x8D, 0x57, 0x61, 0xAA, 0xB6, 0x58, 0x39, 0x24, 
	0xA1, 0xDD, 0x19, 0x58, 0xB2, 0x86, 0xBD, 0x1E, 0x0E, 0x31, 
	0x6E, 0xC5, 0x5E, 0x5C, 0x8C, 0xF0, 0xC7, 0xCB, 0x5C, 0xD2, 
	0x31, 0x20, 0x10, 0xDD, 0xE8, 0xFD, 0x49, 0xEF, 0x1F, 0xA7, 
	0x25, 0x84, 0xC2, 0x94, 0x92, 0xD2, 0x2A, 0x7A, 0xB0, 0x09, 
	0xE8, 0x36, 0x11, 0x23, 0x26, 0xC9, 0x15, 0xB0, 0x00, 0xF5, 
	0xB3, 0xF0, 0xE5, 0x8A, 0xA6, 0x98, 0x96, 0xA6, 0xC2, 0x8B, 
	0x90, 0x1E, 0x8A, 0x2E, 0xC1, 0x10, 0xD2, 0x07, 0x6A, 0xE8, 
	0xEE, 0xB5, 0x05, 0x5B, 0x9F, 0x25, 0x64, 0x14, 0xD8, 0x7F, 
	0xF1, 0xCE, 0xBC, 0xAA, 0x1C, 0x67, 0x6F, 0x6A, 0x0E, 0x33, 
	0xD8, 0x86, 0x37, 0x8C, 0x46, 0xD4, 0x80, 0x18, 0x2C, 0xCA, 
	0xFE, 0xF5, 0xF0, 0xF0, 0x2A, 0xAA, 0xB3, 0xA2, 0xB0, 0x85, 
	0xE9, 0x16, 0xEB, 0xD1, 0xE5, 0xA6, 0x8D, 0xBA, 0xCA, 0x67, 
	0x61, 0x9F, 0x77, 0x1F, 0xE1, 0xEB, 0x1C, 0x66, 0x43, 0xC5, 
	0x4C, 0x0B, 0xE2, 0xF0, 0xB3, 0xA4, 0xDB, 0x5C, 0x89, 0x33, 
	0xC7, 0xD7, 0x1D, 0x8E, 0xF9, 0x3C, 0x25, 0x74, 0x20, 0x07, 
	0x0E, 0x19, 0xD1, 0x5C, 0x93, 0xB6, 0x1B, 0x5C, 0x2E, 0xF5, 
	0xEB, 0x81, 0x35, 0xDF, 0x20, 0xE1, 0x88, 0x42, 0x46, 0x07, 
	0x92, 0x22, 0x79, 0x45, 0xDD, 0x86, 0x09, 0xEC, 0x77, 0xA1, 
	0x96, 0x30, 0x83, 0xF9, 0x14, 0x13, 0xE4, 0x71, 0x3E, 0x3F, 
	0x5E, 0x93, 0xA8, 0x95, 0x2D, 0xCF, 0xE4, 0xDB, 0x23, 0xA9, 
	0x2F, 0xCB, 0x9E, 0x91, 0xCA, 0x14, 0xF0, 0x94, 0x3E, 0x4B, 
	0xA3, 0x4E, 0x16, 0xC5, 0x1D, 0x23
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
