#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xA0, 0x4B, 0xDA, 0xBB, 0x10, 0xB5, 0x40, 0x08, 0x03, 0x8D, 
	0xB9, 0xD6, 0xBA, 0x3F, 0xEB, 0x50, 0x13, 0x37, 0x50, 0x67, 
	0x2F, 0x62, 0x54, 0x4D, 0x60, 0xF8, 0x31, 0xEC, 0x02, 0xD7, 
	0xDB, 0x6B, 0x4A, 0x98, 0x0E, 0x43, 0xB7, 0x53, 0x8A, 0xDE, 
	0xF0, 0x76, 0x55, 0x30, 0x7E, 0x99, 0x1C, 0x09, 0x04, 0x9D, 
	0x94, 0x45, 0x34, 0x29, 0x50, 0xC4, 0xE1, 0x28, 0x30, 0x55, 
	0xA3, 0x11, 0x39, 0x9A, 0xFE, 0xED, 0x7A, 0xB6, 0x29, 0xFA, 
	0x98, 0x01, 0x19, 0x16, 0x45, 0x2A, 0xBD, 0x4D, 0x1B, 0xD0, 
	0x5D, 0x7D, 0xF0, 0xD2, 0xC1, 0x30, 0xFA, 0xC0, 0xC8, 0xB0, 
	0x81, 0xCC, 0x0D, 0xFE, 0x20, 0x32, 0xB1, 0x95, 0xBB, 0xF5, 
	0xAD, 0x6D, 0xD6, 0xFD, 0xC9, 0x4C, 0xFD, 0xDA, 0x42, 0x68, 
	0xFA, 0x02, 0x6A, 0x08, 0xA0, 0xC9, 0x1B, 0xAB, 0xD9, 0x29, 
	0x97, 0x7F, 0xEF, 0xF8, 0xB1, 0x63, 0xB5, 0xC9, 0x27, 0x18, 
	0x2C, 0x3E, 0xC8, 0x73, 0xB9, 0xE4, 0xBF, 0xEF, 0x96, 0x25, 
	0xEB, 0xBF, 0x41, 0x48, 0x00, 0x3D, 0xB0, 0x19, 0xB6, 0x6B, 
	0x53, 0x37, 0x4C, 0x1B, 0xE7, 0xEF, 0x8E, 0x25, 0x95, 0x49, 
	0xD8, 0x5B, 0x8B, 0x19, 0x7D, 0xA9, 0x7F, 0xA2, 0x30, 0x62, 
	0x65, 0xC0, 0x2F, 0x49, 0x2A, 0x5C, 0x53, 0x0B, 0x1E, 0xA3, 
	0xB4, 0xD6, 0x8F, 0x65, 0x3B, 0x9B, 0x73, 0xEC, 0x4E, 0x9F, 
	0x2D, 0x89, 0xDB, 0xAF, 0xF1, 0xEE, 0xA8, 0x43, 0xB6, 0x54, 
	0x06, 0x24, 0x9E, 0x15, 0x74, 0x63, 0x2E, 0x24, 0xCF, 0x7B, 
	0xE4, 0x56, 0xEC, 0x5A, 0x62, 0x1B, 0x00, 0x90, 0x9E, 0xA8, 
	0x97, 0x2E, 0xFF, 0x3C, 0x8B, 0x39, 0x97, 0xE6, 0x16, 0xCF, 
	0xB6, 0xA9, 0xEC, 0xE3, 0xC5, 0x77, 0x54, 0xB6, 0xBF, 0x04, 
	0xB1, 0x45, 0x20, 0x93, 0x91, 0xC3, 0xBF, 0xCF, 0x1D, 0x1A, 
	0x18, 0x06, 0x84, 0x85, 0xEB, 0xB3
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
