#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xDB, 0xD4, 0x00, 0xCC, 0x27, 0x43, 0xB7, 0x83, 0xE3, 0x3C, 
	0xF9, 0x70, 0x5F, 0x0D, 0xA6, 0x6D, 0xC6, 0x05, 0xD9, 0xA1, 
	0xDD, 0xE7, 0xAE, 0x91, 0x05, 0x81, 0x50, 0xCA, 0x93, 0xC8, 
	0x12, 0xFB, 0x16, 0xB4, 0x27, 0x9D, 0xB7, 0x95, 0x62, 0x36, 
	0x75, 0x0B, 0x74, 0xCC, 0x38, 0xE0, 0xF0, 0xDC, 0x37, 0xEA, 
	0x8D, 0x48, 0xE6, 0x93, 0x30, 0xD0, 0x5E, 0xFA, 0xC7, 0xDD, 
	0xB9, 0xBF, 0x29, 0xB1, 0xC6, 0x0A, 0x74, 0x83, 0xE3, 0x65, 
	0x30, 0x4D, 0x51, 0xFC, 0x46, 0xE3, 0x0E, 0x73, 0xEA, 0xC4, 
	0x9A, 0x62, 0x07, 0xE5, 0x7A, 0x50, 0x79, 0xE4, 0x9B, 0x07, 
	0x00, 0x33, 0xBA, 0x2E, 0xCB, 0xD8, 0xAE, 0x4A, 0x60, 0xD2, 
	0x50, 0xD8, 0x79, 0xC4, 0x27, 0x3D, 0xB0, 0xA2, 0xC0, 0x32, 
	0x31, 0x0E, 0xE0, 0xAE, 0xBB, 0x7F, 0xCA, 0xAF, 0xF8, 0x5E, 
	0x99, 0x7C, 0x81, 0xDB, 0x67, 0xBC, 0xC5, 0xB9, 0x48, 0x7F, 
	0x37, 0x0E, 0x16, 0x01, 0x12, 0x4E, 0xB1, 0x39, 0xA0, 0xB4, 
	0x58, 0x84, 0xAF, 0xB7, 0x2B, 0xC8, 0x4D, 0xDB, 0x38, 0x69, 
	0x38, 0x29, 0x5F, 0xFF, 0x7D, 0x75, 0x20, 0x11, 0x11, 0xA0, 
	0x11, 0xDA, 0xEA, 0x0D, 0x10, 0xDE, 0xE7, 0xF7, 0xF7, 0xAF, 
	0x55, 0x60, 0x1C, 0x69, 0x28, 0x13, 0x0A, 0x4A, 0xAA, 0x79, 
	0x67, 0x89, 0x4C, 0xBF, 0x3A, 0x25, 0xE2, 0xBB, 0xB4, 0x1F, 
	0xA5, 0x23, 0x29, 0xF4, 0x38, 0xF9, 0x37, 0x59, 0x90, 0x84, 
	0x90, 0x10, 0x9D, 0x22, 0x0A, 0xAF, 0xF3, 0x2D, 0xB8, 0x7E, 
	0x9D, 0x77, 0x83, 0x29, 0xAC, 0x54, 0xC6, 0xF8, 0xB1, 0xF1, 
	0xFE, 0x8F, 0xD2, 0x7A, 0x17, 0x28, 0x06, 0xDB, 0x74, 0x6F, 
	0x01, 0x1D, 0x28, 0xFC, 0x82, 0x12, 0x2D, 0x76, 0xC9, 0x0E, 
	0xCC, 0x9E, 0xC5, 0xBE, 0xC5, 0x56, 0x90, 0x85, 0x96, 0x22, 
	0x8A, 0xF1, 0x6D, 0xDC, 0xDF, 0x5B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
