#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xF8, 0x02, 0xB5, 0xA9, 0x8A, 0xBE, 0x2E, 0x19, 0xAD, 0xB0, 
	0x0E, 0xA8, 0xC8, 0x25, 0xD1, 0x42, 0xBC, 0xCA, 0x24, 0xF7, 
	0x80, 0x2A, 0xB0, 0x66, 0x09, 0xB9, 0xEC, 0xBA, 0xAE, 0xBB, 
	0xFB, 0x32, 0xC6, 0x35, 0xBD, 0x94, 0xCD, 0xEA, 0x6A, 0x49, 
	0xF3, 0x77, 0xFD, 0xD0, 0x7E, 0x3E, 0x44, 0x3D, 0x34, 0x19, 
	0x04, 0xC8, 0xDF, 0xF4, 0xC8, 0x58, 0x8B, 0x56, 0xDB, 0x00, 
	0x45, 0x0A, 0x55, 0x24, 0x90, 0xEC, 0xAF, 0x43, 0x9F, 0x27, 
	0x2D, 0x54, 0x37, 0xB3, 0x0D, 0x65, 0xFC, 0x7A, 0xDC, 0x6E, 
	0x30, 0x92, 0x9D, 0xFF, 0x0C, 0x7C, 0x3E, 0x74, 0x0D, 0xE5, 
	0xCF, 0x57, 0x37, 0xAD, 0x3D, 0xB1, 0x55, 0x5D, 0x10, 0xFA, 
	0xF8, 0x8B, 0xAE, 0xF6, 0xBA, 0x52, 0xD6, 0x24, 0x2A, 0xF8, 
	0xD2, 0xB2, 0x0B, 0xBC, 0x63, 0x48, 0x15, 0x32, 0x0E, 0x48, 
	0x57, 0xC2, 0x2D, 0xA8, 0xFD, 0x5E, 0x68, 0x20, 0xA1, 0x1D, 
	0xB4, 0x52, 0x04, 0x22, 0xF4, 0xD4, 0xF0, 0x19, 0x4C, 0x77, 
	0xC4, 0xCC, 0xFB, 0x2C, 0x25, 0x1A, 0x81, 0x4B, 0x1F, 0x26, 
	0xF4, 0x6F, 0xE1, 0x56, 0x3A, 0x3E, 0xDE, 0x7E, 0xC6, 0x1A, 
	0x6C, 0x2F, 0x23, 0x34, 0xD5, 0x12, 0x7D, 0xE6, 0x0E, 0x31, 
	0xE4, 0xFA, 0x14, 0x54, 0x6C, 0x26, 0x7C, 0x41, 0xA8, 0x17, 
	0x49, 0xD5, 0xE8, 0xBA, 0xD9, 0x7C, 0x9E, 0xCE, 0x23, 0x39, 
	0x83, 0x9F, 0xE1, 0x61, 0xB6, 0x4A, 0x97, 0xF6, 0xF9, 0x84, 
	0x3A, 0x62, 0x87, 0xBD, 0xFB, 0xBD, 0xFE, 0x4A, 0x1C, 0xC2, 
	0x0D, 0xED, 0x4B, 0x07, 0x63, 0x98, 0xE9, 0x9C, 0x5A, 0x4E, 
	0x1D, 0x57, 0xC7, 0x13, 0x5C, 0x22, 0x01, 0x6C, 0xEB, 0x73, 
	0x57, 0xBE, 0x4D, 0x83, 0x5D, 0xF7, 0xE1, 0xFE, 0xFA, 0xA7, 
	0x85, 0xC0, 0x62, 0xC3, 0xAD, 0x16, 0x68, 0xB9, 0xC0, 0x8F, 
	0xC5, 0x46, 0x46, 0x8B, 0x7E, 0xE3
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
