/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xEA, 0xAB, 0xD1, 0x12, 0x96, 0x57, 0xE6, 0x1C, 0xCB, 0x63,
        0xF1, 0xE1, 0x48, 0x10, 0xB7, 0x95, 0x7E, 0xC8, 0x45, 0x7A,
        0xCC, 0x4D, 0xDC, 0xA0, 0xEC, 0x46, 0xB3, 0xFF, 0xAE, 0x60,
        0x0C, 0xE9, 0xA8, 0x43, 0xA0, 0x1C, 0x9F, 0x96, 0x09, 0x14,
        0x4C, 0x63, 0x65, 0x7D, 0x9A, 0x0D, 0x69, 0x42, 0x62, 0xFA,
        0x4C, 0x3C, 0x0C, 0xD2, 0xC2, 0xF6, 0xA3, 0x57, 0x99, 0x8C,
        0x4A, 0x24, 0x57, 0x97, 0x21, 0x05, 0x6A, 0x7C, 0xF2, 0xE7,
        0x69, 0xF2, 0x0A, 0x5F, 0xDF, 0xBD, 0x83, 0x43, 0x1F, 0x6C,
        0xDA, 0x21, 0xF5, 0x02, 0x9D, 0x9F, 0x03, 0xA4, 0x6C, 0x6F,
        0x8E, 0x5F, 0xE7, 0xD6, 0xBC, 0x93, 0x0E, 0x5A, 0x55, 0x88,
        0xED, 0x96, 0x5D, 0x3B, 0x39, 0x80, 0xB0, 0xDA, 0xDF, 0x24,
        0xFC, 0xAC, 0xB9, 0xE1, 0xEE, 0xB6, 0xA6, 0x28, 0x84, 0x79,
        0x34, 0xDC, 0xBC, 0x8F, 0x39, 0x52, 0x20, 0x6F, 0xAC, 0x57,
        0x76, 0xA3, 0x3A, 0x05, 0x28, 0xAD, 0x7F, 0x1C, 0xC1, 0x93,
        0x54, 0x75, 0x58, 0x4F, 0x59, 0x79, 0x0D, 0x6F, 0xFE, 0x91,
        0x38, 0x7E, 0x6D, 0xEF, 0xB4, 0xCC, 0x10, 0x79, 0x73, 0x04,
        0x07, 0x1E, 0xB2, 0x4E, 0x87, 0xA6, 0xA1, 0x7B, 0xCA, 0xFB,
        0x5B, 0xF8, 0xFD, 0xC6, 0xDF, 0x32, 0x1F, 0x35, 0x44, 0xB8,
        0x70, 0x98, 0xE0, 0x5B, 0xFD, 0x80, 0x76, 0x29, 0x78, 0xFB,
        0xEE, 0xB4, 0xAC, 0xFB, 0x6C, 0x44, 0xCF, 0x94, 0x58, 0x13,
        0xA6, 0xD3, 0xBD, 0x26, 0x91, 0xA6, 0x4B, 0xFC, 0x5A, 0x04,
        0x6C, 0x1C, 0xB8, 0x2E, 0x17, 0x22, 0x9D, 0xD4, 0xA3, 0x79,
        0x9A, 0xCB, 0x93, 0x7F, 0x0F, 0x55, 0x0A, 0x4D, 0xFC, 0x48,
        0x23, 0xA2, 0xCE, 0x9C, 0xE9, 0x1C, 0x62, 0x36, 0x89, 0x7E,
        0xB4, 0xAC, 0xEB, 0xBA, 0xF1, 0xB5, 0x04, 0x80, 0x9B, 0xEE,
        0xE3, 0x47, 0x29, 0x49, 0xB9, 0x1B
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.61 */
