#!/bin/bash
. /usr/share/beakerlib/beakerlib.sh || exit 1

rlJournalStart
    rlPhaseStartSetup
        rlRun "tmp=\$(mktemp -d)" 0 "Create tmp directory"
        rlRun "pushd $tmp"
        rlRun "rlImport tests/nested/file"
    rlPhaseEnd

    rlPhaseStartTest
        rlRun "fileCreate fooo"
        rlAssertExists "fooo"
    rlPhaseEnd

    rlPhaseStartTest
        rlRun "randomFileCreate"
    rlPhaseEnd

    rlPhaseStartCleanup
        rlRun "popd"
        rlRun "rm -r $tmp" 0 "Remove tmp directory"
    rlPhaseEnd
rlJournalEnd
