;; Tests for the load_splat instructions

(module
  (memory 1)
  (data (i32.const 0) "\00\01\02\03\04\05\06\07\08\09\0A\0B\0C\0D\0E\0F")
  (data (i32.const 65520) "\10\11\12\13\14\15\16\17\18\19\1A\1B\1C\1D\1E\1F")

  (func (export "v128.load8_splat") (param $address i32) (result v128) (v128.load8_splat (local.get $address)))
  (func (export "v128.load16_splat") (param $address i32) (result v128) (v128.load16_splat (local.get $address)))
  (func (export "v128.load32_splat") (param $address i32) (result v128) (v128.load32_splat (local.get $address)))
  (func (export "v128.load64_splat") (param $address i32) (result v128) (v128.load64_splat (local.get $address)))

  ;; Load data with different offset/align arguments
  (func (export "v8x16.offset0") (param $address i32) (result v128) (v128.load8_splat offset=0 (local.get $address)))
  (func (export "v8x16.align1") (param $address i32) (result v128) (v128.load8_splat align=1 (local.get $address)))
  (func (export "v8x16.offset1_align1") (param $address i32) (result v128) (v128.load8_splat offset=1 align=1 (local.get $address)))
  (func (export "v8x16.offset2_align1") (param $address i32) (result v128) (v128.load8_splat offset=2 align=1 (local.get $address)))
  (func (export "v8x16.offset15_align1") (param $address i32) (result v128) (v128.load8_splat offset=15 align=1 (local.get $address)))

  (func (export "v16x8.offset0") (param $address i32) (result v128) (v128.load16_splat offset=0 (local.get $address)))
  (func (export "v16x8.align1") (param $address i32) (result v128) (v128.load16_splat align=1 (local.get $address)))
  (func (export "v16x8.offset1_align1") (param $address i32) (result v128) (v128.load16_splat offset=1 align=1 (local.get $address)))
  (func (export "v16x8.offset2_align1") (param $address i32) (result v128) (v128.load16_splat offset=2 align=1 (local.get $address)))
  (func (export "v16x8.offset15_align2") (param $address i32) (result v128) (v128.load16_splat offset=15 align=2 (local.get $address)))

  (func (export "v32x4.offset0") (param $address i32) (result v128) (v128.load32_splat offset=0 (local.get $address)))
  (func (export "v32x4.align1") (param $address i32) (result v128) (v128.load32_splat align=1 (local.get $address)))
  (func (export "v32x4.offset1_align1") (param $address i32) (result v128) (v128.load32_splat offset=1 align=1 (local.get $address)))
  (func (export "v32x4.offset2_align2") (param $address i32) (result v128) (v128.load32_splat offset=2 align=2 (local.get $address)))
  (func (export "v32x4.offset15_align4") (param $address i32) (result v128) (v128.load32_splat offset=15 align=4 (local.get $address)))

  (func (export "v64x2.offset0") (param $address i32) (result v128) (v128.load64_splat offset=0 (local.get $address)))
  (func (export "v64x2.align1") (param $address i32) (result v128) (v128.load64_splat align=1 (local.get $address)))
  (func (export "v64x2.offset1_align2") (param $address i32) (result v128) (v128.load64_splat offset=1 align=2 (local.get $address)))
  (func (export "v64x2.offset2_align4") (param $address i32) (result v128) (v128.load64_splat offset=2 align=4 (local.get $address)))
  (func (export "v64x2.offset15_align8") (param $address i32) (result v128) (v128.load64_splat offset=15 align=8 (local.get $address)))

  (func (export "v8x16.offset65536") (param $address i32) (result v128) (v128.load8_splat offset=65536 (local.get $address)))
  (func (export "v16x8.offset65535") (param $address i32) (result v128) (v128.load16_splat offset=65535 (local.get $address)))
  (func (export "v32x4.offset65533") (param $address i32) (result v128) (v128.load32_splat offset=65533 (local.get $address)))
  (func (export "v64x2.offset65529") (param $address i32) (result v128) (v128.load64_splat offset=65529 (local.get $address)))
)
(assert_return (invoke "v128.load8_splat" (i32.const 0)) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_splat" (i32.const 1)) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "v128.load8_splat" (i32.const 2)) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "v128.load8_splat" (i32.const 3)) (v128.const i8x16 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3))
(assert_return (invoke "v128.load8_splat" (i32.const 65535)) (v128.const i8x16 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31))
(assert_return (invoke "v128.load16_splat" (i32.const 4)) (v128.const i16x8 0x0504 0x0504 0x0504 0x0504 0x0504 0x0504 0x0504 0x0504))
(assert_return (invoke "v128.load16_splat" (i32.const 5)) (v128.const i16x8 0x0605 0x0605 0x0605 0x0605 0x0605 0x0605 0x0605 0x0605))
(assert_return (invoke "v128.load16_splat" (i32.const 6)) (v128.const i16x8 0x0706 0x0706 0x0706 0x0706 0x0706 0x0706 0x0706 0x0706))
(assert_return (invoke "v128.load16_splat" (i32.const 7)) (v128.const i16x8 0x0807 0x0807 0x0807 0x0807 0x0807 0x0807 0x0807 0x0807))
(assert_return (invoke "v128.load16_splat" (i32.const 65534)) (v128.const i16x8 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E))
(assert_return (invoke "v128.load32_splat" (i32.const 8)) (v128.const i32x4 0x0B0A0908 0x0B0A0908 0x0B0A0908 0x0B0A0908))
(assert_return (invoke "v128.load32_splat" (i32.const 9)) (v128.const i32x4 0x0C0B0A09 0x0C0B0A09 0x0C0B0A09 0x0C0B0A09))
(assert_return (invoke "v128.load32_splat" (i32.const 10)) (v128.const i32x4 0x0D0C0B0A 0x0D0C0B0A 0x0D0C0B0A 0x0D0C0B0A))
(assert_return (invoke "v128.load32_splat" (i32.const 11)) (v128.const i32x4 0x0E0D0C0B 0x0E0D0C0B 0x0E0D0C0B 0x0E0D0C0B))
(assert_return (invoke "v128.load32_splat" (i32.const 65532)) (v128.const i32x4 0x1F1E1D1C 0x1F1E1D1C 0x1F1E1D1C 0x1F1E1D1C))
(assert_return (invoke "v128.load64_splat" (i32.const 12)) (v128.const i64x2 0x000000000F0E0D0C 0x000000000F0E0D0C))
(assert_return (invoke "v128.load64_splat" (i32.const 13)) (v128.const i64x2 0x00000000000F0E0D 0x00000000000F0E0D))
(assert_return (invoke "v128.load64_splat" (i32.const 14)) (v128.const i64x2 0x0000000000000F0E 0x0000000000000F0E))
(assert_return (invoke "v128.load64_splat" (i32.const 15)) (v128.const i64x2 0x000000000000000F 0x000000000000000F))
(assert_return (invoke "v128.load64_splat" (i32.const 65528)) (v128.const i64x2 0x1F1E1D1C1B1A1918 0x1F1E1D1C1B1A1918))

;; v8x16
(assert_return (invoke "v8x16.offset0" (i32.const 0)) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v8x16.align1" (i32.const 0)) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v8x16.offset1_align1" (i32.const 0)) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "v8x16.offset2_align1" (i32.const 0)) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "v8x16.offset15_align1" (i32.const 0)) (v128.const i8x16 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15 15))
(assert_return (invoke "v8x16.offset0" (i32.const 1)) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "v8x16.align1" (i32.const 1)) (v128.const i8x16 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1))
(assert_return (invoke "v8x16.offset1_align1" (i32.const 1)) (v128.const i8x16 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2))
(assert_return (invoke "v8x16.offset2_align1" (i32.const 1)) (v128.const i8x16 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3))
(assert_return (invoke "v8x16.offset15_align1" (i32.const 1)) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v8x16.offset0" (i32.const 65535)) (v128.const i8x16 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31))
(assert_return (invoke "v8x16.align1" (i32.const 65535)) (v128.const i8x16 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31 31))
;; v16x8
(assert_return (invoke "v16x8.offset0" (i32.const 0)) (v128.const i16x8 0x0100 0x0100 0x0100 0x0100 0x0100 0x0100 0x0100 0x0100))
(assert_return (invoke "v16x8.align1" (i32.const 0)) (v128.const i16x8 0x0100 0x0100 0x0100 0x0100 0x0100 0x0100 0x0100 0x0100))
(assert_return (invoke "v16x8.offset1_align1" (i32.const 0)) (v128.const i16x8 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201))
(assert_return (invoke "v16x8.offset2_align1" (i32.const 0)) (v128.const i16x8 0x0302 0x0302 0x0302 0x0302 0x0302 0x0302 0x0302 0x0302))
(assert_return (invoke "v16x8.offset15_align2" (i32.const 0)) (v128.const i16x8 0x000F 0x000F 0x000F 0x000F 0x000F 0x000F 0x000F 0x000F))
(assert_return (invoke "v16x8.offset0" (i32.const 1)) (v128.const i16x8 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201))
(assert_return (invoke "v16x8.align1" (i32.const 1)) (v128.const i16x8 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201))
(assert_return (invoke "v16x8.offset1_align1" (i32.const 1)) (v128.const i16x8 0x0302 0x0302 0x0302 0x0302 0x0302 0x0302 0x0302 0x0302))
(assert_return (invoke "v16x8.offset2_align1" (i32.const 1)) (v128.const i16x8 0x0403 0x0403 0x0403 0x0403 0x0403 0x0403 0x0403 0x0403))
(assert_return (invoke "v16x8.offset15_align2" (i32.const 1)) (v128.const i16x8 0x0000 0x0000 0x0000 0x0000 0x0000 0x0000 0x0000 0x0000))
(assert_return (invoke "v16x8.offset0" (i32.const 65534)) (v128.const i16x8 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E))
(assert_return (invoke "v16x8.align1" (i32.const 65534)) (v128.const i16x8 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E 0x1F1E))
;; v32x4
(assert_return (invoke "v32x4.offset0" (i32.const 0)) (v128.const i32x4 0x03020100 0x03020100 0x03020100 0x03020100))
(assert_return (invoke "v32x4.align1" (i32.const 0)) (v128.const i32x4 0x03020100 0x03020100 0x03020100 0x03020100))
(assert_return (invoke "v32x4.offset1_align1" (i32.const 0)) (v128.const i32x4 0x04030201 0x04030201 0x04030201 0x04030201))
(assert_return (invoke "v32x4.offset2_align2" (i32.const 0)) (v128.const i32x4 0x05040302 0x05040302 0x05040302 0x05040302))
(assert_return (invoke "v32x4.offset15_align4" (i32.const 0)) (v128.const i32x4 0x0000000F 0x0000000F 0x0000000F 0x0000000F))
(assert_return (invoke "v32x4.offset0" (i32.const 1)) (v128.const i32x4 0x04030201 0x04030201 0x04030201 0x04030201))
(assert_return (invoke "v32x4.align1" (i32.const 1)) (v128.const i32x4 0x04030201 0x04030201 0x04030201 0x04030201))
(assert_return (invoke "v32x4.offset1_align1" (i32.const 1)) (v128.const i32x4 0x05040302 0x05040302 0x05040302 0x05040302))
(assert_return (invoke "v32x4.offset2_align2" (i32.const 1)) (v128.const i32x4 0x06050403 0x06050403 0x06050403 0x06050403))
(assert_return (invoke "v32x4.offset15_align4" (i32.const 1)) (v128.const i32x4 0x00000000 0x00000000 0x00000000 0x00000000))
(assert_return (invoke "v32x4.offset0" (i32.const 65532)) (v128.const i32x4 0x1F1E1D1C 0x1F1E1D1C 0x1F1E1D1C 0x1F1E1D1C))
(assert_return (invoke "v32x4.align1" (i32.const 65532)) (v128.const i32x4 0x1F1E1D1C 0x1F1E1D1C 0x1F1E1D1C 0x1F1E1D1C))
;; v64x2
(assert_return (invoke "v64x2.offset0" (i32.const 0)) (v128.const i64x2 0x0706050403020100 0x0706050403020100))
(assert_return (invoke "v64x2.align1" (i32.const 0)) (v128.const i64x2 0x0706050403020100 0x0706050403020100))
(assert_return (invoke "v64x2.offset1_align2" (i32.const 0)) (v128.const i64x2 0x0807060504030201 0x0807060504030201))
(assert_return (invoke "v64x2.offset2_align4" (i32.const 0)) (v128.const i64x2 0x0908070605040302 0x0908070605040302))
(assert_return (invoke "v64x2.offset15_align8" (i32.const 0)) (v128.const i64x2 0x000000000000000F 0x000000000000000F))
(assert_return (invoke "v64x2.offset0" (i32.const 1)) (v128.const i64x2 0x0807060504030201 0x0807060504030201))
(assert_return (invoke "v64x2.align1" (i32.const 1)) (v128.const i64x2 0x0807060504030201 0x0807060504030201))
(assert_return (invoke "v64x2.offset1_align2" (i32.const 1)) (v128.const i64x2 0x0908070605040302 0x0908070605040302))
(assert_return (invoke "v64x2.offset2_align4" (i32.const 1)) (v128.const i64x2 0x0A09080706050403 0x0A09080706050403))
(assert_return (invoke "v64x2.offset15_align8" (i32.const 1)) (v128.const i64x2 0x0000000000000000 0x0000000000000000))
(assert_return (invoke "v64x2.offset0" (i32.const 65528)) (v128.const i64x2 0x1F1E1D1C1B1A1918 0x1F1E1D1C1B1A1918))
(assert_return (invoke "v64x2.align1" (i32.const 65528)) (v128.const i64x2 0x1F1E1D1C1B1A1918 0x1F1E1D1C1B1A1918))


;; Out of bounds memory access
(assert_trap (invoke "v128.load8_splat" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v128.load16_splat" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v128.load32_splat" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v128.load64_splat" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v128.load8_splat" (i32.const 65536)) "out of bounds memory access")
(assert_trap (invoke "v128.load16_splat" (i32.const 65535)) "out of bounds memory access")
(assert_trap (invoke "v128.load32_splat" (i32.const 65533)) "out of bounds memory access")
(assert_trap (invoke "v128.load64_splat" (i32.const 65529)) "out of bounds memory access")

(assert_trap (invoke "v8x16.offset1_align1" (i32.const 65535)) "out of bounds memory access")
(assert_trap (invoke "v8x16.offset2_align1" (i32.const 65535)) "out of bounds memory access")
(assert_trap (invoke "v8x16.offset15_align1" (i32.const 65535)) "out of bounds memory access")
(assert_trap (invoke "v16x8.offset1_align1" (i32.const 65534)) "out of bounds memory access")
(assert_trap (invoke "v16x8.offset2_align1" (i32.const 65534)) "out of bounds memory access")
(assert_trap (invoke "v16x8.offset15_align2" (i32.const 65534)) "out of bounds memory access")
(assert_trap (invoke "v32x4.offset1_align1" (i32.const 65532)) "out of bounds memory access")
(assert_trap (invoke "v32x4.offset2_align2" (i32.const 65532)) "out of bounds memory access")
(assert_trap (invoke "v32x4.offset15_align4" (i32.const 65532)) "out of bounds memory access")
(assert_trap (invoke "v64x2.offset1_align2" (i32.const 65528)) "out of bounds memory access")
(assert_trap (invoke "v64x2.offset2_align4" (i32.const 65528)) "out of bounds memory access")
(assert_trap (invoke "v64x2.offset15_align8" (i32.const 65528)) "out of bounds memory access")

(assert_trap (invoke "v8x16.offset1_align1" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v16x8.offset1_align1" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v32x4.offset1_align1" (i32.const -1)) "out of bounds memory access")
(assert_trap (invoke "v64x2.offset1_align2" (i32.const -1)) "out of bounds memory access")

(assert_trap (invoke "v8x16.offset65536" (i32.const 0)) "out of bounds memory access")
(assert_trap (invoke "v16x8.offset65535" (i32.const 0)) "out of bounds memory access")
(assert_trap (invoke "v32x4.offset65533" (i32.const 0)) "out of bounds memory access")
(assert_trap (invoke "v64x2.offset65529" (i32.const 0)) "out of bounds memory access")
(assert_trap (invoke "v8x16.offset65536" (i32.const 1)) "out of bounds memory access")
(assert_trap (invoke "v16x8.offset65535" (i32.const 1)) "out of bounds memory access")
(assert_trap (invoke "v32x4.offset65533" (i32.const 1)) "out of bounds memory access")
(assert_trap (invoke "v64x2.offset65529" (i32.const 1)) "out of bounds memory access")


;; Combination

(module (memory 1)
  (data (i32.const 0) "\00\01\02\03\04\05\06\07\08\09\0A")

  (func (export "v128.load8_splat-in-block") (result v128)
      (block (result v128) (block (result v128) (v128.load8_splat (i32.const 0))))
  )
  (func (export "v128.load16_splat-in-block") (result v128)
      (block (result v128) (block (result v128) (v128.load16_splat (i32.const 1))))
  )
  (func (export "v128.load32_splat-in-block") (result v128)
      (block (result v128) (block (result v128) (v128.load32_splat (i32.const 2))))
  )
  (func (export "v128.load64_splat-in-block") (result v128)
      (block (result v128) (block (result v128) (v128.load64_splat (i32.const 9))))
  )
  (func (export "v128.load8_splat-as-br-value") (result v128)
    (block (result v128) (br 0 (v128.load8_splat (i32.const 3))))
  )
  (func (export "v128.load16_splat-as-br-value") (result v128)
    (block (result v128) (br 0 (v128.load16_splat (i32.const 4))))
  )
  (func (export "v128.load32_splat-as-br-value") (result v128)
    (block (result v128) (br 0 (v128.load32_splat (i32.const 5))))
  )
  (func (export "v128.load64_splat-as-br-value") (result v128)
    (block (result v128) (br 0 (v128.load64_splat (i32.const 10))))
  )
  (func (export "v128.load8_splat-extract_lane_s-operand") (result i32)
    (i8x16.extract_lane_s 0 (v128.load8_splat (i32.const 6)))
  )
  (func (export "v128.load16_splat-extract_lane_s-operand") (result i32)
    (i8x16.extract_lane_s 0 (v128.load16_splat (i32.const 7)))
  )
  (func (export "v128.load32_splat-extract_lane_s-operand") (result i32)
    (i8x16.extract_lane_s 0 (v128.load32_splat (i32.const 8)))
  )
  (func (export "v128.load64_splat-extract_lane_s-operand") (result i32)
    (i8x16.extract_lane_s 0 (v128.load64_splat (i32.const 11)))
  )
)
(assert_return (invoke "v128.load8_splat-in-block") (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load16_splat-in-block") (v128.const i16x8 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201 0x0201))
(assert_return (invoke "v128.load32_splat-in-block") (v128.const i32x4 0x05040302 0x05040302 0x05040302 0x05040302))
(assert_return (invoke "v128.load64_splat-in-block") (v128.const i64x2 0x0000000000000A09 0x0000000000000A09))
(assert_return (invoke "v128.load8_splat-as-br-value") (v128.const i8x16 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3))
(assert_return (invoke "v128.load16_splat-as-br-value") (v128.const i16x8 0x0504 0x0504 0x0504 0x0504 0x0504 0x0504 0x0504 0x0504))
(assert_return (invoke "v128.load32_splat-as-br-value") (v128.const i32x4 0x08070605 0x08070605 0x08070605 0x08070605))
(assert_return (invoke "v128.load64_splat-as-br-value") (v128.const i64x2 0x000000000000000A 0x000000000000000A))
(assert_return (invoke "v128.load8_splat-extract_lane_s-operand") (i32.const 6))
(assert_return (invoke "v128.load16_splat-extract_lane_s-operand") (i32.const 7))
(assert_return (invoke "v128.load32_splat-extract_lane_s-operand") (i32.const 8))
(assert_return (invoke "v128.load64_splat-extract_lane_s-operand") (i32.const 0))


;; Type check

(assert_invalid (module (memory 0) (func (result v128) (v128.load8_splat (v128.const i32x4 0 0 0 0)))) "type mismatch")
(assert_invalid (module (memory 0) (func (result v128) (v128.load16_splat (v128.const i32x4 0 0 0 0)))) "type mismatch")
(assert_invalid (module (memory 0) (func (result v128) (v128.load32_splat (v128.const i32x4 0 0 0 0)))) "type mismatch")
(assert_invalid (module (memory 0) (func (result v128) (v128.load64_splat (v128.const i32x4 0 0 0 0)))) "type mismatch")


;; Unknown operator

(assert_malformed (module quote "(memory 1) (func (drop (i8x16.load_splat (i32.const 0))))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (drop (i16x8.load_splat (i32.const 0))))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (drop (i32x4.load_splat (i32.const 0))))") "unknown operator")
(assert_malformed (module quote "(memory 1) (func (drop (i64x2.load_splat (i32.const 0))))") "unknown operator")


;; Test operation with empty argument

(assert_invalid
  (module (memory 0)
    (func $v128.load8_splat-arg-empty (result v128)
      (v128.load8_splat)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module (memory 0)
    (func $v128.load16_splat-arg-empty (result v128)
      (v128.load16_splat)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module (memory 0)
    (func $v128.load32_splat-arg-empty (result v128)
      (v128.load32_splat)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module (memory 0)
    (func $v128.load64_splat-arg-empty (result v128)
      (v128.load64_splat)
    )
  )
  "type mismatch"
)
