/*
 *  Copyright (C) 2006-2025, Thomas Maier-Komor
 *
 *  This is the source code of xjobs.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef JOBCTRL_H
#define JOBCTRL_H

#include <sys/types.h>

typedef struct arg_s {
	char *arg;
	struct arg_s *prev;
} arg_t;

typedef struct job_s {
	pid_t pid;
	unsigned job;
	char **args;
	size_t numargs;
	char *in, *out, *err, *cmd, *pwd;
	int outfile;
	unsigned flags;	/* 1 = stdout, 2 = stderr, 3 = both, 4 = overwrite */
	unsigned long long start;
	struct job_s *next;
} job_t;

struct rusage;

extern job_t *Executing, *Ready, *ReadyEnd, *JobCache;
extern arg_t *ArgCache;
extern unsigned  Skipped, Finished, Numbaseargs, Running,
       Waiting, Failed, Parsed;
extern const char *JobIn;

void name_job(job_t *j);
void add_job(arg_t *a, size_t n, char *in, char *out, char *err, char *pwd, int app);
void clear_job(pid_t pid, int ret, struct rusage *rusage);
void signal_jobs(int sig);
int start_jobs(void);
void add_basearg(arg_t *a);
void display_status();

#endif
