\ Convert ANSI Forth standard definition names from lower to upper case.

\ This file contains code to convert ANSI Forth source code
\ with standard definition names written in lower case (environmental 
\ dependency) to source code with standard definition names written in
\ UPPER case. It thus helps porting ANSI Forth code written for case
\ insensitive systems to case sensitive systems.

\ This code can be used and copied free of charge. All rights reserved.
\ Original idea, Ulrich Hoffmann
\ 4tH version, Hans Bezemer

\ Thanks to J.Plewe for his helpful hints.
\ ---------------------------------------------------------------------------

\ From the draft proposed standard:

\ 3.4.2 ... A system may be either case sensitive, treating
\ upper- and lower-case letters as different and not matching,
\ or case insensitive, ignoring differences in case while searching.

\ 3.3.1.2 ... Programs that use lower case for standard definition
\ names or depend on the case-sensitivity properties of a system have
\ an environmental dependency.

include lib/row.4th                    \ for ROW
include lib/parsname.4th               \ for PARSE-NAME
include lib/ulcase.4th                 \ for S>UPPER

2048 constant /mytib                   \ size of user-defined TIB
/mytib string mytib                    \ allocate user-defined TIB

aka refill Read-File                   \ required by CONVERT.4TH
                                       \ table with string words
create string-word?                    ( a n -- a n f)
  ,| "|      CHAR " ,
  ,| ."|     CHAR " ,
  ,| ABORT"| CHAR " ,
  ," .("     CHAR ) ,
  ,| C"|     CHAR " ,
  ,| S"|     CHAR " ,
  ," ("      CHAR ) ,
  ," \"      0      ,
  NULL ,
DOES>                                  \ if keyword found, convert it to upper
  2 string-key row dup >r              \ case and parse until delimiter
  if cell+ @c parse 2drop s>upper else drop then r>
;
                                       \ table with all ANS-Forth words
create ansify                          ( a n --)
\ ," !"
\ ," #"
\ ," #>"
  ," #S"
  ," #TIB"
\ ," ("
\ ," '"
  ," (LOCAL)"
\ ," *"
\ ," */"
  ," */MOD"
\ ," +"
\ ," +!"
  ," +LOOP"
\ ," ,"
\ ," -"
  ," -TRAILING"
\ ," ."
\ ,| ."|
\ ," .("
  ," .R"
  ," .S"
\ ," /"
  ," /MOD"
  ," /STRING"
\ ," 0<"
\ ," 0<>"
\ ," 0="
\ ," 0>"
\ ," 1+"
\ ," 1-"
\ ," 2!"
\ ," 2*"
\ ," 2/"
  ," 2>R"
\ ," 2@"
  ," 2CONSTANT"
  ," 2DROP"
  ," 2DUP"
  ," 2LITERAL"
  ," 2OVER"
\ ," 2R>"
\ ," 2R@"
  ," 2ROT"
  ," 2SWAP"
  ," 2VARIABLE"
\ ," :"
  ," :NONAME"
\ ," ;"
  ," ;CODE"
\ ," <"
\ ," <#"
\ ," <>"
\ ," ="
\ ," >"
  ," >BODY"
  ," >FLOAT"
  ," >IN"
  ," >NUMBER"
  ," >R"
\ ," ?"
  ," ?DO"
  ," ?DUP"
\ ," @"
  ," ABORT"
\ ,| ABORT"|
  ," ABS"
  ," ACCEPT"
  ," AGAIN"
  ," AHEAD"
  ," ALIGN"
  ," ALIGNED"
  ," ALLOCATE"
  ," ALLOT"
  ," ALSO"
  ," AND"
  ," ASSEMBLER"
  ," AT-XY"
  ," BASE"
  ," BEGIN"
  ," BIN"
  ," BL"
  ," BLANK"
  ," BLK"
  ," BLOCK"
  ," BUFFER"
  ," BYE"
  ," C!"
\ ,| C"|
  ," C,"
  ," C@"
  ," CASE"
  ," CATCH"
  ," CELL+"
  ," CELLS"
  ," CHAR"
  ," CHAR+"
  ," CHARS"
  ," CLOSE-FILE"
  ," CMOVE"
  ," CMOVE>"
  ," CODE"
  ," COMPARE"
  ," COMPILE,"
  ," CONSTANT"
  ," CONVERT"
  ," COUNT"
  ," CR"
  ," CREATE"
  ," CREATE-FILE"
  ," CS-PICK"
  ," CS-ROLL"
  ," D+"
  ," D-"
  ," D."
  ," D.R"
  ," D0<"
  ," D0="
  ," D2*"
  ," D2/"
  ," D<"
  ," D="
  ," D>F"
  ," D>S"
  ," DABS"
  ," DECIMAL"
  ," DEFINITIONS"
  ," DELETE-FILE"
  ," DEPTH"
  ," DF!"
  ," DF@"
  ," DFALIGN"
  ," DFALIGNED"
  ," DFLOAT+"
  ," DFLOATS"
  ," DMAX"
  ," DMIN"
  ," DNEGATE"
  ," DO"
  ," DOES>"
  ," DROP"
  ," DU<"
  ," DUMP"
  ," DUP"
  ," EDITOR"
  ," EKEY?"
  ," EKEY>CHAR"
  ," EKEY"
  ," ELSE"
  ," EMIT"
  ," EMIT?"
  ," EMPTY-BUFFERS"
  ," ENDCASE"
  ," ENDOF"
  ," ENVIRONMENT?"
  ," ERASE"
  ," EVALUATE"
  ," EXECUTE"
  ," EXIT"
  ," EXPECT"
  ," F!"
  ," F*"
  ," F**"
  ," F+"
  ," F-"
  ," F."
  ," F/"
  ," F0<"
  ," F0="
  ," F<"
  ," F>D"
  ," F>S"
  ," F@"
  ," FABS"
  ," FACOS"
  ," FACOSH"
  ," FALIGN"
  ," FALIGNED"
  ," FALOG"
  ," FALSE"
  ," FASIN"
  ," FASINH"
  ," FATAN"
  ," FATAN2"
  ," FATANH"
  ," FCONSTANT"
  ," FCOS"
  ," FCOSH"
  ," FDEPTH"
  ," FDROP"
  ," FDUP"
  ," FE."
  ," FEXP"
  ," FEXPM1"
  ," FILE-POSITION"
  ," FILE-SIZE"
  ," FILE-STATUS"
  ," FILL"
  ," FIND"
  ," FLITERAL"
  ," FLN"
  ," FLNP1"
  ," FLOAT+"
  ," FLOATS"
  ," FLOG"
  ," FLOOR"
  ," FLUSH"
  ," FLUSH-FILE"
  ," FM/MOD"
  ," FMAX"
  ," FMIN"
  ," FNEGATE"
  ," FORGET"
  ," FORTH"
  ," FORTH-WORDLIST"
  ," FOVER"
  ," FREE"
  ," FROT"
  ," FROUND"
  ," FS."
  ," FSIN"
  ," FSINCOS"
  ," FSINH"
  ," FSQRT"
  ," FSWAP"
  ," FTAN"
  ," FTANH"
  ," FVARIABLE"
  ," F~"
  ," GET-CURRENT"
  ," GET-ORDER"
  ," HERE"
  ," HEX"
  ," HOLD"
  ," I"
  ," IF"
  ," IMMEDIATE"
  ," INCLUDE-FILE"
  ," INCLUDED"
  ," INVERT"
  ," J"
  ," KEY"
  ," KEY?"
  ," LEAVE"
  ," LIST"
  ," LITERAL"
  ," LOAD"
  ," LOCALS|"
  ," LOOP"
  ," LSHIFT"
  ," M*"
  ," M*/"
  ," M+"
  ," MARKER"
  ," MAX"
  ," MIN"
  ," MOD"
  ," MOVE"
  ," MS"
  ," NEGATE"
  ," NIP"
  ," OF"
  ," ONLY"
  ," OPEN-FILE"
  ," OR"
  ," ORDER"
  ," OVER"
  ," PAD"
  ," PAGE"
  ," PARSE"
  ," PICK"
  ," POSTPONE"
  ," PRECISION"
  ," PREVIOUS"
  ," QUERY"
  ," QUIT"
  ," R/O"
  ," R/W"
  ," R>"
  ," R@"
  ," READ-FILE"
  ," READ-LINE"
  ," RECURSE"
  ," REFILL"
  ," RENAME-FILE"
  ," REPEAT"
  ," REPOSITION-FILE"
  ," REPRESENT"
  ," RESIZE"
  ," RESIZE-FILE"
  ," RESTORE-INPUT"
  ," ROLL"
  ," ROT"
  ," RSHIFT"
\ ,| S"|
  ," S>D"
  ," S>F"
  ," SAVE-BUFFERS"
  ," SAVE-INPUT"
  ," SCR"
  ," SEARCH"
  ," SEARCH-WORDLIST"
  ," SEE"
  ," SET-CURRENT"
  ," SET-ORDER"
  ," SET-PRECISION"
  ," SF!"
  ," SF@"
  ," SFALIGN"
  ," SFALIGNED"
  ," SFLOAT+"
  ," SFLOATS"
  ," SIGN"
  ," SLITERAL"
  ," SM/REM"
  ," SOURCE"
  ," SOURCE-ID"
  ," SPACE"
  ," SPACES"
  ," SPAN"
  ," STATE"
  ," SWAP"
  ," THEN"
  ," THROW"
  ," THRU"
  ," TIB"
  ," TIME&DATE"
  ," TO"
  ," TRUE"
  ," TUCK"
  ," TYPE"
  ," U."
  ," U.R"
  ," U<"
  ," U>"
  ," UM*"
  ," UM/MOD"
  ," UNLOOP"
  ," UNTIL"
  ," UNUSED"
  ," UPDATE"
  ," VALUE"
  ," VARIABLE"
  ," W/O"
  ," WHILE"
  ," WITHIN"
  ," WORD"
  ," WORDLIST"
  ," WORDS"
  ," WRITE-FILE"
  ," WRITE-LINE"
  ," XOR"
\ ," ["
\ ," [']"
  ," [CHAR]"
  ," [COMPILE]"
  ," [ELSE]"
  ," [IF]"
  ," [THEN]"
\ ," \"
\ ," ]"
  NULL ,
DOES> 1 string-key row nip if s>upper then 2drop ;

: PreProcess mytib /mytib source! ;   \ required by CONVERT.4TH
: Usage abort" Usage: ansify infile outfile" ;

: Process                             \ parse string and ansify keywords
  begin parse-name dup while string-word? if 2drop else ansify then repeat
  2drop 0 >in ! 0 parse type cr       \ drop empty string, reset >IN
;                                     \ and write TIB

include lib/convert.4th
