/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpContentReader
extends WikiReader {
    public HelpContentReader(String baseUrl) {
        super(baseUrl);
    }

    public String fetchHelpTopicContent(String helpTopicUrl, boolean dotest) throws HelpContentReaderException {
        String string;
        block10: {
            if (helpTopicUrl == null) {
                throw new MissingHelpContentException("helpTopicUrl is null");
            }
            HttpClient.Response con = null;
            URL u = new URL(helpTopicUrl);
            con = HttpClient.create(u).connect();
            BufferedReader in = con.getContentReader();
            try {
                string = this.prepareHelpContent(in, dotest, u);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw new HelpContentReaderException(e, 0);
                }
                catch (IOException e) {
                    throw new HelpContentReaderException(e, con != null ? con.getResponseCode() : 0);
                }
            }
            in.close();
        }
        return string;
    }

    protected String prepareHelpContent(BufferedReader in, boolean dotest, URL url) throws HelpContentReaderException {
        String s = "";
        try {
            s = this.readFromTrac(in, url);
        }
        catch (IOException e) {
            throw new HelpContentReaderException(e, 0);
        }
        if (dotest && s.isEmpty()) {
            throw new MissingHelpContentException(s);
        }
        return s;
    }
}

