/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonPatch;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonPointer;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.eclipse.parsson.BufferPoolImpl;
import org.eclipse.parsson.JsonArrayBuilderImpl;
import org.eclipse.parsson.JsonBuilderFactoryImpl;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonGeneratorFactoryImpl;
import org.eclipse.parsson.JsonGeneratorImpl;
import org.eclipse.parsson.JsonMergePatchImpl;
import org.eclipse.parsson.JsonNumberImpl;
import org.eclipse.parsson.JsonObjectBuilderImpl;
import org.eclipse.parsson.JsonParserFactoryImpl;
import org.eclipse.parsson.JsonParserImpl;
import org.eclipse.parsson.JsonPatchBuilderImpl;
import org.eclipse.parsson.JsonPatchImpl;
import org.eclipse.parsson.JsonPointerImpl;
import org.eclipse.parsson.JsonReaderFactoryImpl;
import org.eclipse.parsson.JsonReaderImpl;
import org.eclipse.parsson.JsonStringImpl;
import org.eclipse.parsson.JsonWriterFactoryImpl;
import org.eclipse.parsson.JsonWriterImpl;
import org.eclipse.parsson.api.BufferPool;

public class JsonProviderImpl
extends JsonProvider {
    private final BufferPool bufferPool = new BufferPoolImpl();
    private final JsonContext emptyContext = new JsonContext(null, this.bufferPool);

    @Override
    public JsonGenerator createGenerator(Writer writer) {
        return new JsonGeneratorImpl(writer, this.emptyContext);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream out) {
        return new JsonGeneratorImpl(out, this.emptyContext);
    }

    @Override
    public JsonParser createParser(Reader reader) {
        return new JsonParserImpl(reader, this.emptyContext);
    }

    @Override
    public JsonParser createParser(InputStream in) {
        return new JsonParserImpl(in, this.emptyContext);
    }

    @Override
    public JsonParserFactory createParserFactory(Map<String, ?> config) {
        return config == null ? new JsonParserFactoryImpl(this.emptyContext) : new JsonParserFactoryImpl(new JsonContext(config, this.bufferPool, JsonContext.PROPERTY_BUFFER_POOL));
    }

    @Override
    public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
        return config == null ? new JsonGeneratorFactoryImpl(this.emptyContext) : new JsonGeneratorFactoryImpl(new JsonContext(config, this.bufferPool, "jakarta.json.stream.JsonGenerator.prettyPrinting", JsonContext.PROPERTY_BUFFER_POOL));
    }

    @Override
    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(reader, this.emptyContext);
    }

    @Override
    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(in, this.emptyContext);
    }

    @Override
    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.emptyContext);
    }

    @Override
    public JsonWriter createWriter(OutputStream out) {
        return new JsonWriterImpl(out, this.emptyContext);
    }

    @Override
    public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
        return config == null ? new JsonWriterFactoryImpl(this.emptyContext) : new JsonWriterFactoryImpl(new JsonContext(config, this.bufferPool, "jakarta.json.stream.JsonGenerator.prettyPrinting", JsonContext.PROPERTY_BUFFER_POOL));
    }

    @Override
    public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
        return config == null ? new JsonReaderFactoryImpl(this.emptyContext) : new JsonReaderFactoryImpl(new JsonContext(config, this.bufferPool, "org.eclipse.parsson.rejectDuplicateKeys", "jakarta.json.JsonConfig.keyStrategy", JsonContext.PROPERTY_BUFFER_POOL));
    }

    @Override
    public JsonObjectBuilder createObjectBuilder() {
        return new JsonObjectBuilderImpl(this.emptyContext);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(JsonObject object) {
        return new JsonObjectBuilderImpl(object, this.emptyContext);
    }

    @Override
    public JsonObjectBuilder createObjectBuilder(Map<String, ?> map) {
        return new JsonObjectBuilderImpl(map, this.emptyContext);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder() {
        return new JsonArrayBuilderImpl(this.emptyContext);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(JsonArray array) {
        return new JsonArrayBuilderImpl(array, this.emptyContext);
    }

    @Override
    public JsonArrayBuilder createArrayBuilder(Collection<?> collection) {
        return new JsonArrayBuilderImpl(collection, this.emptyContext);
    }

    @Override
    public JsonPointer createPointer(String jsonPointer) {
        return new JsonPointerImpl(jsonPointer, this.emptyContext);
    }

    @Override
    public JsonPatchBuilder createPatchBuilder() {
        return new JsonPatchBuilderImpl(this.emptyContext);
    }

    @Override
    public JsonPatchBuilder createPatchBuilder(JsonArray array) {
        return new JsonPatchBuilderImpl(array, this.emptyContext);
    }

    @Override
    public JsonPatch createPatch(JsonArray array) {
        return new JsonPatchImpl(array, this.emptyContext);
    }

    @Override
    public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
        return new JsonPatchImpl(JsonPatchImpl.diff(source, target, this.emptyContext), this.emptyContext);
    }

    @Override
    public JsonMergePatch createMergePatch(JsonValue patch) {
        return new JsonMergePatchImpl(patch, this.emptyContext);
    }

    @Override
    public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
        return new JsonMergePatchImpl(JsonMergePatchImpl.diff(source, target, this.emptyContext), this.emptyContext);
    }

    @Override
    public JsonString createValue(String value) {
        return new JsonStringImpl(value);
    }

    @Override
    public JsonNumber createValue(int value) {
        return JsonNumberImpl.getJsonNumber(value, this.emptyContext.bigIntegerScaleLimit());
    }

    @Override
    public JsonNumber createValue(long value) {
        return JsonNumberImpl.getJsonNumber(value, this.emptyContext.bigIntegerScaleLimit());
    }

    @Override
    public JsonNumber createValue(double value) {
        return JsonNumberImpl.getJsonNumber(value, this.emptyContext.bigIntegerScaleLimit());
    }

    @Override
    public JsonNumber createValue(BigInteger value) {
        return JsonNumberImpl.getJsonNumber(value, this.emptyContext.bigIntegerScaleLimit());
    }

    @Override
    public JsonNumber createValue(BigDecimal value) {
        return JsonNumberImpl.getJsonNumber(value, this.emptyContext.bigIntegerScaleLimit());
    }

    @Override
    public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
        return config == null ? new JsonBuilderFactoryImpl(this.emptyContext) : new JsonBuilderFactoryImpl(new JsonContext(config, this.bufferPool, "org.eclipse.parsson.rejectDuplicateKeys", "jakarta.json.JsonConfig.keyStrategy", JsonContext.PROPERTY_BUFFER_POOL));
    }

    @Override
    public JsonNumber createValue(Number value) {
        return JsonNumberImpl.getJsonNumber(value, this.emptyContext.bigIntegerScaleLimit());
    }
}

