/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.dialogs.PropertiesMembershipChoiceDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.UserCancelException;

public class UnGlueAction
extends JosmAction {
    private transient Node selectedNode;
    private transient Way selectedWay;
    private transient Set<Node> selectedNodes;

    public UnGlueAction() {
        super(I18n.tr("UnGlue Ways", new Object[0]), "unglueways", I18n.tr("Duplicate nodes that are used by multiple ways.", new Object[0]), Shortcut.registerShortcut("tools:unglue", I18n.tr("Tools: {0}", I18n.tr("UnGlue Ways", new Object[0])), 71, 5003), true);
        this.setHelpId(HelpUtil.ht("/Action/UnGlue"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.unglue();
        }
        catch (UserCancelException ignore) {
            Logging.trace(ignore);
        }
        finally {
            this.cleanup();
        }
    }

    protected void unglue() throws UserCancelException {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        Object errMsg = null;
        int errorTime = Notification.TIME_DEFAULT;
        if (this.checkSelectionOneNodeAtMostOneWay(selection)) {
            this.checkAndConfirmOutlyingUnglue();
            List parentWays = this.selectedNode.getParentWays().stream().filter(Way::isUsable).collect(Collectors.toList());
            if (parentWays.size() < 2) {
                if (!parentWays.isEmpty()) {
                    Way way = this.selectedWay == null ? (Way)parentWays.get(0) : this.selectedWay;
                    boolean closedOrSelfCrossing = way.getNodes().stream().filter(n -> n == this.selectedNode).count() > 1L;
                    PropertiesMembershipChoiceDialog dialog = PropertiesMembershipChoiceDialog.showIfNecessary(Collections.singleton(this.selectedNode), !this.selectedNode.isTagged());
                    if (dialog != null && dialog.getTags().isPresent()) {
                        this.unglueOneNodeAtMostOneWay(way, dialog);
                        return;
                    }
                    if (closedOrSelfCrossing) {
                        this.unglueClosedOrSelfCrossingWay(way, dialog);
                        return;
                    }
                }
                errorTime = Notification.TIME_SHORT;
                errMsg = I18n.tr("This node is not glued to anything else.", new Object[0]);
            } else {
                this.unglueWays();
            }
        } else if (this.checkSelectionOneWayAnyNodes(selection)) {
            this.checkAndConfirmOutlyingUnglue();
            this.selectedNodes.removeIf(n -> n.getParentWays().stream().filter(Way::isUsable).count() < 2L);
            if (this.selectedNodes.isEmpty()) {
                errMsg = selection.size() > 1 ? I18n.tr("None of these nodes are glued to anything else.", new Object[0]) : I18n.tr("None of this way''s nodes are glued to anything else.", new Object[0]);
            } else if (this.selectedNodes.size() == 1) {
                this.selectedNode = this.selectedNodes.iterator().next();
                this.unglueWays();
            } else {
                this.unglueOneWayAnyNodes();
            }
        } else {
            errorTime = Notification.TIME_VERY_LONG;
            errMsg = I18n.tr("The current selection cannot be used for unglueing.", new Object[0]) + "\n\n" + I18n.tr("Select either:", new Object[0]) + "\n" + I18n.tr("* One tagged node, or", new Object[0]) + "\n" + I18n.tr("* One node that is used by more than one way, or", new Object[0]) + "\n" + I18n.tr("* One node that is used by more than one way and one of those ways, or", new Object[0]) + "\n" + I18n.tr("* One way that has one or more nodes that are used by more than one way, or", new Object[0]) + "\n" + I18n.tr("* One way and one or more of its nodes that are used by more than one way.", new Object[0]) + "\n\n" + I18n.tr("Note: If a way is selected, this way will get fresh copies of the unglued\nnodes and the new nodes will be selected. Otherwise, all ways will get their\nown copy and all nodes will be selected.", new Object[0]);
        }
        if (errMsg != null) {
            new Notification((String)errMsg).setIcon(0).setDuration(errorTime).show();
        }
    }

    private void cleanup() {
        this.selectedNode = null;
        this.selectedWay = null;
        this.selectedNodes = null;
    }

    static void update(PropertiesMembershipChoiceDialog dialog, Node existingNode, List<Node> newNodes, List<Command> cmds) {
        UnGlueAction.updateMemberships(dialog.getMemberships().orElse(null), existingNode, newNodes, cmds);
        UnGlueAction.updateProperties(dialog.getTags().orElse(null), existingNode, newNodes, cmds);
    }

    private static void updateProperties(PropertiesMembershipChoiceDialog.ExistingBothNew tags, Node existingNode, Iterable<Node> newNodes, List<Command> cmds) {
        if (PropertiesMembershipChoiceDialog.ExistingBothNew.NEW == tags) {
            Node newSelectedNode = new Node(existingNode);
            newSelectedNode.removeAll();
            cmds.add(new ChangeCommand(existingNode, newSelectedNode));
        } else if (PropertiesMembershipChoiceDialog.ExistingBothNew.OLD == tags) {
            for (Node newNode : newNodes) {
                newNode.removeAll();
            }
        }
    }

    private void unglueOneNodeAtMostOneWay(Way way, PropertiesMembershipChoiceDialog dialog) {
        MapView mv;
        Point currMousePos;
        ArrayList<Command> cmds = new ArrayList<Command>();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        cmds.add(new ChangeNodesCommand(way, UnGlueAction.modifyWay(this.selectedNode, way, cmds, newNodes)));
        if (dialog != null) {
            UnGlueAction.update(dialog, this.selectedNode, newNodes, cmds);
        }
        if ((currMousePos = (mv = MainApplication.getMap().mapView).getMousePosition()) != null) {
            cmds.add(new MoveCommand(this.selectedNode, mv.getLatLon(currMousePos.getX(), currMousePos.getY())));
        } else {
            cmds.add(new MoveCommand((OsmPrimitive)this.selectedNode, 0.0, 5.0));
        }
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.tr("Unglued Node", new Object[0]), cmds));
        this.getLayerManager().getEditDataSet().setSelected(this.selectedNode);
    }

    private boolean checkSelectionOneNodeAtMostOneWay(Collection<? extends OsmPrimitive> selection) {
        int size = selection.size();
        if (size < 1 || size > 2) {
            return false;
        }
        this.selectedNode = null;
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (osmPrimitive instanceof Node) {
                this.selectedNode = (Node)osmPrimitive;
                if (size != 1 && (this.selectedWay == null || !this.selectedWay.containsNode(this.selectedNode))) continue;
                return true;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            this.selectedWay = (Way)osmPrimitive;
            if (size != 2 || this.selectedNode == null) continue;
            return this.selectedWay.containsNode(this.selectedNode);
        }
        return false;
    }

    private boolean checkSelectionOneWayAnyNodes(Collection<? extends OsmPrimitive> selection) {
        if (selection.isEmpty()) {
            return false;
        }
        this.selectedWay = null;
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Way)) continue;
            if (this.selectedWay != null) {
                return false;
            }
            this.selectedWay = (Way)osmPrimitive;
        }
        if (this.selectedWay == null) {
            return false;
        }
        this.selectedNodes = new HashSet<Node>();
        for (OsmPrimitive osmPrimitive : selection) {
            if (!(osmPrimitive instanceof Node)) continue;
            Node n = (Node)osmPrimitive;
            if (!this.selectedWay.containsNode(n)) {
                return false;
            }
            this.selectedNodes.add(n);
        }
        if (this.selectedNodes.isEmpty()) {
            this.selectedNodes.addAll(this.selectedWay.getNodes());
        }
        return true;
    }

    private static List<Node> modifyWay(Node originalNode, Way w, List<Command> cmds, List<Node> newNodes) {
        Node newNode = UnGlueAction.cloneNode(originalNode, cmds);
        newNodes.add(newNode);
        ArrayList<Node> nn = new ArrayList<Node>(w.getNodes());
        nn.replaceAll(n -> n == originalNode ? newNode : n);
        return nn;
    }

    private static Node cloneNode(Node originalNode, List<Command> cmds) {
        Node newNode = new Node(originalNode, true);
        cmds.add(new AddCommand(originalNode.getDataSet(), newNode));
        return newNode;
    }

    private static void updateMemberships(PropertiesMembershipChoiceDialog.ExistingBothNew memberships, Node originalNode, List<Node> newNodes, List<Command> cmds) {
        if (memberships == null || PropertiesMembershipChoiceDialog.ExistingBothNew.OLD == memberships) {
            return;
        }
        for (Relation r : OsmPrimitive.getParentRelations(Collections.singleton(originalNode))) {
            if (r.isDeleted()) continue;
            ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>(r.getMembers());
            boolean changed = false;
            for (int i = r.getMembersCount() - 1; i >= 0; --i) {
                RelationMember rm = r.getMember(i);
                if (rm.getMember() != originalNode) continue;
                for (Node n : newNodes) {
                    newMembers.add(i + 1, new RelationMember(rm.getRole(), n));
                }
                if (PropertiesMembershipChoiceDialog.ExistingBothNew.NEW == memberships) {
                    newMembers.remove(i);
                }
                changed = true;
            }
            if (!changed) continue;
            cmds.add(new ChangeMembersCommand(r, newMembers));
        }
    }

    private void unglueWays() throws UserCancelException {
        List<Way> parentWays;
        PropertiesMembershipChoiceDialog dialog = PropertiesMembershipChoiceDialog.showIfNecessary(Collections.singleton(this.selectedNode), false);
        ArrayList<Command> cmds = new ArrayList<Command>();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        if (this.selectedWay == null) {
            parentWays = this.selectedNode.referrers(Way.class).filter(Way::isUsable).collect(Collectors.toList());
            parentWays.sort((o1, o2) -> {
                int d = Boolean.compare(!o1.isNew() && !o1.isModified(), !o2.isNew() && !o2.isModified());
                if (d == 0) {
                    d = Integer.compare(o2.getReferrers().size(), o1.getReferrers().size());
                }
                if (d == 0) {
                    d = Boolean.compare(o1.isFirstLastNode(this.selectedNode), o2.isFirstLastNode(this.selectedNode));
                }
                return d;
            });
            parentWays.remove(0);
        } else {
            parentWays = Collections.singletonList(this.selectedWay);
        }
        HashSet<Way> warnParents = new HashSet<Way>();
        for (Way w : parentWays) {
            if (w.isFirstLastNode(this.selectedNode)) {
                warnParents.add(w);
            }
            cmds.add(new ChangeNodesCommand(w, UnGlueAction.modifyWay(this.selectedNode, w, cmds, newNodes)));
        }
        if (dialog != null) {
            UnGlueAction.update(dialog, this.selectedNode, newNodes, cmds);
        }
        this.notifyWayPartOfRelation(warnParents);
        this.execCommands(cmds, newNodes);
    }

    private void execCommands(List<Command> cmds, List<Node> newNodes) {
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.trn("Dupe into {0} node", "Dupe into {0} nodes", (long)newNodes.size() + 1L, (long)newNodes.size() + 1L), cmds));
        this.getLayerManager().getEditDataSet().setSelected(newNodes.get(0));
    }

    private boolean unglueClosedOrSelfCrossingWay(Way way, PropertiesMembershipChoiceDialog dialog) {
        ArrayList<Command> cmds = new ArrayList<Command>();
        List<Node> oldNodes = way.getNodes();
        ArrayList<Node> newNodes = new ArrayList<Node>(oldNodes.size());
        ArrayList<Node> addNodes = new ArrayList<Node>();
        int count = 0;
        for (Node n : oldNodes) {
            if (n == this.selectedNode && count++ > 0) {
                n = UnGlueAction.cloneNode(this.selectedNode, cmds);
                addNodes.add(n);
            }
            newNodes.add(n);
        }
        if (addNodes.isEmpty()) {
            return false;
        }
        if (dialog != null) {
            UnGlueAction.update(dialog, this.selectedNode, addNodes, cmds);
        }
        this.addCheckedChangeNodesCmd(cmds, way, newNodes);
        this.execCommands(cmds, addNodes);
        return true;
    }

    private void unglueOneWayAnyNodes() throws UserCancelException {
        PropertiesMembershipChoiceDialog dialog = PropertiesMembershipChoiceDialog.showIfNecessary(this.selectedNodes, false);
        HashMap<Node, Node> replaced = new HashMap<Node, Node>();
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.selectedNodes.forEach(n -> replaced.put((Node)n, UnGlueAction.cloneNode(n, cmds)));
        ArrayList<Node> modNodes = new ArrayList<Node>(this.selectedWay.getNodes());
        modNodes.replaceAll(n -> replaced.getOrDefault(n, (Node)n));
        if (dialog != null) {
            replaced.forEach((k, v) -> UnGlueAction.update(dialog, k, Collections.singletonList(v), cmds));
        }
        this.addCheckedChangeNodesCmd(cmds, this.selectedWay, modNodes);
        UndoRedoHandler.getInstance().add(new SequenceCommand(I18n.trn("Dupe {0} node into {1} nodes", "Dupe {0} nodes into {1} nodes", this.selectedNodes.size(), this.selectedNodes.size(), 2 * this.selectedNodes.size()), cmds));
        this.getLayerManager().getEditDataSet().setSelected(replaced.values());
    }

    private boolean addCheckedChangeNodesCmd(List<Command> cmds, Way w, List<Node> nodes) {
        boolean relationCheck = !this.calcAffectedRelations(Collections.singleton(w)).isEmpty();
        cmds.add(new ChangeNodesCommand(w, nodes));
        if (relationCheck) {
            this.notifyWayPartOfRelation(Collections.singleton(w));
        }
        return relationCheck;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }

    protected void checkAndConfirmOutlyingUnglue() throws UserCancelException {
        boolean ok;
        ArrayList<Node> primitives = new ArrayList<Node>(2 + (this.selectedNodes == null ? 0 : this.selectedNodes.size()));
        if (this.selectedNodes != null) {
            primitives.addAll(this.selectedNodes);
        }
        if (this.selectedNode != null) {
            primitives.add(this.selectedNode);
        }
        if (!(ok = UnGlueAction.checkAndConfirmOutlyingOperation("unglue", I18n.tr("Unglue confirmation", new Object[0]), I18n.tr("You are about to unglue nodes which can have other referrers not yet downloaded.<br>This can cause problems because other objects (that you do not see) might use them.<br>Do you really want to unglue?", new Object[0]), I18n.tr("You are about to unglue incomplete objects.<br>This will cause problems because you don''t see the real object.<br>Do you really want to unglue?", new Object[0]), primitives, null))) {
            throw new UserCancelException();
        }
    }

    protected void notifyWayPartOfRelation(Collection<Way> ways) {
        Set<Relation> affectedRelations = this.calcAffectedRelations(ways);
        if (affectedRelations.isEmpty()) {
            return;
        }
        int size = affectedRelations.size();
        String msg1 = I18n.trn("Unglueing possibly affected {0} relation: {1}", "Unglueing possibly affected {0} relations: {1}", size, size, DefaultNameFormatter.getInstance().formatAsHtmlUnorderedList(affectedRelations, 20));
        String msg2 = I18n.trn("Ensure that the relation has not been broken!", "Ensure that the relations have not been broken!", size, new Object[0]);
        new Notification(msg1 + msg2).setIcon(2).show();
    }

    protected Set<Relation> calcAffectedRelations(Collection<Way> ways) {
        Set<Node> affectedNodes = this.selectedNodes != null ? this.selectedNodes : Collections.singleton(this.selectedNode);
        return OsmPrimitive.getParentRelations(ways).stream().filter(r -> UnGlueAction.isRelationAffected(r, affectedNodes, ways)).collect(Collectors.toSet());
    }

    private static boolean isRelationAffected(Relation r, Set<Node> affectedNodes, Collection<Way> ways) {
        if (!r.isUsable()) {
            return false;
        }
        if (!r.hasTag("type", "restriction", "connectivity", "destination_sign") || r.hasIncompleteMembers()) {
            return true;
        }
        int count = 0;
        for (RelationMember rm : r.getMembers()) {
            if (rm.isNode() && affectedNodes.contains(rm.getNode())) {
                ++count;
            }
            if (!rm.isWay() || !ways.contains(rm.getWay())) continue;
            ++count;
            if (!"via".equals(rm.getRole())) continue;
            ++count;
        }
        return count >= 2;
    }
}

