# minitest - a minimal testing framework v0.0.1 --------------------------------
test_library <- function(package) library(package = package, character.only = TRUE)
test_type <- function(type, x) invisible(typeof(x) == type || {stop("object of type '", typeof(x), "' was returned instead of '", type, "'")})
test_equal <- function(a, b) invisible(a == b || {print(a); print(b); stop("the above expressions were not equal")})
test_error <- function(x, containing = "") invisible(inherits(x <- tryCatch(x, error = identity), "error") && grepl(containing, x[["message"]], fixed = TRUE) || stop("expected error message containing '", containing, "' was not generated"))
# ------------------------------------------------------------------------------

test_library("secretbase")
# Known SHA hashes from NIST:
test_equal(sha3("", 224), "6b4e03423667dbb73b6e15454f0eb1abd4597f9a1b078e3f5b5a6bc7")
test_equal(sha3("", 256), "a7ffc6f8bf1ed76651c14756a061d662f580ff4de43b49fa82d80a4b80f8434a")
test_equal(sha3("", 384), "0c63a75b845e4f7d01107d852e4c2485c51a50aaaa94fc61995e71bbee983a2ac3713831264adb47fb6bd1e058d5f004")
test_equal(sha3("", 512), "a69f73cca23a9ac5c8b567dc185a756e97c982164fe25859e0d1dcc1475c80a615b2123af1f5f94c11e3e9402c3ac558f500199d95b6d3e301758586281dcd26")
test_equal(sha256(""), "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855")
# SHA-3 tests:
test_equal(sha3("secret base"), "a721d57570e7ce366adee2fccbe9770723c6e3622549c31c7cab9dbb4a795520")
test_equal(sha3("secret base", bits = 224), "5511b3469d3f1a87b62ce8f0d2dc9510ec5e4547579b8afb32052f99")
test_equal(sha3("secret base", bits = 384L), "79e54f865df004dde10dc2f61baf47eb4637c68d87a2baeb7fe6bc0ac983c2154835ec7deb49b16c246c0dc1d43e32f9")
test_equal(sha3("secret base", bits = "512"), "31076b4690961320a761be0951eeaa9efd0c75c37137a2a50877cbebb8afcc6d7927c41a120ae8fa73fdce8fff726fcbc51d448d020240bc7455963a16e639b1")
test_type("raw", sha3("secret base", convert = FALSE))
# Streaming serialization tests:
test_equal(sha3(data.frame(a = 1, b = 2)), "05d4308e79d029b4af5604739ecc6c4efa1f602a23add0ed2d247b7407d4832f")
test_equal(sha3(c("secret", "base")), "d906024c71828a10e28865a80f5e81d2cb5cd74067d44852d7039813ba62b0b6")
test_equal(sha3(`attr<-`("base", "secret", "base")), "eac181cb1c64e7196c458d40cebfb8bbd6d34a1d728936a2e689465879240e2a")
test_equal(sha3(NULL), "b3e37e4c5def1bfb2841b79ef8503b83d1fed46836b5b913d7c16de92966dcee")
test_equal(sha3(substitute()), "9d31eb41cfb721b8040c52d574df1aacfc381d371c2b933f90792beba5160a57")
# Error handling tests:
test_error(sha3("secret base", bits = 6), "'bits' must be 224, 256, 384 or 512")
test_error(sha3("", convert = 1), "'convert' must be a logical value")
test_error(sha3(file = NULL), "'file' must be a character string")
# File interface tests:
hash_func <- function(file, string) {
  on.exit(unlink(file))
  cat(string, file = file)
  sha3(file = file)
}
test_equal(hash_func(tempfile(), "secret base"), "a721d57570e7ce366adee2fccbe9770723c6e3622549c31c7cab9dbb4a795520")
test_error(hash_func("", ""), "file not found or no read permission")
if (.Platform[["OS.type"]] == "unix") test_error(sha3(file = "~/"), "file read error")
# SHAKE256 tests:
test_equal(shake256("secret base"), "995ebac18dbfeb170606cbbc0f2accce85db4db0dcf4fbe4d3efaf8ccf4e0a94")
test_equal(shake256("secret base", bits = 32, convert = NA), -1044750695L)
test_type("raw", shake256("secret base", convert = FALSE))
test_equal(shake256("secret base", bits = 32), "995ebac1")
test_equal(shake256(shake256("secret base", bits = 32, convert = FALSE), bits = 32), "4d872090")
test_type("character", shake256(rnorm(1e5), bits = 8196))
test_equal(shake256(`class<-`(shake256(character(), bits = 192, convert = FALSE), "hash"), bits = "32", convert = NA), -111175135L)
hash_func <- function(file, string) {
  on.exit(unlink(file))
  cat(string, file = file)
  shake256(file = file)
}
test_equal(hash_func(tempfile(), "secret base"), "995ebac18dbfeb170606cbbc0f2accce85db4db0dcf4fbe4d3efaf8ccf4e0a94")
test_error(shake256("secret base", bits = 0), "'bits' outside valid range of 8 to 2^24")
test_error(shake256("secret base", bits = -1), "'bits' outside valid range of 8 to 2^24")
test_error(shake256("secret base", bits = 2^24 + 1), "'bits' outside valid range of 8 to 2^24")
# Keccak tests:
test_equal(keccak("secret base"), "3fc6092bbec5a434a9933b486a89fa466c1ca013d1e37ab4348ce3764f3463d1")
test_equal(keccak("secret base", bits = 224), "1ddaa7776f138ff5bba898ca7530410a52d09da412c4276bda0682a8")
test_equal(keccak("secret base", bits = 384L), "c82bae24175676028e44aa08b9e2424311847adb0b071c68c7ea47edf049b0e935ddd2fc7c499333bccc08c7eb7b1203")
test_equal(keccak("secret base", bits = "512"), "38297e891d9118e4cf6ff5ba6d6de8c2c3bfa790b425848da7b1d8dffcb4a6a3ca2e32ca0a66f36ce2882786ce2299642de8ffd3bae3b51a1ee145fad555a9d8")
test_type("raw", keccak("secret base", convert = FALSE))
test_error(keccak("secret base", bits = 6), "'bits' must be 224, 256, 384 or 512")
hash_func <- function(file, string) {
  on.exit(unlink(file))
  cat(string, file = file)
  keccak(file = file)
}
test_equal(hash_func(tempfile(), "secret base"), "3fc6092bbec5a434a9933b486a89fa466c1ca013d1e37ab4348ce3764f3463d1")
# SHA-256 tests:
test_equal(sha256("secret base"), "1951c1ca3d50e95e6ede2b1c26fefd0f0e8eba1e51a837f8ccefb583a2b686fe")
test_equal(sha256("secret base", convert = NA)[2L], 1592348733L)
test_equal(sha256(sha256("secret base", convert = FALSE)), "bd45eca9cbd4404cd467909fa8a2196ee9ffc7cb7f70f6343ff6647419744d41")
test_equal(sha256(data.frame(a = 1, b = 2)), "189874c3ac59edecb4eab95a2d7c1bbb293a6ccd04e3da5b28daca91ebc7f15b")
test_equal(sha256(c("secret", "base")), "6a38552b0dab8bf0a6c2f9a6a7acf764631319843f58e85f883301a3cd08b1f2")
test_equal(sha256(`attr<-`("base", "secret", "base")), "6e9e5b1a42304047ba73161360917d001c19974aebd98d345251ff138cddf6ea")
test_equal(sha256(NULL), "71557d1c8bac9bbe3cbec8d00bb223a2f372279827064095447e569fbf5a760a")
test_equal(sha256(substitute()), "4627dde6550f3e355515de5f2c6bb0099161c53c2c7186ce79ab1a74df004bfc")
test_equal(sha256(`class<-`(sha256(character(), convert = FALSE), "hash")), "c762db048ff48f7ba3e9df5539db3aa678cb2f336d96d5c81b4e5d3e19783d14") 
test_error(sha256("", convert = 0), "'convert' must be a logical value")
test_error(sha256(file = NULL), "'file' must be a character string")
hash_func <- function(file, string) {
  on.exit(unlink(file))
  cat(string, file = file)
  sha256(file = file)
}
test_equal(hash_func(tempfile(), "secret base"), "1951c1ca3d50e95e6ede2b1c26fefd0f0e8eba1e51a837f8ccefb583a2b686fe")
test_error(hash_func("", ""), "file not found or no read permission")
if (.Platform[["OS.type"]] == "unix") test_error(sha256(file = "~/"), "file read error")
test_equal(sha256(paste(1:888, collapse = "")), "ec5df945d0ff0c927812ec503fe9ffd5cbdf7cf79b5391ad5002b3a80760183b")
test_equal(sha256("secret", key = "base"), "14b24e4c66bd03c1d6b59bc59e1e47468a437001662ae4be2cb30e0483e13e44")
test_equal(sha256("secret base", key = paste(rep("secret base ", 21L), collapse = "")), "5dab9794515ad176763276bd46f49b029b4578795c52c984243dd636dc0ac11f")
test_equal(sha256("secret base", key = as.raw(1L)), "35a0fc031777e1a16b2c11a614532fbbee5e2ce83271230f62808432a4d13337")
test_equal(sha256("secret base", key = rep(c(as.raw(1L), as.raw(2L)), 64L)), "0d9cbfe4872e0d9ef16f86fbbe5397fd4ed30b7e50b4c5c7722ccf4786aa58d2")
test_equal(sha256("secret base", key = character()), "6bc4693e2025baadf345dd0b133b867ac081dbf6ae02e94e774db4b1a65203ca")
test_error(sha256("secret base", key = list()), "'key' must be a character string, raw vector or NULL")
# SipHash tests:
test_equal(siphash13(""), "2c530c1562a7fbd1")
test_equal(siphash13("", key = ""), "2c530c1562a7fbd1")
test_equal(siphash13("", key = character()), "2c530c1562a7fbd1")
test_equal(siphash13("secret base"), "48c60a316babef0e")
test_equal(siphash13("secret base", key = "secret base"), "2cf27a8f22f02e59")
test_equal(siphash13("secret base", key = c("secret base", "more")), "2cf27a8f22f02e59")
test_equal(siphash13("secret base", key = as.raw(1L)), "5ecd894f7d269521")
test_error(siphash13("", key = list()), "'key' must be a character string, raw vector or NULL") 
test_equal(siphash13("secret base", convert = NA)[2L], 250588011L)
test_equal(siphash13(siphash13("secret base", convert = FALSE)), "498db1332ca02148")
test_equal(siphash13(data.frame(a = 1, b = 2)), "e91a1e412627d654")
test_equal(siphash13(c("secret", "base")), "ddf3c7a54c52150c")
test_equal(siphash13(`attr<-`("base", "secret", "base")), "4a7c3eb69f91f04e")
test_equal(siphash13(NULL), "08d5f59e833de599")
test_equal(siphash13(substitute()), "c8cadc1ab377142a")
test_equal(siphash13(`class<-`(siphash13(character(), convert = FALSE), "hash")), "39124d8b9643418a")
test_error(siphash13("", convert = 0L), "'convert' must be a logical value")
test_error(siphash13(file = NULL), "'file' must be a character string")
hash_func <- function(file, string) {
  on.exit(unlink(file))
  cat(string, file = file)
  siphash13(file = file)
}
test_equal(hash_func(tempfile(), "secret base"), "48c60a316babef0e")
test_error(hash_func("", ""), "file not found or no read permission")
if (.Platform[["OS.type"]] == "unix") test_error(siphash13(file = "~/"), "file read error")
test_equal(siphash13(paste(1:888, collapse = "")), "8337f50b05209c40")
# Base64 tests:
test_type("character", base64enc(c("secret", "base")))
test_type("raw", base64enc(data.frame(), convert = FALSE))
test_type("raw", base64dec(base64enc(as.raw(c(1L, 2L)), convert = FALSE), convert = FALSE))
test_type("integer", base64dec(base64enc(c(1L, 2L)), convert = NA))
test_type("raw", suppressWarnings(base64dec(base64enc(data.frame()))))
test_error(base64enc("", convert = 0), "'convert' must be a logical value")
test_error(base64dec("", convert = 1L), "'convert' must be a logical value")
test_error(base64dec("__"), "input is not valid base64")
test_error(base64dec(404), "input is not valid base64")
test_error(base64dec("c2Vjcm V0IGJhc2U="), "input is not valid base64")
test_error(base64dec("c==="), "input is not valid base64")
test_error(base64dec("c=2="), "input is not valid base64")
test_equal(base64enc(double(1e5), convert = FALSE)[1e5], as.hexmode("41"))
test_equal(base64enc("secret base"), "c2VjcmV0IGJhc2U=")
test_equal(base64dec("c2VjcmV0IGJhc2U= \r\n"), "secret base")
test_equal(base64dec(base64enc("secret base")), "secret base")
test_equal(base64enc("s"), "cw==")
test_equal(base64dec("c2VjcmV0"), "secret")
test_equal(base64enc(""), base64dec(""))
