/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.metadata.placement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.metadata.OptionalStringComparator;
import org.apache.kafka.metadata.placement.ClusterDescriber;
import org.apache.kafka.metadata.placement.PartitionAssignment;
import org.apache.kafka.metadata.placement.PlacementSpec;
import org.apache.kafka.metadata.placement.ReplicaPlacer;
import org.apache.kafka.metadata.placement.TopicAssignment;
import org.apache.kafka.metadata.placement.UsableBroker;

public class StripedReplicaPlacer
implements ReplicaPlacer {
    private final Random random;

    private static void throwInvalidReplicationFactorIfNonPositive(int replicationFactor) {
        if (replicationFactor <= 0) {
            throw new InvalidReplicationFactorException("Invalid replication factor " + replicationFactor + ": the replication factor must be positive.");
        }
    }

    private static void throwInvalidReplicationFactorIfZero(int numUnfenced) {
        if (numUnfenced == 0) {
            throw new InvalidReplicationFactorException("All brokers are currently fenced.");
        }
    }

    private static void throwInvalidReplicationFactorIfTooFewBrokers(int replicationFactor, int numTotalBrokers) {
        if (replicationFactor > numTotalBrokers) {
            throw new InvalidReplicationFactorException("The target replication factor of " + replicationFactor + " cannot be reached because only " + numTotalBrokers + " broker(s) are registered.");
        }
    }

    public StripedReplicaPlacer(Random random) {
        this.random = random;
    }

    @Override
    public TopicAssignment place(PlacementSpec placement, ClusterDescriber cluster) throws InvalidReplicationFactorException {
        RackList rackList = new RackList(this.random, cluster.usableBrokers());
        StripedReplicaPlacer.throwInvalidReplicationFactorIfNonPositive(placement.numReplicas());
        StripedReplicaPlacer.throwInvalidReplicationFactorIfZero(rackList.numUnfencedBrokers());
        StripedReplicaPlacer.throwInvalidReplicationFactorIfTooFewBrokers(placement.numReplicas(), rackList.numTotalBrokers());
        ArrayList<List<Integer>> placements = new ArrayList<List<Integer>>(placement.numPartitions());
        for (int partition = 0; partition < placement.numPartitions(); ++partition) {
            placements.add(rackList.place(placement.numReplicas()));
        }
        return new TopicAssignment(placements.stream().map(replicas -> new PartitionAssignment((List<Integer>)replicas, cluster)).collect(Collectors.toList()));
    }

    static class RackList {
        private final Random random;
        private final Map<Optional<String>, Rack> racks = new HashMap<Optional<String>, Rack>();
        private final List<Optional<String>> rackNames = new ArrayList<Optional<String>>();
        private final int numTotalBrokers;
        private final int numUnfencedBrokers;
        private int epoch = 0;
        private int offset;

        RackList(Random random, Iterator<UsableBroker> iterator) {
            this.random = random;
            int numTotalBrokersCount = 0;
            int numUnfencedBrokersCount = 0;
            while (iterator.hasNext()) {
                UsableBroker broker = iterator.next();
                Rack rack = this.racks.get(broker.rack());
                if (rack == null) {
                    this.rackNames.add(broker.rack());
                    rack = new Rack();
                    this.racks.put(broker.rack(), rack);
                }
                if (broker.fenced()) {
                    rack.fenced().add(broker.id());
                } else {
                    ++numUnfencedBrokersCount;
                    rack.unfenced().add(broker.id());
                }
                ++numTotalBrokersCount;
            }
            for (Rack rack : this.racks.values()) {
                rack.initialize(random);
            }
            this.rackNames.sort(OptionalStringComparator.INSTANCE);
            this.numTotalBrokers = numTotalBrokersCount;
            this.numUnfencedBrokers = numUnfencedBrokersCount;
            this.offset = this.rackNames.isEmpty() ? 0 : random.nextInt(this.rackNames.size());
        }

        int numTotalBrokers() {
            return this.numTotalBrokers;
        }

        int numUnfencedBrokers() {
            return this.numUnfencedBrokers;
        }

        List<Optional<String>> rackNames() {
            return this.rackNames;
        }

        List<Integer> place(int replicationFactor) {
            int result;
            StripedReplicaPlacer.throwInvalidReplicationFactorIfNonPositive(replicationFactor);
            StripedReplicaPlacer.throwInvalidReplicationFactorIfTooFewBrokers(replicationFactor, this.numTotalBrokers());
            StripedReplicaPlacer.throwInvalidReplicationFactorIfZero(this.numUnfencedBrokers());
            if (this.epoch == this.numUnfencedBrokers && this.numUnfencedBrokers > 1) {
                this.shuffle();
                this.epoch = 0;
            }
            if (this.offset == this.rackNames.size()) {
                this.offset = 0;
            }
            ArrayList<Integer> brokers = new ArrayList<Integer>(replicationFactor);
            int firstRackIndex = this.offset;
            while (true) {
                Optional<String> name;
                Rack rack;
                if ((result = (rack = this.racks.get(name = this.rackNames.get(firstRackIndex))).nextUnfenced(this.epoch)) >= 0) break;
                if (++firstRackIndex != this.rackNames.size()) continue;
                firstRackIndex = 0;
            }
            brokers.add(result);
            int rackIndex = this.offset;
            for (int replica = 1; replica < replicationFactor; ++replica) {
                result = -1;
                do {
                    if (rackIndex == firstRackIndex) {
                        firstRackIndex = -1;
                    } else {
                        Optional<String> rackName = this.rackNames.get(rackIndex);
                        Rack rack = this.racks.get(rackName);
                        result = rack.next(this.epoch);
                    }
                    if (++rackIndex != this.rackNames.size()) continue;
                    rackIndex = 0;
                } while (result < 0);
                brokers.add(result);
            }
            ++this.epoch;
            ++this.offset;
            return brokers;
        }

        void shuffle() {
            Collections.shuffle(this.rackNames, this.random);
            for (Rack rack : this.racks.values()) {
                rack.shuffle(this.random);
            }
        }
    }

    static class Rack {
        private final BrokerList fenced = new BrokerList();
        private final BrokerList unfenced = new BrokerList();

        Rack() {
        }

        void initialize(Random random) {
            this.fenced.initialize(random);
            this.unfenced.initialize(random);
        }

        void shuffle(Random random) {
            this.fenced.shuffle(random);
            this.unfenced.shuffle(random);
        }

        BrokerList fenced() {
            return this.fenced;
        }

        BrokerList unfenced() {
            return this.unfenced;
        }

        int nextUnfenced(int epoch) {
            return this.unfenced.next(epoch);
        }

        int next(int epoch) {
            int result = this.unfenced.next(epoch);
            if (result >= 0) {
                return result;
            }
            return this.fenced.next(epoch);
        }
    }

    static class BrokerList {
        static final BrokerList EMPTY = new BrokerList();
        private final List<Integer> brokers = new ArrayList<Integer>(0);
        private int index = 0;
        private int offset = 0;
        private int epoch = 0;

        BrokerList() {
        }

        BrokerList add(int broker) {
            this.brokers.add(broker);
            return this;
        }

        void initialize(Random random) {
            if (!this.brokers.isEmpty()) {
                this.brokers.sort(Integer::compareTo);
                this.offset = random.nextInt(this.brokers.size());
            }
        }

        void shuffle(Random random) {
            Collections.shuffle(this.brokers, random);
        }

        int size() {
            return this.brokers.size();
        }

        int next(int epoch) {
            if (this.brokers.isEmpty()) {
                return -1;
            }
            if (this.epoch != epoch) {
                this.epoch = epoch;
                this.index = 0;
                this.offset = (this.offset + 1) % this.brokers.size();
            }
            if (this.index >= this.brokers.size()) {
                return -1;
            }
            int broker = this.brokers.get((this.index + this.offset) % this.brokers.size());
            ++this.index;
            return broker;
        }
    }
}

