/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.PropertiesUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreDescriptor;

public class CloudDescriptor {
    private final CoreDescriptor cd;
    private String shardId;
    private String collectionName;
    private String roles = null;
    private Integer numShards;
    private String nodeName = null;
    private Map<String, String> collectionParams = new HashMap<String, String>();
    private volatile boolean isLeader = false;
    private volatile boolean hasRegistered = false;
    private volatile Replica.State lastPublished = Replica.State.ACTIVE;
    public static final String NUM_SHARDS = "numShards";
    public static final String REPLICA_TYPE = "replicaType";
    private final Replica.Type replicaType;

    public CloudDescriptor(CoreDescriptor cd, String coreName, Properties props) {
        this.cd = cd;
        this.shardId = props.getProperty("shard", null);
        if (StrUtils.isNullOrEmpty((String)this.shardId)) {
            this.shardId = null;
        }
        this.collectionName = props.getProperty("collection", coreName);
        this.roles = props.getProperty("roles", null);
        this.nodeName = props.getProperty("coreNodeName");
        if (StrUtils.isNullOrEmpty((String)this.nodeName)) {
            this.nodeName = null;
        }
        this.numShards = PropertiesUtil.toInteger((String)props.getProperty(NUM_SHARDS), null);
        String replicaTypeStr = props.getProperty(REPLICA_TYPE);
        this.replicaType = StrUtils.isNullOrEmpty((String)replicaTypeStr) ? Replica.Type.NRT : Replica.Type.valueOf((String)replicaTypeStr);
        for (String propName : props.stringPropertyNames()) {
            if (!propName.startsWith("collection.")) continue;
            this.collectionParams.put(propName.substring("collection.".length()), props.getProperty(propName));
        }
    }

    public boolean requiresTransactionLog() {
        return this.replicaType != Replica.Type.PULL;
    }

    public Replica.State getLastPublished() {
        return this.lastPublished;
    }

    public void setLastPublished(Replica.State state) {
        this.lastPublished = state;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public void setLeader(boolean isLeader) {
        this.isLeader = isLeader;
    }

    public boolean hasRegistered() {
        return this.hasRegistered;
    }

    public void setHasRegistered(boolean hasRegistered) {
        this.hasRegistered = hasRegistered;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getShardId() {
        return this.shardId;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        this.roles = roles;
    }

    public Map<String, String> getParams() {
        return this.collectionParams;
    }

    public Integer getNumShards() {
        return this.numShards;
    }

    public void setNumShards(int numShards) {
        this.numShards = numShards;
    }

    public String getCoreNodeName() {
        return this.nodeName;
    }

    public void setCoreNodeName(String nodeName) {
        this.nodeName = nodeName;
        if (nodeName == null) {
            this.cd.getPersistableStandardProperties().remove("coreNodeName");
        } else {
            this.cd.getPersistableStandardProperties().setProperty("coreNodeName", nodeName);
        }
    }

    public void reload(CloudDescriptor reloadFrom) {
        if (reloadFrom == null) {
            return;
        }
        this.setShardId(StrUtils.isNullOrEmpty((String)reloadFrom.getShardId()) ? this.getShardId() : reloadFrom.getShardId());
        this.setCollectionName(StrUtils.isNullOrEmpty((String)reloadFrom.getCollectionName()) ? this.getCollectionName() : reloadFrom.getCollectionName());
        this.setRoles(StrUtils.isNullOrEmpty((String)reloadFrom.getRoles()) ? this.getRoles() : reloadFrom.getRoles());
        if (reloadFrom.getNumShards() != null) {
            this.setNumShards(reloadFrom.getNumShards());
        }
        this.setCoreNodeName(StrUtils.isNullOrEmpty((String)reloadFrom.getCoreNodeName()) ? this.getCoreNodeName() : reloadFrom.getCoreNodeName());
        this.setLeader(reloadFrom.isLeader);
        this.setHasRegistered(reloadFrom.hasRegistered);
        this.setLastPublished(reloadFrom.getLastPublished());
        for (Map.Entry<String, String> ent : reloadFrom.getParams().entrySet()) {
            this.collectionParams.put(ent.getKey(), ent.getValue());
        }
    }

    public Replica.Type getReplicaType() {
        return this.replicaType;
    }
}

